/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorLongDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="IdeDocumentHistory", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class IdeDocumentHistoryImpl
extends IdeDocumentHistory
implements Disposable,
PersistentStateComponent<RecentlyChangedFilesState> {
    private static final Logger LOG = Logger.getInstance(IdeDocumentHistoryImpl.class);
    private static final int BACK_QUEUE_LIMIT = Registry.intValue((String)"editor.navigation.history.stack.size");
    private static final int CHANGE_QUEUE_LIMIT = Registry.intValue((String)"editor.navigation.history.stack.size");
    private final Project myProject;
    private FileDocumentManager myFileDocumentManager;
    private final LinkedList<PlaceInfo> myBackPlaces;
    private final LinkedList<PlaceInfo> myForwardPlaces;
    private boolean myBackInProgress;
    private boolean myForwardInProgress;
    private Object myLastGroupId;
    private boolean myRegisteredBackPlaceInLastGroup;
    private final LinkedList<PlaceInfo> myChangePlaces;
    private int myCurrentIndex;
    private PlaceInfo myCommandStartPlace;
    private boolean myCurrentCommandIsNavigation;
    private boolean myCurrentCommandHasChanges;
    private final Set<VirtualFile> myChangedFilesInCurrentCommand;
    private boolean myCurrentCommandHasMoves;
    private final PersistentHashMap<String, Long> myRecentFilesTimestampsMap;
    private final List<String> myRecentlyChangedFiles;

    public IdeDocumentHistoryImpl(@NotNull Project project) {
        if (project == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(0);
        }
        this.myBackPlaces = new LinkedList();
        this.myForwardPlaces = new LinkedList();
        this.myChangePlaces = new LinkedList();
        this.myChangedFilesInCurrentCommand = new THashSet();
        this.myRecentlyChangedFiles = new ArrayList<String>();
        this.myProject = project;
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeDocumentHistoryImpl.this.onSelectionChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$1", "selectionChanged"));
            }
        });
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    IdeDocumentHistoryImpl.this.removeInvalidFilesFromStacks();
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$2", "after"));
            }
        });
        busConnection.subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                IdeDocumentHistoryImpl.this.onCommandStarted();
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                IdeDocumentHistoryImpl.this.onCommandFinished(event.getProject(), event.getCommandGroupId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        EditorEventListener listener2 = new EditorEventListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                Document document = e.getDocument();
                VirtualFile file2 = IdeDocumentHistoryImpl.this.getFileDocumentManager().getFile(document);
                if (file2 != null && !(file2 instanceof LightVirtualFile) && !ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class)) {
                    if (!ApplicationManager.getApplication().isDispatchThread()) {
                        LOG.error("Document update for physical file not in EDT: " + file2);
                    }
                    IdeDocumentHistoryImpl.this.myCurrentCommandHasChanges = true;
                    IdeDocumentHistoryImpl.this.myChangedFilesInCurrentCommand.add(file2);
                }
            }

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (e.getOldPosition().line == e.getNewPosition().line) {
                    return;
                }
                Document document = e.getEditor().getDocument();
                if (IdeDocumentHistoryImpl.this.getFileDocumentManager().getFile(document) != null) {
                    IdeDocumentHistoryImpl.this.myCurrentCommandHasMoves = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)listener2, (Disposable)this);
        multicaster.addCaretListener((CaretListener)listener2, (Disposable)this);
        this.myRecentFilesTimestampsMap = this.initRecentFilesTimestampMap(project);
    }

    protected FileEditorManagerEx getFileEditorManager() {
        return FileEditorManagerEx.getInstanceEx(this.myProject);
    }

    @NotNull
    private PersistentHashMap<String, Long> initRecentFilesTimestampMap(@NotNull Project project) {
        PersistentHashMap map2;
        if (project == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(1);
        }
        Path file2 = ProjectUtil.getProjectCachePath((Project)project, (String)"recentFilesTimeStamps.dat");
        try {
            map2 = (PersistentHashMap)IOUtil.openCleanOrResetBroken(() -> IdeDocumentHistoryImpl.createMap(file2), (Path)file2);
        }
        catch (IOException e) {
            LOG.error("Cannot create PersistentHashMap in " + file2, (Throwable)e);
            throw new RuntimeException(e);
        }
        Disposer.register((Disposable)this, () -> {
            try {
                map2.close();
            }
            catch (IOException e) {
                LOG.info("Cannot close persistent viewed files timestamps hash map", (Throwable)e);
            }
        });
        PersistentHashMap persistentHashMap = map2;
        if (persistentHashMap == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(2);
        }
        return persistentHashMap;
    }

    @NotNull
    private static PersistentHashMap<String, Long> createMap(Path file2) throws IOException {
        return new PersistentHashMap(file2, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)EnumeratorLongDescriptor.INSTANCE, 256, 0, new PagedFileStorage.StorageLockContext(true));
    }

    private void registerViewed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        try {
            this.myRecentFilesTimestampsMap.put((Object)file2.getPath(), (Object)System.currentTimeMillis());
        }
        catch (IOException e) {
            LOG.info("Cannot put a timestamp from a persistent hash map", (Throwable)e);
        }
    }

    public static void appendTimestamp(@NotNull Project project, @NotNull SimpleColoredComponent component2, @NotNull VirtualFile file2) {
        if (project == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(4);
        }
        if (component2 == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(6);
        }
        if (!UISettings.getInstance().getShowInplaceComments()) {
            return;
        }
        try {
            Long timestamp = (Long)IdeDocumentHistoryImpl.getInstance(project).getRecentFilesTimestamps().get((Object)file2.getPath());
            if (timestamp != null) {
                component2.append(" ").append(DateFormatUtil.formatPrettyDateTime((long)timestamp), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
        catch (IOException e) {
            LOG.info("Cannot get a timestamp from a persistent hash map", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecentlyChangedFilesState getState() {
        List<String> list2 = this.myRecentlyChangedFiles;
        synchronized (list2) {
            RecentlyChangedFilesState state = new RecentlyChangedFilesState();
            state.CHANGED_PATHS.addAll(this.myRecentlyChangedFiles);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull RecentlyChangedFilesState state) {
        if (state == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(7);
        }
        List<String> list2 = this.myRecentlyChangedFiles;
        synchronized (list2) {
            this.myRecentlyChangedFiles.clear();
            this.myRecentlyChangedFiles.addAll(state.CHANGED_PATHS);
        }
    }

    public final void onSelectionChanged() {
        this.myCurrentCommandIsNavigation = true;
        this.myCurrentCommandHasMoves = true;
    }

    final void onCommandStarted() {
        this.myCommandStartPlace = this.getCurrentPlaceInfo();
        this.myCurrentCommandIsNavigation = false;
        this.myCurrentCommandHasChanges = false;
        this.myCurrentCommandHasMoves = false;
        this.myChangedFilesInCurrentCommand.clear();
    }

    @Nullable
    private PlaceInfo getCurrentPlaceInfo() {
        FileEditorWithProvider selectedEditorWithProvider = this.getSelectedEditor();
        if (selectedEditorWithProvider == null) {
            return null;
        }
        return this.createPlaceInfo(selectedEditorWithProvider.getFileEditor(), selectedEditorWithProvider.getProvider());
    }

    @Nullable
    private static PlaceInfo getPlaceInfoFromFocus() {
        VirtualFile file2;
        FileEditor fileEditor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
        if (fileEditor instanceof TextEditor && fileEditor.isValid() && (file2 = fileEditor.getFile()) != null) {
            return new PlaceInfo(file2, fileEditor.getState(FileEditorStateLevel.NAVIGATION), TextEditorProvider.getInstance().getEditorTypeId(), null, IdeDocumentHistoryImpl.getCaretPosition(fileEditor), System.currentTimeMillis());
        }
        return null;
    }

    final void onCommandFinished(Project project, Object commandGroupId) {
        if (!CommandMerger.canMergeGroup(commandGroupId, this.myLastGroupId)) {
            this.myRegisteredBackPlaceInLastGroup = false;
        }
        this.myLastGroupId = commandGroupId;
        if (this.myCommandStartPlace != null && this.myCurrentCommandIsNavigation && this.myCurrentCommandHasMoves) {
            if (!this.myBackInProgress) {
                if (!this.myRegisteredBackPlaceInLastGroup) {
                    this.myRegisteredBackPlaceInLastGroup = true;
                    this.putLastOrMerge(this.myCommandStartPlace, BACK_QUEUE_LIMIT, false);
                    this.registerViewed(this.myCommandStartPlace.myFile);
                }
                if (!this.myForwardInProgress) {
                    this.myForwardPlaces.clear();
                }
            }
            this.removeInvalidFilesFromStacks();
        }
        if (this.myCurrentCommandHasChanges) {
            this.setCurrentChangePlace(project == this.myProject);
        } else if (this.myCurrentCommandHasMoves) {
            this.myCurrentIndex = this.myChangePlaces.size();
        }
    }

    @Override
    public final void includeCurrentCommandAsNavigation() {
        this.myCurrentCommandIsNavigation = true;
    }

    @Override
    public void setCurrentCommandHasMoves() {
        this.myCurrentCommandHasMoves = true;
    }

    @Override
    public final void includeCurrentPlaceAsChangePlace() {
        this.setCurrentChangePlace(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentChangePlace(boolean acceptPlaceFromFocus) {
        PlaceInfo placeInfo = this.getCurrentPlaceInfo();
        if (placeInfo != null && !this.myChangedFilesInCurrentCommand.contains(placeInfo.getFile())) {
            placeInfo = null;
        }
        if (placeInfo == null && acceptPlaceFromFocus) {
            placeInfo = IdeDocumentHistoryImpl.getPlaceInfoFromFocus();
        }
        if (placeInfo != null && !this.myChangedFilesInCurrentCommand.contains(placeInfo.getFile())) {
            placeInfo = null;
        }
        if (placeInfo == null) {
            return;
        }
        int limit = UISettings.getInstance().getRecentFilesLimit() + 1;
        List<String> list2 = this.myRecentlyChangedFiles;
        synchronized (list2) {
            String path = placeInfo.getFile().getPath();
            this.myRecentlyChangedFiles.remove(path);
            this.myRecentlyChangedFiles.add(path);
            while (this.myRecentlyChangedFiles.size() > limit) {
                this.myRecentlyChangedFiles.remove(0);
            }
        }
        this.putLastOrMerge(placeInfo, CHANGE_QUEUE_LIMIT, true);
        this.myCurrentIndex = this.myChangePlaces.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile[] getChangedFiles() {
        ArrayList<String> paths;
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        List<String> list2 = this.myRecentlyChangedFiles;
        synchronized (list2) {
            paths = new ArrayList<String>(this.myRecentlyChangedFiles);
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (String path : paths) {
            VirtualFile file2 = lfs.findFileByPath(path);
            if (file2 == null) continue;
            files2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(files2);
    }

    @Override
    public PersistentHashMap<String, Long> getRecentFilesTimestamps() {
        return this.myRecentFilesTimestampsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRecentlyChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(8);
        }
        List<String> list2 = this.myRecentlyChangedFiles;
        synchronized (list2) {
            return this.myRecentlyChangedFiles.contains(file2.getPath());
        }
    }

    @Override
    public final void clearHistory() {
        this.myBackPlaces.clear();
        this.myForwardPlaces.clear();
        this.myChangePlaces.clear();
        this.myLastGroupId = null;
        this.myCurrentIndex = 0;
        this.myCommandStartPlace = null;
    }

    @Override
    public final void back() {
        this.removeInvalidFilesFromStacks();
        if (this.myBackPlaces.isEmpty()) {
            return;
        }
        PlaceInfo info = this.myBackPlaces.removeLast();
        ((RecentPlacesListener)this.myProject.getMessageBus().syncPublisher(RecentPlacesListener.TOPIC)).recentPlaceRemoved(info, false);
        PlaceInfo current2 = this.getCurrentPlaceInfo();
        if (current2 != null) {
            this.myForwardPlaces.add(current2);
        }
        this.myBackInProgress = true;
        try {
            this.executeCommand(() -> this.gotoPlaceInfo(info), "", null);
        }
        finally {
            this.myBackInProgress = false;
        }
    }

    @Override
    public final void forward() {
        this.removeInvalidFilesFromStacks();
        PlaceInfo target2 = this.getTargetForwardInfo();
        if (target2 == null) {
            return;
        }
        this.myForwardInProgress = true;
        try {
            this.executeCommand(() -> this.gotoPlaceInfo(target2), "", null);
        }
        finally {
            this.myForwardInProgress = false;
        }
    }

    private PlaceInfo getTargetForwardInfo() {
        if (this.myForwardPlaces.isEmpty()) {
            return null;
        }
        PlaceInfo target2 = this.myForwardPlaces.removeLast();
        PlaceInfo current2 = this.getCurrentPlaceInfo();
        while (!this.myForwardPlaces.isEmpty() && current2 != null && IdeDocumentHistoryImpl.isSame(current2, target2)) {
            target2 = this.myForwardPlaces.removeLast();
        }
        return target2;
    }

    @Override
    public final boolean isBackAvailable() {
        return !this.myBackPlaces.isEmpty();
    }

    @Override
    public final boolean isForwardAvailable() {
        return !this.myForwardPlaces.isEmpty();
    }

    @Override
    public final void navigatePreviousChange() {
        this.removeInvalidFilesFromStacks();
        if (this.myCurrentIndex == 0) {
            return;
        }
        PlaceInfo currentPlace = this.getCurrentPlaceInfo();
        for (int i = this.myCurrentIndex - 1; i >= 0; --i) {
            PlaceInfo info = this.myChangePlaces.get(i);
            if (currentPlace != null && IdeDocumentHistoryImpl.isSame(currentPlace, info)) continue;
            this.executeCommand(() -> this.gotoPlaceInfo(info), "", null);
            this.myCurrentIndex = i;
            break;
        }
    }

    @Override
    @NotNull
    public List<PlaceInfo> getBackPlaces() {
        ImmutableList immutableList = ContainerUtil.immutableList(this.myBackPlaces);
        if (immutableList == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    @Override
    public List<PlaceInfo> getChangePlaces() {
        return ContainerUtil.immutableList(this.myChangePlaces);
    }

    @Override
    public void removeBackPlace(@NotNull PlaceInfo placeInfo) {
        if (placeInfo == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(10);
        }
        this.removePlaceInfo(placeInfo, this.myBackPlaces, false);
    }

    @Override
    public void removeChangePlace(@NotNull PlaceInfo placeInfo) {
        if (placeInfo == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(11);
        }
        this.removePlaceInfo(placeInfo, this.myChangePlaces, true);
    }

    private void removePlaceInfo(@NotNull PlaceInfo placeInfo, @NotNull LinkedList<PlaceInfo> places, boolean changed2) {
        boolean removed;
        if (placeInfo == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(12);
        }
        if (places == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(13);
        }
        if (removed = places.remove(placeInfo)) {
            ((RecentPlacesListener)this.myProject.getMessageBus().syncPublisher(RecentPlacesListener.TOPIC)).recentPlaceRemoved(placeInfo, changed2);
        }
    }

    @Override
    public final boolean isNavigatePreviousChangeAvailable() {
        return this.myCurrentIndex > 0;
    }

    void removeInvalidFilesFromStacks() {
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myBackPlaces);
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myForwardPlaces);
        if (IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myChangePlaces)) {
            this.myCurrentIndex = this.myChangePlaces.size();
        }
    }

    @Override
    public void navigateNextChange() {
        this.removeInvalidFilesFromStacks();
        if (this.myCurrentIndex >= this.myChangePlaces.size()) {
            return;
        }
        PlaceInfo currentPlace = this.getCurrentPlaceInfo();
        for (int i = this.myCurrentIndex; i < this.myChangePlaces.size(); ++i) {
            PlaceInfo info = this.myChangePlaces.get(i);
            if (currentPlace != null && IdeDocumentHistoryImpl.isSame(currentPlace, info)) continue;
            this.executeCommand(() -> this.gotoPlaceInfo(info), "", null);
            this.myCurrentIndex = i + 1;
            break;
        }
    }

    @Override
    public boolean isNavigateNextChangeAvailable() {
        return this.myCurrentIndex < this.myChangePlaces.size();
    }

    private static boolean removeInvalidFilesFrom(@NotNull List<PlaceInfo> backPlaces) {
        if (backPlaces == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(14);
        }
        boolean removed = false;
        Iterator<PlaceInfo> iterator2 = backPlaces.iterator();
        while (iterator2.hasNext()) {
            PlaceInfo info = iterator2.next();
            VirtualFile file2 = info.myFile;
            if (file2.isValid()) continue;
            iterator2.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public void gotoPlaceInfo(@NotNull PlaceInfo info) {
        if (info == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(15);
        }
        this.gotoPlaceInfo(info, ToolWindowManager.getInstance((Project)this.myProject).isEditorComponentActive());
    }

    @Override
    public void gotoPlaceInfo(@NotNull PlaceInfo info, boolean wasActive) {
        if (info == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(16);
        }
        EditorWindow wnd = info.getWindow();
        FileEditorManagerEx editorManager = this.getFileEditorManager();
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = wnd != null && wnd.isValid() ? editorManager.openFileWithProviders(info.getFile(), wasActive, wnd) : editorManager.openFileWithProviders(info.getFile(), wasActive, false);
        editorManager.setSelectedEditor(info.getFile(), info.getEditorTypeId());
        FileEditor[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        for (int i = 0; i < editors.length; ++i) {
            String typeId = providers[i].getEditorTypeId();
            if (!typeId.equals(info.getEditorTypeId())) continue;
            editors[i].setState(info.getNavigationState());
        }
    }

    @Nullable
    protected FileEditorWithProvider getSelectedEditor() {
        FileEditorManagerEx editorManager = this.getFileEditorManager();
        VirtualFile file2 = editorManager != null ? editorManager.getCurrentFile() : null;
        return file2 == null ? null : editorManager.getSelectedEditorWithProvider(file2);
    }

    protected PlaceInfo createPlaceInfo(@NotNull FileEditor fileEditor, FileEditorProvider fileProvider) {
        if (fileEditor == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(17);
        }
        if (!fileEditor.isValid()) {
            return null;
        }
        FileEditorManagerEx editorManager = this.getFileEditorManager();
        VirtualFile file2 = editorManager.getFile(fileEditor);
        LOG.assertTrue(file2 != null);
        FileEditorState state = fileEditor.getState(FileEditorStateLevel.NAVIGATION);
        return new PlaceInfo(file2, state, fileProvider.getEditorTypeId(), editorManager.getCurrentWindow(), IdeDocumentHistoryImpl.getCaretPosition(fileEditor), System.currentTimeMillis());
    }

    @Nullable
    private static RangeMarker getCaretPosition(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(18);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        int offset = editor.getCaretModel().getOffset();
        return editor.getDocument().createRangeMarker(offset, offset);
    }

    private void putLastOrMerge(@NotNull PlaceInfo next, int limit, boolean isChanged) {
        PlaceInfo prev;
        if (next == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(19);
        }
        LinkedList<PlaceInfo> list2 = isChanged ? this.myChangePlaces : this.myBackPlaces;
        MessageBus messageBus = this.myProject.getMessageBus();
        RecentPlacesListener listener2 = (RecentPlacesListener)messageBus.syncPublisher(RecentPlacesListener.TOPIC);
        if (!list2.isEmpty() && IdeDocumentHistoryImpl.isSame(prev = list2.getLast(), next)) {
            PlaceInfo removed = list2.removeLast();
            listener2.recentPlaceRemoved(removed, isChanged);
        }
        list2.add(next);
        listener2.recentPlaceAdded(next, isChanged);
        if (list2.size() > limit) {
            PlaceInfo first = list2.removeFirst();
            listener2.recentPlaceRemoved(first, isChanged);
        }
    }

    private FileDocumentManager getFileDocumentManager() {
        if (this.myFileDocumentManager == null) {
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }
        return this.myFileDocumentManager;
    }

    public final void dispose() {
        this.myLastGroupId = null;
    }

    protected void executeCommand(Runnable runnable2, String name, Object groupId2) {
        CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, name, groupId2);
    }

    public static boolean isSame(@NotNull PlaceInfo first, @NotNull PlaceInfo second) {
        if (first == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(20);
        }
        if (second == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(21);
        }
        if (first.getFile().equals(second.getFile())) {
            FileEditorState secondState;
            FileEditorState firstState = first.getNavigationState();
            return firstState.equals(secondState = second.getNavigationState()) || firstState.canBeMergedWith(secondState, FileEditorStateLevel.NAVIGATION);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backPlaces";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initRecentFilesTimestampMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackPlaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initRecentFilesTimestampMap";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerViewed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendTimestamp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRecentlyChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeBackPlace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeChangePlace";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removePlaceInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeInvalidFilesFrom";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "gotoPlaceInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCaretPosition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putLastOrMerge";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSame";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RecentPlacesListener {
        public static final Topic<RecentPlacesListener> TOPIC = Topic.create((String)"RecentPlacesListener", RecentPlacesListener.class);

        public void recentPlaceAdded(@NotNull PlaceInfo var1, boolean var2);

        public void recentPlaceRemoved(@NotNull PlaceInfo var1, boolean var2);
    }

    public static final class PlaceInfo {
        private final VirtualFile myFile;
        private final FileEditorState myNavigationState;
        private final String myEditorTypeId;
        private final Reference<EditorWindow> myWindow;
        @Nullable
        private final RangeMarker myCaretPosition;
        private final long myTimeStamp;

        public PlaceInfo(@NotNull VirtualFile file2, @NotNull FileEditorState navigationState, @NotNull String editorTypeId, @Nullable EditorWindow window, @Nullable RangeMarker caretPosition) {
            if (file2 == null) {
                PlaceInfo.$$$reportNull$$$0(0);
            }
            if (navigationState == null) {
                PlaceInfo.$$$reportNull$$$0(1);
            }
            if (editorTypeId == null) {
                PlaceInfo.$$$reportNull$$$0(2);
            }
            this.myNavigationState = navigationState;
            this.myFile = file2;
            this.myEditorTypeId = editorTypeId;
            this.myWindow = new WeakReference<EditorWindow>(window);
            this.myCaretPosition = caretPosition;
            this.myTimeStamp = -1L;
        }

        public PlaceInfo(@NotNull VirtualFile file2, @NotNull FileEditorState navigationState, @NotNull String editorTypeId, @Nullable EditorWindow window, @Nullable RangeMarker caretPosition, long stamp) {
            if (file2 == null) {
                PlaceInfo.$$$reportNull$$$0(3);
            }
            if (navigationState == null) {
                PlaceInfo.$$$reportNull$$$0(4);
            }
            if (editorTypeId == null) {
                PlaceInfo.$$$reportNull$$$0(5);
            }
            this.myNavigationState = navigationState;
            this.myFile = file2;
            this.myEditorTypeId = editorTypeId;
            this.myWindow = new WeakReference<EditorWindow>(window);
            this.myCaretPosition = caretPosition;
            this.myTimeStamp = stamp;
        }

        public EditorWindow getWindow() {
            return this.myWindow.get();
        }

        @NotNull
        public FileEditorState getNavigationState() {
            FileEditorState fileEditorState = this.myNavigationState;
            if (fileEditorState == null) {
                PlaceInfo.$$$reportNull$$$0(6);
            }
            return fileEditorState;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                PlaceInfo.$$$reportNull$$$0(7);
            }
            return virtualFile;
        }

        @NotNull
        public String getEditorTypeId() {
            String string = this.myEditorTypeId;
            if (string == null) {
                PlaceInfo.$$$reportNull$$$0(8);
            }
            return string;
        }

        public String toString() {
            return this.getFile().getName() + " " + this.getNavigationState();
        }

        @Nullable
        public RangeMarker getCaretPosition() {
            return this.myCaretPosition;
        }

        public long getTimeStamp() {
            return this.myTimeStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationState";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorTypeId";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationState";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorTypeId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RecentlyChangedFilesState {
        public List<String> CHANGED_PATHS = new ArrayList<String>();
    }
}

