/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemProjectsWatcherImpl
implements ExternalSystemProjectsWatcher {
    private final Project project;
    private static final ExtensionPointName<Contributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalProjectWatcherContributor");

    public ExternalSystemProjectsWatcherImpl(Project project) {
        this.project = project;
    }

    public void markDirtyAllExternalProjects() {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.project);
        this.findAllProjectSettings().forEach(it -> projectTracker.markDirty(it));
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirtyAllExternalProjects(this.project);
        }
        projectTracker.scheduleProjectRefresh();
    }

    public void markDirty(Module module) {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.project);
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        this.findAllProjectSettings().stream().filter(it -> it.getExternalProjectPath().equals(projectPath)).forEach(it -> projectTracker.markDirty(it));
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirty(module);
        }
        projectTracker.scheduleProjectRefresh();
    }

    public void markDirty(String projectPath) {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.project);
        this.findAllProjectSettings().stream().filter(it -> it.getExternalProjectPath().equals(projectPath)).forEach(it -> projectTracker.markDirty(it));
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirty(projectPath);
        }
        projectTracker.scheduleProjectRefresh();
    }

    private List<ExternalSystemProjectId> findAllProjectSettings() {
        ArrayList<ExternalSystemProjectId> list2 = new ArrayList<ExternalSystemProjectId>();
        ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager -> {
            ProjectSystemId systemId = manager.getSystemId();
            Collection linkedProjectsSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.project)).getLinkedProjectsSettings();
            for (ExternalProjectSettings settings : linkedProjectsSettings) {
                String externalProjectPath = settings.getExternalProjectPath();
                if (externalProjectPath == null) continue;
                list2.add(new ExternalSystemProjectId(systemId, externalProjectPath));
            }
        });
        return list2;
    }

    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);

        default public void markDirty(@NotNull String projectPath) {
            if (projectPath == null) {
                Contributor.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$Contributor", "markDirty"));
        }
    }
}

