/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PasteFromX11Action
extends EditorAction {
    private static final Logger LOG = Logger.getInstance(PasteFromX11Action.class);

    public PasteFromX11Action() {
        super((EditorActionHandler)new Handler());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PasteFromX11Action.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null || !SystemInfo.isXWindow) {
            presentation.setEnabled(false);
        } else {
            boolean rightPlace = true;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                rightPlace = false;
                MouseEvent me = (MouseEvent)inputEvent;
                if (dataContext.getData(EditorGutter.KEY) == null) {
                    Component component2 = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
                    rightPlace = !(component2 instanceof JScrollBar);
                }
            }
            presentation.setEnabled(rightPlace);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/PasteFromX11Action", "update"));
    }

    public static class Handler
    extends BasePasteHandler {
        @Override
        protected Transferable getContentsToPaste(Editor editor, DataContext dataContext) {
            Clipboard clip = editor.getComponent().getToolkit().getSystemSelection();
            if (clip == null) {
                return null;
            }
            try {
                return clip.getContents(null);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
    }
}

