/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.CannotUndoReportDialog;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.MentionOnlyUndoableAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

abstract class UndoRedo {
    protected final UndoManagerImpl myManager;
    protected final FileEditor myEditor;
    protected final UndoableGroup myUndoableGroup;

    protected UndoRedo(UndoManagerImpl manager, FileEditor editor) {
        this.myManager = manager;
        this.myEditor = editor;
        this.myUndoableGroup = this.getLastAction();
    }

    private UndoableGroup getLastAction() {
        return this.getStackHolder().getLastAction(this.getDecRefs());
    }

    boolean isTransparent() {
        return this.myUndoableGroup.isTransparent();
    }

    boolean isTemporary() {
        return this.myUndoableGroup.isTemporary();
    }

    boolean hasMoreActions() {
        return this.getStackHolder().canBeUndoneOrRedone(this.getDecRefs());
    }

    private Set<DocumentReference> getDecRefs() {
        return this.myEditor == null ? Collections.emptySet() : UndoManagerImpl.getDocumentReferences(this.myEditor);
    }

    protected abstract UndoRedoStacksHolder getStackHolder();

    protected abstract UndoRedoStacksHolder getReverseStackHolder();

    protected abstract String getActionName();

    protected abstract String getActionName(String var1);

    protected abstract EditorAndState getBeforeState();

    protected abstract EditorAndState getAfterState();

    protected abstract void performAction();

    protected abstract void setBeforeState(EditorAndState var1);

    public boolean execute(boolean drop, boolean disableConfirmation) {
        Collection<Document> readOnlyDocuments;
        Collection<VirtualFile> readOnlyFiles;
        if (!this.myUndoableGroup.isUndoable()) {
            this.reportCannotUndo(IdeBundle.message((String)"cannot.undo.error.contains.nonundoable.changes.message", (Object[])new Object[0]), this.myUndoableGroup.getAffectedDocuments());
            return false;
        }
        Set<DocumentReference> clashing = this.getStackHolder().collectClashingActions(this.myUndoableGroup);
        if (!clashing.isEmpty()) {
            this.reportCannotUndo(IdeBundle.message((String)"cannot.undo.error.other.affected.files.changed.message", (Object[])new Object[0]), clashing);
            return false;
        }
        if (!disableConfirmation && this.myUndoableGroup.shouldAskConfirmation(this.isRedo()) && !UndoManagerImpl.ourNeverAskUser) {
            if (!this.askUser()) {
                return false;
            }
        } else if (this.restore(this.getBeforeState(), true)) {
            this.setBeforeState(new EditorAndState(this.myEditor, this.myEditor.getState(FileEditorStateLevel.UNDO)));
            return true;
        }
        if (!(readOnlyFiles = this.collectReadOnlyAffectedFiles()).isEmpty()) {
            Project project = this.myManager.getProject();
            if (project == null) {
                return false;
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(readOnlyFiles);
            if (operationStatus.hasReadonlyFiles()) {
                return false;
            }
        }
        if (!(readOnlyDocuments = this.collectReadOnlyDocuments()).isEmpty()) {
            for (Document document : readOnlyDocuments) {
                document.fireReadOnlyModificationAttempt();
            }
            return false;
        }
        this.getStackHolder().removeFromStacks(this.myUndoableGroup);
        if (!drop) {
            this.getReverseStackHolder().addToStacks(this.myUndoableGroup);
        }
        this.performAction();
        this.restore(this.getAfterState(), false);
        return true;
    }

    protected abstract boolean isRedo();

    private Collection<Document> collectReadOnlyDocuments() {
        ArrayList<Document> readOnlyDocs = new ArrayList<Document>();
        for (UndoableAction action2 : this.myUndoableGroup.getActions()) {
            DocumentReference[] refs;
            if (action2 instanceof MentionOnlyUndoableAction || (refs = action2.getAffectedDocuments()) == null) continue;
            for (DocumentReference ref : refs) {
                Document doc;
                if (!(ref instanceof DocumentReferenceByDocument) || (doc = ref.getDocument()) == null || doc.isWritable()) continue;
                readOnlyDocs.add(doc);
            }
        }
        return readOnlyDocs;
    }

    private Collection<VirtualFile> collectReadOnlyAffectedFiles() {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (UndoableAction action2 : this.myUndoableGroup.getActions()) {
            DocumentReference[] refs;
            if (action2 instanceof MentionOnlyUndoableAction || (refs = action2.getAffectedDocuments()) == null) continue;
            for (DocumentReference ref : refs) {
                VirtualFile file2 = ref.getFile();
                if (file2 == null || !file2.isValid() || file2.isWritable()) continue;
                readOnlyFiles.add(file2);
            }
        }
        return readOnlyFiles;
    }

    private void reportCannotUndo(String message, Collection<? extends DocumentReference> problemFiles) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message + "\n" + StringUtil.join(problemFiles, (Function)StringUtil.createToStringFunction(DocumentReference.class), (String)"\n"));
        }
        new CannotUndoReportDialog(this.myManager.getProject(), message, problemFiles).show();
    }

    private boolean askUser() {
        String actionText = this.getActionName(this.myUndoableGroup.getCommandName());
        return Messages.showOkCancelDialog((Project)this.myManager.getProject(), (String)(actionText + "?"), (String)this.getActionName(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    boolean confirmSwitchTo(@NotNull UndoRedo other) {
        if (other == null) {
            UndoRedo.$$$reportNull$$$0(0);
        }
        String message = IdeBundle.message((String)"undo.conflicting.change.confirmation", (Object[])new Object[0]) + "\n" + this.getActionName(other.myUndoableGroup.getCommandName()) + "?";
        return Messages.showOkCancelDialog((Project)this.myManager.getProject(), (String)message, (String)this.getActionName(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private boolean restore(EditorAndState pair, boolean onlyIfDiffers) {
        if (pair == null || this.myEditor == null || !this.myEditor.isValid() || !pair.canBeAppliedTo(this.myEditor)) {
            return false;
        }
        FileEditorState stateToRestore = pair.getState();
        FileEditorState currentState = this.myEditor.getState(FileEditorStateLevel.UNDO);
        if (onlyIfDiffers && currentState.equals(stateToRestore)) {
            return false;
        }
        this.myEditor.setState(stateToRestore);
        FileEditorState newState2 = this.myEditor.getState(FileEditorStateLevel.UNDO);
        return newState2.equals(stateToRestore);
    }

    public boolean isBlockedByOtherChanges() {
        return this.myUndoableGroup.isGlobal() && this.myUndoableGroup.isUndoable() && !this.getStackHolder().collectClashingActions(this.myUndoableGroup).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/openapi/command/impl/UndoRedo", "confirmSwitchTo"));
    }
}

