/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.moduleDependencies.DependenciesAnalyzeManager;
import com.intellij.moduleDependencies.ModulesDependenciesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class ShowModuleDependenciesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowModuleDependenciesAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowModuleDependenciesAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Module[] modules = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        if (modules == null) {
            Module module;
            PsiElement element2 = (PsiElement)e.getData(CommonDataKeys.PSI_FILE);
            Module module2 = module = element2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)element2) : null;
            if (module != null && ModuleManager.getInstance((Project)project).getModules().length > 1) {
                MyModuleOrProjectScope dlg = new MyModuleOrProjectScope(module.getName());
                if (!dlg.showAndGet()) {
                    return;
                }
                if (!dlg.useProjectScope()) {
                    modules = new Module[]{module};
                }
            }
        }
        ModulesDependenciesPanel panel2 = new ModulesDependenciesPanel(project, modules);
        AnalysisScope scope = modules != null ? new AnalysisScope(modules) : new AnalysisScope(project);
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, scope.getDisplayName(), false);
        content2.setHelpId("module.dependencies.tool.window");
        content2.setDisposer((Disposable)panel2);
        panel2.setContent(content2);
        DependenciesAnalyzeManager.getInstance(project).addContent(content2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/moduleDependencies/ShowModuleDependenciesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyModuleOrProjectScope
    extends DialogWrapper {
        private final JRadioButton myProjectScope;
        private final JRadioButton myModuleScope;

        protected MyModuleOrProjectScope(String moduleName) {
            super(false);
            this.setTitle(CodeInsightBundle.message((String)"module.dependencies.scope.dialog.title", (Object[])new Object[0]));
            ButtonGroup group = new ButtonGroup();
            this.myProjectScope = new JRadioButton(CodeInsightBundle.message((String)"module.dependencies.scope.dialog.project.button", (Object[])new Object[0]));
            this.myModuleScope = new JRadioButton(CodeInsightBundle.message((String)"module.dependencies.scope.dialog.module.button", (Object[])new Object[]{moduleName}));
            group.add(this.myProjectScope);
            group.add(this.myModuleScope);
            this.myProjectScope.setSelected(true);
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new GridLayout(2, 1));
            panel2.add(this.myProjectScope);
            panel2.add(this.myModuleScope);
            return panel2;
        }

        public boolean useProjectScope() {
            return this.myProjectScope.isSelected();
        }
    }
}

