/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.google.common.base.MoreObjects;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInspectorAction
extends ToggleAction
implements DumbAware {
    private static final String CLICK_INFO = "CLICK_INFO";
    private static final String CLICK_INFO_POINT = "CLICK_INFO_POINT";
    private static final String RENDERER_BOUNDS = "clicked renderer";
    private static final int MAX_DEEPNESS_TO_DISCOVER_FIELD_NAME = 8;
    private UiInspector myInspector;

    public UiInspectorAction() {
        if (Boolean.getBoolean("idea.ui.debug.mode")) {
            ApplicationManager.getApplication().invokeLater(() -> this.setSelected(true));
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            UiInspectorAction.$$$reportNull$$$0(0);
        }
        return this.myInspector != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            UiInspectorAction.$$$reportNull$$$0(1);
        }
        this.setSelected(state);
    }

    void setSelected(boolean state) {
        if (state) {
            UiInspectorNotification[] existing;
            if (this.myInspector == null) {
                this.myInspector = new UiInspector();
            }
            if ((existing = (UiInspectorNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UiInspectorNotification.class, null)).length == 0 && !Boolean.getBoolean("idea.ui.debug.mode")) {
                Notifications.Bus.notify((Notification)new UiInspectorNotification(), null);
            }
        } else {
            UiInspector inspector = this.myInspector;
            this.myInspector = null;
            if (inspector != null) {
                Disposer.dispose((Disposable)inspector);
            }
        }
    }

    @NotNull
    private static String getComponentName(Component component2) {
        String name = UiInspectorAction.getClassName(component2);
        String componentName = component2.getName();
        if (StringUtil.isNotEmpty((String)componentName)) {
            name = name + " \"" + componentName + "\"";
        }
        String string = name;
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static Pair<Class, String> getClassAndFieldName(Component component2) {
        Container parent = component2.getParent();
        for (int deepness = 1; parent != null && deepness <= 8; parent = parent.getParent(), ++deepness) {
            Field[] fields;
            Class<?> aClass = parent.getClass();
            for (Field field : fields = aClass.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    if (field.get(parent) != component2) continue;
                    return Pair.create(parent.getClass(), (Object)field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static TreeModel buildModel(Component c) {
        Container parent = c.getParent();
        while (parent != null) {
            c = parent;
            parent = c.getParent();
        }
        return new DefaultTreeModel(new HierarchyTree.ComponentNode(c));
    }

    private static void drawCenteredString(Graphics2D g2d, FontMetrics fm, int fontHeight, String text2, int x, int y) {
        int width = fm.stringWidth(text2);
        UIUtil.drawCenteredString((Graphics2D)g2d, (Rectangle)new Rectangle(x - width / 2, y - fontHeight / 2, width, fontHeight), (String)text2);
    }

    @NotNull
    private static String getToStringValue(@NotNull Object value2) {
        if (value2 == null) {
            UiInspectorAction.$$$reportNull$$$0(3);
        }
        StringBuilder sb = new StringBuilder();
        if (value2.getClass().getName().equals("javax.swing.ArrayTable")) {
            Object table = ReflectionUtil.getField(value2.getClass(), (Object)value2, Object.class, (String)"table");
            if (table != null) {
                try {
                    if (table instanceof Object[]) {
                        Object[] arr = (Object[])table;
                        for (int i = 0; i < arr.length; i += 2) {
                            if (arr[i].equals("uiInspector.addedAt")) continue;
                            if (sb.length() > 0) {
                                sb.append(",");
                            }
                            sb.append('[').append(arr[i]).append("->").append(arr[i + 1]).append(']');
                        }
                    } else if (table instanceof Map) {
                        Map map2 = (Map)table;
                        Set set = map2.entrySet();
                        for (Map.Entry entry : set) {
                            if (entry.getKey().equals("uiInspector.addedAt")) continue;
                            if (sb.length() > 0) {
                                sb.append(",");
                            }
                            sb.append('[').append(entry.getKey()).append("->").append(entry.getValue()).append(']');
                        }
                    }
                }
                catch (Exception map2) {
                    // empty catch block
                }
            }
            if (sb.length() == 0) {
                sb.append("-");
            }
            value2 = sb;
        }
        if (value2.getClass().isArray()) {
            int length = Array.getLength(value2);
            for (int index = 0; index < length; ++index) {
                Object obj;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if ((obj = Array.get(value2, index)) == null) continue;
                sb.append(obj.getClass().getName());
            }
            value2 = sb.length() == 0 ? "-" : sb;
        }
        String toString2 = StringUtil.notNullize((String)String.valueOf(value2), (String)"toString()==null");
        String string = toString2.replace('\n', ' ');
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getClassName(Object value2) {
        Class<?> clazz0 = value2.getClass();
        Class<?> clazz = clazz0.isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
        String string = clazz.getSimpleName();
        if (string == null) {
            UiInspectorAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static ColorIcon createColorIcon(Color color) {
        return (ColorIcon)JBUI.scale((JBUI.JBIcon)new ColorIcon(13, 11, color, true));
    }

    private static Icon createColorIcon(Color color1, Color color2) {
        return JBUI.scale((JBUI.JBIcon)new ColorsIcon(11, new Color[]{color1, color2}));
    }

    @Nullable
    private static AnAction getAction(Component c) {
        return (AnAction)UIUtil.getClientProperty((Object)c, (Key)CustomComponentAction.ACTION_KEY);
    }

    private static Object fromObject(Object o, Class<?> type) {
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return o;
        }
        if ("null".equals(o)) {
            return null;
        }
        String value2 = String.valueOf(o).trim();
        if (type == Integer.TYPE) {
            return Integer.parseInt(value2);
        }
        if (type == Boolean.TYPE) {
            return "yes".equalsIgnoreCase(value2) || "true".equalsIgnoreCase(value2);
        }
        if (type == Byte.TYPE) {
            return Byte.parseByte(value2);
        }
        if (type == Short.TYPE) {
            return Short.parseShort(value2);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value2);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value2));
        }
        String[] s = value2.split("(?i)\\s*(?:[x@:]|[a-z]+:)\\s*", 6);
        if (type == Dimension.class) {
            if (s.length == 2) {
                return new Dimension(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type == Point.class) {
            if (s.length == 2) {
                return new Point(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
            }
        } else if (type == Rectangle.class) {
            if (s.length >= 5) {
                return new Rectangle(Integer.parseInt(s[3]), Integer.parseInt(s[4]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
            }
        } else if (type == Insets.class) {
            if (s.length >= 5) {
                return new Insets(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[4]), Integer.parseInt(s[4]));
            }
        } else if (type == Color.class) {
            if (s.length >= 5) {
                return new ColorUIResource(new Color(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])));
            }
        } else if (type.getSimpleName().contains("ArrayTable")) {
            return "ArrayTable!";
        }
        throw new UnsupportedOperationException(type.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToStringValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getToStringValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UiInspector
    implements AWTEventListener,
    Disposable {
        UiInspector() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 18L);
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            for (Window window : Window.getWindows()) {
                if (!(window instanceof InspectorWindow)) continue;
                ((InspectorWindow)window).close();
            }
        }

        public void showInspector(@NotNull Component c) {
            if (c == null) {
                UiInspector.$$$reportNull$$$0(0);
            }
            InspectorWindow window = new InspectorWindow(c);
            if (DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey()) == null) {
                window.pack();
            }
            ((Window)window).setVisible(true);
            window.toFront();
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)event);
            } else if (event instanceof ContainerEvent) {
                UiInspector.processContainerEvent((ContainerEvent)event);
            }
        }

        private void processMouseEvent(MouseEvent me) {
            if (!me.isAltDown() || !me.isControlDown()) {
                return;
            }
            if (me.getClickCount() != 1 || me.isPopupTrigger()) {
                return;
            }
            me.consume();
            if (me.getID() != 502) {
                return;
            }
            Component component2 = me.getComponent();
            if (component2 instanceof Container) {
                component2 = ((Container)component2).findComponentAt(me.getPoint());
            } else if (component2 == null) {
                component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            if (component2 != null) {
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).putClientProperty(UiInspectorAction.CLICK_INFO, UiInspector.getClickInfo(me, component2));
                    ((JComponent)component2).putClientProperty(UiInspectorAction.CLICK_INFO_POINT, me.getPoint());
                }
                this.showInspector(component2);
            }
        }

        private static List<PropertyBean> getClickInfo(MouseEvent me, Component component2) {
            JTree tree;
            TreePath path;
            JList list2;
            int row;
            if (me.getComponent() == null) {
                return null;
            }
            me = SwingUtilities.convertMouseEvent(me.getComponent(), me, component2);
            ArrayList<PropertyBean> clickInfo = new ArrayList<PropertyBean>();
            if (component2 instanceof JList && (row = (list2 = (JList)component2).getUI().locationToIndex(list2, me.getPoint())) != -1) {
                Component rendererComponent = list2.getCellRenderer().getListCellRendererComponent(list2, list2.getModel().getElementAt(row), row, list2.getSelectionModel().isSelectedIndex(row), list2.hasFocus());
                clickInfo.addAll(UiInspector.findActionsFor(list2.getModel().getElementAt(row)));
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, list2.getUI().getCellBounds(list2, row, row)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            if (component2 instanceof JTable) {
                JTable table = (JTable)component2;
                row = table.rowAtPoint(me.getPoint());
                int column = table.columnAtPoint(me.getPoint());
                if (row != -1 && column != -1) {
                    Component rendererComponent = table.getCellRenderer(row, column).getTableCellRendererComponent(table, table.getValueAt(row, column), table.getSelectionModel().isSelectedIndex(row), table.hasFocus(), row, column);
                    clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, table.getCellRect(row, column, true)));
                    clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                    return clickInfo;
                }
            }
            if (component2 instanceof JTree && (path = (tree = (JTree)component2).getClosestPathForLocation(me.getX(), me.getY())) != null) {
                Object object = path.getLastPathComponent();
                Component rendererComponent = tree.getCellRenderer().getTreeCellRendererComponent(tree, object, tree.getSelectionModel().isPathSelected(path), tree.isExpanded(path), tree.getModel().isLeaf(object), tree.getRowForPath(path), tree.hasFocus());
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, tree.getPathBounds(path)));
                clickInfo.addAll(new InspectorTableModel((Component)rendererComponent).myProperties);
                return clickInfo;
            }
            return null;
        }

        private static List<PropertyBean> findActionsFor(Object object) {
            if (object instanceof PopupFactoryImpl.ActionItem) {
                AnAction action2 = ((PopupFactoryImpl.ActionItem)object).getAction();
                return UiInspectorUtil.collectAnActionInfo(action2);
            }
            if (object instanceof QuickFixWrapper) {
                return UiInspector.findActionsFor(((QuickFixWrapper)object).getFix());
            }
            if (object instanceof IntentionActionDelegate) {
                IntentionAction delegate = ((IntentionActionDelegate)object).getDelegate();
                if (delegate != object) {
                    return UiInspector.findActionsFor(delegate);
                }
            } else {
                if (object instanceof IntentionAction) {
                    return Collections.singletonList(new PropertyBean("intention action", object.getClass().getName(), true));
                }
                if (object instanceof QuickFix) {
                    return Collections.singletonList(new PropertyBean("quick fix", object.getClass().getName(), true));
                }
            }
            return Collections.emptyList();
        }

        private static void processContainerEvent(ContainerEvent event) {
            Component child2;
            Component component2 = child2 = event.getID() == 300 ? event.getChild() : null;
            if (child2 instanceof JComponent && !(event.getSource() instanceof CellRendererPane)) {
                String text2 = ExceptionUtil.getThrowableText((Throwable)new Throwable());
                int first = text2.indexOf("at com.intellij", text2.indexOf("at java.awt"));
                int last = text2.indexOf("at java.awt.EventQueue");
                if (last == -1) {
                    last = text2.length();
                }
                String val = last > first && first > 0 ? text2.substring(first, last).trim() : null;
                ((JComponent)child2).putClientProperty("uiInspector.addedAt", val);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$UiInspector", "showInspector"));
        }
    }

    private static class InspectorTableModel
    extends AbstractTableModel {
        final List<String> PROPERTIES;
        final List<String> CHECKERS;
        final List<String> ACCESSIBLE_CONTEXT_PROPERTIES;
        final List<String> MIGLAYOUT_CC_PROPERTIES;
        final Component myComponent;
        final List<PropertyBean> myProperties;

        InspectorTableModel(@NotNull List<? extends PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorTableModel.$$$reportNull$$$0(0);
            }
            this.PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "cursor", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight", "getClientProperties", "getMouseListeners");
            this.CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
            this.ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
            this.MIGLAYOUT_CC_PROPERTIES = Arrays.asList("getHorizontal", "getVertical");
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = null;
            this.myProperties.addAll(clickInfo);
        }

        InspectorTableModel(@NotNull Component c) {
            if (c == null) {
                InspectorTableModel.$$$reportNull$$$0(1);
            }
            this.PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getText", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "cursor", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight", "getClientProperties", "getMouseListeners");
            this.CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
            this.ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
            this.MIGLAYOUT_CC_PROPERTIES = Arrays.asList("getHorizontal", "getVertical");
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = c;
            this.fillTable();
        }

        void fillTable() {
            CC cc;
            LayoutManager layout;
            this.addProperties("", this.myComponent, this.PROPERTIES);
            Object addedAt = this.myComponent instanceof JComponent ? ((JComponent)this.myComponent).getClientProperty("uiInspector.addedAt") : null;
            this.myProperties.add(new PropertyBean("added-at", addedAt));
            boolean isAccessible = this.myComponent instanceof Accessible;
            this.myProperties.add(new PropertyBean("accessible", isAccessible));
            AccessibleContext context = this.myComponent.getAccessibleContext();
            this.myProperties.add(new PropertyBean("accessibleContext", context));
            if (isAccessible) {
                this.addProperties("  ", this.myComponent.getAccessibleContext(), this.ACCESSIBLE_CONTEXT_PROPERTIES);
            }
            if (this.myComponent instanceof Container) {
                this.addLayoutProperties((Container)this.myComponent);
            }
            if (this.myComponent.getParent() != null && (layout = this.myComponent.getParent().getLayout()) instanceof com.intellij.ui.layout.migLayout.patched.MigLayout && (cc = ((com.intellij.ui.layout.migLayout.patched.MigLayout)layout).getComponentConstraints().get(this.myComponent)) != null) {
                this.addMigLayoutComponentConstraints(cc);
            }
        }

        private void addProperties(@NotNull String prefix, @NotNull Object component2, @NotNull List<String> methodNames) {
            DialogWrapper dialog2;
            TreeModel model;
            Class<?> declaringClass;
            Class<?> superClass;
            if (prefix == null) {
                InspectorTableModel.$$$reportNull$$$0(2);
            }
            if (component2 == null) {
                InspectorTableModel.$$$reportNull$$$0(3);
            }
            if (methodNames == null) {
                InspectorTableModel.$$$reportNull$$$0(4);
            }
            Class<?> clazz = component2.getClass();
            this.myProperties.add(new PropertyBean(prefix + "class", clazz.getName()));
            if (clazz.isAnonymousClass() && (superClass = clazz.getSuperclass()) != null) {
                this.myProperties.add(new PropertyBean(prefix + "superclass", superClass.getName(), true));
            }
            if ((declaringClass = clazz.getDeclaringClass()) != null) {
                this.myProperties.add(new PropertyBean(prefix + "declaringClass", declaringClass.getName()));
            }
            if (component2 instanceof Tree && (model = ((Tree)component2).getModel()) != null) {
                this.myProperties.add(new PropertyBean(prefix + "treeModelClass", model.getClass().getName(), true));
            }
            this.addActionInfo(component2);
            this.addToolbarInfo(component2);
            this.addGutterInfo(component2);
            UiInspectorContextProvider contextProvider = UiInspectorUtil.getProvider(component2);
            if (contextProvider != null) {
                this.myProperties.addAll(contextProvider.getUiInspectorContext());
            }
            StringBuilder classHierarchy = new StringBuilder();
            for (Class<?> cl = clazz.getSuperclass(); cl != null; cl = cl.getSuperclass()) {
                if (classHierarchy.length() > 0) {
                    classHierarchy.append(" -> ");
                }
                classHierarchy.append(cl.getName());
                if (JComponent.class.getName().equals(cl.getName())) break;
            }
            this.myProperties.add(new PropertyBean(prefix + "hierarchy", classHierarchy.toString()));
            if (component2 instanceof Component && (dialog2 = DialogWrapper.findInstance((Component)((Component)component2))) != null) {
                this.myProperties.add(new PropertyBean(prefix + "dialogWrapperClass", dialog2.getClass().getName(), true));
            }
            this.addPropertiesFromMethodNames(prefix, component2, methodNames);
        }

        private static List<Method> collectAllMethodsRecursively(Class<?> clazz) {
            ArrayList<Method> list2 = new ArrayList<Method>();
            for (Class<?> cl = clazz; cl != null; cl = cl.getSuperclass()) {
                list2.addAll(Arrays.asList(cl.getDeclaredMethods()));
            }
            return list2;
        }

        private void addPropertiesFromMethodNames(@NotNull String prefix, @NotNull Object component2, @NotNull List<String> methodNames) {
            Class<?> clazz0;
            if (prefix == null) {
                InspectorTableModel.$$$reportNull$$$0(5);
            }
            if (component2 == null) {
                InspectorTableModel.$$$reportNull$$$0(6);
            }
            if (methodNames == null) {
                InspectorTableModel.$$$reportNull$$$0(7);
            }
            Class<?> clazz = (clazz0 = component2.getClass()).isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
            for (String name : methodNames) {
                String propertyName = (String)ObjectUtils.notNull((Object)StringUtil.getPropertyName((String)name), (Object)name);
                try {
                    Object propertyValue;
                    try {
                        propertyValue = ReflectionUtil.findMethod(InspectorTableModel.collectAllMethodsRecursively(clazz), (String)name, (Class[])new Class[0]).invoke(component2, new Object[0]);
                    }
                    catch (Exception e) {
                        propertyValue = ReflectionUtil.findField(clazz, null, (String)name).get(component2);
                    }
                    boolean changed2 = false;
                    try {
                        Object value2;
                        String checkerMethodName = "is" + StringUtil.capitalize((String)propertyName) + "Set";
                        if (this.CHECKERS.contains(checkerMethodName) && (value2 = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)checkerMethodName, (Class[])new Class[0]).invoke(component2, new Object[0])) instanceof Boolean) {
                            changed2 = (Boolean)value2;
                        }
                    }
                    catch (Exception e) {
                        changed2 = false;
                    }
                    this.myProperties.add(new PropertyBean(prefix + propertyName, propertyValue, changed2));
                }
                catch (Exception exception) {}
            }
        }

        private void addGutterInfo(Object component2) {
            Point clickPoint;
            GutterMark renderer;
            if (component2 instanceof EditorGutterComponentEx && ((JComponent)component2).getClientProperty(UiInspectorAction.CLICK_INFO_POINT) instanceof Point && (renderer = ((EditorGutterComponentEx)component2).getGutterRenderer(clickPoint = (Point)((JComponent)component2).getClientProperty(UiInspectorAction.CLICK_INFO_POINT))) != null) {
                this.myProperties.add(new PropertyBean("gutter renderer", renderer.getClass().getName(), true));
            }
        }

        private void addActionInfo(Object component2) {
            AnAction action2 = null;
            if (component2 instanceof ActionButton) {
                action2 = ((ActionButton)component2).getAction();
            } else if (component2 instanceof JComponent) {
                action2 = component2 instanceof ActionMenuItem ? ((ActionMenuItem)((Object)component2)).getAnAction() : (component2 instanceof ActionMenu ? ((ActionMenu)((Object)component2)).getAnAction() : UiInspectorAction.getAction(ComponentUtil.findParentByCondition((Component)((Component)component2), c -> UiInspectorAction.getAction(c) != null)));
            }
            if (action2 != null) {
                this.myProperties.addAll(UiInspectorUtil.collectAnActionInfo(action2));
            }
        }

        private void addToolbarInfo(Object component2) {
            if (component2 instanceof ActionToolbarImpl) {
                ActionToolbarImpl toolbar = (ActionToolbarImpl)component2;
                this.myProperties.addAll(UiInspectorUtil.collectActionGroupInfo("Toolbar", toolbar.getActionGroup(), toolbar.getPlace()));
            }
        }

        private void addLayoutProperties(@NotNull Container component2) {
            if (component2 == null) {
                InspectorTableModel.$$$reportNull$$$0(8);
            }
            String prefix = "  ";
            LayoutManager layout = component2.getLayout();
            if (layout instanceof GridBagLayout) {
                GridBagLayout bagLayout = (GridBagLayout)layout;
                GridBagConstraints defaultConstraints = (GridBagConstraints)ReflectionUtil.getField(GridBagLayout.class, (Object)bagLayout, GridBagConstraints.class, (String)"defaultConstraints");
                this.myProperties.add(new PropertyBean("GridBagLayout constraints", String.format("defaultConstraints - %s", InspectorTableModel.toString(defaultConstraints))));
                if (bagLayout.columnWidths != null) {
                    this.myProperties.add(new PropertyBean(prefix + "columnWidths", Arrays.toString(bagLayout.columnWidths)));
                }
                if (bagLayout.rowHeights != null) {
                    this.myProperties.add(new PropertyBean(prefix + "rowHeights", Arrays.toString(bagLayout.rowHeights)));
                }
                if (bagLayout.columnWeights != null) {
                    this.myProperties.add(new PropertyBean(prefix + "columnWeights", Arrays.toString(bagLayout.columnWeights)));
                }
                if (bagLayout.rowWeights != null) {
                    this.myProperties.add(new PropertyBean(prefix + "rowWeights", Arrays.toString(bagLayout.rowWeights)));
                }
                for (Component child2 : component2.getComponents()) {
                    this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child2), InspectorTableModel.toString(bagLayout.getConstraints(child2))));
                }
            } else if (layout instanceof BorderLayout) {
                BorderLayout borderLayout = (BorderLayout)layout;
                this.myProperties.add(new PropertyBean("BorderLayout constraints", String.format("hgap - %s, vgap - %s", borderLayout.getHgap(), borderLayout.getVgap())));
                for (Component child3 : component2.getComponents()) {
                    this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child3), borderLayout.getConstraints(child3)));
                }
            } else if (layout instanceof CardLayout) {
                CardLayout cardLayout = (CardLayout)layout;
                Integer currentCard = (Integer)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, null, (String)"currentCard");
                Vector vector = (Vector)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, Vector.class, (String)"vector");
                String cardDescription = "???";
                if (vector != null && currentCard != null) {
                    Object card = vector.get(currentCard);
                    cardDescription = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                }
                this.myProperties.add(new PropertyBean("CardLayout constraints", String.format("card - %s, hgap - %s, vgap - %s", cardDescription, cardLayout.getHgap(), cardLayout.getVgap())));
                if (vector != null) {
                    for (Object card : vector) {
                        String cardName = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                        Component child4 = (Component)ReflectionUtil.getField(card.getClass(), card, Component.class, (String)"comp");
                        this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child4), cardName));
                    }
                }
            } else if (layout instanceof MigLayout) {
                MigLayout migLayout = (MigLayout)layout;
                Object constraints = migLayout.getLayoutConstraints();
                if (constraints instanceof LC) {
                    this.addMigLayoutLayoutConstraints((LC)constraints);
                } else {
                    this.myProperties.add(new PropertyBean("MigLayout layout constraints", constraints));
                }
                constraints = migLayout.getColumnConstraints();
                if (constraints instanceof AC) {
                    this.addMigLayoutAxisConstraints("MigLayout column constraints", (AC)constraints);
                } else {
                    this.myProperties.add(new PropertyBean("MigLayout column constraints", constraints));
                }
                constraints = migLayout.getRowConstraints();
                if (constraints instanceof AC) {
                    this.addMigLayoutAxisConstraints("MigLayout row constraints", (AC)constraints);
                } else {
                    this.myProperties.add(new PropertyBean("MigLayout row constraints", constraints));
                }
                for (Component child5 : component2.getComponents()) {
                    this.myProperties.add(new PropertyBean(prefix + UiInspectorAction.getComponentName(child5), migLayout.getComponentConstraints(child5)));
                }
            } else if (layout instanceof com.intellij.ui.layout.migLayout.patched.MigLayout) {
                com.intellij.ui.layout.migLayout.patched.MigLayout migLayout = (com.intellij.ui.layout.migLayout.patched.MigLayout)layout;
                this.addMigLayoutLayoutConstraints(migLayout.getLayoutConstraints());
                this.addMigLayoutAxisConstraints("MigLayout column constraints", migLayout.getColumnConstraints());
                this.addMigLayoutAxisConstraints("MigLayout row constraints", migLayout.getRowConstraints());
            }
        }

        private void addMigLayoutLayoutConstraints(LC lc) {
            this.myProperties.add(new PropertyBean("MigLayout layout constraints", InspectorTableModel.lcConstraintToString(lc)));
            Object[] insets = lc.getInsets();
            if (insets != null) {
                this.myProperties.add(new PropertyBean("  lc.insets", Arrays.toString(insets)));
            }
            UnitValue alignX = lc.getAlignX();
            UnitValue alignY = lc.getAlignY();
            if (alignX != null || alignY != null) {
                this.myProperties.add(new PropertyBean("  lc.align", "x: " + alignX + "; y: " + alignY));
            }
            BoundSize width = lc.getWidth();
            BoundSize height = lc.getHeight();
            if (width != BoundSize.NULL_SIZE || height != BoundSize.NULL_SIZE) {
                this.myProperties.add(new PropertyBean("  lc.size", "width: " + width + "; height: " + height));
            }
            BoundSize gridX = lc.getGridGapX();
            BoundSize gridY = lc.getGridGapY();
            if (gridX != null || gridY != null) {
                this.myProperties.add(new PropertyBean("  lc.gridGap", "x: " + gridX + "; y: " + gridY));
            }
            boolean fillX = lc.isFillX();
            boolean fillY = lc.isFillY();
            if (fillX || fillY) {
                this.myProperties.add(new PropertyBean("  lc.fill", "x: " + fillX + "; y: " + fillY));
            }
            BoundSize packWidth = lc.getPackWidth();
            BoundSize packHeight = lc.getPackHeight();
            if (packWidth != BoundSize.NULL_SIZE || packHeight != BoundSize.NULL_SIZE) {
                this.myProperties.add(new PropertyBean("  lc.pack", "width: " + packWidth + "; height: " + packHeight + "; widthAlign: " + lc.getPackWidthAlign() + "; heightAlign: " + lc.getPackHeightAlign()));
            }
        }

        private static String lcConstraintToString(LC constraint) {
            return "isFlowX=" + constraint.isFlowX() + " leftToRight=" + constraint.getLeftToRight() + " noGrid=" + constraint.isNoGrid() + " hideMode=" + constraint.getHideMode() + " visualPadding=" + constraint.isVisualPadding() + " topToBottom=" + constraint.isTopToBottom() + " noCache=" + constraint.isNoCache();
        }

        private void addMigLayoutAxisConstraints(String title, AC ac) {
            this.myProperties.add(new PropertyBean(title, ac));
            DimConstraint[] constraints = ac.getConstaints();
            for (int i = 0; i < constraints.length; ++i) {
                this.addDimConstraintProperties("  [" + i + "]", constraints[i]);
            }
        }

        private void addMigLayoutComponentConstraints(CC cc) {
            this.myProperties.add(new PropertyBean("MigLayout component constraints", InspectorTableModel.componentConstraintsToString(cc)));
            DimConstraint horizontal = cc.getHorizontal();
            this.addDimConstraintProperties("  cc.horizontal", horizontal);
            DimConstraint vertical = cc.getVertical();
            this.addDimConstraintProperties("  cc.vertical", vertical);
        }

        private void addDimConstraintProperties(String name, DimConstraint constraint) {
            BoundSize gapAfter;
            BoundSize gapBefore;
            UnitValue align;
            this.myProperties.add(new PropertyBean(name, InspectorTableModel.dimConstraintToString(constraint)));
            BoundSize size = constraint.getSize();
            if (size != null) {
                this.myProperties.add(new PropertyBean("  " + name + ".size", size.toString()));
            }
            if ((align = constraint.getAlign()) != null) {
                this.myProperties.add(new PropertyBean("  " + name + ".align", align.toString()));
            }
            if ((gapBefore = constraint.getGapBefore()) != null && !gapBefore.isUnset()) {
                this.myProperties.add(new PropertyBean("  " + name + ".gapBefore", gapBefore.toString()));
            }
            if ((gapAfter = constraint.getGapAfter()) != null && !gapAfter.isUnset()) {
                this.myProperties.add(new PropertyBean("  " + name + ".gapAfter", gapAfter.toString()));
            }
        }

        private static String componentConstraintsToString(CC cc) {
            CC newCC = new CC();
            StringBuilder stringBuilder = new StringBuilder();
            if (cc.getSkip() != newCC.getSkip()) {
                stringBuilder.append(" skip=").append(cc.getSkip());
            }
            if (cc.getSpanX() != newCC.getSpanX()) {
                stringBuilder.append(" spanX=").append(cc.getSpanX() == 2097051 ? "INF" : Integer.valueOf(cc.getSpanX()));
            }
            if (cc.getSpanY() != newCC.getSpanY()) {
                stringBuilder.append(" spanY=").append(cc.getSpanY() == 2097051 ? "INF" : Integer.valueOf(cc.getSpanY()));
            }
            if (cc.getPushX() != null) {
                stringBuilder.append(" pushX=").append(cc.getPushX());
            }
            if (cc.getPushY() != null) {
                stringBuilder.append(" pushY=").append(cc.getPushY());
            }
            if (cc.getSplit() != newCC.getSplit()) {
                stringBuilder.append(" split=").append(cc.getSplit());
            }
            if (cc.isWrap()) {
                stringBuilder.append(" wrap=");
                if (cc.getWrapGapSize() != null) {
                    stringBuilder.append(cc.getWrapGapSize());
                } else {
                    stringBuilder.append("true");
                }
            }
            if (cc.isNewline()) {
                stringBuilder.append(" newline=");
                if (cc.getNewlineGapSize() != null) {
                    stringBuilder.append(cc.getNewlineGapSize());
                } else {
                    stringBuilder.append("true");
                }
            }
            return stringBuilder.toString().trim();
        }

        private static String dimConstraintToString(DimConstraint constraint) {
            StringBuilder stringBuilder = new StringBuilder();
            DimConstraint newConstraint = new DimConstraint();
            if (!Comparing.equal((Object)constraint.getGrow(), (Object)newConstraint.getGrow())) {
                stringBuilder.append(" grow=").append(constraint.getGrow());
            }
            if (constraint.getGrowPriority() != newConstraint.getGrowPriority()) {
                stringBuilder.append(" growPrio=").append(constraint.getGrowPriority());
            }
            if (!Comparing.equal((Object)constraint.getShrink(), (Object)newConstraint.getShrink())) {
                stringBuilder.append(" shrink=").append(constraint.getShrink());
            }
            if (constraint.getShrinkPriority() != newConstraint.getShrinkPriority()) {
                stringBuilder.append(" shrinkPrio=").append(constraint.getShrinkPriority());
            }
            if (constraint.isFill() != newConstraint.isFill()) {
                stringBuilder.append(" fill=").append(constraint.isFill());
            }
            if (constraint.isNoGrid() != newConstraint.isNoGrid()) {
                stringBuilder.append(" noGrid=").append(constraint.isNoGrid());
            }
            if (!Comparing.equal((String)constraint.getSizeGroup(), (String)newConstraint.getSizeGroup())) {
                stringBuilder.append(" sizeGroup=").append(constraint.getSizeGroup());
            }
            if (!Comparing.equal((String)constraint.getEndGroup(), (String)newConstraint.getEndGroup())) {
                stringBuilder.append(" endGroup=").append(constraint.getEndGroup());
            }
            return stringBuilder.toString();
        }

        @NotNull
        private static String toString(@Nullable GridBagConstraints constraints) {
            if (constraints == null) {
                return "null";
            }
            MoreObjects.ToStringHelper h = MoreObjects.toStringHelper((String)"");
            InspectorTableModel.appendFieldValue(h, constraints, "gridx");
            InspectorTableModel.appendFieldValue(h, constraints, "gridy");
            InspectorTableModel.appendFieldValue(h, constraints, "gridwidth");
            InspectorTableModel.appendFieldValue(h, constraints, "gridheight");
            InspectorTableModel.appendFieldValue(h, constraints, "weightx");
            InspectorTableModel.appendFieldValue(h, constraints, "weighty");
            InspectorTableModel.appendFieldValue(h, constraints, "anchor");
            InspectorTableModel.appendFieldValue(h, constraints, "fill");
            InspectorTableModel.appendFieldValue(h, constraints, "insets");
            InspectorTableModel.appendFieldValue(h, constraints, "ipadx");
            InspectorTableModel.appendFieldValue(h, constraints, "ipady");
            String string = h.toString();
            if (string == null) {
                InspectorTableModel.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static void appendFieldValue(@NotNull MoreObjects.ToStringHelper h, @NotNull GridBagConstraints constraints, @NotNull String field) {
            Object defaultValue;
            Object value2;
            if (h == null) {
                InspectorTableModel.$$$reportNull$$$0(10);
            }
            if (constraints == null) {
                InspectorTableModel.$$$reportNull$$$0(11);
            }
            if (field == null) {
                InspectorTableModel.$$$reportNull$$$0(12);
            }
            if (!Comparing.equal((Object)(value2 = ReflectionUtil.getField(GridBagConstraints.class, (Object)constraints, null, (String)field)), (Object)(defaultValue = ReflectionUtil.getField(GridBagConstraints.class, (Object)new GridBagConstraints(), null, (String)field)))) {
                h.add(field, value2);
            }
        }

        @Override
        @Nullable
        public Object getValueAt(int row, int column) {
            PropertyBean bean = this.myProperties.get(row);
            if (bean != null) {
                return column == 0 ? bean.propertyName : bean.propertyValue;
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 && this.updater(this.myProperties.get(row)) != null;
        }

        @Override
        public void setValueAt(Object value2, int row, int col) {
            PropertyBean bean = this.myProperties.get(row);
            try {
                this.myProperties.set(row, new PropertyBean(bean.propertyName, Objects.requireNonNull(this.updater(bean)).fun(value2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Nullable
        public Function<Object, Object> updater(PropertyBean bean) {
            if (this.myComponent == null) {
                return null;
            }
            String name = bean.propertyName.trim();
            try {
                Method getter;
                try {
                    getter = this.myComponent.getClass().getMethod("get" + StringUtil.capitalize((String)name), new Class[0]);
                }
                catch (Exception e) {
                    getter = this.myComponent.getClass().getMethod("is" + StringUtil.capitalize((String)name), new Class[0]);
                }
                Method finalGetter = getter;
                Method setter = this.myComponent.getClass().getMethod("set" + StringUtil.capitalize((String)name), getter.getReturnType());
                setter.setAccessible(true);
                return o -> {
                    try {
                        setter.invoke((Object)this.myComponent, UiInspectorAction.fromObject(o, finalGetter.getReturnType()));
                        return finalGetter.invoke((Object)this.myComponent, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (Exception e) {
                try {
                    Field field = ReflectionUtil.findField(this.myComponent.getClass(), null, (String)name);
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
                        return null;
                    }
                    return o -> {
                        try {
                            field.set(this.myComponent, UiInspectorAction.fromObject(o, field.getType()));
                            return field.get(this.myComponent);
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    };
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myProperties.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Object.class;
        }

        public void refresh() {
            this.myProperties.clear();
            this.fillTable();
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNames";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTableModel";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTableModel";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addProperties";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertiesFromMethodNames";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addLayoutProperties";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "appendFieldValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ObjectRenderer
    extends Renderer<Object> {
        private ObjectRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public void setValue(@NotNull Object value2) {
            if (value2 == null) {
                ObjectRenderer.$$$reportNull$$$0(0);
            }
            this.setText(UiInspectorAction.getToStringValue(value2));
            if (!this.getText().equals(this.getText().trim())) {
                this.setForeground((Color)JBColor.RED);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ObjectRenderer", "setValue"));
        }
    }

    private static class BorderRenderer
    extends Renderer<Border> {
        private BorderRenderer() {
        }

        @Override
        public void setValue(@NotNull Border value2) {
            if (value2 == null) {
                BorderRenderer.$$$reportNull$$$0(0);
            }
            this.setText(BorderRenderer.getTextDescription(value2));
            if (value2 instanceof CompoundBorder) {
                Color insideColor = BorderRenderer.getBorderColor(((CompoundBorder)value2).getInsideBorder());
                Color outsideColor = BorderRenderer.getBorderColor(((CompoundBorder)value2).getOutsideBorder());
                if (insideColor != null && outsideColor != null) {
                    this.setIcon(UiInspectorAction.createColorIcon(insideColor, outsideColor));
                } else if (insideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(insideColor));
                } else if (outsideColor != null) {
                    this.setIcon((Icon)UiInspectorAction.createColorIcon(outsideColor));
                } else {
                    this.setIcon(null);
                }
            } else {
                Color color = BorderRenderer.getBorderColor(value2);
                this.setIcon((Icon)(color != null ? UiInspectorAction.createColorIcon(color) : null));
            }
        }

        @Nullable
        private static Color getBorderColor(@NotNull Border value2) {
            if (value2 == null) {
                BorderRenderer.$$$reportNull$$$0(1);
            }
            if (value2 instanceof LineBorder) {
                return ((LineBorder)value2).getLineColor();
            }
            if (value2 instanceof CustomLineBorder) {
                try {
                    return (Color)ReflectionUtil.findField(CustomLineBorder.class, Color.class, (String)"myColor").get(value2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @NotNull
        private static String getTextDescription(@Nullable Border value2) {
            if (value2 == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(UiInspectorAction.getClassName(value2));
            Color color = BorderRenderer.getBorderColor(value2);
            if (color != null) {
                sb.append(" color=").append(color.toString());
            }
            if (value2 instanceof LineBorder && ((LineBorder)value2).getRoundedCorners()) {
                sb.append(" roundedCorners=true");
            }
            if (value2 instanceof TitledBorder) {
                sb.append(" title='").append(((TitledBorder)value2).getTitle()).append("'");
            }
            if (value2 instanceof CompoundBorder) {
                sb.append(" inside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value2).getInsideBorder())).append("}");
                sb.append(" outside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value2).getOutsideBorder())).append("}");
            }
            if (value2 instanceof EmptyBorder) {
                Insets insets = ((EmptyBorder)value2).getBorderInsets();
                sb.append(" insets={top=").append(insets.top).append(" left=").append(insets.left).append(" bottom=").append(insets.bottom).append(" right=").append(insets.right).append("}");
            }
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            sb.append(" (").append(UiInspectorAction.getToStringValue(value2)).append(")");
            String string = sb.toString();
            if (string == null) {
                BorderRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$BorderRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$BorderRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getBorderColor";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IconRenderer
    extends Renderer<Icon> {
        private IconRenderer() {
        }

        @Override
        public void setValue(@NotNull Icon value2) {
            if (value2 == null) {
                IconRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(value2);
            this.setText(IconRenderer.getPathToIcon(value2));
        }

        private static String getPathToIcon(@NotNull Icon value2) {
            Icon icon2;
            if (value2 == null) {
                IconRenderer.$$$reportNull$$$0(1);
            }
            if (value2 instanceof RetrievableIcon && (icon2 = ((RetrievableIcon)value2).retrieveIcon()) != value2) {
                return IconRenderer.getPathToIcon(icon2);
            }
            String text2 = UiInspectorAction.getToStringValue(value2);
            if (text2.startsWith("jar:") && text2.contains("!")) {
                int index = text2.lastIndexOf("!");
                String jarFile = text2.substring(4, index);
                String path = text2.substring(index + 1);
                return path + " in " + jarFile;
            }
            return text2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$IconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPathToIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanRenderer
    extends Renderer<Boolean> {
        private BooleanRenderer() {
        }

        @Override
        public void setValue(@NotNull Boolean value2) {
            if (value2 == null) {
                BooleanRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value2 != false ? "Yes" : "No");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$BooleanRenderer", "setValue"));
        }
    }

    private static class FontRenderer
    extends Renderer<Font> {
        private FontRenderer() {
        }

        @Override
        public void setValue(@NotNull Font value2) {
            if (value2 == null) {
                FontRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(value2.getFontName()).append(" (").append(value2.getFamily()).append("), ").append(value2.getSize()).append("px");
            if (1 == (1 & value2.getStyle())) {
                sb.append(" bold");
            }
            if (2 == (2 & value2.getStyle())) {
                sb.append(" italic");
            }
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            Map<TextAttribute, ?> attributes = value2.getAttributes();
            StringBuilder attrs = new StringBuilder();
            for (Map.Entry<TextAttribute, ?> entry : attributes.entrySet()) {
                String name;
                if (entry.getKey() == TextAttribute.FAMILY || entry.getKey() == TextAttribute.SIZE || entry.getValue() == null) continue;
                if (attrs.length() > 0) {
                    attrs.append(",");
                }
                attrs.append((name = (String)ReflectionUtil.getField(TextAttribute.class, (Object)entry.getKey(), String.class, (String)"name")) != null ? name : entry.getKey()).append("=").append(entry.getValue());
            }
            if (attrs.length() > 0) {
                sb.append(" {").append((CharSequence)attrs).append("}");
            }
            this.setText(sb.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$FontRenderer", "setValue"));
        }
    }

    private static class ColorRenderer
    extends Renderer<Color> {
        private ColorRenderer() {
        }

        @Override
        public void setValue(@NotNull Color value2) {
            if (value2 == null) {
                ColorRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" r:").append(value2.getRed());
            sb.append(" g:").append(value2.getGreen());
            sb.append(" b:").append(value2.getBlue());
            sb.append(" a:").append(value2.getAlpha());
            sb.append(" argb:0x");
            String hex = Integer.toHexString(value2.getRGB());
            for (int i = hex.length(); i < 8; ++i) {
                sb.append('0');
            }
            sb.append(StringUtil.toUpperCase((String)hex));
            if (value2 instanceof UIResource) {
                sb.append(" UIResource");
            }
            this.setText(sb.toString());
            this.setIcon((Icon)UiInspectorAction.createColorIcon(value2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ColorRenderer", "setValue"));
        }
    }

    private static class RectangleRenderer
    extends Renderer<Rectangle> {
        private RectangleRenderer() {
        }

        @Override
        public void setValue(@NotNull Rectangle value2) {
            if (value2 == null) {
                RectangleRenderer.$$$reportNull$$$0(0);
            }
            this.setText(RectangleRenderer.toString(value2));
        }

        @NotNull
        static String toString(@NotNull Rectangle r) {
            if (r == null) {
                RectangleRenderer.$$$reportNull$$$0(1);
            }
            String string = r.width + "x" + r.height + " @ " + r.x + ":" + r.y;
            if (string == null) {
                RectangleRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction$RectangleRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$RectangleRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InsetsRenderer
    extends Renderer<Insets> {
        private InsetsRenderer() {
        }

        @Override
        public void setValue(@NotNull Insets value2) {
            if (value2 == null) {
                InsetsRenderer.$$$reportNull$$$0(0);
            }
            this.setText("top: " + value2.top + " left:" + value2.left + " bottom:" + value2.bottom + " right:" + value2.right);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$InsetsRenderer", "setValue"));
        }
    }

    private static class DimensionRenderer
    extends Renderer<Dimension> {
        private DimensionRenderer() {
        }

        @Override
        public void setValue(@NotNull Dimension value2) {
            if (value2 == null) {
                DimensionRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value2.width + "x" + value2.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$DimensionRenderer", "setValue"));
        }
    }

    private static class PointRenderer
    extends Renderer<Point> {
        private PointRenderer() {
        }

        @Override
        public void setValue(@NotNull Point value2) {
            if (value2 == null) {
                PointRenderer.$$$reportNull$$$0(0);
            }
            this.setText(String.valueOf(value2.x) + ':' + value2.y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$PointRenderer", "setValue"));
        }
    }

    private static abstract class Renderer<T>
    extends JLabel {
        private Renderer() {
        }

        abstract void setValue(@NotNull T var1);
    }

    private static class ValueCellRenderer
    implements TableCellRenderer {
        private static final Map<Class, Renderer> RENDERERS = new HashMap<Class, Renderer>();
        private static final Renderer<Object> DEFAULT_RENDERER;
        private static final JLabel NULL_RENDERER;

        private ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value2 == null) {
                NULL_RENDERER.setOpaque(isSelected);
                NULL_RENDERER.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                NULL_RENDERER.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return NULL_RENDERER;
            }
            Renderer renderer = (Renderer)ObjectUtils.notNull(ValueCellRenderer.getRenderer(value2.getClass()), DEFAULT_RENDERER);
            renderer.setOpaque(isSelected);
            renderer.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            renderer.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            renderer.setValue(value2);
            return renderer;
        }

        @Nullable
        private static Renderer<Object> getRenderer(Class clazz) {
            Class<?>[] interfaces;
            if (clazz == null) {
                return null;
            }
            Renderer<Object> renderer = RENDERERS.get(clazz);
            if (renderer != null) {
                return renderer;
            }
            for (Class<?> aClass : interfaces = clazz.getInterfaces()) {
                renderer = ValueCellRenderer.getRenderer(aClass);
                if (renderer == null) continue;
                return renderer;
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                return ValueCellRenderer.getRenderer(clazz);
            }
            return null;
        }

        static {
            RENDERERS.put(Point.class, new PointRenderer());
            RENDERERS.put(Dimension.class, new DimensionRenderer());
            RENDERERS.put(Insets.class, new InsetsRenderer());
            RENDERERS.put(Rectangle.class, new RectangleRenderer());
            RENDERERS.put(Color.class, new ColorRenderer());
            RENDERERS.put(Font.class, new FontRenderer());
            RENDERERS.put(Boolean.class, new BooleanRenderer());
            RENDERERS.put(Icon.class, new IconRenderer());
            RENDERERS.put(Border.class, new BorderRenderer());
            DEFAULT_RENDERER = new ObjectRenderer();
            NULL_RENDERER = new JLabel("-");
        }
    }

    private static class DimensionsComponent
    extends JComponent {
        Component myComponent;
        int myWidth;
        int myHeight;
        Border myBorder;
        Insets myInsets;

        private DimensionsComponent(@NotNull Component component2) {
            if (component2 == null) {
                DimensionsComponent.$$$reportNull$$$0(0);
            }
            this.myComponent = component2;
            this.setOpaque(true);
            this.setBackground((Color)JBColor.WHITE);
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            this.setFont((Font)JBUI.Fonts.label((float)9.0f));
            this.update();
        }

        public void update() {
            this.myWidth = this.myComponent.getWidth();
            this.myHeight = this.myComponent.getHeight();
            if (this.myComponent instanceof JComponent) {
                this.myBorder = ((JComponent)this.myComponent).getBorder();
                this.myInsets = ((JComponent)this.myComponent).getInsets();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            GraphicsConfig config2 = new GraphicsConfig(g).setAntialiasing(UISettings.getShadowInstance().getIdeAAType() != AntialiasingType.OFF);
            Rectangle bounds2 = this.getBounds();
            g2d.setColor(this.getBackground());
            Insets insets = this.getInsets();
            g2d.fillRect(insets.left, insets.top, bounds2.width - insets.left - insets.right, bounds2.height - insets.top - insets.bottom);
            String sizeString = String.format("%d x %d", this.myWidth, this.myHeight);
            FontMetrics fm = g2d.getFontMetrics();
            int sizeWidth = fm.stringWidth(sizeString);
            int fontHeight = fm.getHeight();
            int innerBoxWidthGap = JBUIScale.scale((int)20);
            int innerBoxHeightGap = JBUIScale.scale((int)5);
            int boxSize = JBUIScale.scale((int)15);
            int centerX = bounds2.width / 2;
            int centerY = bounds2.height / 2;
            int innerX = centerX - sizeWidth / 2 - innerBoxWidthGap;
            int innerY = centerY - fontHeight / 2 - innerBoxHeightGap;
            int innerWidth = sizeWidth + innerBoxWidthGap * 2;
            int innerHeight = fontHeight + innerBoxHeightGap * 2;
            g2d.setColor(this.getForeground());
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, sizeString, centerX, centerY);
            g2d.setColor((Color)JBColor.GRAY);
            g2d.drawRect(innerX, innerY, innerWidth, innerHeight);
            Insets borderInsets = null;
            if (this.myBorder != null) {
                borderInsets = this.myBorder.getBorderInsets(this.myComponent);
            }
            UIUtil.drawDottedRectangle((Graphics)g2d, (int)(innerX - boxSize), (int)(innerY - boxSize), (int)(innerX + innerWidth + boxSize), (int)(innerY + innerHeight + boxSize));
            DimensionsComponent.drawInsets(g2d, fm, "border", borderInsets, boxSize, fontHeight, innerX, innerY, innerWidth, innerHeight);
            g2d.drawRect(innerX - boxSize * 2, innerY - boxSize * 2, innerWidth + boxSize * 4, innerHeight + boxSize * 4);
            DimensionsComponent.drawInsets(g2d, fm, "insets", this.myInsets, boxSize * 2, fontHeight, innerX, innerY, innerWidth, innerHeight);
            config2.restore();
        }

        private static void drawInsets(Graphics2D g2d, FontMetrics fm, String name, Insets insets, int offset, int fontHeight, int innerX, int innerY, int innerWidth, int innerHeight) {
            g2d.setColor((Color)JBColor.BLACK);
            g2d.drawString(name, innerX - offset + JBUIScale.scale((int)5), innerY - offset + fontHeight);
            g2d.setColor((Color)JBColor.GRAY);
            int outerX = innerX - offset;
            int outerWidth = innerWidth + offset * 2;
            int outerY = innerY - offset;
            int outerHeight = innerHeight + offset * 2;
            String top = insets != null ? Integer.toString(insets.top) : "-";
            String bottom = insets != null ? Integer.toString(insets.bottom) : "-";
            String left = insets != null ? Integer.toString(insets.left) : "-";
            String right = insets != null ? Integer.toString(insets.right) : "-";
            int shift = JBUIScale.scale((int)7);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, top, outerX + outerWidth / 2, outerY + shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, bottom, outerX + outerWidth / 2, outerY + outerHeight - shift);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, left, outerX + shift, outerY + outerHeight / 2);
            UiInspectorAction.drawCenteredString(g2d, fm, fontHeight, right, outerX + outerWidth - shift, outerY + outerHeight / 2);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)120);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)150);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$DimensionsComponent", "<init>"));
        }
    }

    private static class InspectorTable
    extends JPanel {
        InspectorTableModel myModel;
        DimensionsComponent myDimensionComponent;

        private InspectorTable(@NotNull List<? extends PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorTable.$$$reportNull$$$0(0);
            }
            this.myModel = new InspectorTableModel(clickInfo);
            this.init(null);
        }

        private InspectorTable(@NotNull Component component2) {
            if (component2 == null) {
                InspectorTable.$$$reportNull$$$0(1);
            }
            this.myModel = new InspectorTableModel(component2);
            this.init(component2);
        }

        private void init(final @Nullable Component component2) {
            this.setLayout(new BorderLayout());
            final StripeTable table = new StripeTable((TableModel)this.myModel);
            new TableSpeedSearch((JTable)table);
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn propertyColumn = columnModel.getColumn(0);
            propertyColumn.setMinWidth(JBUIScale.scale((int)200));
            propertyColumn.setMaxWidth(JBUIScale.scale((int)200));
            propertyColumn.setResizable(false);
            propertyColumn.setCellRenderer(new PropertyNameRenderer());
            TableColumn valueColumn = columnModel.getColumn(1);
            valueColumn.setMinWidth(JBUIScale.scale((int)200));
            valueColumn.setResizable(false);
            valueColumn.setCellRenderer(new ValueCellRenderer());
            valueColumn.setCellEditor(new DefaultCellEditor((JTextField)new JBTextField()){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
                    Component comp = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value2, false, false, row, column);
                    if (comp instanceof JLabel) {
                        value2 = ((JLabel)comp).getText();
                    }
                    Component result2 = super.getTableCellEditorComponent(table, value2, isSelected, row, column);
                    ((JComponent)result2).setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
                    return result2;
                }
            });
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent event) {
                    Component renderer;
                    int row = table.rowAtPoint(event.getPoint());
                    int column = table.columnAtPoint(event.getPoint());
                    if (row >= 0 && row < table.getRowCount() && column >= 0 && column < table.getColumnCount() && (renderer = table.getCellRenderer(row, column).getTableCellRendererComponent((JTable)table, myModel.getValueAt(row, column), false, false, row, column)) instanceof JLabel) {
                        System.out.println((component2 != null ? UiInspectorAction.getComponentName(component2) + " " : "") + ((JLabel)renderer).getText().replace("\r", "").replace("\tat", "\n\tat"));
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)table);
            table.setAutoResizeMode(3);
            this.add((Component)new JBScrollPane((Component)table), "Center");
            if (component2 != null) {
                this.myDimensionComponent = new DimensionsComponent(component2);
                this.add((Component)this.myDimensionComponent, "South");
            }
        }

        public void refresh() {
            this.myModel.refresh();
            this.myDimensionComponent.update();
            this.myDimensionComponent.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clickInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorTable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PropertyNameRenderer
        extends DefaultTableCellRenderer {
            private PropertyNameRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                TableModel model = table.getModel();
                boolean changed2 = false;
                if (model instanceof InspectorTableModel) {
                    changed2 = ((InspectorTableModel)model).myProperties.get((int)row).changed;
                }
                Color fg = isSelected ? table.getSelectionForeground() : (changed2 ? JBUI.CurrentTheme.Link.linkColor() : table.getForeground());
                JBFont font = JBFont.label();
                this.setFont((Font)(changed2 ? font.asBold() : font));
                this.setForeground(fg);
                return this;
            }
        }
    }

    private static class HighlightComponent
    extends JComponent {
        @NotNull
        private final Color myColor;
        @NotNull
        private final Insets myInsets;

        private HighlightComponent(@NotNull Color c, @NotNull Insets insets) {
            if (c == null) {
                HighlightComponent.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                HighlightComponent.$$$reportNull$$$0(1);
            }
            this.myColor = c;
            this.myInsets = insets;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int i;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r = this.getBounds();
            RectanglePainter.paint((Graphics2D)g2d, (int)0, (int)0, (int)r.width, (int)r.height, (int)0, (Paint)this.myColor, null);
            ((Graphics2D)g).setPaint(this.myColor.darker());
            for (i = 0; i < this.myInsets.left; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)i, (double)this.myInsets.top, (double)i, (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i = 0; i < this.myInsets.right; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)(r.width - i - 1), (double)this.myInsets.top, (double)(r.width - i - 1), (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i = 0; i < this.myInsets.top; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)i, (double)r.width, (double)i);
            }
            for (i = 0; i < this.myInsets.bottom; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)(r.height - i - 1), (double)r.width, (double)(r.height - i - 1));
            }
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "insets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/inspector/UiInspectorAction$HighlightComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class HierarchyTree
    extends JTree
    implements TreeSelectionListener {
        final Component myComponent;

        private HierarchyTree(Component c) {
            this.myComponent = c;
            this.setModel(UiInspectorAction.buildModel(c));
            this.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c)));
            this.getSelectionModel().addTreeSelectionListener(this);
            new TreeSpeedSearch(this);
            if (c instanceof JComponent && ((JComponent)c).getClientProperty(UiInspectorAction.CLICK_INFO) != null) {
                SwingUtilities.invokeLater(() -> this.getSelectionModel().setSelectionPath(this.getPathForRow(this.getLeadSelectionRow() + 1)));
            }
        }

        @Override
        public String convertValueToText(Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof ComponentNode) {
                Pair pair = UiInspectorAction.getClassAndFieldName(((ComponentNode)value2).myComponent);
                if (pair != null) {
                    return ((Class)pair.first).getSimpleName() + '.' + (String)pair.second;
                }
                return this.myComponent.getClass().getName();
            }
            return super.convertValueToText(value2, selected2, expanded, leaf, row, hasFocus);
        }

        public void expandPath() {
            TreeUtil.expandAll((JTree)this);
            int count = this.getRowCount();
            ComponentNode node = new ComponentNode(this.myComponent);
            for (int i = 0; i < count; ++i) {
                TreePath row = this.getPathForRow(i);
                if (!row.getLastPathComponent().equals(node)) continue;
                this.setSelectionPath(row);
                this.scrollPathToVisible(this.getSelectionPath());
                break;
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object[] paths = this.getSelectionPaths();
            if (paths == null) {
                this.onComponentsChanged(Collections.emptyList());
                return;
            }
            List clickInfos = ContainerUtil.mapNotNull((Object[])paths, path -> {
                Object node = path.getLastPathComponent();
                if (node instanceof ClickInfoNode) {
                    return ((ClickInfoNode)node).getInfo();
                }
                return null;
            });
            if (!clickInfos.isEmpty()) {
                this.onClickInfoChanged((List)clickInfos.get(0));
                return;
            }
            List components = ContainerUtil.mapNotNull((Object[])paths, path -> {
                Object node = path.getLastPathComponent();
                if (node instanceof ComponentNode) {
                    return ((ComponentNode)node).getComponent();
                }
                return null;
            });
            this.onComponentsChanged(components);
        }

        public abstract void onClickInfoChanged(List<? extends PropertyBean> var1);

        public abstract void onComponentsChanged(List<Component> var1);

        private static class ClickInfoNode
        extends DefaultMutableTreeNode {
            private final List<PropertyBean> myInfo;

            ClickInfoNode(List<PropertyBean> info) {
                this.myInfo = info;
            }

            @Override
            public String toString() {
                return "Clicked Info";
            }

            public List<PropertyBean> getInfo() {
                return this.myInfo;
            }

            @Override
            public boolean isLeaf() {
                return true;
            }
        }

        private static class ComponentNode
        extends DefaultMutableTreeNode {
            private final Component myComponent;
            String myText;

            private ComponentNode(@NotNull Component component2) {
                if (component2 == null) {
                    ComponentNode.$$$reportNull$$$0(0);
                }
                super(component2);
                this.myComponent = component2;
                this.children = ComponentNode.prepareChildren(this.myComponent);
            }

            Component getComponent() {
                return this.myComponent;
            }

            @Override
            public String toString() {
                return this.myText != null ? this.myText : this.myComponent.getClass().getName();
            }

            public void setText(String value2) {
                this.myText = value2;
            }

            public boolean equals(Object obj) {
                return obj instanceof ComponentNode && ((ComponentNode)obj).getComponent() == this.getComponent();
            }

            private static Vector prepareChildren(Component parent) {
                Component[] o;
                Vector<DefaultMutableTreeNode> result2 = new Vector<DefaultMutableTreeNode>();
                if (parent instanceof JComponent && (o = ((JComponent)parent).getClientProperty(UiInspectorAction.CLICK_INFO)) instanceof List) {
                    result2.add(new ClickInfoNode((List)o));
                }
                if (parent instanceof Container) {
                    for (Component component2 : ((Container)parent).getComponents()) {
                        result2.add(new ComponentNode(component2));
                    }
                }
                if (parent instanceof Window) {
                    Window[] children2;
                    for (Window child2 : children2 = ((Window)parent).getOwnedWindows()) {
                        if (child2 instanceof InspectorWindow) continue;
                        result2.add(new ComponentNode(child2));
                    }
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$HierarchyTree$ComponentNode", "<init>"));
            }
        }
    }

    private static class ComponentTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Component myInitialSelection;

        ComponentTreeCellRenderer(Component initialSelection) {
            this.myInitialSelection = initialSelection;
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color background;
            if (tree == null) {
                ComponentTreeCellRenderer.$$$reportNull$$$0(0);
            }
            Color foreground = UIUtil.getTreeForeground((boolean)selected2, (boolean)hasFocus);
            Color color = background = selected2 ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null;
            if (value2 instanceof HierarchyTree.ComponentNode) {
                HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)value2;
                Component component2 = componentNode.getComponent();
                if (!selected2) {
                    if (!component2.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component2.getWidth() == 0 || component2.getHeight() == 0) {
                        foreground = new JBColor(new Color(128, 10, 0), (Color)JBColor.BLUE);
                    } else if (component2.getPreferredSize() != null && (component2.getSize().width < component2.getPreferredSize().width || component2.getSize().height < component2.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (this.myInitialSelection == componentNode.getComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                this.append(UiInspectorAction.getComponentName(component2));
                Pair class2field = UiInspectorAction.getClassAndFieldName(component2);
                if (class2field != null) {
                    this.append("(" + (String)class2field.second + "@" + ((Class)class2field.first).getSimpleName() + ")");
                }
                this.append(": " + RectangleRenderer.toString(component2.getBounds()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                if (component2.isOpaque()) {
                    this.append(", opaque", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                if (component2.isDoubleBuffered()) {
                    this.append(", double-buffered", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                if (DataManagerImpl.getDataProviderEx(component2) != null) {
                    this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append("data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
                componentNode.setText(this.toString());
                this.setIcon(UiInspectorAction.createColorIcon(component2.getBackground(), component2.getForeground()));
            }
            if (value2 instanceof HierarchyTree.ClickInfoNode) {
                this.append(value2.toString());
                this.setIcon(AllIcons.Ide.Rating);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)false, (boolean)selected2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/inspector/UiInspectorAction$ComponentTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static class InspectorWindow
    extends JDialog {
        private InspectorTable myInspectorTable;
        @NotNull
        private final List<Component> myComponents;
        private List<? extends PropertyBean> myInfo;
        @NotNull
        private final Component myInitialComponent;
        @NotNull
        private final List<HighlightComponent> myHighlightComponents;
        private boolean myIsHighlighted;
        @NotNull
        private final HierarchyTree myHierarchyTree;
        @NotNull
        private final Wrapper myWrapperPanel;

        private InspectorWindow(@NotNull Component component2) throws HeadlessException {
            if (component2 == null) {
                InspectorWindow.$$$reportNull$$$0(0);
            }
            super(InspectorWindow.findWindow(component2));
            this.myComponents = new ArrayList<Component>();
            this.myHighlightComponents = new ArrayList<HighlightComponent>();
            this.myIsHighlighted = true;
            Window window = InspectorWindow.findWindow(component2);
            this.setModal(window instanceof JDialog && ((JDialog)window).isModal());
            this.myComponents.add(component2);
            this.myInitialComponent = component2;
            this.getRootPane().setBorder(JBUI.Borders.empty((int)5));
            this.setDefaultCloseOperation(2);
            this.setLayout(new BorderLayout());
            this.setTitle(component2.getClass().getName());
            Dimension size = DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey());
            Point location2 = DimensionService.getInstance().getLocation(InspectorWindow.getDimensionServiceKey());
            if (size != null) {
                this.setSize(size);
            }
            if (location2 != null) {
                this.setLocation(location2);
            }
            DefaultActionGroup actions = new DefaultActionGroup();
            actions.addAction((AnAction)new MyTextAction(IdeBundle.messagePointer((String)"action.Anonymous.text.highlight", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myIsHighlighted = !myIsHighlighted;
                    this.updateHighlighting();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(myInfo != null || !myComponents.isEmpty());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            actions.addSeparator();
            actions.add((AnAction)new MyTextAction(InternalActionsBundle.messagePointer("action.Anonymous.text.refresh", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.getCurrentTable().refresh();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(!myComponents.isEmpty());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)actions, true);
            this.add((Component)toolbar.getComponent(), "North");
            this.myWrapperPanel = new Wrapper();
            this.myInspectorTable = new InspectorTable(component2);
            this.myHierarchyTree = new HierarchyTree(component2){

                @Override
                public void onComponentsChanged(List<Component> components) {
                    this.switchComponentsInfo(components);
                    this.updateHighlighting();
                }

                @Override
                public void onClickInfoChanged(List<? extends PropertyBean> info) {
                    this.switchClickInfo(info);
                    this.updateHighlighting();
                }
            };
            this.myWrapperPanel.setContent((JComponent)this.myInspectorTable);
            JBSplitter splitPane = new JBSplitter(false, "UiInspector.splitter.proportion", 0.5f);
            splitPane.setSecondComponent((JComponent)this.myWrapperPanel);
            splitPane.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHierarchyTree));
            this.add((Component)splitPane, "Center");
            this.myHierarchyTree.expandPath();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.close();
                }
            });
            this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.close();
                }
            });
            this.updateHighlighting();
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
        }

        private static String getDimensionServiceKey() {
            return "UiInspectorWindow";
        }

        private static Window findWindow(Component component2) {
            DialogWrapper dialogWrapper2 = DialogWrapper.findInstance((Component)component2);
            if (dialogWrapper2 != null) {
                return dialogWrapper2.getPeer().getWindow();
            }
            return null;
        }

        private InspectorTable getCurrentTable() {
            return this.myInspectorTable;
        }

        private void switchComponentsInfo(@NotNull List<Component> components) {
            if (components == null) {
                InspectorWindow.$$$reportNull$$$0(1);
            }
            if (components.isEmpty()) {
                return;
            }
            this.myComponents.clear();
            this.myComponents.addAll(components);
            this.myInfo = null;
            this.setTitle(components.get(0).getClass().getName());
            this.myInspectorTable = new InspectorTable(components.get(0));
            this.myWrapperPanel.setContent((JComponent)this.myInspectorTable);
        }

        private void switchClickInfo(@NotNull List<? extends PropertyBean> clickInfo) {
            if (clickInfo == null) {
                InspectorWindow.$$$reportNull$$$0(2);
            }
            this.myComponents.clear();
            this.myInfo = clickInfo;
            this.setTitle("Click Info");
            this.myInspectorTable = new InspectorTable(clickInfo);
            this.myWrapperPanel.setContent((JComponent)this.myInspectorTable);
        }

        @Override
        public void dispose() {
            DimensionService.getInstance().setSize(InspectorWindow.getDimensionServiceKey(), this.getSize());
            DimensionService.getInstance().setLocation(InspectorWindow.getDimensionServiceKey(), this.getLocation());
            super.dispose();
            DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
            DialogWrapper.cleanupWindowListeners((Window)this);
        }

        public void close() {
            if (this.myInitialComponent instanceof JComponent) {
                ((JComponent)this.myInitialComponent).putClientProperty(UiInspectorAction.CLICK_INFO, null);
            }
            this.myIsHighlighted = false;
            this.myInfo = null;
            this.myComponents.clear();
            this.updateHighlighting();
            this.setVisible(false);
            this.dispose();
        }

        private void updateHighlighting() {
            for (HighlightComponent highlightComponent : this.myHighlightComponents) {
                JComponent jComponent = InspectorWindow.getGlassPane(highlightComponent);
                if (jComponent == null) continue;
                jComponent.remove(highlightComponent);
                jComponent.revalidate();
                jComponent.repaint();
            }
            this.myHighlightComponents.clear();
            if (this.myIsHighlighted) {
                for (Component component2 : this.myComponents) {
                    ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)InspectorWindow.createHighlighter(component2, null));
                }
                if (this.myInfo != null) {
                    Rectangle bounds2 = null;
                    for (PropertyBean propertyBean : this.myInfo) {
                        if (!UiInspectorAction.RENDERER_BOUNDS.equals(propertyBean.propertyName)) continue;
                        bounds2 = (Rectangle)propertyBean.propertyValue;
                        break;
                    }
                    ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)InspectorWindow.createHighlighter(this.myInitialComponent, bounds2));
                }
            }
        }

        @Nullable
        private static HighlightComponent createHighlighter(@NotNull Component component2, @Nullable Rectangle bounds2) {
            JComponent glassPane;
            if (component2 == null) {
                InspectorWindow.$$$reportNull$$$0(3);
            }
            if ((glassPane = InspectorWindow.getGlassPane(component2)) == null) {
                return null;
            }
            if (bounds2 != null) {
                bounds2 = SwingUtilities.convertRectangle(component2, bounds2, glassPane);
            } else {
                Point pt = SwingUtilities.convertPoint(component2, new Point(0, 0), glassPane);
                bounds2 = new Rectangle(pt.x, pt.y, component2.getWidth(), component2.getHeight());
            }
            JBColor color = new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED);
            if (bounds2.width == 0 || bounds2.height == 0) {
                bounds2.width = Math.max(bounds2.width, 1);
                bounds2.height = Math.max(bounds2.height, 1);
                color = JBColor.BLUE;
            }
            JBInsets insets = component2 instanceof JComponent ? ((JComponent)component2).getInsets() : JBUI.emptyInsets();
            HighlightComponent highlightComponent = new HighlightComponent((Color)color, (Insets)insets);
            highlightComponent.setBounds(bounds2);
            glassPane.add(highlightComponent);
            glassPane.revalidate();
            glassPane.repaint();
            return highlightComponent;
        }

        @Nullable
        private static JComponent getGlassPane(@NotNull Component component2) {
            JRootPane rootPane;
            if (component2 == null) {
                InspectorWindow.$$$reportNull$$$0(4);
            }
            return (rootPane = SwingUtilities.getRootPane(component2)) == null ? null : (JComponent)rootPane.getGlassPane();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "switchComponentsInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "switchClickInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlighter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getGlassPane";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static abstract class MyTextAction
        extends IconWithTextAction
        implements DumbAware {
            private MyTextAction(Supplier<String> text2) {
                super(text2);
            }
        }
    }

    private static class UiInspectorNotification
    extends Notification {
        private UiInspectorNotification() {
            super("System Messages", "UI Inspector", "Control-Alt-Click to view component info!", NotificationType.INFORMATION);
        }
    }
}

