/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.DialogAppender;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.adapters.DOMAdapter;
import org.jdom.adapters.JAXPDOMAdapter;
import org.jdom.output.DOMOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";

    LoggerFactory() {
        try {
            LoggerFactory.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name) {
        if (name == null) {
            LoggerFactory.$$$reportNull$$$0(0);
        }
        return new IdeaLogger(Logger.getLogger((String)name));
    }

    private static void init() throws Exception {
        System.setProperty("log4j.defaultInitOverride", "true");
        String configPath = System.getProperty("idea.log.config.file");
        if (configPath != null) {
            Path configFile = Paths.get(configPath, new String[0]);
            if (!configFile.isAbsolute()) {
                configFile = Paths.get(PathManager.getBinPath(), new String[0]).resolve(configPath);
            }
            if (Files.exists(configFile, new LinkOption[0])) {
                LoggerFactory.configureFromXmlFile(configFile);
                return;
            }
        }
        LoggerFactory.configureProgrammatically();
    }

    private static void configureFromXmlFile(Path xmlFile) throws Exception {
        String text2 = new String(Files.readAllBytes(xmlFile), StandardCharsets.UTF_8);
        text2 = StringUtil.replace((String)text2, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
        text2 = StringUtil.replace((String)text2, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
        text2 = StringUtil.replace((String)text2, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)PathManager.getLogPath(), (String)"\\", (String)"\\\\"));
        Document document = JDOMUtil.loadDocument((Reader)new CharSequenceReader((CharSequence)text2));
        Element element2 = new DOMOutputter((DOMAdapter)new JAXPDOMAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public org.w3c.dom.Document createDocument() throws JDOMException {
                String key = "javax.xml.parsers.DocumentBuilderFactory";
                String property = System.setProperty(key, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                try {
                    org.w3c.dom.Document document = super.createDocument();
                    return document;
                }
                finally {
                    if (property == null) {
                        System.clearProperty(key);
                    } else {
                        System.setProperty(key, property);
                    }
                }
            }
        }, null, null).output(document).getDocumentElement();
        new DOMConfigurator().doConfigure(element2, LogManager.getLoggerRepository());
    }

    private static void configureProgrammatically() throws IOException {
        Logger root = LogManager.getRootLogger();
        root.removeAllAppenders();
        root.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%d [%7r] %6p - %30.30c - %m \n");
        RollingFileAppender ideaLog = new RollingFileAppender((Layout)layout, PathManager.getLogPath() + "/idea.log", true);
        ideaLog.setEncoding(StandardCharsets.UTF_8.name());
        ideaLog.setMaxBackupIndex(12);
        ideaLog.setMaximumFileSize(10000000L);
        root.addAppender((Appender)ideaLog);
        ConsoleAppender consoleWarn = new ConsoleAppender((Layout)layout, "System.err");
        LevelRangeFilter warnFilter = new LevelRangeFilter();
        warnFilter.setLevelMin(Level.WARN);
        consoleWarn.addFilter((Filter)warnFilter);
        root.addAppender((Appender)consoleWarn);
        DialogAppender appender = new DialogAppender();
        LevelRangeFilter filter2 = new LevelRangeFilter();
        filter2.setLevelMin(Level.INFO);
        appender.addFilter((Filter)filter2);
        root.addAppender((Appender)appender);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/idea/LoggerFactory", "getLoggerInstance"));
    }
}

