/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ComboBoxPopup;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class DarculaJBPopupComboPopup<T>
implements ComboPopup,
ComboBoxPopup.Context<T>,
ItemListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
PropertyChangeListener,
AncestorListener {
    public static final String CLIENT_PROP = "ComboBox.jbPopup";
    public static final String USE_LIVE_UPDATE_MODEL = "ComboBox.jbPopup.supportUpdateModel";
    private final JComboBox<T> myComboBox;
    private final JList<T> myProxyList;
    private ComboBoxPopup<T> myPopup;
    private boolean myJustClosedViaClick;

    public DarculaJBPopupComboPopup(@NotNull JComboBox<T> comboBox2) {
        if (comboBox2 == null) {
            DarculaJBPopupComboPopup.$$$reportNull$$$0(0);
        }
        this.myProxyList = new JBList();
        this.myComboBox = comboBox2;
        this.myProxyList.setModel(comboBox2.getModel());
        this.myComboBox.addPropertyChangeListener(this);
        this.myComboBox.addItemListener(this);
        this.myComboBox.addAncestorListener(this);
    }

    @Override
    @Nullable
    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myComboBox));
    }

    @Override
    @NotNull
    public ListModel<T> getModel() {
        ComboBoxModel<T> comboBoxModel = this.myComboBox.getModel();
        if (comboBoxModel == null) {
            DarculaJBPopupComboPopup.$$$reportNull$$$0(1);
        }
        return comboBoxModel;
    }

    @Override
    @NotNull
    public ListCellRenderer<? super T> getRenderer() {
        ListCellRenderer<T> listCellRenderer2 = this.myComboBox.getRenderer();
        if (listCellRenderer2 == null) {
            DarculaJBPopupComboPopup.$$$reportNull$$$0(2);
        }
        return listCellRenderer2;
    }

    @Override
    public int getMaximumRowCount() {
        return Math.max(10, this.myComboBox.getMaximumRowCount());
    }

    @Override
    public void onPopupStepCancelled() {
        this.myComboBox.firePopupMenuCanceled();
    }

    @Override
    public void show() {
        this.myJustClosedViaClick = false;
        if (this.myPopup != null) {
            if (this.myPopup.isVisible()) {
                return;
            }
            this.myPopup.cancel();
        }
        Object selectedItem = this.myComboBox.getSelectedItem();
        this.myPopup = new ComboBoxPopup<T>(this, selectedItem, value2 -> this.myComboBox.setSelectedItem(value2)){

            @Override
            public void cancel(InputEvent e) {
                if (e instanceof MouseEvent) {
                    Point point = new RelativePoint((MouseEvent)e).getPoint((Component)DarculaJBPopupComboPopup.this.myComboBox);
                    DarculaJBPopupComboPopup.this.myJustClosedViaClick = new Rectangle(DarculaJBPopupComboPopup.this.myComboBox.getSize()).contains(point);
                }
                super.cancel(e);
            }
        };
        this.myPopup.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                DarculaJBPopupComboPopup.this.myComboBox.firePopupMenuWillBecomeVisible();
                if (DarculaJBPopupComboPopup.this.useLiveUpdateWithModel()) {
                    DarculaJBPopupComboPopup.this.myPopup.syncWithModelChange();
                }
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                DarculaJBPopupComboPopup.this.myComboBox.firePopupMenuWillBecomeInvisible();
                DarculaJBPopupComboPopup.this.myPopup = null;
                DarculaJBPopupComboPopup.this.myProxyList.setCellRenderer(new DefaultListCellRenderer());
                DarculaJBPopupComboPopup.this.myProxyList.setModel(DarculaJBPopupComboPopup.this.myComboBox.getModel());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaJBPopupComboPopup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JList<T> list2 = this.myPopup.getList();
        this.myProxyList.setCellRenderer(list2.getCellRenderer());
        this.myProxyList.setModel(list2.getModel());
        this.myPopup.setMinimumSize(this.myComboBox.getSize());
        this.myPopup.showUnderneathOf(this.myComboBox);
    }

    @Override
    public void configureList(@NotNull JList<T> list2) {
        if (list2 == null) {
            DarculaJBPopupComboPopup.$$$reportNull$$$0(3);
        }
        list2.setFont(this.myComboBox.getFont());
        list2.setForeground(this.myComboBox.getForeground());
        list2.setBackground(this.myComboBox.getBackground());
    }

    @Override
    public void hide() {
        this.myJustClosedViaClick = false;
        if (this.myPopup == null) {
            return;
        }
        this.myPopup.cancel();
    }

    @Override
    public boolean isVisible() {
        return this.myPopup != null && this.myPopup.isVisible();
    }

    public JList<T> getList() {
        return this.myProxyList;
    }

    @Override
    public MouseListener getMouseListener() {
        return this;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return this;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public void uninstallingUI() {
        this.myComboBox.removePropertyChangeListener(this);
        this.myComboBox.removeItemListener(this);
        this.myComboBox.removeAncestorListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        String propertyName = e.getPropertyName();
        if ("renderer".equals(propertyName) || "editable".equals(propertyName)) {
            this.hide();
        }
        if ("model".equals(propertyName) && this.myPopup != null) {
            if (!this.useLiveUpdateWithModel()) {
                this.hide();
            } else {
                this.myPopup.syncWithModelChange();
            }
        }
    }

    private boolean useLiveUpdateWithModel() {
        return Boolean.TRUE.equals(this.myComboBox.getClientProperty(USE_LIVE_UPDATE_MODEL));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.getList()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e) || !this.myComboBox.isEnabled()) {
            return;
        }
        if (this.myComboBox.isEditable()) {
            Component comp = this.myComboBox.getEditor().getEditorComponent();
            if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                comp.requestFocus();
            }
        } else if (this.myComboBox.isRequestFocusEnabled()) {
            this.myComboBox.requestFocus();
        }
        if (this.myJustClosedViaClick) {
            this.myJustClosedViaClick = false;
            return;
        }
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        this.hide();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/DarculaJBPopupComboPopup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaJBPopupComboPopup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

