/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoItem;
import com.intellij.ui.HighlightedRegion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class TodoItemNode
extends BaseToDoNode<SmartTodoItemPointer>
implements HighlightedRegionProvider {
    private static final Logger LOG = Logger.getInstance(TodoItem.class);
    private final List<HighlightedRegion> myHighlightedRegions;
    private final List<HighlightedRegionProvider> myAdditionalLines;

    public TodoItemNode(Project project, @NotNull SmartTodoItemPointer value2, TodoTreeBuilder builder2) {
        if (value2 == null) {
            TodoItemNode.$$$reportNull$$$0(0);
        }
        super(project, value2, builder2);
        RangeMarker rangeMarker = value2.getRangeMarker();
        LOG.assertTrue(rangeMarker.isValid());
        this.myHighlightedRegions = ContainerUtil.createConcurrentList();
        this.myAdditionalLines = ContainerUtil.createConcurrentList();
    }

    @Override
    public boolean contains(Object element2) {
        return this.canRepresent(element2);
    }

    public boolean canRepresent(Object element2) {
        SmartTodoItemPointer value2 = (SmartTodoItemPointer)this.getValue();
        TodoItem item = value2 != null ? value2.getTodoItem() : null;
        return Comparing.equal((Object)item, (Object)element2);
    }

    @Override
    public int getFileCount(SmartTodoItemPointer val) {
        return 1;
    }

    @Override
    public int getTodoItemCount(SmartTodoItemPointer val) {
        return 1;
    }

    public List<HighlightedRegion> getHighlightedRegions() {
        return this.myHighlightedRegions;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        List<AbstractTreeNode<?>> list2 = Collections.emptyList();
        if (list2 == null) {
            TodoItemNode.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void update(@NotNull PresentationData presentation) {
        int lineStartOffset;
        if (presentation == null) {
            TodoItemNode.$$$reportNull$$$0(2);
        }
        SmartTodoItemPointer todoItemPointer = (SmartTodoItemPointer)this.getValue();
        assert (todoItemPointer != null);
        TodoItem todoItem = todoItemPointer.getTodoItem();
        RangeMarker myRangeMarker = todoItemPointer.getRangeMarker();
        if (!todoItem.getFile().isValid() || !myRangeMarker.isValid() || myRangeMarker.getStartOffset() == myRangeMarker.getEndOffset()) {
            myRangeMarker.dispose();
            this.setValue(null);
            return;
        }
        this.myHighlightedRegions.clear();
        this.myAdditionalLines.clear();
        Document document = todoItemPointer.getDocument();
        CharSequence chars = document.getCharsSequence();
        int startOffset = myRangeMarker.getStartOffset();
        int endOffset = myRangeMarker.getEndOffset();
        int lineNumber = document.getLineNumber(startOffset);
        int columnNumber = startOffset - lineStartOffset;
        for (lineStartOffset = document.getLineStartOffset(lineNumber); lineStartOffset < document.getTextLength() && (chars.charAt(lineStartOffset) == '\t' || chars.charAt(lineStartOffset) == ' '); ++lineStartOffset) {
        }
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        String lineColumnPrefix = "(" + (lineNumber + 1) + ", " + (columnNumber + 1) + ") ";
        String highlightedText = chars.subSequence(lineStartOffset, Math.min(lineEndOffset, chars.length())).toString();
        String newName = lineColumnPrefix + highlightedText;
        Icon newIcon = todoItem.getPattern().getAttributes().getIcon();
        this.myHighlightedRegions.clear();
        EditorHighlighter highlighter = this.myBuilder.getHighlighter(todoItem.getFile(), document);
        TodoItemNode.collectHighlights(this.myHighlightedRegions, highlighter, lineStartOffset, lineEndOffset, lineColumnPrefix.length());
        TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
        this.myHighlightedRegions.add(new HighlightedRegion(lineColumnPrefix.length() + startOffset - lineStartOffset, lineColumnPrefix.length() + endOffset - lineStartOffset, attributes));
        presentation.setPresentableText(newName);
        presentation.setIcon(newIcon);
        for (RangeMarker additionalMarker : todoItemPointer.getAdditionalRangeMarkers()) {
            if (!additionalMarker.isValid()) break;
            ArrayList<HighlightedRegion> highlights = new ArrayList<HighlightedRegion>();
            int lineNum = document.getLineNumber(additionalMarker.getStartOffset());
            int lineStart = document.getLineStartOffset(lineNum);
            int lineEnd = document.getLineEndOffset(lineNum);
            int lineStartNonWs = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
            if (lineStartNonWs > additionalMarker.getStartOffset() || lineEnd < additionalMarker.getEndOffset()) break;
            TodoItemNode.collectHighlights(highlights, highlighter, lineStartNonWs, lineEnd, 0);
            highlights.add(new HighlightedRegion(additionalMarker.getStartOffset() - lineStartNonWs, additionalMarker.getEndOffset() - lineStartNonWs, attributes));
            this.myAdditionalLines.add(new AdditionalTodoLine(document.getText(new TextRange(lineStartNonWs, lineEnd)), highlights));
        }
    }

    private static void collectHighlights(@NotNull List<? super HighlightedRegion> highlights, @NotNull EditorHighlighter highlighter, int startOffset, int endOffset, int highlightOffsetShift) {
        if (highlights == null) {
            TodoItemNode.$$$reportNull$$$0(3);
        }
        if (highlighter == null) {
            TodoItemNode.$$$reportNull$$$0(4);
        }
        HighlighterIterator iterator2 = highlighter.createIterator(startOffset);
        while (!iterator2.atEnd()) {
            int start2 = Math.max(iterator2.getStart(), startOffset);
            int end = Math.min(iterator2.getEnd(), endOffset);
            if (start2 >= endOffset) break;
            TextAttributes attributes = iterator2.getTextAttributes();
            int fontType = attributes.getFontType();
            if ((fontType & 1) != 0) {
                attributes = attributes.clone();
                attributes.setFontType(fontType & 0xFFFFFFFE);
            }
            HighlightedRegion region = new HighlightedRegion(highlightOffsetShift + start2 - startOffset, highlightOffsetShift + end - startOffset, attributes);
            highlights.add((HighlightedRegion)region);
            iterator2.advance();
        }
    }

    public int getRowCount() {
        return this.myAdditionalLines.size() + 1;
    }

    public String getTestPresentation() {
        return "Item: " + ((SmartTodoItemPointer)this.getValue()).getTodoItem().getTextRange();
    }

    public int getWeight() {
        return 5;
    }

    @NotNull
    public List<HighlightedRegionProvider> getAdditionalLines() {
        List<HighlightedRegionProvider> list2 = this.myAdditionalLines;
        if (list2 == null) {
            TodoItemNode.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/TodoItemNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/TodoItemNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AdditionalTodoLine
    implements HighlightedRegionProvider {
        private final String myText;
        private final List<HighlightedRegion> myHighlights;

        private AdditionalTodoLine(String text2, List<HighlightedRegion> highlights) {
            this.myText = text2;
            this.myHighlights = highlights;
        }

        @Override
        public Iterable<HighlightedRegion> getHighlightedRegions() {
            return this.myHighlights;
        }

        public String toString() {
            return this.myText;
        }
    }
}

