/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.lightEdit.LightEditConfiguration;
import com.intellij.ide.lightEdit.LightEditFrameWrapper;
import com.intellij.ide.lightEdit.LightEditPanel;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.lightEdit.project.LightEditProjectManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LightEdit", storages={@Storage(value="lightEdit.xml")})
public final class LightEditServiceImpl
implements LightEditService,
Disposable,
LightEditorListener,
AppLifecycleListener,
PersistentStateComponent<LightEditConfiguration> {
    private static final Logger LOG = Logger.getInstance(LightEditServiceImpl.class);
    private LightEditFrameWrapper myFrameWrapper;
    private final LightEditorManagerImpl myEditorManager;
    private final LightEditConfiguration myConfiguration = new LightEditConfiguration();
    private final LightEditProjectManager myLightEditProjectManager = new LightEditProjectManager();

    @NotNull
    public LightEditConfiguration getState() {
        LightEditConfiguration lightEditConfiguration = this.myConfiguration;
        if (lightEditConfiguration == null) {
            LightEditServiceImpl.$$$reportNull$$$0(0);
        }
        return lightEditConfiguration;
    }

    public void loadState(@NotNull LightEditConfiguration state) {
        if (state == null) {
            LightEditServiceImpl.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myConfiguration);
    }

    public LightEditServiceImpl() {
        this.myEditorManager = new LightEditorManagerImpl(this);
        this.myEditorManager.addListener(this);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)this);
        Disposer.register((Disposable)this, (Disposable)this.myEditorManager);
    }

    private void init() {
        if (this.myFrameWrapper == null) {
            this.myFrameWrapper = LightEditFrameWrapper.allocate(() -> this.closeEditorWindow());
            LOG.info("Frame created");
        }
        if (!this.myFrameWrapper.getFrame().isVisible()) {
            this.myFrameWrapper.getFrame().setVisible(true);
            LOG.info("Window opened");
        }
    }

    public void showEditorWindow() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.init();
            this.myFrameWrapper.getFrame().setTitle(LightEditServiceImpl.getAppName());
        }
    }

    private static String getAppName() {
        return ApplicationInfo.getInstance().getVersionName();
    }

    @Nullable
    public Project getProject() {
        return this.myLightEditProjectManager.getProject();
    }

    @NotNull
    public Project getOrCreateProject() {
        Project project = this.myLightEditProjectManager.getOrCreateProject();
        if (project == null) {
            LightEditServiceImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    public boolean openFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(3);
        }
        if (LightEditUtil.isLightEditEnabled()) {
            LightEditServiceImpl.doWhenActionManagerInitialized(() -> this.doOpenFile(file2));
            return true;
        }
        return false;
    }

    private static void doWhenActionManagerInitialized(@NotNull Runnable callback2) {
        ActionManager created;
        if (callback2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(4);
        }
        if ((created = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) == null) {
            NonUrgentExecutor.getInstance().execute(() -> {
                ActionManager.getInstance();
                LightEditServiceImpl.invokeOnEdt(callback2);
            });
        } else {
            LightEditServiceImpl.invokeOnEdt(callback2);
        }
    }

    private static void invokeOnEdt(@NotNull Runnable callback2) {
        if (callback2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            callback2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(callback2);
        }
    }

    private void doOpenFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(6);
        }
        this.showEditorWindow();
        LightEditorInfo openEditorInfo = this.myEditorManager.findOpen(file2);
        if (openEditorInfo == null) {
            LightEditorInfo newEditorInfo = this.myEditorManager.createEditor(file2);
            this.addEditorTab(newEditorInfo);
            LOG.info("Opened new tab for " + file2.getPresentableUrl());
        } else {
            this.selectEditorTab(openEditorInfo);
            LOG.info("Selected tab for " + file2.getPresentableUrl());
        }
        this.logStartupTime();
    }

    private void logStartupTime() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ObjectUtils.consumeIfNotNull((Object)this.getEditPanel().getTabs().getSelectedInfo(), tabInfo -> UiNotifyConnector.doWhenFirstShown((JComponent)tabInfo.getComponent(), () -> ApplicationManager.getApplication().invokeLater(() -> LOG.info("Startup took: " + ManagementFactory.getRuntimeMXBean().getUptime() + " ms"))));
        }
    }

    private void selectEditorTab(LightEditorInfo openEditorInfo) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().selectTab(openEditorInfo);
        }
    }

    private void addEditorTab(LightEditorInfo newEditorInfo) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().addEditorTab(newEditorInfo);
        }
    }

    public void closeEditor(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(7);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getEditPanel().getTabs().closeTab(editorInfo);
        }
    }

    public void createNewFile() {
        this.showEditorWindow();
        LightEditorInfo newEditorInfo = this.myEditorManager.createEditor();
        this.addEditorTab(newEditorInfo);
    }

    public boolean closeEditorWindow() {
        if (this.canClose()) {
            this.myFrameWrapper.getFrame().setVisible(false);
            this.myEditorManager.releaseEditors();
            LOG.info("Window closed");
            if (ProjectManager.getInstance().getOpenProjects().length == 0 && WelcomeFrame.getInstance() == null) {
                this.disposeFrameWrapper();
                LOG.info("No open projects or welcome frame, exiting");
                try {
                    Disposer.dispose((Disposable)this.myEditorManager);
                    this.myLightEditProjectManager.close();
                    ApplicationManager.getApplication().exit();
                }
                catch (Throwable t) {
                    System.exit(1);
                }
            } else {
                this.myFrameWrapper.releaseFrame();
                this.myFrameWrapper = null;
            }
        } else {
            LOG.info("Close cancelled");
        }
        return false;
    }

    private boolean canClose() {
        return !this.myEditorManager.containsUnsavedDocuments() || this.autosaveDocuments() || LightEditUtil.confirmClose(ApplicationBundle.message((String)"light.edit.exit.message", (Object[])new Object[0]), ApplicationBundle.message((String)"light.edit.exit.title", (Object[])new Object[0]), () -> FileDocumentManager.getInstance().saveAllDocuments());
    }

    private boolean autosaveDocuments() {
        if (this.isAutosaveMode()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            return true;
        }
        return false;
    }

    public LightEditPanel getEditPanel() {
        assert (!Disposer.isDisposed((Disposable)this.myFrameWrapper.getLightEditPanel()));
        return this.myFrameWrapper.getLightEditPanel();
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        LightEditFrameWrapper frameWrapper = this.myFrameWrapper;
        if (frameWrapper == null) {
            return null;
        }
        LightEditPanel panel2 = frameWrapper.getLightEditPanel();
        if (!Disposer.isDisposed((Disposable)panel2)) {
            return panel2.getTabs().getSelectedFile();
        }
        return null;
    }

    @Nullable
    public FileEditor getSelectedFileEditor() {
        LightEditFrameWrapper frameWrapper = this.myFrameWrapper;
        if (frameWrapper == null) {
            return null;
        }
        LightEditPanel panel2 = frameWrapper.getLightEditPanel();
        if (!Disposer.isDisposed((Disposable)panel2)) {
            return panel2.getTabs().getSelectedFileEditor();
        }
        return null;
    }

    public void updateFileStatus(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(8);
        }
        List editors = ContainerUtil.mapNotNull(files2, this.myEditorManager::findOpen);
        if (!editors.isEmpty()) {
            this.myEditorManager.fireFileStatusChanged(editors);
        }
    }

    public void dispose() {
        if (this.myFrameWrapper != null) {
            this.disposeFrameWrapper();
        }
    }

    private void disposeFrameWrapper() {
        Disposer.dispose((Disposable)this.myFrameWrapper);
        this.myFrameWrapper = null;
        LOG.info("Frame disposed");
    }

    public void afterSelect(@Nullable LightEditorInfo editorInfo) {
        if (this.myFrameWrapper != null) {
            this.myFrameWrapper.getFrame().setTitle(editorInfo == null ? LightEditServiceImpl.getAppName() : LightEditServiceImpl.getFileTitle(editorInfo.getFile()));
        }
    }

    private static String getFileTitle(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(9);
        }
        StringBuilder titleBuilder = new StringBuilder();
        titleBuilder.append(file2.getPresentableName());
        VirtualFile parent = file2.getParent();
        if (parent != null) {
            titleBuilder.append(" - ").append(LightEditServiceImpl.truncateUrl(parent.getPresentableUrl()));
        }
        return titleBuilder.toString();
    }

    private static String truncateUrl(@NotNull String url) {
        String truncated;
        String withoutLast;
        int prevSlashPos;
        int slashPos;
        if (url == null) {
            LightEditServiceImpl.$$$reportNull$$$0(10);
        }
        if ((slashPos = Math.max(url.lastIndexOf(92), url.lastIndexOf(47))) >= 0 && (prevSlashPos = Math.max((withoutLast = url.substring(0, slashPos)).lastIndexOf(92), withoutLast.lastIndexOf(47))) >= 0 && !url.equals(truncated = url.substring(prevSlashPos))) {
            return "..." + url.substring(prevSlashPos);
        }
        return url;
    }

    public void afterClose(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditServiceImpl.$$$reportNull$$$0(11);
        }
        if (this.myEditorManager.getEditorCount() == 0) {
            this.closeEditorWindow();
        }
    }

    @NotNull
    public LightEditorManager getEditorManager() {
        LightEditorManagerImpl lightEditorManagerImpl = this.myEditorManager;
        if (lightEditorManagerImpl == null) {
            LightEditServiceImpl.$$$reportNull$$$0(12);
        }
        return lightEditorManagerImpl;
    }

    public void saveToAnotherFile(@NotNull VirtualFile file2) {
        VirtualFile targetFile;
        LightEditorInfo editorInfo;
        if (file2 == null) {
            LightEditServiceImpl.$$$reportNull$$$0(13);
        }
        if ((editorInfo = this.myEditorManager.getEditorInfo(file2)) != null && (targetFile = LightEditUtil.chooseTargetFile(this.myFrameWrapper.getLightEditPanel(), editorInfo)) != null) {
            LightEditorInfo newInfo = this.myEditorManager.saveAs(editorInfo, targetFile);
            this.getEditPanel().getTabs().replaceTab(editorInfo, newInfo);
        }
    }

    public boolean isAutosaveMode() {
        return this.myConfiguration.autosaveMode;
    }

    public void setAutosaveMode(boolean autosaveMode) {
        this.myConfiguration.autosaveMode = autosaveMode;
        this.myEditorManager.fireAutosaveModeChanged(autosaveMode);
    }

    public void disposeCurrentSession() {
        this.myEditorManager.releaseEditors();
        this.myLightEditProjectManager.close();
    }

    @Override
    public void appClosing() {
        ((EncodingManagerImpl)EncodingManager.getInstance()).clearDocumentQueue();
        if (this.myFrameWrapper != null) {
            this.myFrameWrapper.getFrame().setVisible(false);
            this.disposeFrameWrapper();
        }
        Disposer.dispose((Disposable)this.myEditorManager);
        this.myLightEditProjectManager.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditServiceImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doWhenActionManagerInitialized";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnEdt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "closeEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateFileStatus";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileTitle";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "truncateUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "afterClose";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveToAnotherFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

