/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.PathUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ReopenProjectAction
extends AnAction
implements DumbAware {
    private final String myProjectPath;
    private final String myProjectName;
    private boolean myIsRemoved;

    public ReopenProjectAction(@NotNull @SystemIndependent String projectPath, String projectName, String displayName) {
        if (projectPath == null) {
            ReopenProjectAction.$$$reportNull$$$0(0);
        }
        this.myIsRemoved = false;
        this.myProjectPath = projectPath;
        this.myProjectName = projectName;
        Presentation presentation = this.getTemplatePresentation();
        String text2 = projectPath.equals(displayName) ? FileUtil.getLocationRelativeToUserHome((String)projectPath) : displayName;
        presentation.setText(text2, false);
        presentation.setDescription(PathUtil.toSystemDependentName((String)projectPath));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ReopenProjectAction.$$$reportNull$$$0(1);
        }
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        Project project = e.getProject();
        Path file2 = Paths.get(this.myProjectPath, new String[0]);
        if (!Files.exists(file2, new LinkOption[0])) {
            if (Messages.showDialog((Project)project, (String)IdeBundle.message((String)"message.the.path.0.does.not.exist.maybe.on.remote", (Object[])new Object[]{PathUtil.toSystemDependentName((String)this.myProjectPath)}), (String)"Reopen Project", (String[])new String[]{"OK", "&Remove From List"}, (int)0, (Icon)Messages.getErrorIcon()) == 1) {
                this.myIsRemoved = true;
                RecentProjectsManager.getInstance().removePath(this.myProjectPath);
            }
            return;
        }
        int modifiers = e.getModifiers();
        boolean forceOpenInNewFrame = BitUtil.isSet((int)modifiers, (int)2) || BitUtil.isSet((int)modifiers, (int)1) || e.getPlace() == "WelcomeScreen";
        RecentProjectsManagerBase.getInstanceEx().openProject(file2, new OpenProjectTask(forceOpenInNewFrame, project));
    }

    public @SystemIndependent String getProjectPath() {
        return this.myProjectPath;
    }

    public boolean isRemoved() {
        return this.myIsRemoved;
    }

    public String getProjectName() {
        RecentProjectsManager mgr = RecentProjectsManager.getInstance();
        if (mgr instanceof RecentProjectsManagerBase) {
            return ((RecentProjectsManagerBase)mgr).getProjectName(this.myProjectPath);
        }
        return this.myProjectName;
    }

    @Nullable
    public String getTemplateText() {
        return "Reopen Project";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ReopenProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

