/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.application.options.RegistryManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.HelpTooltipManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.TooltipEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeTooltipManager
implements Disposable,
AWTEventListener {
    public static final ColorKey TOOLTIP_COLOR_KEY = ColorKey.createColorKey((String)"TOOLTIP", null);
    private static final Key<IdeTooltip> CUSTOM_TOOLTIP = Key.create((String)"custom.tooltip");
    private static final MouseEventAdapter<Void> DUMMY_LISTENER = new MouseEventAdapter(null);
    public static final Color GRAPHITE_COLOR = new Color(100, 100, 100, 230);
    private final RegistryValue myIsEnabled;
    private final RegistryValue myHelpTooltip;
    private HelpTooltipManager myHelpTooltipManager;
    private boolean myHideHelpTooltip;
    private volatile Component myCurrentComponent;
    private volatile Component myQueuedComponent;
    private volatile Component myProcessingComponent;
    private BalloonImpl myCurrentTipUi;
    private MouseEvent myCurrentEvent;
    private boolean myCurrentTipIsCentered;
    private Disposable myLastDisposable;
    private Runnable myHideRunnable;
    private boolean myShowDelay = true;
    private final Alarm myAlarm = new Alarm();
    private int myX;
    private int myY;
    private IdeTooltip myCurrentTooltip;
    private Runnable myShowRequest;
    private IdeTooltip myQueuedTooltip;

    public IdeTooltipManager() {
        RegistryManager registryManager = RegistryManager.getInstance();
        this.myIsEnabled = registryManager.get("ide.tooltip.callout");
        this.myHelpTooltip = registryManager.get("ide.helptooltip.enabled");
        RegistryValueListener listener2 = new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeTooltipManager.this.processEnabled();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/IdeTooltipManager$1", "afterValueChanged"));
            }
        };
        Application app = ApplicationManager.getApplication();
        this.myIsEnabled.addListener(listener2, (Disposable)app);
        this.myHelpTooltip.addListener(listener2, (Disposable)app);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
        app.getMessageBus().connect().subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                IdeTooltipManager.this.hideCurrent(null, action2, event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/IdeTooltipManager$2";
                objectArray[2] = "beforeActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.processEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDispatched(AWTEvent event) {
        if (!this.myIsEnabled.asBoolean()) {
            return;
        }
        MouseEvent me = (MouseEvent)event;
        this.myProcessingComponent = me.getComponent();
        try {
            if (me.getID() == 504) {
                boolean canShow = true;
                if (this.componentContextHasChanged(this.myProcessingComponent)) {
                    canShow = this.hideCurrent(me, null, null);
                }
                if (canShow) {
                    this.maybeShowFor(this.myProcessingComponent, me);
                }
            } else if (me.getID() == 505) {
                if (this.myProcessingComponent == this.myCurrentComponent && this.myCurrentTooltip != null && !this.myCurrentTooltip.isHint() && this.myCurrentTipUi != null) {
                    this.myCurrentTipUi.setAnimationEnabled(false);
                    this.hideCurrent(null, null, null, null, false);
                } else if (this.myProcessingComponent == this.myCurrentComponent || this.myProcessingComponent == this.myQueuedComponent) {
                    this.hideCurrent(me, null, null);
                }
            } else if (me.getID() == 503) {
                if (this.myProcessingComponent == this.myCurrentComponent || this.myProcessingComponent == this.myQueuedComponent) {
                    if (this.myCurrentTipUi != null && this.myCurrentTipUi.wasFadedIn()) {
                        this.maybeShowFor(this.myProcessingComponent, me);
                    } else if (!this.myCurrentTipIsCentered) {
                        this.myX = me.getX();
                        this.myY = me.getY();
                        if (!(!(this.myProcessingComponent instanceof JComponent) || this.isTooltipDefined((JComponent)this.myProcessingComponent, me) || this.myQueuedTooltip != null && this.myQueuedTooltip.isHint())) {
                            this.hideCurrent(me, null, null);
                        } else {
                            this.maybeShowFor(this.myProcessingComponent, me);
                        }
                    }
                } else if (this.myCurrentComponent == null && this.myQueuedComponent == null) {
                    this.maybeShowFor(this.myProcessingComponent, me);
                }
            } else if (me.getID() == 501) {
                boolean clickOnTooltip;
                boolean bl = clickOnTooltip = this.myCurrentTipUi != null && this.myCurrentTipUi == JBPopupFactory.getInstance().getParentBalloonFor(this.myProcessingComponent);
                if (this.myProcessingComponent == this.myCurrentComponent || clickOnTooltip && !this.myCurrentTipUi.isClickProcessor()) {
                    this.hideCurrent(me, null, null, null, !clickOnTooltip);
                }
            } else if (me.getID() == 506) {
                this.hideCurrent(me, null, null);
            }
        }
        finally {
            this.myProcessingComponent = null;
        }
    }

    private boolean componentContextHasChanged(Component eventComponent) {
        Point tooltipPoint;
        if (eventComponent == this.myCurrentComponent) {
            return false;
        }
        if (this.myQueuedTooltip != null && (tooltipPoint = this.myQueuedTooltip.getPoint()) != null) {
            Component realQueuedComponent = SwingUtilities.getDeepestComponentAt(this.myQueuedTooltip.getComponent(), tooltipPoint.x, tooltipPoint.y);
            return eventComponent != realQueuedComponent;
        }
        return true;
    }

    private void maybeShowFor(Component c, MouseEvent me) {
        this.showForComponent(c, me, false);
    }

    private void showForComponent(Component c, MouseEvent me, boolean now) {
        int row;
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent comp = (JComponent)c;
        Window wnd = SwingUtilities.getWindowAncestor(comp);
        if (wnd == null) {
            return;
        }
        if (!wnd.isActive() && JBPopupFactory.getInstance().isChildPopupFocused((Component)wnd)) {
            return;
        }
        if (!this.isTooltipDefined(comp, me)) {
            this.hideCurrent(null);
            return;
        }
        boolean centerDefault = Boolean.TRUE.equals(comp.getClientProperty("ToCenterTooltip"));
        boolean centerStrict = Boolean.TRUE.equals(comp.getClientProperty("ToCenterTooltip.default"));
        int shift = centerStrict ? 0 : (centerDefault ? 4 : 0);
        Rectangle rowBounds = null;
        if (c instanceof JTree) {
            TreePath path = ((JTree)c).getClosestPathForLocation(me.getX(), me.getY());
            if (path != null) {
                rowBounds = ((JTree)c).getPathBounds(path);
            }
        } else if (c instanceof JList && (row = ((JList)c).locationToIndex(me.getPoint())) > -1) {
            rowBounds = ((JList)c).getCellBounds(row, row);
        }
        if (rowBounds != null && rowBounds.y + 4 < me.getY()) {
            shift += me.getY() - rowBounds.y - 4;
        }
        this.showTooltipForEvent(comp, me, centerStrict || centerDefault, shift, -shift, -shift, now);
    }

    private boolean isTooltipDefined(JComponent comp, MouseEvent me) {
        return !StringUtil.isEmpty((String)comp.getToolTipText(me)) || this.getCustomTooltip(comp) != null;
    }

    private void showTooltipForEvent(final JComponent c, final MouseEvent me, boolean toCenter, int shift, int posChangeX, int posChangeY, boolean now) {
        IdeTooltip tooltip = this.getCustomTooltip(c);
        if (tooltip == null) {
            if (this.myHelpTooltipManager != null) {
                this.myCurrentComponent = c;
                this.myHideHelpTooltip = true;
                this.myHelpTooltipManager.showTooltip(c, me);
                return;
            }
            String aText = String.valueOf(c.getToolTipText(me));
            tooltip = new IdeTooltip(c, me.getPoint(), null, new Object[]{c, aText}){

                @Override
                protected boolean beforeShow() {
                    Rectangle visibleRect;
                    IdeTooltipManager.this.myCurrentEvent = me;
                    if (!c.isShowing()) {
                        return false;
                    }
                    String text2 = c.getToolTipText(IdeTooltipManager.this.myCurrentEvent);
                    if (text2 == null || text2.trim().isEmpty()) {
                        return false;
                    }
                    Rectangle rectangle = c.getParent() instanceof JViewport ? ((JViewport)c.getParent()).getViewRect() : (visibleRect = IdeMouseEventDispatcher.isDiagramViewComponent(c) ? c.getBounds() : c.getVisibleRect());
                    if (!visibleRect.contains(this.getPoint())) {
                        return false;
                    }
                    JLayeredPane layeredPane = (JLayeredPane)ComponentUtil.getParentOfType(JLayeredPane.class, (Component)c);
                    JEditorPane pane2 = IdeTooltipManager.initPane(text2, new HintHint(me).setAwtTooltip(true), layeredPane);
                    Wrapper wrapper2 = new Wrapper((JComponent)pane2);
                    this.setTipComponent((JComponent)wrapper2);
                    return true;
                }
            }.setToCenter(toCenter).setCalloutShift(shift).setPositionChangeShift(posChangeX, posChangeY).setLayer(Balloon.Layer.top);
        } else if (this.myCurrentTooltip == tooltip) {
            return;
        }
        this.show(tooltip, now);
    }

    @ApiStatus.Experimental
    @Contract(value="null -> false", pure=true)
    public boolean isProcessing(@Nullable Component tooltipOwner) {
        return tooltipOwner != null && (tooltipOwner == this.myCurrentComponent || tooltipOwner == this.myQueuedComponent || tooltipOwner == this.myProcessingComponent);
    }

    @ApiStatus.Experimental
    public void updateShownTooltip(@Nullable Component tooltipOwner) {
        if (!this.hasCurrent() || this.myCurrentComponent == null || this.myCurrentComponent != tooltipOwner) {
            return;
        }
        try {
            MouseEvent reposition;
            if (GraphicsEnvironment.isHeadless()) {
                reposition = this.myCurrentEvent;
            } else {
                Point topLeftComponent = this.myCurrentComponent.getLocationOnScreen();
                Point screenLocation = MouseInfo.getPointerInfo().getLocation();
                reposition = new MouseEvent(this.myCurrentEvent.getComponent(), this.myCurrentEvent.getID(), this.myCurrentEvent.getWhen(), this.myCurrentEvent.getModifiers(), screenLocation.x - topLeftComponent.x, screenLocation.y - topLeftComponent.y, screenLocation.x, screenLocation.y, this.myCurrentEvent.getClickCount(), this.myCurrentEvent.isPopupTrigger(), this.myCurrentEvent.getButton());
            }
            this.showForComponent(this.myCurrentComponent, reposition, true);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void setCustomTooltip(JComponent component2, IdeTooltip tooltip) {
        ComponentUtil.putClientProperty((JComponent)component2, CUSTOM_TOOLTIP, (Object)((Object)tooltip));
        component2.removeMouseListener((MouseListener)DUMMY_LISTENER);
        component2.removeMouseMotionListener((MouseMotionListener)DUMMY_LISTENER);
        if (tooltip != null) {
            component2.addMouseListener((MouseListener)DUMMY_LISTENER);
            component2.addMouseMotionListener((MouseMotionListener)DUMMY_LISTENER);
        }
    }

    public IdeTooltip getCustomTooltip(JComponent component2) {
        return (IdeTooltip)((Object)ComponentUtil.getClientProperty((JComponent)component2, CUSTOM_TOOLTIP));
    }

    public IdeTooltip show(IdeTooltip tooltip, boolean now) {
        return this.show(tooltip, now, true);
    }

    public IdeTooltip show(IdeTooltip tooltip, boolean now, boolean animationEnabled) {
        this.myAlarm.cancelAllRequests();
        this.hideCurrent(null, tooltip, null, null);
        this.myQueuedComponent = tooltip.getComponent();
        this.myQueuedTooltip = tooltip;
        this.myShowRequest = () -> {
            if (this.myShowRequest == null) {
                return;
            }
            if (this.myQueuedComponent != tooltip.getComponent() || !tooltip.getComponent().isShowing()) {
                this.hideCurrent(null, tooltip, null, null, animationEnabled);
                return;
            }
            if (tooltip.beforeShow()) {
                this.show(tooltip, null, animationEnabled);
            } else {
                this.hideCurrent(null, tooltip, null, null, animationEnabled);
            }
        };
        if (now) {
            this.myShowRequest.run();
        } else {
            this.myAlarm.addRequest(this.myShowRequest, this.myShowDelay ? tooltip.getShowDelay() : tooltip.getInitialReshowDelay());
        }
        return tooltip;
    }

    private void show(IdeTooltip tooltip, @Nullable Runnable beforeShow, boolean animationEnabled) {
        boolean toCenterY;
        boolean toCenterX;
        boolean toCenter = tooltip.isToCenter();
        boolean small = false;
        if (!toCenter && tooltip.isToCenterIfSmall()) {
            Dimension size = tooltip.getComponent().getSize();
            toCenterX = size.width < 64;
            toCenterY = size.height < 64;
            toCenter = toCenterX || toCenterY;
            small = true;
        } else {
            toCenterX = true;
            toCenterY = true;
        }
        Point effectivePoint = tooltip.getPoint();
        if (toCenter) {
            Rectangle bounds2 = tooltip.getComponent().getBounds();
            effectivePoint.x = toCenterX ? bounds2.width / 2 : effectivePoint.x;
            int n = effectivePoint.y = toCenterY ? bounds2.height / 2 : effectivePoint.y;
        }
        if (this.myCurrentComponent == tooltip.getComponent() && this.myCurrentTipUi != null && !this.myCurrentTipUi.isDisposed()) {
            this.myCurrentTipUi.show(new RelativePoint(tooltip.getComponent(), effectivePoint), tooltip.getPreferredPosition());
            return;
        }
        if (this.myCurrentComponent == tooltip.getComponent() && effectivePoint.equals(new Point(this.myX, this.myY))) {
            return;
        }
        Color bg = tooltip.getTextBackground() != null ? tooltip.getTextBackground() : this.getTextBackground(true);
        Color fg = tooltip.getTextForeground() != null ? tooltip.getTextForeground() : this.getTextForeground(true);
        Color borderColor = tooltip.getBorderColor() != null ? tooltip.getBorderColor() : this.getBorderColor(true);
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder(tooltip.getTipComponent()).setFillColor(bg).setBorderColor(borderColor).setBorderInsets(tooltip.getBorderInsets()).setAnimationCycle(animationEnabled ? RegistryManager.getInstance().intValue("ide.tooltip.animationCycle") : 0).setShowCallout(true).setCalloutShift(small && tooltip.getCalloutShift() == 0 ? 2 : tooltip.getCalloutShift()).setPositionChangeXShift(tooltip.getPositionChangeX()).setPositionChangeYShift(tooltip.getPositionChangeY()).setHideOnKeyOutside(!tooltip.isExplicitClose()).setHideOnAction(!tooltip.isExplicitClose()).setRequestFocus(tooltip.isRequestFocus()).setLayer(tooltip.getLayer());
        tooltip.getTipComponent().setForeground(fg);
        tooltip.getTipComponent().setBorder(tooltip.getComponentBorder());
        tooltip.getTipComponent().setFont(tooltip.getFont() != null ? tooltip.getFont() : this.getTextFont(true));
        if (beforeShow != null) {
            beforeShow.run();
        }
        this.myCurrentTipUi = (BalloonImpl)builder2.createBalloon();
        this.myCurrentTipUi.setAnimationEnabled(animationEnabled);
        tooltip.setUi(this.myCurrentTipUi);
        this.myCurrentComponent = tooltip.getComponent();
        this.myX = effectivePoint.x;
        this.myY = effectivePoint.y;
        this.myCurrentTipIsCentered = toCenter;
        this.myCurrentTooltip = tooltip;
        this.myShowRequest = null;
        this.myQueuedComponent = null;
        this.myQueuedTooltip = null;
        this.myLastDisposable = this.myCurrentTipUi;
        Disposer.register((Disposable)this.myLastDisposable, (Disposable)new Disposable(){

            public void dispose() {
                IdeTooltipManager.this.myLastDisposable = null;
            }
        });
        this.myCurrentTipUi.show(new RelativePoint(tooltip.getComponent(), effectivePoint), tooltip.getPreferredPosition());
        this.myAlarm.addRequest(() -> {
            if (this.myCurrentTooltip == tooltip && tooltip.canBeDismissedOnTimeout()) {
                this.hideCurrent(null, null, null);
            }
        }, tooltip.getDismissDelay());
    }

    public Color getTextForeground(boolean awtTooltip) {
        return UIUtil.getToolTipForeground();
    }

    public Color getLinkForeground(boolean awtTooltip) {
        return JBUI.CurrentTheme.Link.linkColor();
    }

    public Color getTextBackground(boolean awtTooltip) {
        Color color = EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)TOOLTIP_COLOR_KEY);
        return color != null ? color : UIUtil.getToolTipBackground();
    }

    public String getUlImg(boolean awtTooltip) {
        return StartupUiUtil.isUnderDarcula() ? "/general/mdot-white.png" : "/general/mdot.png";
    }

    public Color getBorderColor(boolean awtTooltip) {
        return new JBColor((Color)Gray._160, new Color(91, 93, 95));
    }

    public boolean isOwnBorderAllowed(boolean awtTooltip) {
        return !awtTooltip;
    }

    public boolean isOpaqueAllowed(boolean awtTooltip) {
        return !awtTooltip;
    }

    public Font getTextFont(boolean awtTooltip) {
        return UIManager.getFont("ToolTip.font");
    }

    public boolean hasCurrent() {
        return this.myCurrentTooltip != null;
    }

    public boolean hasScheduled() {
        return this.myShowRequest != null;
    }

    public boolean hideCurrent(@Nullable MouseEvent me) {
        return this.hideCurrent(me, null, null, null);
    }

    private boolean hideCurrent(@Nullable MouseEvent me, @Nullable AnAction action2, @Nullable AnActionEvent event) {
        return this.hideCurrent(me, null, action2, event, this.myCurrentTipUi != null && this.myCurrentTipUi.isAnimationEnabled());
    }

    private boolean hideCurrent(@Nullable MouseEvent me, @Nullable IdeTooltip tooltipToShow, @Nullable AnAction action2, @Nullable AnActionEvent event) {
        return this.hideCurrent(me, tooltipToShow, action2, event, this.myCurrentTipUi != null && this.myCurrentTipUi.isAnimationEnabled());
    }

    private boolean hideCurrent(@Nullable MouseEvent me, @Nullable IdeTooltip tooltipToShow, @Nullable AnAction action2, @Nullable AnActionEvent event, boolean animationEnabled) {
        if (this.myHelpTooltipManager != null && this.myHideHelpTooltip) {
            this.hideCurrentNow(false);
            return true;
        }
        if (this.myCurrentTooltip != null && me != null && this.myCurrentTooltip.isInside(new RelativePoint(me)) && (me.getButton() == 0 || this.myCurrentTipUi == null || this.myCurrentTipUi.isBlockClicks())) {
            return false;
        }
        this.myShowRequest = null;
        this.myQueuedComponent = null;
        this.myQueuedTooltip = null;
        if (this.myCurrentTooltip == null) {
            return true;
        }
        if (this.myCurrentTipUi != null) {
            boolean implicitMouseMove;
            RelativePoint target2 = me != null ? new RelativePoint(me) : null;
            boolean isInsideOrMovingForward = target2 != null && (this.myCurrentTipUi.isInside(target2) || this.myCurrentTipUi.isMovingForward(target2));
            boolean canAutoHide = this.myCurrentTooltip.canAutohideOn(new TooltipEvent(me, isInsideOrMovingForward, action2, event));
            boolean bl = implicitMouseMove = me != null && (me.getID() == 503 || me.getID() == 505 || me.getID() == 504);
            if (!canAutoHide || isInsideOrMovingForward && implicitMouseMove || this.myCurrentTooltip.isExplicitClose() && implicitMouseMove || tooltipToShow != null && !tooltipToShow.isHint() && Comparing.equal((Object)((Object)this.myCurrentTooltip), (Object)((Object)tooltipToShow))) {
                if (this.myHideRunnable != null) {
                    this.myHideRunnable = null;
                }
                return false;
            }
        }
        this.myHideRunnable = () -> {
            if (this.myHideRunnable != null) {
                this.hideCurrentNow(animationEnabled);
                this.myHideRunnable = null;
            }
        };
        if (me != null && me.getButton() == 0) {
            this.myAlarm.addRequest(this.myHideRunnable, RegistryManager.getInstance().intValue("ide.tooltip.autoDismissDeadZone"));
        } else {
            this.myHideRunnable.run();
            this.myHideRunnable = null;
        }
        return true;
    }

    public void hideCurrentNow(boolean animationEnabled) {
        if (this.myHelpTooltipManager != null) {
            this.myHelpTooltipManager.hideTooltip();
        }
        if (this.myCurrentTipUi != null) {
            this.myCurrentTipUi.setAnimationEnabled(animationEnabled);
            this.myCurrentTipUi.hide();
            this.myCurrentTooltip.onHidden();
            this.myShowDelay = false;
            this.myAlarm.addRequest(() -> {
                this.myShowDelay = true;
            }, RegistryManager.getInstance().intValue("ide.tooltip.reshowDelay"));
        }
        this.myHideHelpTooltip = false;
        this.myShowRequest = null;
        this.myCurrentTooltip = null;
        this.myCurrentTipUi = null;
        this.myCurrentComponent = null;
        this.myQueuedComponent = null;
        this.myQueuedTooltip = null;
        this.myCurrentEvent = null;
        this.myCurrentTipIsCentered = false;
        this.myX = -1;
        this.myY = -1;
    }

    private void processEnabled() {
        if (this.myIsEnabled.asBoolean()) {
            ToolTipManager.sharedInstance().setEnabled(false);
            if (this.myHelpTooltip.asBoolean()) {
                if (this.myHelpTooltipManager == null) {
                    this.myHelpTooltipManager = new HelpTooltipManager();
                }
                return;
            }
        } else {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        if (this.myHelpTooltipManager != null) {
            this.myHelpTooltipManager.hideTooltip();
            this.myHelpTooltipManager = null;
        }
    }

    public void dispose() {
        this.hideCurrentNow(false);
        if (this.myLastDisposable != null) {
            Disposer.dispose((Disposable)this.myLastDisposable);
        }
    }

    public static IdeTooltipManager getInstance() {
        return (IdeTooltipManager)ApplicationManager.getApplication().getService(IdeTooltipManager.class);
    }

    public void hide(@Nullable IdeTooltip tooltip) {
        if (this.myCurrentTooltip == tooltip || tooltip == null || tooltip == this.myQueuedTooltip) {
            this.hideCurrent(null, null, null);
        }
    }

    public void cancelAutoHide() {
        this.myHideRunnable = null;
    }

    public static JEditorPane initPane(@NonNls String text2, HintHint hintHint, @Nullable JLayeredPane layeredPane) {
        return IdeTooltipManager.initPane(new Html(text2), hintHint, layeredPane);
    }

    public static JEditorPane initPane(@NonNls Html html, HintHint hintHint, @Nullable JLayeredPane layeredPane) {
        return IdeTooltipManager.initPane(html, hintHint, layeredPane, true);
    }

    public static JEditorPane initPane(@NonNls Html html, final HintHint hintHint, final @Nullable JLayeredPane layeredPane, boolean limitWidthToScreen) {
        final Ref prefSize = new Ref(null);
        String text2 = HintUtil.prepareHintText(html, hintHint);
        final boolean[] prefSizeWasComputed = new boolean[]{false};
        JEditorPane pane2 = limitWidthToScreen ? new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                if (!prefSizeWasComputed[0] && hintHint.isAwtTooltip()) {
                    Dimension size;
                    JRootPane rootPane;
                    JLayeredPane lp = layeredPane;
                    if (lp == null && (rootPane = UIUtil.getRootPane((Component)this)) != null) {
                        lp = rootPane.getLayeredPane();
                    }
                    if (lp != null) {
                        AppUIUtil.targetToDevice(this, lp);
                        size = lp.getSize();
                        prefSizeWasComputed[0] = true;
                    } else {
                        size = ScreenUtil.getScreenRectangle((int)0, (int)0).getSize();
                    }
                    int fitWidth = (int)((double)size.width * 0.8);
                    Dimension prefSizeOriginal = super.getPreferredSize();
                    if (prefSizeOriginal.width > fitWidth) {
                        this.setSize(new Dimension(fitWidth, Integer.MAX_VALUE));
                        Dimension fixedWidthSize = super.getPreferredSize();
                        Dimension minSize = super.getMinimumSize();
                        prefSize.set((Object)new Dimension(Math.max(fitWidth, minSize.width), fixedWidthSize.height));
                    } else {
                        prefSize.set((Object)new Dimension(prefSizeOriginal));
                    }
                }
                Dimension s = prefSize.get() != null ? new Dimension((Dimension)prefSize.get()) : super.getPreferredSize();
                Border b = this.getBorder();
                if (b != null) {
                    JBInsets.addTo((Dimension)s, (Insets)b.getBorderInsets(this));
                }
                return s;
            }

            @Override
            public void setPreferredSize(Dimension preferredSize) {
                super.setPreferredSize(preferredSize);
                prefSize.set((Object)preferredSize);
            }
        } : new JEditorPane();
        JBHtmlEditorKit kit = new JBHtmlEditorKit(){
            final HTMLEditorKit.HTMLFactory factory = new HTMLEditorKit.HTMLFactory(){

                @Override
                public View create(Element elem) {
                    HTML.Tag kind;
                    Object o;
                    AttributeSet attrs = elem.getAttributes();
                    Object elementName = attrs.getAttribute("$ename");
                    Object object = o = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
                    if (o instanceof HTML.Tag && (kind = (HTML.Tag)o) == HTML.Tag.HR) {
                        View view = super.create(elem);
                        try {
                            Field field = view.getClass().getDeclaredField("size");
                            field.setAccessible(true);
                            field.set(view, JBUIScale.scale((int)1));
                            return view;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return super.create(elem);
                }
            };

            public ViewFactory getViewFactory() {
                return this.factory;
            }
        };
        String editorFontName = EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName();
        if (editorFontName != null) {
            String style = "font-family:\"" + StringUtil.escapeQuotes((String)editorFontName) + "\";font-size:95%;";
            kit.getStyleSheet().addRule("pre {" + style + "}");
            text2 = text2.replace("<code>", "<code style='" + style + "'>");
        }
        pane2.setEditorKit((EditorKit)kit);
        pane2.setText(text2);
        pane2.setCaretPosition(0);
        pane2.setEditable(false);
        if (hintHint.isOwnBorderAllowed()) {
            IdeTooltipManager.setBorder(pane2);
            IdeTooltipManager.setColors(pane2);
        } else {
            pane2.setBorder(null);
        }
        if (!hintHint.isAwtTooltip()) {
            prefSizeWasComputed[0] = true;
        }
        boolean opaque = hintHint.isOpaqueAllowed();
        pane2.setOpaque(opaque);
        pane2.setBackground(hintHint.getTextBackground());
        if (!limitWidthToScreen) {
            AppUIUtil.targetToDevice(pane2, layeredPane);
        }
        return pane2;
    }

    public static void setColors(JComponent pane2) {
        pane2.setForeground(JBColor.foreground());
        pane2.setBackground(HintUtil.getInformationColor());
        pane2.setOpaque(true);
    }

    public static void setBorder(JComponent pane2) {
        pane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), (Border)JBUI.Borders.empty((int)0, (int)5)));
    }

    public boolean isQueuedToShow(IdeTooltip tooltip) {
        return Comparing.equal((Object)((Object)this.myQueuedTooltip), (Object)((Object)tooltip));
    }
}

