/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.actions;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.CompletionStatistics;
import com.intellij.featureStatistics.CumulativeStatistics;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public final class ShowFeatureUsageStatisticsDialog
extends DialogWrapper {
    private static final Comparator<FeatureDescriptor> DISPLAY_NAME_COMPARATOR = Comparator.comparing(FeatureDescriptor::getDisplayName);
    private static final Comparator<FeatureDescriptor> GROUP_NAME_COMPARATOR = Comparator.comparing(ShowFeatureUsageStatisticsDialog::getGroupName);
    private static final Comparator<FeatureDescriptor> USAGE_COUNT_COMPARATOR = Comparator.comparingInt(FeatureDescriptor::getUsageCount);
    private static final Comparator<FeatureDescriptor> LAST_USED_COMPARATOR = (fd1, fd2) -> new Date(fd2.getLastTimeUsed()).compareTo(new Date(fd1.getLastTimeUsed()));
    private static final ColumnInfo<FeatureDescriptor, String> DISPLAY_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.feature", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return featureDescriptor.getDisplayName();
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return DISPLAY_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> GROUP_NAME = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.group", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            return ShowFeatureUsageStatisticsDialog.getGroupName(featureDescriptor);
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return GROUP_NAME_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> USED_TOTAL = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.usage.count", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            int count = featureDescriptor.getUsageCount();
            return FeatureStatisticsBundle.message((String)"feature.statistics.usage.count", (Object[])new Object[]{count});
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return USAGE_COUNT_COMPARATOR;
        }
    };
    private static final ColumnInfo<FeatureDescriptor, String> LAST_USED = new ColumnInfo<FeatureDescriptor, String>(FeatureStatisticsBundle.message((String)"feature.statistics.column.last.used", (Object[])new Object[0])){

        public String valueOf(FeatureDescriptor featureDescriptor) {
            long tm = featureDescriptor.getLastTimeUsed();
            if (tm <= 0L) {
                return FeatureStatisticsBundle.message((String)"feature.statistics.not.applicable", (Object[])new Object[0]);
            }
            return DateFormatUtil.formatBetweenDates((long)tm, (long)System.currentTimeMillis());
        }

        public Comparator<FeatureDescriptor> getComparator() {
            return LAST_USED_COMPARATOR;
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{DISPLAY_NAME, GROUP_NAME, USED_TOTAL, LAST_USED};

    public ShowFeatureUsageStatisticsDialog(Project project) {
        super(project, true);
        this.setTitle(FeatureStatisticsBundle.message((String)"feature.statistics.dialog.title", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.setModal(false);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.featureStatistics.actions.ShowFeatureUsageStatisticsDialog";
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            ShowFeatureUsageStatisticsDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected String getHelpId() {
        return "editing.productivityGuide";
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(true);
        splitter.setShowDividerControls(true);
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        ArrayList<FeatureDescriptor> features = new ArrayList<FeatureDescriptor>();
        for (String id2 : registry.getFeatureIds()) {
            features.add(registry.getFeatureDescriptor(id2));
        }
        final TableView table = new TableView(new ListTableModel(COLUMNS, features, 0));
        new TableViewSpeedSearch<FeatureDescriptor>(table){

            @Override
            protected String getItemText(@NotNull FeatureDescriptor element2) {
                if (element2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return element2.getDisplayName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/featureStatistics/actions/ShowFeatureUsageStatisticsDialog$5", "getItemText"));
            }
        };
        JPanel controlsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        Application app = ApplicationManager.getApplication();
        long uptime = System.currentTimeMillis() - app.getStartTime();
        long idleTime = app.getIdleTime();
        String uptimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.uptime", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), StringUtil.formatDurationApproximate((long)uptime)});
        String idleTimeS = FeatureStatisticsBundle.message((String)"feature.statistics.application.idle.time", (Object[])new Object[]{StringUtil.formatDurationApproximate((long)idleTime)});
        String labelText = uptimeS + ", " + idleTimeS;
        CompletionStatistics stats = ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getCompletionStatistics();
        if (stats.dayCount > 0 && stats.sparedCharacters > 0) {
            String total = ShowFeatureUsageStatisticsDialog.formatCharacterCount(stats.sparedCharacters, true);
            String perDay = ShowFeatureUsageStatisticsDialog.formatCharacterCount(stats.sparedCharacters / stats.dayCount, false);
            labelText = labelText + "<br>Code completion has saved you from typing at least " + total + " since " + DateFormatUtil.formatDate((long)stats.startDate) + " (~" + perDay + " per working day)";
        }
        CumulativeStatistics fstats = ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats();
        if (fstats.dayCount > 0 && fstats.invocations > 0) {
            labelText = labelText + "<br>Quick fixes have saved you from " + fstats.invocations + " possible bugs since " + DateFormatUtil.formatDate((long)fstats.startDate) + " (~" + fstats.invocations / fstats.dayCount + " per working day)";
        }
        controlsPanel.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)labelText)), "North");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)controlsPanel, "North");
        topPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)table), "Center");
        splitter.setFirstComponent((JComponent)topPanel);
        final TipUIUtil.Browser browser = TipUIUtil.createBrowser();
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)browser.getComponent()));
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Collection selection = table.getSelection();
                if (selection.isEmpty()) {
                    browser.setText("");
                } else {
                    TipUIUtil.openTipInBrowser(TipUIUtil.getTip((FeatureDescriptor)selection.iterator().next()), browser);
                }
            }
        });
        return splitter;
    }

    private static String formatCharacterCount(int count, boolean full) {
        String result2;
        DecimalFormat oneDigit = new DecimalFormat("0.0");
        String string = count > 0x100000 ? oneDigit.format((double)count / 1024.0 / 1024.0) + "M" : (result2 = count > 1024 ? oneDigit.format((double)count / 1024.0) + "K" : String.valueOf(count));
        if (full) {
            return result2 + " characters";
        }
        return result2;
    }

    private static String getGroupName(@NotNull FeatureDescriptor featureDescriptor) {
        ProductivityFeaturesRegistry registry;
        GroupDescriptor groupDescriptor;
        if (featureDescriptor == null) {
            ShowFeatureUsageStatisticsDialog.$$$reportNull$$$0(1);
        }
        return (groupDescriptor = (registry = ProductivityFeaturesRegistry.getInstance()).getGroupDescriptor(featureDescriptor.getGroupId())) != null ? groupDescriptor.getDisplayName() : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/actions/ShowFeatureUsageStatisticsDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/actions/ShowFeatureUsageStatisticsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

