/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsDialog;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class ExportTestResultsAction
extends DumbAwareAction {
    private static final String ID = "ExportTestResults";
    private static final Logger LOG = Logger.getInstance((String)ExportTestResultsAction.class.getName());
    private TestFrameworkRunningModel myModel;
    private String myToolWindowId;
    private RunConfiguration myRunConfiguration;

    public static ExportTestResultsAction create(String toolWindowId, RunConfiguration runtimeConfiguration, JComponent component2) {
        ExportTestResultsAction action2 = new ExportTestResultsAction();
        ActionUtil.copyFrom((AnAction)action2, (String)ID);
        action2.myToolWindowId = toolWindowId;
        action2.myRunConfiguration = runtimeConfiguration;
        action2.registerCustomShortcutSet(action2.getShortcutSet(), component2);
        return action2;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportTestResultsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(this.isEnabled(e.getDataContext()));
    }

    private boolean isEnabled(DataContext dataContext) {
        if (this.myModel == null) {
            return false;
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
            return false;
        }
        return !this.myModel.getRoot().isInProgress();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExportTestResultsAction.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        final ExportTestResultsConfiguration config2 = ExportTestResultsConfiguration.getInstance(project);
        String name = ExecutionBundle.message((String)"export.test.results.filename", (Object[])new Object[]{PathUtil.suggestFileName((String)this.myRunConfiguration.getName())});
        String filename = name + "." + config2.getExportFormat().getDefaultExtension();
        boolean showDialog = true;
        while (showDialog) {
            ExportTestResultsDialog d = new ExportTestResultsDialog(project, config2, filename);
            if (!d.showAndGet()) {
                return;
            }
            filename = d.getFileName();
            showDialog = ExportTestResultsAction.getOutputFile(config2, project, filename).exists() && Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"export.test.results.file.exists.message", (Object[])new Object[]{filename}), (String)ExecutionBundle.message((String)"export.test.results.file.exists.title", (Object[])new Object[0]), (String)"Overwrite", (String)"Cancel", (Icon)Messages.getQuestionIcon()) != 0;
        }
        final String filename_ = filename;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, ExecutionBundle.message((String)"export.test.results.task.name", (Object[])new Object[0]), false, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return true;
            }
        }){

            public void run(@NotNull ProgressIndicator indicator) {
                String outputText;
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                final File outputFile = ExportTestResultsAction.getOutputFile(config2, project, filename_);
                try {
                    outputText = ExportTestResultsAction.this.getOutputText(config2);
                    if (outputText == null) {
                        return;
                    }
                }
                catch (IOException | TransformerException | SAXException ex) {
                    LOG.warn((Throwable)ex);
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.failed", (Object[])new Object[]{ex.getMessage()}), null);
                    return;
                }
                catch (RuntimeException ex) {
                    String xml = null;
                    try {
                        ExportTestResultsConfiguration c = new ExportTestResultsConfiguration();
                        c.setExportFormat(ExportTestResultsConfiguration.ExportFormat.Xml);
                        c.setOpenResults(false);
                        xml = ExportTestResultsAction.this.getOutputText(c);
                    }
                    catch (Throwable c) {
                        // empty catch block
                    }
                    if (xml != null) {
                        LOG.error("Failed to export test results", (Throwable)ex, new Attachment[]{new Attachment("dump.xml", xml)});
                    } else {
                        LOG.error("Failed to export test results", (Throwable)ex);
                    }
                    return;
                }
                final Ref result2 = new Ref();
                final Ref error = new Ref();
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result2.set(ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

                            public VirtualFile compute() {
                                outputFile.getParentFile().mkdirs();
                                VirtualFile parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outputFile.getParentFile());
                                if (parent == null || !parent.isValid()) {
                                    error.set((Object)ExecutionBundle.message((String)"failed.to.create.output.file", (Object[])new Object[]{outputFile.getPath()}));
                                    return null;
                                }
                                try {
                                    VirtualFile result2 = parent.findChild(outputFile.getName());
                                    if (result2 == null) {
                                        result2 = parent.createChildData((Object)this, outputFile.getName());
                                    }
                                    VfsUtil.saveText((VirtualFile)result2, (String)outputText);
                                    return result2;
                                }
                                catch (IOException e) {
                                    LOG.warn((Throwable)e);
                                    error.set((Object)e.getMessage());
                                    return null;
                                }
                            }
                        }));
                    }
                });
                if (!result2.isNull()) {
                    if (config2.isOpenResults()) {
                        ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result2.get(), project, config2.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                    } else {
                        HyperlinkListener listener2 = new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                    ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result2.get(), project, config2.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                                }
                            }
                        };
                        ExportTestResultsAction.this.showBalloon(project, MessageType.INFO, ExecutionBundle.message((String)"export.test.results.succeeded", (Object[])new Object[]{outputFile.getName()}), listener2);
                    }
                } else {
                    ExportTestResultsAction.this.showBalloon(project, MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.failed", (Object[])new Object[]{error.get()}), null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/export/ExportTestResultsAction$2", "run"));
            }
        });
    }

    @NotNull
    private static File getOutputFile(@NotNull ExportTestResultsConfiguration config2, @NotNull Project project, @NotNull String filename) {
        String outputFolderPath;
        if (config2 == null) {
            ExportTestResultsAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ExportTestResultsAction.$$$reportNull$$$0(3);
        }
        if (filename == null) {
            ExportTestResultsAction.$$$reportNull$$$0(4);
        }
        File outputFolder = !StringUtil.isEmptyOrSpaces((String)(outputFolderPath = config2.getOutputFolder())) ? (FileUtil.isAbsolute((String)outputFolderPath) ? new File(outputFolderPath) : new File(new File(project.getBasePath()), config2.getOutputFolder())) : new File(project.getBasePath());
        return new File(outputFolder, filename);
    }

    private static void openEditorOrBrowser(VirtualFile result2, Project project, boolean editor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor) {
                FileEditorManager.getInstance((Project)project).openFile(result2, true);
            } else {
                BrowserUtil.browse((VirtualFile)result2);
            }
        });
    }

    @Nullable
    private String getOutputText(ExportTestResultsConfiguration config2) throws IOException, TransformerException, SAXException {
        TransformerHandler handler2;
        ExportTestResultsConfiguration.ExportFormat exportFormat = config2.getExportFormat();
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        if (exportFormat == ExportTestResultsConfiguration.ExportFormat.Xml) {
            handler2 = transformerFactory.newTransformerHandler();
            handler2.getTransformer().setOutputProperty("indent", "yes");
            handler2.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        } else {
            StreamSource xslSource;
            if (config2.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.BundledTemplate) {
                URL bundledXsltUrl = ((Object)((Object)this)).getClass().getResource("intellij-export.xsl");
                xslSource = new StreamSource(URLUtil.openStream((URL)bundledXsltUrl));
            } else {
                File xslFile = new File(config2.getUserTemplatePath());
                if (!xslFile.isFile()) {
                    this.showBalloon(this.myRunConfiguration.getProject(), MessageType.ERROR, ExecutionBundle.message((String)"export.test.results.custom.template.not.found", (Object[])new Object[]{xslFile.getPath()}), null);
                    return null;
                }
                xslSource = new StreamSource(xslFile);
            }
            handler2 = transformerFactory.newTransformerHandler(xslSource);
            handler2.getTransformer().setParameter("TITLE", ExecutionBundle.message((String)"export.test.results.filename", (Object[])new Object[]{this.myRunConfiguration.getName(), this.myRunConfiguration.getType().getDisplayName()}));
        }
        StringWriter w = new StringWriter();
        handler2.setResult(new StreamResult(w));
        try {
            TestResultsXmlFormatter.execute(this.myModel.getRoot(), this.myRunConfiguration, this.myModel.getProperties(), handler2);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        return w.toString();
    }

    private void showBalloon(Project project, MessageType type, String text2, @Nullable HyperlinkListener listener2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            if (ToolWindowManager.getInstance((Project)project).getToolWindow(this.myToolWindowId) != null) {
                ToolWindowManager.getInstance((Project)project).notifyByBalloon(this.myToolWindowId, type, text2, null, listener2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/export/ExportTestResultsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOutputFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

