/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProcessStreamsSynchronizer {
    static final long AWAIT_SAME_STREAM_TEXT_NANO = TimeUnit.MILLISECONDS.toNanos(10L);
    private final Object myLock;
    private final List<Chunk> myPendingChunks;
    private final Alarm myAlarm;
    private final boolean isUnitTestMode;
    private boolean myFlushedChunksEndWithNewline;
    private ProcessOutputType myLastFlushedChunkBaseOutputType;
    private long myLastFlushedChunkCreatedNanoTime;
    private int myReschedules;

    ProcessStreamsSynchronizer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ProcessStreamsSynchronizer.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myPendingChunks = new ArrayList<Chunk>();
        this.isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myFlushedChunksEndWithNewline = true;
        this.myLastFlushedChunkBaseOutputType = null;
        this.myLastFlushedChunkCreatedNanoTime = 0L;
        this.myReschedules = 0;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = ProcessStreamsSynchronizer.this.myLock;
                synchronized (object) {
                    ProcessStreamsSynchronizer.this.flushAllPendingChunks();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doWhenStreamsSynchronized(@NotNull String text2, @NotNull ProcessOutputType outputType, @NotNull Runnable flushRunnable) {
        if (text2 == null) {
            ProcessStreamsSynchronizer.$$$reportNull$$$0(1);
        }
        if (outputType == null) {
            ProcessStreamsSynchronizer.$$$reportNull$$$0(2);
        }
        if (flushRunnable == null) {
            ProcessStreamsSynchronizer.$$$reportNull$$$0(3);
        }
        long nowNano = this.getNanoTime();
        Object object = this.myLock;
        synchronized (object) {
            Boolean textEndsWithNewline;
            ProcessOutputType baseOutputType = outputType.getBaseOutputType();
            if (ProcessOutputType.SYSTEM.equals((Object)baseOutputType)) {
                this.handleSystemOutput(flushRunnable, nowNano);
                return;
            }
            Boolean bl = textEndsWithNewline = text2.isEmpty() ? null : Boolean.valueOf(StringUtil.endsWithChar((CharSequence)text2, (char)'\n'));
            if (this.myLastFlushedChunkBaseOutputType == null || baseOutputType.equals((Object)this.myLastFlushedChunkBaseOutputType)) {
                boolean newlineAdded;
                boolean bl2 = newlineAdded = !this.myFlushedChunksEndWithNewline && Boolean.TRUE.equals(textEndsWithNewline);
                if (textEndsWithNewline != null) {
                    this.myFlushedChunksEndWithNewline = textEndsWithNewline;
                }
                this.myLastFlushedChunkBaseOutputType = baseOutputType;
                this.myLastFlushedChunkCreatedNanoTime = nowNano;
                flushRunnable.run();
                if (newlineAdded && this.myPendingChunks.size() > 0 && this.myPendingChunks.get(0).getNanoTimePassedSinceLastFlushedChunk(nowNano) >= AWAIT_SAME_STREAM_TEXT_NANO) {
                    this.processPendingChunks(nowNano);
                }
                return;
            }
            Chunk chunk = new Chunk(textEndsWithNewline, baseOutputType, nowNano, this.myLastFlushedChunkCreatedNanoTime, flushRunnable);
            this.myPendingChunks.add(chunk);
            if (!this.isProcessingScheduled()) {
                long delayNano = AWAIT_SAME_STREAM_TEXT_NANO - chunk.getNanoTimePassedSinceLastFlushedChunk(nowNano);
                if (delayNano <= 0L) {
                    this.processPendingChunks(nowNano);
                } else {
                    ++this.myReschedules;
                    this.scheduleProcessPendingChunks(delayNano);
                }
            }
        }
    }

    boolean isProcessingScheduled() {
        return !this.myAlarm.isEmpty();
    }

    long getNanoTime() {
        return System.nanoTime();
    }

    void scheduleProcessPendingChunks(long delayNano) {
        this.myAlarm.addRequest(() -> this.processPendingChunks(this.getNanoTime()), TimeUnit.NANOSECONDS.toMillis(delayNano));
    }

    private void handleSystemOutput(@NotNull Runnable flushRunnable, long nowNano) {
        if (flushRunnable == null) {
            ProcessStreamsSynchronizer.$$$reportNull$$$0(4);
        }
        if (this.myPendingChunks.isEmpty()) {
            flushRunnable.run();
            return;
        }
        Chunk first = this.myPendingChunks.get(0);
        this.myPendingChunks.add(new Chunk(null, first.myBaseOutputType, nowNano, this.myLastFlushedChunkCreatedNanoTime, flushRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processPendingChunks(long nowNano) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myPendingChunks.isEmpty()) {
                this.myReschedules = 0;
                return;
            }
            Chunk eldestChunk = this.myPendingChunks.get(0);
            long awaitNano = eldestChunk.getNanoTimePassedSinceLastFlushedChunk(nowNano);
            if (awaitNano >= AWAIT_SAME_STREAM_TEXT_NANO && this.myFlushedChunksEndWithNewline || this.myReschedules > (this.isUnitTestMode ? 10 : 1)) {
                this.flushAllPendingChunks();
            }
            if (!this.myPendingChunks.isEmpty()) {
                ++this.myReschedules;
                this.scheduleProcessPendingChunks(AWAIT_SAME_STREAM_TEXT_NANO);
            } else {
                this.myReschedules = 0;
            }
        }
    }

    private void flushAllPendingChunks() {
        for (Chunk chunk : this.myPendingChunks) {
            this.flush(chunk);
        }
        this.myPendingChunks.clear();
    }

    private void flush(@NotNull Chunk chunk) {
        if (chunk == null) {
            ProcessStreamsSynchronizer.$$$reportNull$$$0(5);
        }
        if (chunk.myTextEndsWithNewline != null) {
            this.myFlushedChunksEndWithNewline = chunk.myTextEndsWithNewline;
        }
        this.myLastFlushedChunkBaseOutputType = chunk.myBaseOutputType;
        this.myLastFlushedChunkCreatedNanoTime = chunk.myCreatedNanoTime;
        chunk.myFlushRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForAllFlushed() {
        while (true) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myPendingChunks.isEmpty()) {
                    return;
                }
                if (this.myAlarm.isEmpty()) {
                    throw new RuntimeException("No requests scheduled");
                }
            }
            try {
                this.myAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushRunnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/impl/ProcessStreamsSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhenStreamsSynchronized";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSystemOutput";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "flush";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Chunk {
        @Nullable
        private final Boolean myTextEndsWithNewline;
        private final ProcessOutputType myBaseOutputType;
        private final long myCreatedNanoTime;
        private final long myPrevFlushedChunkCreatedNanoTime;
        private final Runnable myFlushRunnable;

        /*
         * WARNING - void declaration
         */
        private Chunk(@Nullable Boolean textEndsWithNewline, @NotNull ProcessOutputType baseOutputType, long createdNanoTime, long prevFlushedChunkCreatedNanoTime, @NotNull Runnable runnable2) {
            void flushRunnable;
            if (baseOutputType == null) {
                Chunk.$$$reportNull$$$0(0);
            }
            if (runnable2 == null) {
                Chunk.$$$reportNull$$$0(1);
            }
            this.myTextEndsWithNewline = textEndsWithNewline;
            this.myBaseOutputType = baseOutputType;
            this.myCreatedNanoTime = createdNanoTime;
            this.myPrevFlushedChunkCreatedNanoTime = prevFlushedChunkCreatedNanoTime;
            this.myFlushRunnable = flushRunnable;
        }

        long getNanoTimePassedSinceLastFlushedChunk(long nowNanoTime) {
            return this.myPrevFlushedChunkCreatedNanoTime > 0L ? nowNanoTime - this.myPrevFlushedChunkCreatedNanoTime : nowNanoTime - this.myCreatedNanoTime;
        }

        public String toString() {
            return "ends-with-newline='" + this.myTextEndsWithNewline + '\'' + ", outputType=" + this.myBaseOutputType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseOutputType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "flushRunnable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/impl/ProcessStreamsSynchronizer$Chunk";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

