/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ThreeState;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunConfigurationAction
extends ActionGroup {
    protected static final Logger LOG = Logger.getInstance(BaseRunConfigurationAction.class);
    @Nullable
    private static Integer ourLastTimeoutStamp = null;

    protected BaseRunConfigurationAction(@NotNull Supplier<String> text2, @NotNull Supplier<String> description, Icon icon2) {
        if (text2 == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(1);
        }
        super(text2, description, icon2);
        this.setPopup(true);
        this.setEnabledInModalContext(true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = e != null ? this.getChildren(e.getDataContext()) : EMPTY_ARRAY;
        if (anActionArray == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private AnAction[] getChildren(DataContext dataContext) {
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        if (!Registry.is((String)"suggest.all.run.configurations.from.context") && context.findExisting() != null) {
            return EMPTY_ARRAY;
        }
        return this.createChildActions(context, this.getConfigurationsFromContext(context)).toArray(EMPTY_ARRAY);
    }

    @NotNull
    protected List<AnAction> createChildActions(final @NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (context == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(3);
        }
        if (configurations == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(4);
        }
        if (configurations.size() <= 1) {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>();
        for (final ConfigurationFromContext configurationFromContext : configurations) {
            ConfigurationType configurationType = configurationFromContext.getConfigurationType();
            String actionName = BaseRunConfigurationAction.childActionName(configurationFromContext);
            AnAction anAction = new AnAction(actionName, configurationType.getDisplayName(), configurationFromContext.getConfiguration().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BaseRunConfigurationAction.this.perform(configurationFromContext, context);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/BaseRunConfigurationAction$1", "actionPerformed"));
                }
            };
            anAction.getTemplatePresentation().setText(actionName, false);
            childActions.add(anAction);
        }
        ArrayList<AnAction> arrayList = childActions;
        if (arrayList == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private List<ConfigurationFromContext> getConfigurationsFromContext(ConfigurationContext context) {
        List fromContext = context.getConfigurationsFromContext();
        if (fromContext == null) {
            List<ConfigurationFromContext> list2 = Collections.emptyList();
            if (list2 == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(7);
            }
            return list2;
        }
        ArrayList<ConfigurationFromContext> enabledConfigurations = new ArrayList<ConfigurationFromContext>();
        for (ConfigurationFromContext configurationFromContext : fromContext) {
            if (!this.isEnabledFor(configurationFromContext.getConfiguration())) continue;
            enabledConfigurations.add(configurationFromContext);
        }
        ArrayList<ConfigurationFromContext> arrayList = enabledConfigurations;
        if (arrayList == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    protected boolean isEnabledFor(RunConfiguration configuration) {
        return true;
    }

    public boolean canBePerformed(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(9);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null && DumbService.isDumb((Project)project)) {
            return false;
        }
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            return fromContext.size() <= 1;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(10);
        }
        DataContext dataContext = e.getDataContext();
        MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> producers = this.getConfigurationsFromContext(context);
            if (producers.isEmpty()) {
                return;
            }
            if (producers.size() > 1) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                Collections.sort(producers, ConfigurationFromContext.NAME_COMPARATOR);
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationFromContext>(ExecutionBundle.message((String)"configuration.action.chooser.title", (Object[])new Object[0]), producers){

                    @NotNull
                    public String getTextFor(ConfigurationFromContext producer) {
                        String string = BaseRunConfigurationAction.childActionName(producer);
                        if (string == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public Icon getIconFor(ConfigurationFromContext producer) {
                        return producer.getConfigurationType().getIcon();
                    }

                    public PopupStep<?> onChosen(ConfigurationFromContext producer, boolean finalChoice) {
                        BaseRunConfigurationAction.this.perform(producer, context);
                        return FINAL_CHOICE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/BaseRunConfigurationAction$2", "getTextFor"));
                    }
                });
                InputEvent event = e.getInputEvent();
                if (event instanceof MouseEvent) {
                    popup2.show(new RelativePoint((MouseEvent)event));
                } else if (editor != null) {
                    popup2.showInBestPositionFor(editor);
                } else {
                    popup2.showInBestPositionFor(dataContext);
                }
            } else {
                this.perform(producers.get(0), context);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            String configurationClass = existing.getConfiguration().getClass().getName();
            LOG.debug(String.format("Use existing run configuration: %s", configurationClass));
        }
        this.perform(context);
    }

    private void perform(ConfigurationFromContext configurationFromContext, ConfigurationContext context) {
        RunnerAndConfigurationSettings configurationSettings = configurationFromContext.getConfigurationSettings();
        context.setConfiguration(configurationSettings);
        configurationFromContext.onFirstRun(context, () -> {
            if (LOG.isDebugEnabled()) {
                RunnerAndConfigurationSettings settings = context.getConfiguration();
                RunConfiguration configuration = settings == null ? null : settings.getConfiguration();
                String configurationClass = configuration == null ? null : configuration.getClass().getName();
                LOG.debug(String.format("Create run configuration: %s", configurationClass));
            }
            this.perform(context);
        });
    }

    protected abstract void perform(ConfigurationContext var1);

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(11);
        }
        this.fullUpdate(e);
    }

    public void update(@NotNull AnActionEvent event) {
        boolean success;
        VirtualFile vFile;
        ThreeState hadAnythingRunnable;
        if (event == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(12);
        }
        ThreeState threeState = hadAnythingRunnable = (vFile = (VirtualFile)event.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE)) == null ? ThreeState.UNSURE : RunLineMarkerProvider.hadAnythingRunnable(vFile);
        if (hadAnythingRunnable == ThreeState.UNSURE) {
            this.fullUpdate(event);
            return;
        }
        boolean bl = success = !BaseRunConfigurationAction.alreadyExceededTimeoutOnSimilarAction() && ProgressIndicatorUtils.withTimeout(Registry.intValue((String)"run.configuration.update.timeout"), () -> {
            this.fullUpdate(event);
            return true;
        }) != null;
        if (!success) {
            BaseRunConfigurationAction.recordUpdateTimeout();
            this.approximatePresentationByPreviousAvailability(event, hadAnythingRunnable);
        }
    }

    private static boolean alreadyExceededTimeoutOnSimilarAction() {
        return Objects.equals(IdeEventQueue.getInstance().getEventCount(), ourLastTimeoutStamp);
    }

    private static void recordUpdateTimeout() {
        ourLastTimeoutStamp = IdeEventQueue.getInstance().getEventCount();
    }

    protected void approximatePresentationByPreviousAvailability(AnActionEvent event, ThreeState hadAnythingRunnable) {
        event.getPresentation().copyFrom(this.getTemplatePresentation());
        event.getPresentation().setEnabledAndVisible(hadAnythingRunnable == ThreeState.YES);
    }

    protected void fullUpdate(@NotNull AnActionEvent event) {
        if (event == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(13);
        }
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)event.getDataContext());
        Presentation presentation = event.getPresentation();
        RunnerAndConfigurationSettings existing = context.findExisting();
        RunnerAndConfigurationSettings configuration = existing;
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        if (configuration == null) {
            presentation.setEnabledAndVisible(false);
        } else {
            presentation.setEnabledAndVisible(true);
            VirtualFile vFile = (VirtualFile)event.getDataContext().getData(CommonDataKeys.VIRTUAL_FILE);
            if (vFile != null) {
                RunLineMarkerProvider.markRunnable(vFile, true);
            }
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            if (existing == null && !fromContext.isEmpty()) {
                context.setConfiguration(fromContext.get(0).getConfigurationSettings());
            }
            String name = BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration.getConfiguration());
            this.updatePresentation(presentation, existing != null || fromContext.size() <= 1 ? name : "", context);
        }
    }

    public boolean isDumbAware() {
        return false;
    }

    @NotNull
    public static String suggestRunActionName(@NotNull LocatableConfiguration configuration) {
        String actionName;
        if (configuration == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(14);
        }
        if (configuration instanceof LocatableConfigurationBase && configuration.isGeneratedName() && (actionName = ((LocatableConfigurationBase)configuration).getActionName()) != null) {
            String string = actionName;
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = ProgramRunnerUtil.shortenName(configuration.getName(), 0);
        if (string == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String childActionName(ConfigurationFromContext configurationFromContext) {
        String locationDisplayName;
        RunConfiguration configuration = configurationFromContext.getConfiguration();
        if (!(configuration instanceof LocatableConfiguration)) {
            String string = configurationFromContext.getConfigurationType().getDisplayName();
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (configurationFromContext.isFromAlternativeLocation() && (locationDisplayName = configurationFromContext.getAlternativeLocationDisplayName()) != null) {
            String string = ((LocatableConfigurationBase)configuration).getActionName() + " " + locationDisplayName;
            if (string == null) {
                BaseRunConfigurationAction.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = StringUtil.unquoteString((String)BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configurationFromContext.getConfiguration()));
        if (string == null) {
            BaseRunConfigurationAction.$$$reportNull$$$0(19);
        }
        return string;
    }

    protected abstract void updatePresentation(Presentation var1, @NotNull String var2, ConfigurationContext var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/BaseRunConfigurationAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/BaseRunConfigurationAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsFromContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestRunActionName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "childActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChildActions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canBePerformed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fullUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "suggestRunActionName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

