/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDrawUtil {
    private static final Logger LOG = Logger.getInstance(DiffDrawUtil.class);
    public static final int STRIPE_LAYER = 4999;
    public static final int DEFAULT_LAYER = 5898;
    public static final int INLINE_LAYER = 5899;
    public static final int LINE_MARKER_LAYER = 5900;
    public static final int LST_LINE_MARKER_LAYER = 5999;
    private static final double CTRL_PROXIMITY_X = 0.3;
    public static final LineSeparatorRenderer BORDER_LINE_RENDERER = new LineSeparatorRenderer(){

        public void drawLine(Graphics g, int x1, int x2, int y) {
            Rectangle clip = g.getClipBounds();
            x2 = clip.x + clip.width;
            g.setColor(JBColor.border());
            g.drawLine(x1, y, x2, y);
        }
    };

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        return DiffDrawUtil.getDividerColor(null);
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        return DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme) {
        Color gutterBackground;
        if (scheme == null) {
            DiffDrawUtil.$$$reportNull$$$0(0);
        }
        if ((gutterBackground = scheme.getColor(EditorColors.GUTTER_BACKGROUND)) == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        Color color = gutterBackground;
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(1);
        }
        return color;
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(2);
        }
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(3);
        }
        if (dottedLine && doubleLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
        } else if (dottedLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
        } else if (doubleLine) {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)(y + 1), (int)x2, (int)(y + 1), null, (Color)color);
        } else {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(4);
        }
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawLine(x1, start1, x2, start2);
            g.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(5);
        }
        if (fillColor != null) {
            g.setColor(fillColor);
            g.fill(DiffDrawUtil.makeCurvePath(x1, x2, start1, start2, end1 + 1, end2 + 1));
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUIScale.scale((float)1.0f)));
            g.draw(DiffDrawUtil.makeCurve(x1, x2, (start1 + end1) / 2, (start2 + end2) / 2, true));
            g.setStroke(oldStroke);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            DiffDrawUtil.drawCurveLine(g, x1, x2, start1, start2);
            DiffDrawUtil.drawCurveLine(g, x1, x2, end1, end2);
        }
    }

    private static void drawCurveLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2) {
        boolean isHighSlope;
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(6);
        }
        boolean bl = isHighSlope = Math.abs(x2 - x1) < Math.abs(y2 - y1);
        if (!isHighSlope && DiffDrawUtil.isThickSimpleStroke(g)) {
            g.fill(DiffDrawUtil.makeCurvePath(x1, x2, y1, y2, y1 + 1, y2 + 1));
        } else {
            g.draw(DiffDrawUtil.makeCurve(x1, x2, y1, y2, true));
        }
    }

    private static boolean isThickSimpleStroke(@NotNull Graphics2D g) {
        Stroke stroke;
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(7);
        }
        if ((stroke = g.getStroke()) instanceof BasicStroke) {
            float strokeWidth = ((BasicStroke)stroke).getLineWidth();
            return (double)strokeWidth == 1.0 && PaintUtil.devValue((double)strokeWidth, (Graphics2D)g) > 1.0;
        }
        return false;
    }

    @NotNull
    private static Path2D makeCurvePath(int x1, int x2, int y11, int y12, int y21, int y22) {
        Path2D.Double path = new Path2D.Double();
        path.append(DiffDrawUtil.makeCurve(x1, x2, y11, y12, true), true);
        path.append(DiffDrawUtil.makeCurve(x1, x2, y21, y22, false), true);
        path.closePath();
        Path2D.Double double_ = path;
        if (double_ == null) {
            DiffDrawUtil.$$$reportNull$$$0(8);
        }
        return double_;
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    public static int lineToY(@NotNull Editor editor, int line) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(9);
        }
        return DiffDrawUtil.lineToY(editor, line, true, false);
    }

    public static int lineToY(@NotNull Editor editor, int line, boolean lineStart) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(10);
        }
        return DiffDrawUtil.lineToY(editor, line, lineStart, false);
    }

    public static int lineToY(@NotNull Editor editor, int line, boolean lineStart, boolean includeInlays) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(11);
        }
        if (line < 0) {
            return 0;
        }
        Document document = editor.getDocument();
        if (line >= DiffUtil.getLineCount(document)) {
            int y = editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getTextLength())).y;
            int tailLines = line - DiffUtil.getLineCount(document) + (lineStart ? 0 : 1);
            return y + editor.getLineHeight() * tailLines;
        }
        if (lineStart) {
            int visualLine = editor.offsetToVisualPosition((int)document.getLineStartOffset((int)line), (boolean)false, (boolean)false).line;
            int inlay = includeInlays ? EditorUtil.getInlaysHeight(editor, visualLine, true) : 0;
            return editor.visualLineToY(visualLine) - inlay;
        }
        int visualLine = editor.offsetToVisualPosition((int)document.getLineEndOffset((int)line), (boolean)true, (boolean)true).line;
        int inlay = includeInlays ? EditorUtil.getInlaysHeight(editor, visualLine, false) : 0;
        return editor.visualLineToY(visualLine) + editor.getLineHeight() + inlay;
    }

    public static int yToLine(@NotNull Editor editor, int y) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(12);
        }
        return editor.xyToLogicalPosition((Point)new Point((int)0, (int)y)).line;
    }

    @NotNull
    public static MarkerRange getGutterMarkerPaintRange(@NotNull Editor editor, int startLine, int endLine) {
        int y2;
        int y1;
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(13);
        }
        if (startLine == endLine) {
            y1 = startLine == 0 ? DiffDrawUtil.lineToY(editor, 0, true, true) + 1 : DiffDrawUtil.lineToY(editor, startLine - 1, false, true);
            y2 = y1;
        } else {
            y1 = DiffDrawUtil.lineToY(editor, startLine, true, false);
            y2 = DiffDrawUtil.lineToY(editor, endLine - 1, false, false);
        }
        return new MarkerRange(y1, y2);
    }

    @Nullable
    private static TextAttributes getTextAttributes(final @NotNull TextDiffType type, final @Nullable Editor editor, final @NotNull BackgroundType background) {
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(14);
        }
        if (background == null) {
            DiffDrawUtil.$$$reportNull$$$0(15);
        }
        if (background == BackgroundType.NONE) {
            return null;
        }
        return new TextAttributes(){

            public Color getBackgroundColor() {
                return background == BackgroundType.IGNORED ? type.getIgnoredColor(editor) : type.getColor(editor);
            }
        };
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(final @NotNull TextDiffType type, final @NotNull Editor editor) {
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(17);
        }
        return new TextAttributes(){

            public Color getErrorStripeColor() {
                return type.getMarkerColor(editor);
            }
        };
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type) {
        if (highlighter == null) {
            DiffDrawUtil.$$$reportNull$$$0(18);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(19);
        }
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type));
    }

    @NotNull
    private static LineSeparatorRenderer createDiffLineRenderer(final @NotNull Editor editor, final @Nullable RangeHighlighter parentHighlighter, final @NotNull TextDiffType type, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(20);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(21);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(22);
        }
        return new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                if (parentHighlighter != null && FoldingUtil.isHighlighterFolded(editor, parentHighlighter)) {
                    return;
                }
                Rectangle clip = g.getClipBounds();
                x2 = clip.x + clip.width;
                if (placement == SeparatorPlacement.TOP) {
                    ++y;
                }
                DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, x1, x2, y, type.getColor(editor), doubleLine, resolved);
            }
        };
    }

    @NotNull
    private static LineMarkerRenderer createFoldingGutterLineRenderer(final @NotNull TextDiffType type, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(23);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(24);
        }
        return new LineMarkerRendererEx(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
                Graphics2D g2 = (Graphics2D)g;
                int x1 = gutter.getWhitespaceSeparatorOffset();
                int x2 = gutter.getWidth();
                int y = r.y;
                if (placement == SeparatorPlacement.BOTTOM) {
                    LOG.warn("BOTTOM gutter line renderers are not supported");
                    y += editor.getLineHeight() - 1;
                }
                DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y, type.getColor(editor), doubleLine, resolved);
            }

            @Override
            @NotNull
            public LineMarkerRendererEx.Position getPosition() {
                LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
                if (position == null) {
                    5.$$$reportNull$$$0(0);
                }
                return position;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$5", "getPosition"));
            }
        };
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, @Nullable List<? extends DiffFragment> innerFragments) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(25);
        }
        if (deleted == null) {
            DiffDrawUtil.$$$reportNull$$$0(26);
        }
        if (inserted == null) {
            DiffDrawUtil.$$$reportNull$$$0(27);
        }
        return DiffDrawUtil.createUnifiedChunkHighlighters(editor, deleted, inserted, false, false, innerFragments);
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, boolean excluded, boolean skipped, @Nullable List<? extends DiffFragment> innerFragments) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(28);
        }
        if (deleted == null) {
            DiffDrawUtil.$$$reportNull$$$0(29);
        }
        if (inserted == null) {
            DiffDrawUtil.$$$reportNull$$$0(30);
        }
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list2 = new ArrayList<RangeHighlighter>();
        if (!inserted.isEmpty() && !deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (!inserted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (!deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
        }
        if (innerFragments != null && !skipped) {
            int deletedStartOffset = editor.getDocument().getLineStartOffset(deleted.start);
            int insertedStartOffset = editor.getDocument().getLineStartOffset(inserted.start);
            for (DiffFragment diffFragment : innerFragments) {
                int deletedWordStart = deletedStartOffset + diffFragment.getStartOffset1();
                int deletedWordEnd = deletedStartOffset + diffFragment.getEndOffset1();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, deletedWordStart, deletedWordEnd, TextDiffType.DELETED));
                int insertedWordStart = insertedStartOffset + diffFragment.getStartOffset2();
                int insertedWordEnd = insertedStartOffset + diffFragment.getEndOffset2();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, insertedWordStart, insertedWordEnd, TextDiffType.INSERTED));
            }
        }
        ArrayList<RangeHighlighter> arrayList = list2;
        if (arrayList == null) {
            DiffDrawUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    private static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean excludedInEditor, boolean excludedInGutter) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(32);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(33);
        }
        List<RangeHighlighter> list2 = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(excludedInEditor).withExcludedInGutter(excludedInGutter).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(34);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(35);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(36);
        }
        List<RangeHighlighter> list2 = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(37);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean resolved, boolean isExcluded, boolean hideWithoutLineNumbers, boolean hideStripeMarkers) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(38);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(39);
        }
        List<RangeHighlighter> list2 = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withExcluded(isExcluded).withHideWithoutLineNumbers(hideWithoutLineNumbers).withHideStripeMarkers(hideStripeMarkers).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(40);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start2, int end, @NotNull TextDiffType type) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(41);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(42);
        }
        List<RangeHighlighter> list2 = new InlineHighlighterBuilder(editor, start2, end, type).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(43);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(44);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(45);
        }
        if (line == 0) {
            List<RangeHighlighter> list2 = Collections.emptyList();
            if (list2 == null) {
                DiffDrawUtil.$$$reportNull$$$0(46);
            }
            return list2;
        }
        List<RangeHighlighter> list3 = new LineMarkerBuilder(editor, line, SeparatorPlacement.TOP).withDefaultRenderer(type, false, false, null).withDefaultGutterRenderer(type, false, false).withDefaultStripeAttributes(type).done();
        if (list3 == null) {
            DiffDrawUtil.$$$reportNull$$$0(47);
        }
        return list3;
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(48);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(49);
        }
        List<RangeHighlighter> list2 = new LineMarkerBuilder(editor, line, placement).withRenderer(BORDER_LINE_RENDERER).done();
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(50);
        }
        return list2;
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(51);
        }
        if (condition == null) {
            DiffDrawUtil.$$$reportNull$$$0(52);
        }
        return DiffDrawUtil.createLineSeparatorHighlighter(editor, offset1, offset2, condition, null);
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition, @Nullable Computable<String> description) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(53);
        }
        if (condition == null) {
            DiffDrawUtil.$$$reportNull$$$0(54);
        }
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5900, null, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, condition, description);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        List<RangeHighlighter> list2 = Collections.singletonList(marker);
        if (list2 == null) {
            DiffDrawUtil.$$$reportNull$$$0(55);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 50: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 50: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 8: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 48: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 22: 
            case 24: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placement";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inserted";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerColorFromScheme";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeCurvePath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnifiedChunkHighlighters";
                break;
            }
            case 34: 
            case 37: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineHighlighter";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarker";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createBorderLineMarker";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineSeparatorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDividerColorFromScheme";
                break;
            }
            case 1: 
            case 8: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 50: 
            case 55: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "drawChunkBorderLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawTrapezium";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "drawCurveTrapezium";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "drawCurveLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isThickSimpleStroke";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lineToY";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "yToLine";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGutterMarkerPaintRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStripeTextAttributes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installEmptyRangeRenderer";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createDiffLineRenderer";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingGutterLineRenderer";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createUnifiedChunkHighlighters";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createInlineHighlighter";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createBorderLineMarker";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createLineSeparatorHighlighter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 31: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 50: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MarkerRange {
        public final int y1;
        public final int y2;

        public MarkerRange(int y1, int y2) {
            this.y1 = y1;
            this.y2 = y2;
        }

        public int component1() {
            return this.y1;
        }

        public int component2() {
            return this.y2;
        }
    }

    static enum BorderType {
        NONE,
        LINE,
        DOTTED;

    }

    static enum BackgroundType {
        NONE,
        DEFAULT,
        IGNORED;

    }

    static class PaintMode {
        @NotNull
        public final BackgroundType background;
        @NotNull
        public final BorderType border;
        public static final PaintMode DEFAULT = new PaintMode(BackgroundType.DEFAULT, BorderType.NONE);
        public static final PaintMode IGNORED = new PaintMode(BackgroundType.IGNORED, BorderType.NONE);
        public static final PaintMode RESOLVED = new PaintMode(BackgroundType.NONE, BorderType.DOTTED);
        public static final PaintMode EXCLUDED_EDITOR = new PaintMode(BackgroundType.NONE, BorderType.LINE);
        public static final PaintMode EXCLUDED_GUTTER = new PaintMode(BackgroundType.IGNORED, BorderType.LINE);

        PaintMode(@NotNull BackgroundType background, @NotNull BorderType border) {
            if (background == null) {
                PaintMode.$$$reportNull$$$0(0);
            }
            if (border == null) {
                PaintMode.$$$reportNull$$$0(1);
            }
            this.background = background;
            this.border = border;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaintMode mode = (PaintMode)o;
            return this.background == mode.background && this.border == mode.border;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.background, this.border});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "border";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffDrawUtil$PaintMode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int offset;
        @NotNull
        private final RangeHighlighter highlighter;
        @Nullable
        private LineSeparatorRenderer lineRenderer;
        @Nullable
        private LineMarkerRenderer gutterRenderer;
        @Nullable
        private TextAttributes stripeAttributes;

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
            if (editor == null) {
                LineMarkerBuilder.$$$reportNull$$$0(0);
            }
            if (placement == null) {
                LineMarkerBuilder.$$$reportNull$$$0(1);
            }
            this.editor = editor;
            this.placement = placement;
            this.offset = DocumentUtil.getFirstNonSpaceCharOffset(editor.getDocument(), line);
            this.highlighter = editor.getMarkupModel().addRangeHighlighter(this.offset, this.offset, 5900, null, HighlighterTargetArea.LINES_IN_RANGE);
        }

        @NotNull
        public LineMarkerBuilder withRenderer(@Nullable LineSeparatorRenderer lineRenderer) {
            this.lineRenderer = lineRenderer;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(2);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withGutterRenderer(@Nullable LineMarkerRenderer gutterRenderer) {
            this.gutterRenderer = gutterRenderer;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(3);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withStripeAttributes(@Nullable TextAttributes stripeAttributes) {
            this.stripeAttributes = stripeAttributes;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(4);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine, @Nullable RangeHighlighter parentHighlighter) {
            if (type == null) {
                LineMarkerBuilder.$$$reportNull$$$0(5);
            }
            RangeHighlighter parent = (RangeHighlighter)ObjectUtils.chooseNotNull((Object)parentHighlighter, (Object)this.highlighter);
            LineSeparatorRenderer renderer = DiffDrawUtil.createDiffLineRenderer(this.editor, parent, type, this.placement, doubleLine, dottedLine);
            LineMarkerBuilder lineMarkerBuilder = this.withRenderer(renderer);
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(6);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultGutterRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine) {
            if (type == null) {
                LineMarkerBuilder.$$$reportNull$$$0(7);
            }
            LineMarkerRenderer renderer = DiffDrawUtil.createFoldingGutterLineRenderer(type, this.placement, doubleLine, dottedLine);
            LineMarkerBuilder lineMarkerBuilder = this.withGutterRenderer(renderer);
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(8);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultStripeAttributes(@NotNull TextDiffType type) {
            if (type == null) {
                LineMarkerBuilder.$$$reportNull$$$0(9);
            }
            TextAttributes attributes = DiffDrawUtil.getStripeTextAttributes(type, this.editor);
            LineMarkerBuilder lineMarkerBuilder = this.withStripeAttributes(attributes);
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(10);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            this.highlighter.setLineSeparatorPlacement(this.placement);
            this.highlighter.setLineSeparatorRenderer(this.lineRenderer);
            this.highlighter.setLineMarkerRenderer(this.gutterRenderer);
            if (this.stripeAttributes == null) {
                List<RangeHighlighter> list2 = Collections.singletonList(this.highlighter);
                if (list2 == null) {
                    LineMarkerBuilder.$$$reportNull$$$0(11);
                }
                return list2;
            }
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(this.offset, this.offset, 4999, this.stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            List<RangeHighlighter> list3 = Arrays.asList(this.highlighter, stripeHighlighter);
            if (list3 == null) {
                LineMarkerBuilder.$$$reportNull$$$0(12);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGutterRenderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withStripeAttributes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultRenderer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultGutterRenderer";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultStripeAttributes";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withDefaultRenderer";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withDefaultGutterRenderer";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withDefaultStripeAttributes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InlineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int start;
        private final int end;

        private InlineHighlighterBuilder(@NotNull Editor editor, int start2, int end, @NotNull TextDiffType type) {
            if (editor == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(0);
            }
            if (type == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(1);
            }
            this.editor = editor;
            this.type = type;
            this.start = start2;
            this.end = end;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            TextAttributes attributes = DiffDrawUtil.getTextAttributes(this.type, this.editor, BackgroundType.DEFAULT);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, 5899, attributes, HighlighterTargetArea.EXACT_RANGE);
            if (this.start == this.end) {
                DiffDrawUtil.installEmptyRangeRenderer(highlighter, this.type);
            }
            List<RangeHighlighter> list2 = Collections.singletonList(highlighter);
            if (list2 == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class LineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int startLine;
        private final int endLine;
        private boolean ignored;
        private boolean resolved;
        private boolean excludedInEditor;
        private boolean excludedInGutter;
        private boolean hideWithoutLineNumbers;
        private boolean hideStripeMarkers;

        public LineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type) {
            if (editor == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(0);
            }
            if (type == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(1);
            }
            this.ignored = false;
            this.resolved = false;
            this.excludedInEditor = false;
            this.excludedInGutter = false;
            this.hideWithoutLineNumbers = false;
            this.hideStripeMarkers = false;
            this.editor = editor;
            this.type = type;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public LineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(2);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(3);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withExcluded(boolean excluded) {
            this.excludedInEditor = excluded;
            this.excludedInGutter = excluded;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(4);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withExcludedInEditor(boolean excluded) {
            this.excludedInEditor = excluded;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(5);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withExcludedInGutter(boolean excluded) {
            this.excludedInGutter = excluded;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(6);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withHideWithoutLineNumbers(boolean hideWithoutLineNumbers) {
            this.hideWithoutLineNumbers = hideWithoutLineNumbers;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(7);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withHideStripeMarkers(boolean hideStripeMarkers) {
            this.hideStripeMarkers = hideStripeMarkers;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(8);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
            PaintMode editorMode = PaintMode.DEFAULT;
            PaintMode gutterMode = PaintMode.DEFAULT;
            if (this.ignored) {
                editorMode = PaintMode.IGNORED;
            }
            if (this.excludedInEditor) {
                editorMode = PaintMode.EXCLUDED_EDITOR;
            }
            if (this.excludedInGutter) {
                gutterMode = PaintMode.EXCLUDED_GUTTER;
            }
            if (this.resolved) {
                editorMode = PaintMode.RESOLVED;
                gutterMode = PaintMode.RESOLVED;
            }
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isFirstLine = this.startLine == 0;
            boolean isLastLine = this.endLine == DiffUtil.getLineCount(this.editor.getDocument());
            TextRange offsets2 = DiffUtil.getLinesRange(this.editor.getDocument(), this.startLine, this.endLine);
            int start2 = offsets2.getStartOffset();
            int end = offsets2.getEndOffset();
            TextAttributes attributes = isEmptyRange ? null : DiffDrawUtil.getTextAttributes(this.type, this.editor, editorMode.background);
            TextAttributes stripeAttributes = this.hideStripeMarkers || this.resolved || this.excludedInEditor ? null : DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            boolean dottedLine = editorMode.border == BorderType.DOTTED;
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(start2, end, 5898, attributes, HighlighterTargetArea.LINES_IN_RANGE);
            highlighters.add(highlighter);
            highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffLineMarkerRenderer(highlighter, this.type, editorMode, gutterMode, this.hideWithoutLineNumbers, isEmptyRange, isFirstLine, isLastLine));
            if (isEmptyRange) {
                if (isFirstLine) {
                    highlighters.addAll(new LineMarkerBuilder(this.editor, 0, SeparatorPlacement.TOP).withDefaultRenderer(this.type, true, dottedLine, highlighter).done());
                } else {
                    highlighters.addAll(new LineMarkerBuilder(this.editor, this.startLine - 1, SeparatorPlacement.BOTTOM).withDefaultRenderer(this.type, true, dottedLine, highlighter).done());
                }
            } else if (editorMode.border != BorderType.NONE) {
                highlighters.addAll(new LineMarkerBuilder(this.editor, this.startLine, SeparatorPlacement.TOP).withDefaultRenderer(this.type, false, dottedLine, highlighter).done());
                highlighters.addAll(new LineMarkerBuilder(this.editor, this.endLine - 1, SeparatorPlacement.BOTTOM).withDefaultRenderer(this.type, false, dottedLine, highlighter).done());
            }
            if (stripeAttributes != null) {
                RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start2, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                highlighters.add(stripeHighlighter);
            }
            ArrayList<RangeHighlighter> arrayList = highlighters;
            if (arrayList == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIgnored";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withResolved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withExcluded";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withExcludedInEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withExcludedInGutter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHideWithoutLineNumbers";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHideStripeMarkers";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

