/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.PreviewHintComponent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.reference.SoftReference;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImagePreviewComponent
extends JPanel
implements PreviewHintComponent {
    private static final Key<Long> TIMESTAMP_KEY = Key.create((String)"Image.timeStamp");
    private static final Key<SoftReference<BufferedImage>> BUFFERED_IMAGE_REF_KEY = Key.create((String)"Image.bufferedImage");
    private static final List<String> supportedExtensions = Arrays.asList(ImageIO.getReaderFormatNames());
    @NotNull
    private final BufferedImage myImage;

    private ImagePreviewComponent(@NotNull BufferedImage image, long imageFileSize) {
        if (image == null) {
            ImagePreviewComponent.$$$reportNull$$$0(0);
        }
        this.setLayout(new BorderLayout());
        this.myImage = (BufferedImage)ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ScaleContext.create((Component)this));
        this.add((Component)new ImageComp(), "Center");
        this.add((Component)ImagePreviewComponent.createLabel(image, imageFileSize), "South");
        this.setBackground(UIUtil.getToolTipBackground());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder((Color)JBColor.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    @Override
    public boolean isEqualTo(@Nullable PreviewHintComponent other) {
        if (!(other instanceof ImagePreviewComponent)) {
            return false;
        }
        ImagePreviewComponent otherPreview = (ImagePreviewComponent)other;
        if (this.myImage.getWidth() == otherPreview.myImage.getWidth() && this.myImage.getHeight() == otherPreview.myImage.getHeight()) {
            for (int x = 0; x < this.myImage.getWidth(); ++x) {
                for (int y = 0; y < this.myImage.getHeight(); ++y) {
                    if (this.myImage.getRGB(x, y) == otherPreview.myImage.getRGB(x, y)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static JLabel createLabel(@NotNull BufferedImage image, long imageFileSize) {
        if (image == null) {
            ImagePreviewComponent.$$$reportNull$$$0(1);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        ColorModel colorModel = image.getColorModel();
        int i = colorModel.getPixelSize();
        return new JLabel(String.format("%dx%d, %dbpp, %s", width, height, i, StringUtil.formatFileSize((long)imageFileSize)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean refresh(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            ImagePreviewComponent.$$$reportNull$$$0(2);
        }
        Long loadedTimeStamp = (Long)file2.getUserData(TIMESTAMP_KEY);
        SoftReference imageRef = (SoftReference)file2.getUserData(BUFFERED_IMAGE_REF_KEY);
        if (loadedTimeStamp == null || loadedTimeStamp < file2.getTimeStamp() || SoftReference.dereference((Reference)imageRef) == null) {
            try {
                byte[] content2 = file2.contentsToByteArray();
                BufferedImage image = ImagePreviewComponent.readImageFromBytes(content2);
                file2.putUserData(BUFFERED_IMAGE_REF_KEY, (Object)new SoftReference((Object)image));
                boolean bl = true;
                return bl;
            }
            finally {
                file2.putUserData(TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            }
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static BufferedImage readImageFromBytes(byte @NotNull [] content2) throws IOException {
        block23: {
            BufferedImage bufferedImage;
            if (content2 == null) {
                ImagePreviewComponent.$$$reportNull$$$0(3);
            }
            try {
                Image image = SVGLoader.load((InputStream)new ByteArrayInputStream(content2), (float)JBUIScale.sysScale());
                if (image == null) break block23;
                bufferedImage = ImageUtil.toBufferedImage((Image)image);
            }
            catch (IOException image) {
                // empty catch block
            }
            if (bufferedImage != null) return bufferedImage;
            ImagePreviewComponent.$$$reportNull$$$0(4);
            return bufferedImage;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content2, 0, content2.length);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        Throwable throwable = null;
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
        if (!imageReaders.hasNext()) throw new IOException("Can't read image from given content");
        ImageReader imageReader = imageReaders.next();
        ImageReadParam param = imageReader.getDefaultReadParam();
        imageReader.setInput(imageInputStream, true, true);
        int minIndex = imageReader.getMinIndex();
        BufferedImage bufferedImage = imageReader.read(minIndex, param);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 != null) return bufferedImage2;
        ImagePreviewComponent.$$$reportNull$$$0(5);
        return bufferedImage2;
        {
            catch (Exception e) {
                throw new IOException("Can't read image from given content", e);
            }
            finally {
                imageReader.dispose();
            }
            {
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
        finally {
            if (imageInputStream != null) {
                if (throwable != null) {
                    try {
                        imageInputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    imageInputStream.close();
                }
            }
        }
    }

    public static JComponent getPreviewComponent(@Nullable PsiElement parent) {
        PsiReference[] references;
        if (parent == null) {
            return null;
        }
        for (PsiReference reference2 : references = parent.getReferences()) {
            VirtualFile file2;
            PsiFileSystemItem item;
            PsiElement fileItem = reference2.resolve();
            if (!(fileItem instanceof PsiFileSystemItem) || (item = (PsiFileSystemItem)fileItem).isDirectory() || (file2 = item.getVirtualFile()) == null || !supportedExtensions.contains(file2.getExtension())) continue;
            try {
                ImagePreviewComponent.refresh(file2);
                SoftReference imageRef = (SoftReference)file2.getUserData(BUFFERED_IMAGE_REF_KEY);
                BufferedImage image = (BufferedImage)SoftReference.dereference((Reference)imageRef);
                if (image == null) continue;
                return new ImagePreviewComponent(image, file2.getLength());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ImagePreviewComponent getPreviewComponent(@NotNull BufferedImage image, long imageFileSize) {
        if (image == null) {
            ImagePreviewComponent.$$$reportNull$$$0(6);
        }
        return new ImagePreviewComponent(image, imageFileSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/preview/ImagePreviewComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/preview/ImagePreviewComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readImageFromBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readImageFromBytes";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImageComp
    extends JComponent {
        private final Dimension myPreferredSize;

        private ImageComp() {
            if (ImagePreviewComponent.this.myImage.getWidth() > 300 || ImagePreviewComponent.this.myImage.getHeight() > 300) {
                float factor = 300.0f / (float)Math.max(ImagePreviewComponent.this.myImage.getWidth(), ImagePreviewComponent.this.myImage.getHeight());
                this.myPreferredSize = new Dimension((int)((float)ImagePreviewComponent.this.myImage.getWidth() * factor), (int)((float)ImagePreviewComponent.this.myImage.getHeight() * factor));
            } else {
                this.myPreferredSize = new Dimension(ImagePreviewComponent.this.myImage.getWidth(), ImagePreviewComponent.this.myImage.getHeight());
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Rectangle r = this.getBounds();
            int width = ImagePreviewComponent.this.myImage.getWidth();
            int height = ImagePreviewComponent.this.myImage.getHeight();
            UIUtil.drawImage((Graphics)g, (Image)ImagePreviewComponent.this.myImage, (Rectangle)new Rectangle(0, 0, r.width > width ? width : r.width, r.height > height ? height : r.height), null, (ImageObserver)this);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

