/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.BlockConstrainedPresentation;
import com.intellij.codeInsight.hints.BlockConstraints;
import com.intellij.codeInsight.hints.ConstrainedPresentation;
import com.intellij.codeInsight.hints.HintsBuffer;
import com.intellij.codeInsight.hints.HorizontalConstrainedPresentation;
import com.intellij.codeInsight.hints.HorizontalConstraints;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.SmartList;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J\r\u0010\u001b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl;", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "buffer", "Lcom/intellij/codeInsight/hints/HintsBuffer;", "document", "Lcom/intellij/openapi/editor/Document;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "addBlockElement", "", "logicalLine", "", "showAbove", "", "presentation", "Lcom/intellij/codeInsight/hints/presentation/RootInlayPresentation;", "constraints", "Lcom/intellij/codeInsight/hints/BlockConstraints;", "offset", "relatesToPrecedingText", "priority", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "addInlineElement", "Lcom/intellij/codeInsight/hints/HorizontalConstraints;", "complete", "complete$intellij_platform_lang_impl", "Companion", "intellij.platform.lang.impl"})
public final class InlayHintsSinkImpl
implements InlayHintsSink {
    private final HintsBuffer buffer;
    private final Document document;
    @NotNull
    private final Editor editor;
    public static final Companion Companion = new Companion(null);

    public void addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull InlayPresentation presentation) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        this.addInlineElement(offset, (RootInlayPresentation)new RecursivelyUpdatingRootPresentation(presentation), new HorizontalConstraints(0, relatesToPrecedingText));
    }

    public void addInlineElement(int offset, @NotNull RootInlayPresentation<?> presentation, @Nullable HorizontalConstraints constraints) {
        Intrinsics.checkParameterIsNotNull(presentation, (String)"presentation");
        InlayHintsSinkImpl.Companion.addCreatingListIfNeeded(this.buffer.getInlineHints(), offset, (ConstrainedPresentation)new HorizontalConstrainedPresentation(presentation, constraints));
    }

    public void addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull InlayPresentation presentation) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        int line = this.document.getLineNumber(offset);
        RecursivelyUpdatingRootPresentation root = new RecursivelyUpdatingRootPresentation(presentation);
        this.addBlockElement(line, showAbove, (RootInlayPresentation)root, new BlockConstraints(relatesToPrecedingText, priority));
    }

    public void addBlockElement(int logicalLine, boolean showAbove, @NotNull RootInlayPresentation<?> presentation, @Nullable BlockConstraints constraints) {
        Intrinsics.checkParameterIsNotNull(presentation, (String)"presentation");
        TIntObjectHashMap<List<ConstrainedPresentation<?, BlockConstraints>>> map2 = showAbove ? this.buffer.getBlockAboveHints() : this.buffer.getBlockBelowHints();
        int offset = this.document.getLineStartOffset(logicalLine);
        InlayHintsSinkImpl.Companion.addCreatingListIfNeeded(map2, offset, (ConstrainedPresentation)new BlockConstrainedPresentation(presentation, constraints));
    }

    @NotNull
    public final HintsBuffer complete$intellij_platform_lang_impl() {
        return this.buffer;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public InlayHintsSinkImpl(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.editor = editor;
        this.buffer = new HintsBuffer();
        Document document = this.editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        this.document = document;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0001*\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00050\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00050\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl$Companion;", "", "()V", "addCreatingListIfNeeded", "", "T", "Lgnu/trove/TIntObjectHashMap;", "", "Lcom/intellij/codeInsight/hints/ConstrainedPresentation;", "offset", "", "value", "intellij.platform.lang.impl"})
    public static final class Companion {
        private final <T> void addCreatingListIfNeeded(@NotNull TIntObjectHashMap<List<ConstrainedPresentation<?, T>>> $this$addCreatingListIfNeeded, int offset, ConstrainedPresentation<?, T> value2) {
            List list2 = (List)$this$addCreatingListIfNeeded.get(offset);
            if (list2 == null) {
                list2 = (List)new SmartList();
                $this$addCreatingListIfNeeded.put(offset, (Object)list2);
            }
            list2.add(value2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

