/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NaturalLanguageTextSelectioner
extends ExtendWordSelectionHandlerBase {
    private static final Set<Character> NATURAL = ContainerUtil.newTroveSet((Object[])new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('$'), Character.valueOf('@'), Character.valueOf('%'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('_')});
    private static final Set<Character> SENTENCE_END = ContainerUtil.newTroveSet((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?')});

    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            NaturalLanguageTextSelectioner.$$$reportNull$$$0(0);
        }
        return (e instanceof PsiPlainText || e instanceof PsiComment) && !(e.getContainingFile().getFileType() instanceof CustomSyntaxTableFileType);
    }

    private static TextRange findParagraphRange(String text2, int start2, int end) {
        int paragraphEnd;
        int paragraphStart = text2.lastIndexOf("\n\n", start2);
        if (paragraphStart >= (paragraphEnd = text2.indexOf("\n\n", end))) {
            return new TextRange(0, text2.length());
        }
        return new TextRange(paragraphStart >= 0 ? paragraphStart + 2 : 0, paragraphEnd < 0 ? text2.length() : paragraphEnd);
    }

    @Nullable
    private static TextRange findCustomRange(String text2, int start2, int end, char startChar, char endChar) {
        int prev = text2.lastIndexOf(startChar, start2);
        int next = text2.indexOf(endChar, end);
        if (prev < 0 || next < 0) {
            return null;
        }
        if (StringUtil.contains((CharSequence)text2, (int)(prev + 1), (int)start2, (char)endChar) || StringUtil.contains((CharSequence)text2, (int)end, (int)next, (char)startChar)) {
            return null;
        }
        if (prev + 1 < start2 || next > end) {
            return new TextRange(prev + 1, next);
        }
        return new TextRange(prev, next + 1);
    }

    @Nullable
    private static TextRange findSentenceRange(String editorText, int start2, int end) {
        int sentenceStart;
        for (sentenceStart = start2; sentenceStart > 0; --sentenceStart) {
            if (start2 - sentenceStart > 1000) {
                return null;
            }
            if (NaturalLanguageTextSelectioner.isSentenceEnd(editorText, sentenceStart - 1) || !NaturalLanguageTextSelectioner.isNatural(editorText.charAt(sentenceStart - 1))) break;
        }
        while (sentenceStart < end && Character.isWhitespace(editorText.charAt(sentenceStart))) {
            ++sentenceStart;
        }
        int sentenceEnd = Math.max(0, end - 1);
        while (sentenceEnd < editorText.length()) {
            if (++sentenceEnd - end > 1000) {
                return null;
            }
            if (!NaturalLanguageTextSelectioner.isSentenceEnd(editorText, sentenceEnd - 1)) continue;
        }
        return new TextRange(sentenceStart, sentenceEnd);
    }

    private static boolean isSentenceEnd(String text2, int i) {
        return SENTENCE_END.contains(Character.valueOf(text2.charAt(i))) && (i + 1 == text2.length() || Character.isWhitespace(text2.charAt(i + 1)));
    }

    private static TextRange findNaturalRange(String editorText, int start2, int end) {
        char c;
        while (start2 > 0 && NaturalLanguageTextSelectioner.isNatural(editorText.charAt(start2 - 1))) {
            --start2;
        }
        while (end < editorText.length() && NaturalLanguageTextSelectioner.isNatural(c = editorText.charAt(end))) {
            ++end;
        }
        return new TextRange(start2, end);
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            NaturalLanguageTextSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            NaturalLanguageTextSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            NaturalLanguageTextSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        NaturalLanguageTextSelectioner.addWordRange(editorText, cursorOffset, result2);
        TextRange range2 = NaturalLanguageTextSelectioner.expandSelection(e, editorText, cursorOffset, cursorOffset);
        if (range2 != null) {
            TextRange next;
            result2.add(range2);
            while ((next = NaturalLanguageTextSelectioner.expandSelection(e, editorText, range2.getStartOffset(), range2.getEndOffset())) != null && !range2.contains(next)) {
                result2.add(next);
                range2 = next;
            }
        }
        return result2;
    }

    private static void addWordRange(CharSequence editorText, int cursorOffset, ArrayList<? super TextRange> result2) {
        SelectWordUtil.addWordSelection(false, editorText, cursorOffset, result2, ch -> Character.isJavaIdentifierPart(ch) || ch == '\'');
        SelectWordUtil.addWordSelection(false, editorText, cursorOffset, result2, ch -> Character.isJavaIdentifierPart(ch) || ch == '\'' || ch == '-');
    }

    @Nullable
    private static TextRange expandSelection(PsiElement e, CharSequence editorText, int selStart, int selEnd) {
        int end;
        int start2;
        TextRange range2 = e.getTextRange();
        int shift = range2.getStartOffset();
        if (selStart <= shift || selEnd >= range2.getEndOffset()) {
            return null;
        }
        String elementText = editorText.subSequence(shift, range2.getEndOffset()).toString();
        TextRange best = NaturalLanguageTextSelectioner.findSentenceRange(elementText, start2 = selStart - shift, end = selEnd - shift);
        if (best == null) {
            return null;
        }
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '\"', '\"'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '(', ')'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '<', '>'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '[', ']'));
        TextRange natural = NaturalLanguageTextSelectioner.findNaturalRange(elementText, start2, end);
        if (!natural.contains(best)) {
            return null;
        }
        TextRange paragraph = NaturalLanguageTextSelectioner.findParagraphRange(elementText, start2, end);
        if (best.getStartOffset() == start2 && best.getEndOffset() == end || !paragraph.contains(best)) {
            return paragraph.shiftRight(shift);
        }
        return best.shiftRight(shift);
    }

    private static TextRange narrowRange(TextRange best, TextRange candidate) {
        return candidate != null && best.contains(candidate) ? candidate : best;
    }

    private static boolean isNatural(char c) {
        return Character.isWhitespace(c) || Character.isLetterOrDigit(c) || NATURAL.contains(Character.valueOf(c));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/NaturalLanguageTextSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

