/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HighlightInfoType {
    @NonNls
    public static final String UNUSED_SYMBOL_SHORT_NAME = "unused";
    public static final HighlightInfoType ERROR = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightInfoType WARNING = new HighlightInfoTypeImpl(HighlightSeverity.WARNING, CodeInsightColors.WARNINGS_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType INFO = new HighlightInfoTypeImpl(HighlightSeverity.INFO, CodeInsightColors.INFO_ATTRIBUTES);
    public static final HighlightInfoType WEAK_WARNING = new HighlightInfoTypeImpl(HighlightSeverity.WEAK_WARNING, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
    public static final HighlightInfoType INFORMATION = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType WRONG_REF = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
    public static final HighlightInfoType GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER = new HighlightInfoTypeImpl(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
    public static final HighlightInfoType DUPLICATE_FROM_SERVER = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.DUPLICATE_FROM_SERVER);
    public static final HighlightInfoType UNUSED_SYMBOL = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister((String)"unused", (String)HighlightInfoType.getUnusedSymbolDisplayName(), (String)"unused"), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
    public static final HighlightInfoType DEPRECATED = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister((String)"Deprecation", (String)DeprecationUtil.getDeprecationDisplayName(), (String)"deprecation"), CodeInsightColors.DEPRECATED_ATTRIBUTES);
    public static final HighlightInfoType MARKED_FOR_REMOVAL = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister((String)"MarkedForRemoval", (String)DeprecationUtil.getForRemovalDisplayName(), (String)"removal"), CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES);
    public static final HighlightSeverity SYMBOL_TYPE_SEVERITY = new HighlightSeverity("SYMBOL_TYPE_SEVERITY", HighlightSeverity.INFORMATION.myVal - 2);
    @Deprecated
    public static final HighlightInfoType LOCAL_VARIABLE = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.LOCAL_VARIABLE_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType METHOD_CALL = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.METHOD_CALL_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType STATIC_METHOD = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.STATIC_METHOD_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType CLASS_NAME = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, CodeInsightColors.CLASS_NAME_ATTRIBUTES);
    public static final HighlightInfoType TODO = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
    public static final HighlightInfoType UNHANDLED_EXCEPTION = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightSeverity INJECTED_FRAGMENT_SYNTAX_SEVERITY = new HighlightSeverity("INJECTED_FRAGMENT_SYNTAX", HighlightInfoType.SYMBOL_TYPE_SEVERITY.myVal - 2);
    public static final HighlightSeverity INJECTED_FRAGMENT_SEVERITY = new HighlightSeverity("INJECTED_FRAGMENT", HighlightInfoType.SYMBOL_TYPE_SEVERITY.myVal - 1);
    public static final HighlightInfoType INJECTED_LANGUAGE_FRAGMENT = new HighlightInfoTypeImpl(INJECTED_FRAGMENT_SYNTAX_SEVERITY, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType INJECTED_LANGUAGE_BACKGROUND = new HighlightInfoTypeImpl(INJECTED_FRAGMENT_SEVERITY, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightSeverity ELEMENT_UNDER_CARET_SEVERITY = new HighlightSeverity("ELEMENT_UNDER_CARET", HighlightSeverity.ERROR.myVal + 1);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_READ = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_WRITE = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_STRUCTURAL = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, CodeInsightColors.MATCHED_BRACE_ATTRIBUTES);
    public static final Set<HighlightInfoType> VISIBLE_IF_FOLDED = ContainerUtil.immutableSet((Object[])new HighlightInfoType[]{ELEMENT_UNDER_CARET_READ, ELEMENT_UNDER_CARET_WRITE, WARNING, ERROR, WRONG_REF});

    @NotNull
    public HighlightSeverity getSeverity(@Nullable PsiElement var1);

    @NotNull
    public TextAttributesKey getAttributesKey();

    public static String getUnusedSymbolDisplayName() {
        return AnalysisBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
    }

    @FunctionalInterface
    public static interface UpdateOnTypingSuppressible {
        public boolean needsUpdateOnTyping();
    }

    @FunctionalInterface
    public static interface Iconable {
        @NotNull
        public Icon getIcon();
    }

    public static class HighlightInfoTypeSeverityByKey
    implements HighlightInfoType {
        static final Logger LOG = Logger.getInstance(HighlightInfoTypeSeverityByKey.class);
        private final TextAttributesKey myAttributesKey;
        private final HighlightDisplayKey myToolKey;

        public HighlightInfoTypeSeverityByKey(@NotNull HighlightDisplayKey severityKey, @NotNull TextAttributesKey attributesKey) {
            if (severityKey == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(0);
            }
            if (attributesKey == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(1);
            }
            this.myToolKey = severityKey;
            this.myAttributesKey = attributesKey;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity(PsiElement psiElement) {
            InspectionProfileImpl profile = psiElement == null ? InspectionProfileManager.getInstance().getCurrentProfile() : InspectionProjectProfileManager.getInstance(psiElement.getProject()).getCurrentProfile();
            HighlightSeverity highlightSeverity = profile.getErrorLevel(this.myToolKey, psiElement).getSeverity();
            if (highlightSeverity == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(2);
            }
            return highlightSeverity;
        }

        @Override
        @NotNull
        public TextAttributesKey getAttributesKey() {
            TextAttributesKey textAttributesKey = this.myAttributesKey;
            if (textAttributesKey == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(3);
            }
            return textAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeSeverityByKey[severity=" + this.myToolKey + ", key=" + this.myAttributesKey + "]";
        }

        public HighlightDisplayKey getSeverityKey() {
            return this.myToolKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severityKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesKey";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeSeverityByKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeSeverityByKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HighlightInfoTypeImpl
    implements HighlightInfoType,
    UpdateOnTypingSuppressible {
        private final HighlightSeverity mySeverity;
        private final TextAttributesKey myAttributesKey;
        private final boolean myNeedsUpdateOnTyping;

        HighlightInfoTypeImpl(@NotNull Element element2) {
            if (element2 == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(0);
            }
            this.mySeverity = new HighlightSeverity(element2);
            this.myAttributesKey = new TextAttributesKey(element2);
            this.myNeedsUpdateOnTyping = false;
        }

        public HighlightInfoTypeImpl(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey attributesKey) {
            if (severity == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(1);
            }
            if (attributesKey == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(2);
            }
            this(severity, attributesKey, true);
        }

        public HighlightInfoTypeImpl(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey attributesKey, boolean needsUpdateOnTyping) {
            if (severity == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(3);
            }
            if (attributesKey == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(4);
            }
            this.mySeverity = severity;
            this.myAttributesKey = attributesKey;
            this.myNeedsUpdateOnTyping = needsUpdateOnTyping;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity(@Nullable PsiElement psiElement) {
            HighlightSeverity highlightSeverity = this.mySeverity;
            if (highlightSeverity == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(5);
            }
            return highlightSeverity;
        }

        @Override
        @NotNull
        public TextAttributesKey getAttributesKey() {
            TextAttributesKey textAttributesKey = this.myAttributesKey;
            if (textAttributesKey == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(6);
            }
            return textAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeImpl[severity=" + this.mySeverity + ", key=" + this.myAttributesKey + "]";
        }

        public void writeExternal(Element element2) {
            try {
                this.mySeverity.writeExternal(element2);
            }
            catch (WriteExternalException e) {
                throw new RuntimeException(e);
            }
            this.myAttributesKey.writeExternal(element2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HighlightInfoTypeImpl)) {
                return false;
            }
            HighlightInfoTypeImpl that = (HighlightInfoTypeImpl)o;
            if (!Comparing.equal((Object)this.myAttributesKey, (Object)that.myAttributesKey)) {
                return false;
            }
            return this.mySeverity.equals((Object)that.mySeverity);
        }

        public int hashCode() {
            int result2 = this.mySeverity.hashCode();
            result2 = 29 * result2 + this.myAttributesKey.hashCode();
            return result2;
        }

        @Override
        public boolean needsUpdateOnTyping() {
            return this.myNeedsUpdateOnTyping;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesKey";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

