/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;

public class DevKitRelatedPropertiesProvider
extends DevkitRelatedLineMarkerProviderBase {
    public String getName() {
        return DevKitBundle.message("line.marker.related.property.description", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.FileTypes.Properties;
        if (icon == null) {
            DevKitRelatedPropertiesProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    protected void collectNavigationMarkers(@NotNull PsiElement leaf, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (leaf == null) {
            DevKitRelatedPropertiesProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            DevKitRelatedPropertiesProvider.$$$reportNull$$$0(2);
        }
        if (!(leaf instanceof XmlToken)) {
            return;
        }
        if (leaf.getNode().getElementType() != XmlTokenType.XML_NAME) {
            return;
        }
        PsiElement prev = PsiTreeUtil.getPrevSiblingOfType((PsiElement)leaf, XmlToken.class);
        if (prev == null || prev.getNode().getElementType() != XmlTokenType.XML_START_TAG_START) {
            return;
        }
        if (!leaf.textMatches((CharSequence)"action") && !leaf.textMatches((CharSequence)"group")) {
            return;
        }
        DomElement ag = DomUtil.getDomElement((PsiElement)leaf);
        if (!(ag instanceof ActionOrGroup)) {
            return;
        }
        GenericAttributeValue<String> attr = ((ActionOrGroup)ag).getId();
        String id = attr.getStringValue();
        String tagName = ag.getXmlElementName();
        if (!"action".equals(tagName) && !"group".equals(tagName)) {
            return;
        }
        if (id != null) {
            PropertiesFileImpl file = DevKitPluginXmlInspectionBase.findBundlePropertiesFile(ag);
            if (file == null) {
                return;
            }
            JBIterable targets = JBIterable.of((Object[])new IProperty[]{file.findPropertyByKey(tagName + "." + id + ".text"), file.findPropertyByKey(tagName + "." + id + ".description")}).filter(PsiElement.class);
            if (targets.isEmpty()) {
                return;
            }
            result.add((RelatedItemLineMarkerInfo)NavigationGutterIconBuilder.create((Icon)AllIcons.FileTypes.Properties, e -> Collections.singletonList((PsiElement)e), e -> Collections.singletonList(new GotoRelatedItem((PsiElement)e))).setTargets((Collection)targets.toList()).setTooltipText(DevKitBundle.message("line.marker.related.property.title", new Object[0])).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(leaf));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/references/DevKitRelatedPropertiesProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/references/DevKitRelatedPropertiesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

