/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

abstract class BaseFix
implements LocalQuickFix {
    protected final SmartPsiElementPointer<? extends PsiElement> myPointer;
    protected final boolean myOnTheFly;

    protected BaseFix(@NotNull SmartPsiElementPointer<? extends PsiElement> pointer, boolean onTheFly) {
        if (pointer == null) {
            BaseFix.$$$reportNull$$$0(0);
        }
        this.myPointer = pointer;
        this.myOnTheFly = onTheFly;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        boolean external;
        PsiElement element;
        if (project == null) {
            BaseFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            BaseFix.$$$reportNull$$$0(2);
        }
        if ((element = this.myPointer.getElement()) == null || !element.isValid()) {
            return;
        }
        boolean bl = external = descriptor.getPsiElement().getContainingFile() != element.getContainingFile();
        if (external) {
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
            ReadonlyStatusHandler.OperationStatus status = readonlyStatusHandler.ensureFilesWritable(Collections.singletonList(element.getContainingFile().getVirtualFile()));
            if (status.hasReadonlyFiles()) {
                String className = clazz != null ? clazz.getQualifiedName() : element.getContainingFile().getName();
                Messages.showMessageDialog((Project)project, (String)DevKitBundle.message("inspections.registration.problems.quickfix.read-only", className), (String)this.getName(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        try {
            this.doFix(project, descriptor, external);
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance(this.getClass()).error((Throwable)e);
        }
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2, boolean var3) throws IncorrectOperationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/BaseFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

