/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OldJetBrainsAnnotationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OldJetBrainsAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                OldJetBrainsAnnotationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiJavaCodeReferenceElement nameElement = annotation.getNameReferenceElement();
                if (nameElement == null) {
                    return;
                }
                String name = nameElement.getText();
                if (!name.equals("Nullable") && !name.equals("NotNull")) {
                    return;
                }
                PsiClass annotationClass = (PsiClass)ObjectUtils.tryCast((Object)nameElement.resolve(), PsiClass.class);
                if (annotationClass == null) {
                    return;
                }
                PsiJavaFile file = (PsiJavaFile)ObjectUtils.tryCast((Object)annotationClass.getContainingFile(), PsiJavaFile.class);
                if (file == null) {
                    return;
                }
                String packageName = file.getPackageName();
                if (!"org.jetbrains.annotations".equals(packageName)) {
                    return;
                }
                Set targets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)annotationClass);
                if (targets == null || targets.contains(PsiAnnotation.TargetType.TYPE_USE)) {
                    return;
                }
                PsiAnnotationOwner owner = annotation.getOwner();
                PsiTypeElement typeElement = OldJetBrainsAnnotationInspection.findTypeElement(owner);
                if (typeElement == null) {
                    return;
                }
                PsiType type = typeElement.getType();
                if (!(type instanceof PsiArrayType)) {
                    return;
                }
                holder.registerProblem((PsiElement)annotation, "Old-style array annotation", new LocalQuickFix[]{new OldJetBrainsAnnotationFix()});
            }
        };
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiTypeElement findTypeElement(PsiAnnotationOwner owner) {
        PsiTypeElement typeElement;
        if (!(owner instanceof PsiModifierList)) {
            return null;
        }
        PsiElement parent = ((PsiModifierList)owner).getParent();
        if (parent instanceof PsiVariable) {
            typeElement = ((PsiVariable)parent).getTypeElement();
        } else if (parent instanceof PsiMethod) {
            typeElement = ((PsiMethod)parent).getReturnTypeElement();
        } else {
            return null;
        }
        if (typeElement == null) {
            return null;
        }
        return typeElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/OldJetBrainsAnnotationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/OldJetBrainsAnnotationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OldJetBrainsAnnotationFix
    implements LocalQuickFix {
        private OldJetBrainsAnnotationFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return "Convert to new-style annotation";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiAnnotation annotation;
            if (project == null) {
                OldJetBrainsAnnotationFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                OldJetBrainsAnnotationFix.$$$reportNull$$$0(1);
            }
            if ((annotation = (PsiAnnotation)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiAnnotation.class)) == null) {
                return;
            }
            PsiAnnotationOwner owner = annotation.getOwner();
            PsiTypeElement typeElement = OldJetBrainsAnnotationInspection.findTypeElement(owner);
            if (typeElement == null) {
                return;
            }
            final PsiAnnotation copy = (PsiAnnotation)annotation.copy();
            PsiType newType = typeElement.getType().annotate(new TypeAnnotationProvider(){

                public PsiAnnotation @NotNull [] getAnnotations() {
                    PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{copy};
                    if (psiAnnotationArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiAnnotationArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/OldJetBrainsAnnotationInspection$OldJetBrainsAnnotationFix$1", "getAnnotations"));
                }
            });
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElementFromText(newType.getCanonicalText(true), (PsiElement)typeElement);
            typeElement.replace((PsiElement)newTypeElement);
            annotation.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/inspections/OldJetBrainsAnnotationInspection$OldJetBrainsAnnotationFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

