/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public abstract class DevKitPluginXmlInspectionBase
extends BasicDomElementsInspection<IdeaPlugin> {
    public DevKitPluginXmlInspectionBase() {
        super(IdeaPlugin.class, new Class[0]);
    }

    @Nullable
    public static PropertiesFileImpl findBundlePropertiesFile(@Nullable DomElement domElement) {
        IdeaPlugin ideaPlugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)domElement, IdeaPlugin.class, (boolean)true);
        if (ideaPlugin == null) {
            return null;
        }
        XmlElement resourceBundleTag = ideaPlugin.getResourceBundle().getXmlElement();
        if (resourceBundleTag == null) {
            return null;
        }
        ResourceBundleReference bundleReference = (ResourceBundleReference)ContainerUtil.findInstance((Object[])resourceBundleTag.getReferences(), ResourceBundleReference.class);
        if (bundleReference == null) {
            return null;
        }
        PropertiesFileImpl bundleFile = (PropertiesFileImpl)ObjectUtils.tryCast((Object)bundleReference.resolve(), PropertiesFileImpl.class);
        if (bundleFile == null) {
            return null;
        }
        return bundleFile;
    }

    @Nullable
    protected static GenericAttributeValue getAttribute(DomElement domElement, String attributeName) {
        DomAttributeChildDescription attributeDescription = domElement.getGenericInfo().getAttributeChildDescription(attributeName);
        if (attributeDescription == null) {
            return null;
        }
        return attributeDescription.getDomAttributeValue(domElement);
    }
}

