/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;

public class ExtensionPointIndex
extends PluginXmlIndexBase<String, Integer> {
    private static final ID<String, Integer> NAME = ID.create((String)"devkit.ExtensionPointIndex");

    @NotNull
    public ID<String, Integer> getName() {
        ID<String, Integer> iD = NAME;
        if (iD == null) {
            ExtensionPointIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    protected Map<String, Integer> performIndexing(IdeaPlugin plugin) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (DomElement domElement : ExtensionPointIndex.getChildrenWithoutIncludes(plugin, "extensionPoints")) {
            for (DomElement domElement2 : ExtensionPointIndex.getChildrenWithoutIncludes(domElement, "extensionPoint")) {
                ExtensionPoint extensionPoint = (ExtensionPoint)domElement2;
                result.put(extensionPoint.getEffectiveQualifiedName(), extensionPoint.getXmlTag().getTextOffset());
            }
        }
        return result;
    }

    private static List<? extends DomElement> getChildrenWithoutIncludes(DomElement parent, String tagName) {
        AbstractCollectionChildDescription collectionChildDescription = (AbstractCollectionChildDescription)parent.getGenericInfo().getCollectionChildDescription(tagName);
        DomInvocationHandler handler = Objects.requireNonNull(DomManagerImpl.getDomInvocationHandler((DomElement)parent));
        return handler.getCollectionChildren(collectionChildDescription, false);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            ExtensionPointIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            ExtensionPointIndex.$$$reportNull$$$0(2);
        }
        return enumeratorIntegerDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    public static Map<String, ExtensionPoint> getExtensionPoints(Project project, Set<VirtualFile> files, String epPrefix) {
        HashMap<String, ExtensionPoint> result = new HashMap<String, ExtensionPoint>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        DomManager domManager = DomManager.getDomManager((Project)project);
        for (VirtualFile file : files) {
            PsiFile psiFile;
            Map data = FileBasedIndex.getInstance().getFileData(NAME, file, project);
            if (data.isEmpty() || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
            for (Map.Entry entry : data.entrySet()) {
                PsiElement psiElement;
                XmlTag xmlTag;
                DomElement domElement;
                String qualifiedName = (String)entry.getKey();
                if (!StringUtil.startsWith((CharSequence)qualifiedName, (CharSequence)epPrefix) || !((domElement = domManager.getDomElement(xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = psiFile.findElementAt(((Integer)entry.getValue()).intValue())), XmlTag.class, (boolean)false))) instanceof ExtensionPoint)) continue;
                result.put(qualifiedName, (ExtensionPoint)domElement);
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/dom/index/ExtensionPointIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

