/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.fus;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageStateEventTrackerKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u0010J\u0016\u0010\n\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u0010J\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/fus/FeatureUsageLogger;", "", "()V", "loggerProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "cleanup", "", "getConfig", "isEnabled", "", "log", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "action", "", "data", "", "groupId", "logState", "rollOver", "intellij.platform.statistics"})
public final class FeatureUsageLogger {
    private static final StatisticsEventLoggerProvider loggerProvider;
    public static final FeatureUsageLogger INSTANCE;

    public final void log(@NotNull EventLogGroup group, @NotNull String action) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        loggerProvider.getLogger().log(group, action, false);
    }

    public final void log(@NotNull EventLogGroup group, @NotNull String action, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        loggerProvider.getLogger().log(group, action, data, false);
    }

    public final void logState(@NotNull EventLogGroup group, @NotNull String action) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        loggerProvider.getLogger().log(group, action, true);
    }

    public final void logState(@NotNull EventLogGroup group, @NotNull String action, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        loggerProvider.getLogger().log(group, action, data, true);
    }

    public final void log(@NotNull String groupId, @NotNull String action) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        loggerProvider.getLogger().log(new EventLogGroup(groupId, 1), action, true);
    }

    public final void cleanup() {
        loggerProvider.getLogger().cleanup();
    }

    public final void rollOver() {
        loggerProvider.getLogger().rollOver();
    }

    @NotNull
    public final StatisticsEventLoggerProvider getConfig() {
        return loggerProvider;
    }

    public final boolean isEnabled() {
        return !(loggerProvider.getLogger() instanceof EmptyStatisticsEventLogger);
    }

    private FeatureUsageLogger() {
    }

    static {
        FeatureUsageLogger featureUsageLogger;
        INSTANCE = featureUsageLogger = new FeatureUsageLogger();
        loggerProvider = StatisticsEventLoggerKt.getEventLogProvider("FUS");
        if (featureUsageLogger.isEnabled()) {
            FeatureUsageStateEventTrackerKt.initStateEventTrackers();
        }
    }
}

