/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit5Framework
extends JavaTestFramework {
    @NotNull
    public String getName() {
        return "JUnit5";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.RunConfigurations.Junit;
        if (icon == null) {
            JUnit5Framework.$$$reportNull$$$0(0);
        }
        return icon;
    }

    protected String getMarkerClassFQName() {
        return "org.junit.jupiter.api.Test";
    }

    @Nullable
    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return JUnitExternalLibraryDescriptor.JUNIT5;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return null;
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (canBePotential) {
            return this.isUnderTestSources(clazz);
        }
        return JUnitUtil.isJUnit5TestClass((PsiClass)clazz, (boolean)false);
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit5Framework.$$$reportNull$$$0(1);
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.jupiter.api.BeforeEach", (int)0)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findBeforeClassMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit5Framework.$$$reportNull$$$0(2);
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!each.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.jupiter.api.BeforeAll", (int)0)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit5Framework.$$$reportNull$$$0(3);
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.jupiter.api.AfterEach", (int)0)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findAfterClassMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit5Framework.$$$reportNull$$$0(4);
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!each.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.jupiter.api.AfterAll", (int)0)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod testMethod;
        PsiMethod method = this.findSetUpMethod(clazz);
        if (method != null) {
            return method;
        }
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        method = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiMethod existingMethod = clazz.findMethodBySignature(method, false);
        if (existingMethod != null) {
            int exit;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)existingMethod, (String)"org.junit.jupiter.api.BeforeAll", (int)0)) {
                return existingMethod;
            }
            int n = exit = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((String)JUnitBundle.message("create.setup.dialog.message", "@BeforeEach"), (String)JUnitBundle.message("create.setup.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (exit == 0) {
                new AddAnnotationFix("org.junit.jupiter.api.BeforeEach", (PsiModifierListOwner)existingMethod, new String[0]).invoke(existingMethod.getProject(), null, existingMethod.getContainingFile());
                return existingMethod;
            }
        }
        method = (testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz)) != null ? (PsiMethod)clazz.addBefore((PsiElement)method, (PsiElement)testMethod) : (PsiMethod)clazz.add((PsiElement)method);
        JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)method);
        return method;
    }

    public boolean isIgnoredMethod(PsiElement element) {
        PsiMethod testMethod = element instanceof PsiMethod ? JUnitUtil.getTestMethod((PsiElement)element) : null;
        return testMethod != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)testMethod, (String)"org.junit.Ignore", (int)0);
    }

    public boolean isTestMethod(PsiElement element, boolean checkAbstract) {
        return element instanceof PsiMethod && JUnitUtil.getTestMethod((PsiElement)element, (boolean)checkAbstract) != null;
    }

    public boolean isTestMethod(PsiMethod method, PsiClass myClass) {
        return JUnitUtil.isTestMethod((Location)MethodLocation.elementInClass((PsiMethod)method, (PsiClass)myClass));
    }

    public boolean isMyConfigurationType(ConfigurationType type) {
        return type instanceof JUnitConfigurationType;
    }

    public boolean acceptNestedClasses() {
        return true;
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 SetUp Method.java");
    }

    public FileTemplateDescriptor getBeforeClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 BeforeAll Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 TearDown Method.java");
    }

    public FileTemplateDescriptor getAfterClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 AfterAll Method.java");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 Test Method.java");
    }

    public char getMnemonic() {
        return '5';
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 Test Class.java");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/JUnit5Framework";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/JUnit5Framework";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSetUpMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findBeforeClassMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTearDownMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAfterClassMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

