/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavigationGutterIconRenderer
extends GutterIconRenderer
implements GutterIconNavigationHandler<PsiElement>,
DumbAware {
    protected final String myPopupTitle;
    private final String myEmptyText;
    protected final Computable<? extends PsiElementListCellRenderer> myCellRenderer;
    private final NotNullLazyValue<? extends List<SmartPsiElementPointer>> myPointers;

    protected NavigationGutterIconRenderer(String popupTitle, String emptyText, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer>> pointers) {
        if (cellRenderer == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(0);
        }
        if (pointers == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(1);
        }
        this.myPopupTitle = popupTitle;
        this.myEmptyText = emptyText;
        this.myCellRenderer = cellRenderer;
        this.myPointers = pointers;
    }

    public boolean isNavigateAction() {
        return true;
    }

    public List<PsiElement> getTargetElements() {
        return ContainerUtil.mapNotNull((Collection)((Collection)this.myPointers.getValue()), (Function)((NullableFunction)smartPsiElementPointer -> smartPsiElementPointer.getElement()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NavigationGutterIconRenderer renderer = (NavigationGutterIconRenderer)((Object)o);
        if (this.myEmptyText != null ? !this.myEmptyText.equals(renderer.myEmptyText) : renderer.myEmptyText != null) {
            return false;
        }
        if (!((List)this.myPointers.getValue()).equals(renderer.myPointers.getValue())) {
            return false;
        }
        return !(this.myPopupTitle != null ? !this.myPopupTitle.equals(renderer.myPopupTitle) : renderer.myPopupTitle != null);
    }

    public int hashCode() {
        int result = this.myPopupTitle != null ? this.myPopupTitle.hashCode() : 0;
        result = 31 * result + (this.myEmptyText != null ? this.myEmptyText.hashCode() : 0);
        result = 31 * result + ((List)this.myPointers.getValue()).hashCode();
        return result;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                NavigationGutterIconRenderer.this.navigate(e == null ? null : (MouseEvent)e.getInputEvent(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer$1", "actionPerformed"));
            }
        };
    }

    public void navigate(@Nullable MouseEvent event, @Nullable PsiElement elt) {
        DumbService dumbService = elt != null ? DumbService.getInstance((Project)elt.getProject()) : null;
        List list = dumbService != null ? (List)dumbService.computeWithAlternativeResolveEnabled(() -> this.getTargetElements()) : this.getTargetElements();
        if (list.isEmpty()) {
            if (this.myEmptyText != null && event != null) {
                JComponent label = HintUtil.createErrorLabel((String)this.myEmptyText);
                label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7, (int)2, (int)7));
                JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint(event), Balloon.Position.above);
            }
            return;
        }
        this.navigateToItems(event, list);
    }

    protected void navigateToItems(@Nullable MouseEvent event, @NotNull List<PsiElement> list) {
        if (list == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(2);
        }
        if (list.size() == 1) {
            PsiNavigateUtil.navigate((PsiElement)list.iterator().next());
        } else if (event != null) {
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])PsiUtilCore.toPsiElementArray(list), (PsiElementListCellRenderer)((PsiElementListCellRenderer)this.myCellRenderer.compute()), (String)this.myPopupTitle);
            popup.show(new RelativePoint(event));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

