/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.FileContentComparator;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class FileAssert
extends GenericAssert<FileAssert, File> {
    private final FileContentComparator comparator;

    protected FileAssert(@Nullable File actual) {
        this(actual, new FileContentComparator());
    }

    @VisibleForTesting
    FileAssert(@Nullable File actual, @Nonnull FileContentComparator comparator) {
        super(FileAssert.class, actual);
        this.comparator = comparator;
    }

    @Nonnull
    public FileAssert doesNotExist() {
        this.isNotNull();
        if (!((File)this.actual).exists()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should not exist", this.actual));
    }

    @Nonnull
    public FileAssert exists() {
        this.isNotNull();
        this.assertExists((File)this.actual);
        return this;
    }

    @Nonnull
    public FileAssert hasSize(long expected) {
        this.isNotNull();
        long size = ((File)this.actual).length();
        if (size == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("size of file:<%s> expected:<%s> but was:<%s>", this.actual, expected, size));
    }

    @Nonnull
    public FileAssert isDirectory() {
        this.isNotNull();
        if (((File)this.actual).isDirectory()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be a directory", this.actual));
    }

    @Nonnull
    public FileAssert isFile() {
        this.isNotNull();
        if (((File)this.actual).isFile()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be a file", this.actual));
    }

    @Nonnull
    public FileAssert hasSameContentAs(@Nonnull File expected) {
        Preconditions.checkNotNull((Object)expected);
        this.isNotNull();
        this.assertExists((File)this.actual).assertExists(expected);
        try {
            Object[] diffs = this.comparator.compareContents((File)this.actual, expected);
            if (!Arrays.isNullOrEmpty((Object[])diffs)) {
                this.fail(expected, (FileContentComparator.LineDiff[])diffs);
            }
        }
        catch (IOException e) {
            this.cannotCompareToExpectedFile(expected, e);
        }
        return this;
    }

    private void fail(@Nonnull File expected, @Nonnull FileContentComparator.LineDiff[] diffs) {
        this.failIfCustomMessageIsSet();
        StringBuilder b = new StringBuilder();
        b.append(String.format("file:%s and file:%s do not have same contents:", Formatting.inBrackets(this.actual), Formatting.inBrackets(expected)));
        for (FileContentComparator.LineDiff diff : diffs) {
            String line = String.format("%nline:<%d>, expected:%s but was:%s", diff.lineNumber, Formatting.inBrackets(diff.expected), Formatting.inBrackets(diff.actual));
            b.append(line);
        }
        this.fail(b.toString());
    }

    private void cannotCompareToExpectedFile(@Nonnull File expected, @Nonnull Exception e) {
        this.failIfCustomMessageIsSet(e);
        String message = Formatting.format("unable to compare contents of files:<%s> and <%s>", this.actual, expected);
        this.fail(message, e);
    }

    private FileAssert assertExists(@Nonnull File file) {
        if (file.exists()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should exist", file));
    }

    @Nonnull
    public FileAssert isRelative() {
        this.isNotNull();
        if (!((File)this.actual).isAbsolute()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be a relative path", this.actual));
    }

    @Nonnull
    public FileAssert isAbsolute() {
        this.isNotNull();
        if (((File)this.actual).isAbsolute()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Formatting.format("file:<%s> should be an absolute path", this.actual));
    }
}

