/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;

class GlueCursor {
    private final GlueDocument glueDocument;
    private GlueElement currentElement;

    public GlueCursor(GlueDocument glueDocument) {
        this.glueDocument = glueDocument;
        this.gotoFirstElement();
    }

    public GlueElement getCurrentElement() {
        return this.currentElement;
    }

    public final void gotoFirstElement() {
        this.currentElement = this.glueDocument.getRootElement();
    }

    public void moveToNextElement() {
        assert (this.currentElement != null);
        if (this.currentElement.getChildren().isEmpty()) {
            GlueElement nextElement = this.currentElement.getNextSibling();
            while (nextElement == null && this.currentElement.getParent() != null) {
                this.currentElement = this.currentElement.getParent();
                nextElement = this.currentElement.getNextSibling();
            }
            this.currentElement = nextElement;
        } else {
            this.currentElement = this.currentElement.getChildren().get(0);
        }
    }
}

