/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.layout.Region;

public class RegionResizer
extends AbstractResizer<Region> {
    private final double originalMinWidth;
    private final double originalMinHeight;
    private final double originalPrefWidth;
    private final double originalPrefHeight;
    private final double originalMaxWidth;
    private final double originalMaxHeight;
    private final PropertyName minWidthName = new PropertyName("minWidth");
    private final PropertyName minHeightName = new PropertyName("minHeight");
    private final PropertyName prefWidthName = new PropertyName("prefWidth");
    private final PropertyName prefHeightName = new PropertyName("prefHeight");
    private final PropertyName maxWidthName = new PropertyName("maxWidth");
    private final PropertyName maxHeightName = new PropertyName("maxHeight");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public RegionResizer(Region sceneGraphObject) {
        super(sceneGraphObject);
        this.originalMinWidth = sceneGraphObject.getMinWidth();
        this.originalMinHeight = sceneGraphObject.getMinHeight();
        this.originalPrefWidth = sceneGraphObject.getPrefWidth();
        this.originalPrefHeight = sceneGraphObject.getPrefHeight();
        this.originalMaxWidth = sceneGraphObject.getMaxWidth();
        this.originalMaxHeight = sceneGraphObject.getMaxHeight();
        this.propertyNames.add(this.prefWidthName);
        this.propertyNames.add(this.prefHeightName);
        this.propertyNames.add(this.minWidthName);
        this.propertyNames.add(this.minHeightName);
        this.propertyNames.add(this.maxWidthName);
        this.propertyNames.add(this.maxHeightName);
    }

    public static String makeSizeString(double size) {
        String result = size == Double.MAX_VALUE ? "MAX_VALUE" : String.valueOf(size);
        return result;
    }

    public static String makeComputedSizeString(double size) {
        String result = size == -1.0 ? "USE_COMPUTED_SIZE" : RegionResizer.makeSizeString(size);
        return result;
    }

    public static String makePrefSizeString(double size) {
        String result = size == Double.NEGATIVE_INFINITY ? "USE_PREF_SIZE" : RegionResizer.makeComputedSizeString(size);
        return result;
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        return new BoundingBox(0.0, 0.0, (double)Math.round(width), (double)Math.round(height));
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.FREE;
    }

    @Override
    public void changeWidth(double weight) {
        double w = Math.round(weight);
        ((Region)this.sceneGraphObject).setPrefWidth(w);
        if (this.originalMinWidth != -1.0 && this.originalMinWidth != Double.NEGATIVE_INFINITY) {
            ((Region)this.sceneGraphObject).setMinWidth(Math.min(w, this.originalMinWidth));
        }
        if (this.originalMaxWidth != -1.0 && this.originalMaxWidth != Double.NEGATIVE_INFINITY) {
            ((Region)this.sceneGraphObject).setMaxWidth(Math.max(w, this.originalMaxWidth));
        }
    }

    @Override
    public void changeHeight(double height) {
        double h = Math.round(height);
        ((Region)this.sceneGraphObject).setPrefHeight(h);
        if (this.originalMinHeight != -1.0 && this.originalMinHeight != Double.NEGATIVE_INFINITY) {
            ((Region)this.sceneGraphObject).setMinHeight(Math.min(h, this.originalMinHeight));
        }
        if (this.originalMaxHeight != -1.0 && this.originalMaxHeight != Double.NEGATIVE_INFINITY) {
            ((Region)this.sceneGraphObject).setMaxHeight(Math.max(h, this.originalMaxHeight));
        }
    }

    @Override
    public void revertToOriginalSize() {
        ((Region)this.sceneGraphObject).setMinWidth(this.originalMinWidth);
        ((Region)this.sceneGraphObject).setMinHeight(this.originalMinHeight);
        ((Region)this.sceneGraphObject).setPrefWidth(this.originalPrefWidth);
        ((Region)this.sceneGraphObject).setPrefHeight(this.originalPrefHeight);
        ((Region)this.sceneGraphObject).setMaxWidth(this.originalMaxWidth);
        ((Region)this.sceneGraphObject).setMaxHeight(this.originalMaxHeight);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        String result = propertyName.equals(this.minWidthName) ? RegionResizer.makePrefSizeString(((Region)this.sceneGraphObject).getMinWidth()) : (propertyName.equals(this.minHeightName) ? RegionResizer.makePrefSizeString(((Region)this.sceneGraphObject).getMinHeight()) : (propertyName.equals(this.prefWidthName) ? RegionResizer.makeComputedSizeString(((Region)this.sceneGraphObject).getPrefWidth()) : (propertyName.equals(this.prefHeightName) ? RegionResizer.makeComputedSizeString(((Region)this.sceneGraphObject).getPrefHeight()) : (propertyName.equals(this.maxWidthName) ? RegionResizer.makePrefSizeString(((Region)this.sceneGraphObject).getMaxWidth()) : (propertyName.equals(this.maxHeightName) ? RegionResizer.makePrefSizeString(((Region)this.sceneGraphObject).getMaxHeight()) : null)))));
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((Region)this.sceneGraphObject).getMinWidth(), this.originalMinWidth)) {
            result.put(this.minWidthName, ((Region)this.sceneGraphObject).getMinWidth());
        }
        if (!MathUtils.equals(((Region)this.sceneGraphObject).getMinHeight(), this.originalMinHeight)) {
            result.put(this.minHeightName, ((Region)this.sceneGraphObject).getMinHeight());
        }
        if (!MathUtils.equals(((Region)this.sceneGraphObject).getPrefWidth(), this.originalPrefWidth)) {
            result.put(this.prefWidthName, ((Region)this.sceneGraphObject).getPrefWidth());
        }
        if (!MathUtils.equals(((Region)this.sceneGraphObject).getPrefHeight(), this.originalPrefHeight)) {
            result.put(this.prefHeightName, ((Region)this.sceneGraphObject).getPrefHeight());
        }
        if (!MathUtils.equals(((Region)this.sceneGraphObject).getMaxWidth(), this.originalMaxWidth)) {
            result.put(this.maxWidthName, ((Region)this.sceneGraphObject).getMaxWidth());
        }
        if (!MathUtils.equals(((Region)this.sceneGraphObject).getMaxHeight(), this.originalMaxHeight)) {
            result.put(this.maxHeightName, ((Region)this.sceneGraphObject).getMaxHeight());
        }
        return result;
    }
}

