"""Generated message classes for cloudasset version v1p4beta1.

The cloud asset API manages the history and inventory of cloud resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudasset'


class AccessSelector(_messages.Message):
  r"""Specifies roles and/or permissions to analyze, to determine both the
  identities possessing them and the resources they control. If multiple
  values are specified, results will include identities and resources matching
  any of them.

  Fields:
    permissions: Optional. The permissions to appear in result.
    roles: Optional. The roles to appear in result.
  """

  permissions = _messages.StringField(1, repeated=True)
  roles = _messages.StringField(2, repeated=True)


class AnalyzeIamPolicyResponse(_messages.Message):
  r"""A response message for AssetService.AnalyzeIamPolicy.

  Fields:
    fullyExplored: Represents whether all entries in the main_analysis and
      service_account_impersonation_analysis have been fully explored to
      answer the query in the request.
    mainAnalysis: The main analysis that matches the original request.
    nonCriticalErrors: A list of non-critical errors happened during the
      request handling to explain why `fully_explored` is false, or empty if
      no error happened.
    serviceAccountImpersonationAnalysis: The service account impersonation
      analysis if
      AnalyzeIamPolicyRequest.analyze_service_account_impersonation is
      enabled.
  """

  fullyExplored = _messages.BooleanField(1)
  mainAnalysis = _messages.MessageField('IamPolicyAnalysis', 2)
  nonCriticalErrors = _messages.MessageField('GoogleCloudAssetV1p4beta1AnalysisState', 3, repeated=True)
  serviceAccountImpersonationAnalysis = _messages.MessageField('IamPolicyAnalysis', 4, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CloudassetAnalyzeIamPolicyRequest(_messages.Message):
  r"""A CloudassetAnalyzeIamPolicyRequest object.

  Fields:
    analysisQuery_accessSelector_permissions: Optional. The permissions to
      appear in result.
    analysisQuery_accessSelector_roles: Optional. The roles to appear in
      result.
    analysisQuery_identitySelector_identity: Required. The identity appear in
      the form of members in [IAM policy
      binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
    analysisQuery_resourceSelector_fullResourceName: Required. The [full
      resource name](https://cloud.google.com/apis/design/resource_names#full_
      resource_name) .
    options_analyzeServiceAccountImpersonation: Optional. If true, the
      response will include access analysis from identities to resources via
      service account impersonation. This is a very expensive operation,
      because many derived queries will be executed. We highly recommend you
      use ExportIamPolicyAnalysis rpc instead.  For example, if the request
      analyzes for which resources user A has permission P, and there's an IAM
      policy states user A has iam.serviceAccounts.getAccessToken permission
      to a service account SA, and there's another IAM policy states service
      account SA has permission P to a GCP folder F, then user A potentially
      has access to the GCP folder F. And those advanced analysis results will
      be included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
      Another example, if the request analyzes for who has permission P to a
      GCP folder F, and there's an IAM policy states user A has
      iam.serviceAccounts.actAs permission to a service account SA, and
      there's another IAM policy states service account SA has permission P to
      the GCP folder F, then user A potentially has access to the GCP folder
      F. And those advanced analysis results will be included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
      Default is false.
    options_executionTimeout: Optional. Amount of time executable has to
      complete.  See JSON representation of
      [Duration](https://developers.google.com/protocol-
      buffers/docs/proto3#json).  If this field is set with a value less than
      the RPC deadline, and the execution of your query hasn't finished in the
      specified execution timeout,  you will get a response with partial
      result. Otherwise, your query's execution will continue until the RPC
      deadline. If it's not finished until then, you will get a
      DEADLINE_EXCEEDED error.  Default is empty.
    options_expandGroups: Optional. If true, the identities section of the
      result will expand any Google groups appearing in an IAM policy binding.
      If identity_selector is specified, the identity in the result will be
      determined by the selector, and this flag will have no effect.  Default
      is false.
    options_expandResources: Optional. If true, the resource section of the
      result will expand any resource attached to an IAM policy to include
      resources lower in the resource hierarchy.  For example, if the request
      analyzes for which resources user A has permission P, and the results
      include an IAM policy with P on a GCP folder, the results will also
      include resources in that folder with permission P.  If
      resource_selector is specified, the resource section of the result will
      be determined by the selector, and this flag will have no effect.
      Default is false.
    options_expandRoles: Optional. If true, the access section of result will
      expand any roles appearing in IAM policy bindings to include their
      permissions.  If access_selector is specified, the access section of the
      result will be determined by the selector, and this flag will have no
      effect.  Default is false.
    options_outputGroupEdges: Optional. If true, the result will output group
      identity edges, starting from the binding's group members, to any
      expanded identities. Default is false.
    options_outputResourceEdges: Optional. If true, the result will output
      resource edges, starting from the policy attached resource, to any
      expanded resources. Default is false.
    parent: Required. The relative name of the root asset. Only resources and
      IAM policies within the parent will be analyzed. This can only be an
      organization number (such as "organizations/123") or a folder number
      (such as "folders/123").
  """

  analysisQuery_accessSelector_permissions = _messages.StringField(1, repeated=True)
  analysisQuery_accessSelector_roles = _messages.StringField(2, repeated=True)
  analysisQuery_identitySelector_identity = _messages.StringField(3)
  analysisQuery_resourceSelector_fullResourceName = _messages.StringField(4)
  options_analyzeServiceAccountImpersonation = _messages.BooleanField(5)
  options_executionTimeout = _messages.StringField(6)
  options_expandGroups = _messages.BooleanField(7)
  options_expandResources = _messages.BooleanField(8)
  options_expandRoles = _messages.BooleanField(9)
  options_outputGroupEdges = _messages.BooleanField(10)
  options_outputResourceEdges = _messages.BooleanField(11)
  parent = _messages.StringField(12, required=True)


class CloudassetExportIamPolicyAnalysisRequest(_messages.Message):
  r"""A CloudassetExportIamPolicyAnalysisRequest object.

  Fields:
    exportIamPolicyAnalysisRequest: A ExportIamPolicyAnalysisRequest resource
      to be passed as the request body.
    parent: Required. The relative name of the root asset. Only resources and
      IAM policies within the parent will be analyzed. This can only be an
      organization number (such as "organizations/123") or a folder number
      (such as "folders/123").
  """

  exportIamPolicyAnalysisRequest = _messages.MessageField('ExportIamPolicyAnalysisRequest', 1)
  parent = _messages.StringField(2, required=True)


class ExportIamPolicyAnalysisRequest(_messages.Message):
  r"""A request message for AssetService.ExportIamPolicyAnalysis.

  Fields:
    analysisQuery: Required. The request query.
    options: Optional. The request options.
    outputConfig: Required. Output configuration indicating where the results
      will be output to.
  """

  analysisQuery = _messages.MessageField('IamPolicyAnalysisQuery', 1)
  options = _messages.MessageField('Options', 2)
  outputConfig = _messages.MessageField('IamPolicyAnalysisOutputConfig', 3)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.  Example (Comparison):
  title: "Summary size limit"     description: "Determines if a summary is
  less than 100 chars"     expression: "document.summary.size() < 100"
  Example (Equality):      title: "Requestor is owner"     description:
  "Determines if requestor is the document owner"     expression:
  "document.owner == request.auth.claims.email"  Example (Logic):      title:
  "Public documents"     description: "Determine whether the document should
  be publicly visible"     expression: "document.type != 'private' &&
  document.type != 'internal'"  Example (Data Manipulation):      title:
  "Notification string"     description: "Create a notification string with a
  timestamp."     expression: "'New message received at ' +
  string(document.create_time)"  The exact variables and functions that may be
  referenced within an expression are determined by the service that evaluates
  it. See the service documentation for additional information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GcsDestination(_messages.Message):
  r"""A Cloud Storage location.

  Fields:
    uri: Required. The uri of the Cloud Storage object. It's the same uri that
      is used by gsutil. For example: "gs://bucket_name/object_name". See
      [Viewing and Editing Object
      Metadata](https://cloud.google.com/storage/docs/viewing-editing-
      metadata) for more information.
  """

  uri = _messages.StringField(1)


class GoogleCloudAssetV1p4beta1Access(_messages.Message):
  r"""A role or permission that appears in an access control list.

  Fields:
    analysisState: The analysis state of this access node.
    permission: The permission.
    role: The role.
  """

  analysisState = _messages.MessageField('GoogleCloudAssetV1p4beta1AnalysisState', 1)
  permission = _messages.StringField(2)
  role = _messages.StringField(3)


class GoogleCloudAssetV1p4beta1AccessControlList(_messages.Message):
  r"""An access control list, derived from the above IAM policy binding, which
  contains a set of resources and accesses. May include one item from each set
  to compose an access control entry.  NOTICE that there could be multiple
  access control lists for one IAM policy binding. The access control lists
  are created based on resource and access combinations.  For example, assume
  we have the following cases in one IAM policy binding: - Permission P1 and
  P2 apply to resource R1 and R2; - Permission P3 applies to resource R2 and
  R3;  This will result in the following access control lists: -
  AccessControlList 1: [R1, R2], [P1, P2] - AccessControlList 2: [R2, R3],
  [P3]

  Fields:
    accesses: The accesses that match one of the following conditions: - The
      access_selector, if it is specified in request; - Otherwise, access
      specifiers reachable from the policy binding's role.
    resourceEdges: Resource edges of the graph starting from the policy
      attached resource to any descendant resources. The Edge.source_node
      contains the full resource name of a parent resource and
      Edge.target_node contains the full resource name of a child resource.
      This field is present only if the output_resource_edges option is
      enabled in request.
    resources: The resources that match one of the following conditions: - The
      resource_selector, if it is specified in request; - Otherwise, resources
      reachable from the policy attached resource.
  """

  accesses = _messages.MessageField('GoogleCloudAssetV1p4beta1Access', 1, repeated=True)
  resourceEdges = _messages.MessageField('GoogleCloudAssetV1p4beta1Edge', 2, repeated=True)
  resources = _messages.MessageField('GoogleCloudAssetV1p4beta1Resource', 3, repeated=True)


class GoogleCloudAssetV1p4beta1AnalysisState(_messages.Message):
  r"""Represents analysis state of each node in the result graph or non-
  critical errors in the response.

  Enums:
    CodeValueValuesEnum: The Google standard error code that best describes
      the state. For example: - OK means the node has been successfully
      explored; - PERMISSION_DENIED means an access denied error is
      encountered; - DEADLINE_EXCEEDED means the node hasn't been explored in
      time;

  Fields:
    cause: The human-readable description of the cause of failure.
    code: The Google standard error code that best describes the state. For
      example: - OK means the node has been successfully explored; -
      PERMISSION_DENIED means an access denied error is encountered; -
      DEADLINE_EXCEEDED means the node hasn't been explored in time;
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""The Google standard error code that best describes the state. For
    example: - OK means the node has been successfully explored; -
    PERMISSION_DENIED means an access denied error is encountered; -
    DEADLINE_EXCEEDED means the node hasn't been explored in time;

    Values:
      OK: Not an error; returned on success  HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller.  HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error.  For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space.  Also errors raised by
        APIs that do not return enough error information may be converted to
        this error.  HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument.  Note that
        this differs from `FAILED_PRECONDITION`.  `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name).  HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully.  For example, a successful response from a server could
        have been delayed long enough for the deadline to expire.  HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found.  Note to server developers: if a request is denied for an
        entire class of users, such as gradual feature rollout or undocumented
        whitelist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used.  HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists.  HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions.  HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation.  HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space.  HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution.  For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc.  Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`:  (a) Use `UNAVAILABLE` if the client can
        retry just the failing call.  (b) Use `ABORTED` if the client should
        retry at a higher level      (e.g., when a client-specified test-and-
        set fails, indicating the      client should restart a read-modify-
        write sequence).  (c) Use `FAILED_PRECONDITION` if the client should
        not retry until      the system state has been explicitly fixed.
        E.g., if an "rmdir"      fails because the directory is non-empty,
        `FAILED_PRECONDITION`      should be returned since the client should
        not retry unless      the files are deleted from the directory.  HTTP
        Mapping: 400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort.  See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`.  HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range.  E.g.,
        seeking or reading past end-of-file.  Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size.  There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`.  We
        recommend using `OUT_OF_RANGE` (the more specific error) when it
        applies so that callers who are iterating through a space can easily
        look for an `OUT_OF_RANGE` error to detect when they are done.  HTTP
        Mapping: 400 Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service.  HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors.  This means that some invariants expected by
        the underlying system have been broken.  This error code is reserved
        for serious errors.  HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable.  This is most likely
        a transient condition, which can be corrected by retrying with a
        backoff. Note that it is not always safe to retry non-idempotent
        operations.  See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`.  HTTP Mapping:
        503 Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption.  HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  cause = _messages.StringField(1)
  code = _messages.EnumField('CodeValueValuesEnum', 2)


class GoogleCloudAssetV1p4beta1Edge(_messages.Message):
  r"""A directional edge.

  Fields:
    sourceNode: The source node of the edge.
    targetNode: The target node of the edge.
  """

  sourceNode = _messages.StringField(1)
  targetNode = _messages.StringField(2)


class GoogleCloudAssetV1p4beta1Identity(_messages.Message):
  r"""An identity that appears in an access control list.

  Fields:
    analysisState: The analysis state of this identity node.
    name: The identity name in any form of members appear in [IAM policy
      binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
      as: - user:foo@google.com - group:group1@google.com -
      serviceAccount:s1@prj1.iam.gserviceaccount.com -
      projectOwner:some_project_id - domain:google.com - allUsers - etc.
  """

  analysisState = _messages.MessageField('GoogleCloudAssetV1p4beta1AnalysisState', 1)
  name = _messages.StringField(2)


class GoogleCloudAssetV1p4beta1IdentityList(_messages.Message):
  r"""A GoogleCloudAssetV1p4beta1IdentityList object.

  Fields:
    groupEdges: Group identity edges of the graph starting from the binding's
      group members to any node of the identities. The Edge.source_node
      contains a group, such as "group:parent@google.com". The
      Edge.target_node contains a member of the group, such as
      "group:child@google.com" or "user:foo@google.com". This field is present
      only if the output_group_edges option is enabled in request.
    identities: Only the identities that match one of the following conditions
      will be presented: - The identity_selector, if it is specified in
      request; - Otherwise, identities reachable from the policy binding's
      members.
  """

  groupEdges = _messages.MessageField('GoogleCloudAssetV1p4beta1Edge', 1, repeated=True)
  identities = _messages.MessageField('GoogleCloudAssetV1p4beta1Identity', 2, repeated=True)


class GoogleCloudAssetV1p4beta1Resource(_messages.Message):
  r"""A GCP resource that appears in an access control list.

  Fields:
    analysisState: The analysis state of this resource node.
    fullResourceName: The [full resource name](https://aip.dev/122#full-
      resource-names).
  """

  analysisState = _messages.MessageField('GoogleCloudAssetV1p4beta1AnalysisState', 1)
  fullResourceName = _messages.StringField(2)


class IamPolicyAnalysis(_messages.Message):
  r"""An analysis message to group the query and results.

  Fields:
    analysisQuery: The analysis query.
    analysisResults: A list of IamPolicyAnalysisResult that matches the
      analysis query, or empty if no result is found.
    fullyExplored: Represents whether all entries in the analysis_results have
      been fully explored to answer the query.
  """

  analysisQuery = _messages.MessageField('IamPolicyAnalysisQuery', 1)
  analysisResults = _messages.MessageField('IamPolicyAnalysisResult', 2, repeated=True)
  fullyExplored = _messages.BooleanField(3)


class IamPolicyAnalysisOutputConfig(_messages.Message):
  r"""Output configuration for export IAM policy analysis destination.

  Fields:
    gcsDestination: Destination on Cloud Storage.
  """

  gcsDestination = _messages.MessageField('GcsDestination', 1)


class IamPolicyAnalysisQuery(_messages.Message):
  r"""IAM policy analysis query message.

  Fields:
    accessSelector: Optional. Specifies roles or permissions for analysis.
      Leaving it empty means ANY.
    identitySelector: Optional. Specifies an identity for analysis. Leaving it
      empty means ANY.
    parent: Required. The relative name of the root asset. Only resources and
      IAM policies within the parent will be analyzed. This can only be an
      organization number (such as "organizations/123") or a folder number
      (such as "folders/123").
    resourceSelector: Optional. Specifies a resource for analysis. Leaving it
      empty means ANY.
  """

  accessSelector = _messages.MessageField('AccessSelector', 1)
  identitySelector = _messages.MessageField('IdentitySelector', 2)
  parent = _messages.StringField(3)
  resourceSelector = _messages.MessageField('ResourceSelector', 4)


class IamPolicyAnalysisResult(_messages.Message):
  r"""IAM Policy analysis result, consisting of one IAM policy binding and
  derived access control lists.

  Fields:
    accessControlLists: The access control lists derived from the iam_binding
      that match or potentially match resource and access selectors specified
      in the request.
    attachedResourceFullName: The full name of the resource to which the
      iam_binding policy attaches.
    fullyExplored: Represents whether all nodes in the transitive closure of
      the iam_binding node have been explored.
    iamBinding: The Cloud IAM policy binding under analysis.
    identityList: The identity list derived from members of the iam_binding
      that match or potentially match identity selector specified in the
      request.
  """

  accessControlLists = _messages.MessageField('GoogleCloudAssetV1p4beta1AccessControlList', 1, repeated=True)
  attachedResourceFullName = _messages.StringField(2)
  fullyExplored = _messages.BooleanField(3)
  iamBinding = _messages.MessageField('Binding', 4)
  identityList = _messages.MessageField('GoogleCloudAssetV1p4beta1IdentityList', 5)


class IdentitySelector(_messages.Message):
  r"""Specifies an identity for which to determine resource access, based on
  roles assigned either directly to them or to the groups they belong to,
  directly or indirectly.

  Fields:
    identity: Required. The identity appear in the form of members in [IAM
      policy binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
  """

  identity = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Options(_messages.Message):
  r"""Contains request options.

  Fields:
    analyzeServiceAccountImpersonation: Optional. If true, the response will
      include access analysis from identities to resources via service account
      impersonation. This is a very expensive operation, because many derived
      queries will be executed.  For example, if the request analyzes for
      which resources user A has permission P, and there's an IAM policy
      states user A has iam.serviceAccounts.getAccessToken permission to a
      service account SA, and there's another IAM policy states service
      account SA has permission P to a GCP folder F, then user A potentially
      has access to the GCP folder F. And those advanced analysis results will
      be included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
      Another example, if the request analyzes for who has permission P to a
      GCP folder F, and there's an IAM policy states user A has
      iam.serviceAccounts.actAs permission to a service account SA, and
      there's another IAM policy states service account SA has permission P to
      the GCP folder F, then user A potentially has access to the GCP folder
      F. And those advanced analysis results will be included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
      Default is false.
    expandGroups: Optional. If true, the identities section of the result will
      expand any Google groups appearing in an IAM policy binding.  If
      identity_selector is specified, the identity in the result will be
      determined by the selector, and this flag will have no effect.  Default
      is false.
    expandResources: Optional. If true, the resource section of the result
      will expand any resource attached to an IAM policy to include resources
      lower in the resource hierarchy.  For example, if the request analyzes
      for which resources user A has permission P, and the results include an
      IAM policy with P on a GCP folder, the results will also include
      resources in that folder with permission P.  If resource_selector is
      specified, the resource section of the result will be determined by the
      selector, and this flag will have no effect. Default is false.
    expandRoles: Optional. If true, the access section of result will expand
      any roles appearing in IAM policy bindings to include their permissions.
      If access_selector is specified, the access section of the result will
      be determined by the selector, and this flag will have no effect.
      Default is false.
    outputGroupEdges: Optional. If true, the result will output group identity
      edges, starting from the binding's group members, to any expanded
      identities. Default is false.
    outputResourceEdges: Optional. If true, the result will output resource
      edges, starting from the policy attached resource, to any expanded
      resources. Default is false.
  """

  analyzeServiceAccountImpersonation = _messages.BooleanField(1)
  expandGroups = _messages.BooleanField(2)
  expandResources = _messages.BooleanField(3)
  expandRoles = _messages.BooleanField(4)
  outputGroupEdges = _messages.BooleanField(5)
  outputResourceEdges = _messages.BooleanField(6)


class ResourceSelector(_messages.Message):
  r"""Specifies the resource to analyze for access policies, which may be set
  directly on the resource, or on ancestors such as organizations, folders or
  projects. At least one of ResourceSelector, IdentitySelector or
  AccessSelector must be specified in a request.

  Fields:
    fullResourceName: Required. The [full resource name](https://cloud.google.
      com/apis/design/resource_names#full_resource_name) .
  """

  fullResourceName = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
