(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/signal#kill
    (lambda (_pid145330_ _signo145331_)
      (let ((_r145333_ (std/os/signal#_kill _pid145330_ _signo145331_)))
        (if (not (##fxnegative? _r145333_))
            _r145333_
            (std/os/error#raise-os-error
             (##fx- _r145333_)
             std/os/signal#kill
             _pid145330_
             _signo145331_)))))
  (define std/os/signal#sigprocmask
    (lambda (_how145323_ _sigset145324_ _old-sigset145325_)
      (let ((_r145327_
             (std/os/signal#_sigprocmask
              _how145323_
              _sigset145324_
              _old-sigset145325_)))
        (if (not (##fxnegative? _r145327_))
            _r145327_
            (std/os/error#raise-os-error
             (##fx- _r145327_)
             std/os/signal#sigprocmask
             _how145323_
             _sigset145324_
             _old-sigset145325_)))))
  (define-cond-expand-feature bsd)
  (define-cond-expand-feature openbsd)
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (c-declare "#include <stdlib.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace
   ("std/os/signal#"
    _kill
    _sigprocmask
    make_sigset
    sigemptyset
    sigfillset
    sigaddset
    sigdelset
    sigismember))
  (c-declare "#include <sys/types.h>")
  (c-declare "#include <signal.h>")
  (c-declare "#include <errno.h>")
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args))) (if (##fx< r 0) (##fx- (__errno)) r))))
  (namespace
   ("std/os/signal#"
    SIGHUP
    SIGINT
    SIGQUIT
    SIGILL
    SIGTRAP
    SIGABRT
    SIGBUS
    SIGFPE
    SIGKILL
    SIGUSR1
    SIGSEGV
    SIGUSR2
    SIGPIPE
    SIGALRM
    SIGTERM
    SIGCHLD
    SIGCONT
    SIGSTOP
    SIGTSTP
    SIGTTIN
    SIGTTOU
    SIGURG
    SIGXCPU
    SIGXFSZ
    SIGVTALRM
    SIGPROF
    SIGWINCH
    SIGIO
    SIGSYS
    SIGSTKFLT
    SIGPOLL
    SIGPWR
    SIGIOT
    SIGRTMIN
    SIGRTMAX
    SIGEMT
    SIGINFO
    NSIG
    SIGTHR
    SIGPWR
    SIG_BLOCK
    SIG_UNBLOCK
    SIG_SETMASK
    __kill
    __sigprocmask
    __errno))
  (define-c-lambda __errno () int "___return (errno);")
  (define-const SIGHUP)
  (define-const SIGINT)
  (define-const SIGQUIT)
  (define-const SIGILL)
  (define-const SIGTRAP)
  (define-const SIGABRT)
  (define-const SIGBUS)
  (define-const SIGFPE)
  (define-const SIGKILL)
  (define-const SIGUSR1)
  (define-const SIGSEGV)
  (define-const SIGUSR2)
  (define-const SIGPIPE)
  (define-const SIGALRM)
  (define-const SIGTERM)
  (define-const SIGCHLD)
  (define-const SIGCONT)
  (define-const SIGSTOP)
  (define-const SIGTSTP)
  (define-const SIGTTIN)
  (define-const SIGTTOU)
  (define-const SIGURG)
  (define-const SIGXCPU)
  (define-const SIGXFSZ)
  (define-const SIGVTALRM)
  (define-const SIGPROF)
  (define-const SIGWINCH)
  (define-const SIGIO)
  (define-const SIGSYS)
  (define-const SIG_BLOCK)
  (define-const SIG_UNBLOCK)
  (define-const SIG_SETMASK)
  (cond-expand
   (linux (define-const SIGIOT)
          (define-const SIGSTKFLT)
          (define-const SIGPOLL)
          (define-const SIGPWR)
          (define-const SIGRTMIN)
          (define-const SIGRTMAX))
   (bsd (define-const SIGEMT) (define-const SIGINFO) (define-const NSIG)))
  (cond-expand
   (openbsd (define-const SIGTHR))
   (netbsd (define-const SIGPWR))
   (freebsd)
   (darwin)
   (linux))
  (define-c-lambda __kill (int int) int "kill")
  (define-with-errno _kill __kill (pid signo))
  (define-guard ffi-have-sigset (c-define-type sigset_t "sigset_t"))
  (define-guard
   ffi-have-sigset*
   (c-define-type sigset_t* (pointer "sigset_t" (sigset_t*) "ffi_free")))
  (define-c-lambda __sigprocmask (int sigset_t* sigset_t*) int "sigprocmask")
  (define-with-errno _sigprocmask __sigprocmask (how sigset old-sigset))
  (define-c-lambda
   make_sigset
   ()
   sigset_t*
   "___return ((sigset_t*) malloc (sizeof (sigset_t))); ")
  (define-c-lambda sigemptyset (sigset_t*) int)
  (define-c-lambda sigfillset (sigset_t*) int)
  (define-c-lambda sigaddset (sigset_t* int) int)
  (define-c-lambda sigdelset (sigset_t* int) int)
  (define-c-lambda sigismember (sigset_t* int) int)
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif")
  (define std/os/signal#SIGMAX std/os/signal#NSIG))
