export default class JavaScriptREPL{static wrapObjectLiteral(code){if(!(/^\s*\{/.test(code)&&/\}\s*$/.test(code))){return code;}
const parse=(async()=>0).constructor;try{parse('return '+code+';');const wrappedCode='('+code+')';parse(wrappedCode);return wrappedCode;}catch(e){return code;}}
static async preprocessExpression(text){text=JavaScriptREPL.wrapObjectLiteral(text);let preprocessed=false;if(text.indexOf('await')!==-1){const preprocessedText=await Formatter.formatterWorkerPool().preprocessTopLevelAwaitExpressions(text);preprocessed=!!preprocessedText;text=preprocessedText||text;}
return{text,preprocessed};}
static async evaluateAndBuildPreview(text,throwOnSideEffect,timeout,allowErrors,objectGroup){const executionContext=UI.context.flavor(SDK.ExecutionContext);const isTextLong=text.length>ObjectUI.JavaScriptREPL._MaxLengthForEvaluation;if(!text||!executionContext||(throwOnSideEffect&&isTextLong)){return{preview:createDocumentFragment(),result:null};}
const wrappedResult=await JavaScriptREPL.preprocessExpression(text);const options={expression:wrappedResult.text,generatePreview:true,includeCommandLineAPI:true,throwOnSideEffect:throwOnSideEffect,timeout:timeout,objectGroup:objectGroup,disableBreaks:true};const result=await executionContext.evaluate(options,false,wrappedResult.preprocessed);const preview=JavaScriptREPL._buildEvaluationPreview(result,allowErrors);return{preview,result};}
static _buildEvaluationPreview(result,allowErrors){const fragment=createDocumentFragment();if(result.error){return fragment;}
if(result.exceptionDetails&&result.exceptionDetails.exception&&result.exceptionDetails.exception.description){const exception=result.exceptionDetails.exception.description;if(exception.startsWith('TypeError: ')||allowErrors){fragment.createChild('span').textContent=result.exceptionDetails.text+' '+exception;}
return fragment;}
const formatter=new ObjectUI.RemoteObjectPreviewFormatter();const{preview,type,subtype,description}=result.object;if(preview&&type==='object'&&subtype!=='node'){formatter.appendObjectPreview(fragment,preview,false);}else{const nonObjectPreview=formatter.renderPropertyPreview(type,subtype,description.trimEndWithMaxLength(400));fragment.appendChild(nonObjectPreview);}
return fragment;}}
export const _MaxLengthForEvaluation=2000;self.ObjectUI=self.ObjectUI||{};ObjectUI=ObjectUI||{};ObjectUI.JavaScriptREPL=JavaScriptREPL;ObjectUI.JavaScriptREPL._MaxLengthForEvaluation=_MaxLengthForEvaluation;