/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.util.component.ApiMethod;

public final class ApiMethodImpl
implements ApiMethod {
    private final String name;
    private final Class<?> resultType;
    private final List<String> argNames;
    private final List<Class<?>> argTypes;
    private final Method method;

    public ApiMethodImpl(Class<?> proxyType, Class<?> resultType, String name, Object ... args) throws IllegalArgumentException {
        this.name = name;
        this.resultType = resultType;
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid parameter list, must be of the form 'Class arg1, String arg1Name, Class arg2, String arg2Name...");
        }
        int nArgs = args.length / 2;
        this.argNames = new ArrayList<String>(nArgs);
        this.argTypes = new ArrayList(nArgs);
        for (int i = 0; i < nArgs; ++i) {
            this.argTypes.add((Class)args[i * 2]);
            this.argNames.add((String)args[i * 2 + 1]);
        }
        try {
            this.method = proxyType.getMethod(name, this.argTypes.toArray(new Class[nArgs]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Missing method %s %s", name, this.argTypes.toString().replace('[', '(').replace(']', ')')), e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getResultType() {
        return this.resultType;
    }

    @Override
    public List<String> getArgNames() {
        return Collections.unmodifiableList(this.argNames);
    }

    @Override
    public List<Class<?>> getArgTypes() {
        return Collections.unmodifiableList(this.argTypes);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("name=").append(this.name).append(", resultType=").append(this.resultType).append(", argNames=").append(this.argNames).append(", argTypes=").append(this.argTypes).append("}");
        return builder.toString();
    }
}

