get_filename_component(myDir ${CMAKE_CURRENT_LIST_FILE} PATH) # get the directory where I myself am
get_filename_component(rootDir ${myDir}/ ABSOLUTE) # get the chosen install prefix

# set the version of myself
set(KACTIVITIES_VERSION_MAJOR 6)
set(KACTIVITIES_VERSION_MINOR 2)
set(KACTIVITIES_VERSION_PATCH 0)
set(KACTIVITIES_VERSION 6.2.0)
set(KACTIVITIES_VERSION_STRING "6.2.0")

# what is my include directory
# we have _DIRS for compat with existing usage
SET(KACTIVITIES_INCLUDE_DIRS "include/kde4" "include/kde4/KDE" CACHE PATH "Include path for the KActivities library")
set(KACTIVITIES_INCLUDES "${rootDir}/include/kde4" "include/kde4/KDE")
set(KACTIVITIES_ONTOLOGIES_DIR "/usr/local/share/ontology/kde")

# import the exported targets
include(${myDir}/KActivitiesLibraryTargets.cmake)

# set the expected library variable
# XXX: only KACTIVITIES_LIBRARIES should be used according to CMake's conventions,
#      KACTIVITIES_LIBRARY is kept for compatibility with all the places using it.
set(KACTIVITIES_LIBRARY kactivities)
set(KACTIVITIES_LIBRARIES kactivities)
