local lang = {
  ["abort"] = "Abort",
  ["actions"] = "Actions",
  ["activities"] = "Activities",
  ["activity"] = "Activity",
  ["advanced"] = "Advanced",
  ["aggregation"] = "Aggregation",
  ["all"] = "All",
  ["allowed"] = "Allowed",
  ["any"] = "any",
  ["application"] = "Application",
  ["application_protocol"] = "Application Protocol",
  ["applications"] = "Applications",
  ["apply"] = "Apply",
  ["arp"] = "ARP",
  ["as"] = "AS",
  ["as_number"] = "AS number",
  ["asn"] = "ASN",
  ["backup"] = "Backup",
  ["begin"] = "Begin",
  ["breakdown"] = "Breakdown",
  ["bridge"] = "Bridge",
  ["broadcast_traffic"] = "Broadcast Traffic",
  ["bytes"] = "Bytes",
  ["cancel"] = "Cancel",
  ["categories"] = "Categories",
  ["category"] = "Category",
  ["change_number_of_rows"] = "Change the number of rows per page",
  ["chart"] = "Chart",
  ["client"] = "Client",
  ["clone"] = "Clone",
  ["close"] = "Close",
  ["countries"] = "Countries",
  ["date_from"] = "Begin Date/Time:",
  ["date_to"] = "End Date/Time:",
  ["day"] = "Day",
  ["define"] = "Define",
  ["delete"] = "Delete",
  ["destination"] = "Destination",
  ["device_protocols_description"] = "In this page it is possible to configure the list of acceptable application protocols per device type and direction (device as client or server with respect to the application protocol). By enabling Device Protocols Alerts in the Alerts configuration page under Preferences, alerts are generated when an anomalous protocol is detected.",
  ["difference"] = "Difference",
  ["disabled"] = "Disabled",
  ["dns"] = "DNS",
  ["download"] = "Download",
  ["download_x"] = "%{what} download",
  ["downloaders"] = "Download Volume",
  ["duration"] = "Duration",
  ["egress"] = "Egress",
  ["empty"] = "Empty",
  ["end"] = "End",
  ["enterpriseOnly"] = "This feature is only available in the ntopng Enterprise edition",
  ["error"] = "Error",
  ["error_no_search_results"] = "No results found. Please modify your search criteria.",
  ["error_rrd_cannot_complete_dump"] = "Cannot complete local hosts RRD dump. Disk slow or too many local hosts?",
  ["error_rrd_low_resolution"] = "You are asking to fetch data at lower resolution than the one available on RRD, which will lead to invalid data.<br>If you still want data with such granularity, please tune <a href=\"%{prefs}\">Protocol/Networks Timeseries</a> preferences",
  ["flow"] = "Flow",
  ["flow_search_criteria"] = "Flow Search Criteria",
  ["flow_search_from_aggregated"] = "(Aggregated)",
  ["flow_search_results"] = "Flow Search Results",
  ["flows"] = "Flows",
  ["forbidden"] = "Forbidden",
  ["free"] = "Free",
  ["from"] = "from",
  ["gateway"] = "Gateway",
  ["host"] = "Host %{host}",
  ["hosts"] = "Hosts",
  ["hour"] = "Hour",
  ["http"] = "HTTP",
  ["icmp"] = "ICMP",
  ["incomingflows"] = "Incoming Flows Count",
  ["info"] = "Info",
  ["ingress"] = "Ingress",
  ["interface"] = "Interface",
  ["interface_ifname"] = "Interface %{ifname}",
  ["interfaces"] = "Interfaces",
  ["ip_address"] = "IP Address",
  ["ipv4"] = "IPv4",
  ["ipv6"] = "IPv6",
  ["key"] = "Key",
  ["l4_protocol"] = "L4 Protocol",
  ["l4_protocols"] = "L4 Protocols",
  ["l7_protocol"] = "L7 Protocol",
  ["l7_protocols"] = "L7 Protocols",
  ["language"] = "Language",
  ["layer_2"] = "Mac Addresses",
  ["legenda"] = "Legenda",
  ["local_traffic"] = "Local Traffic",
  ["mac_address"] = "Mac Address",
  ["max_rate"] = "Max Rate",
  ["model"] = "Model",
  ["month"] = "Month",
  ["mtu"] = "MTU",
  ["name"] = "Name",
  ["netmask"] = "Netmask",
  ["networks"] = "Networks",
  ["next"] = "Next",
  ["no"] = "No",
  ["noTraffic"] = "No traffic has been reported for the specified date/time selection",
  ["no_data_available"] = "No Data Available",
  ["no_results_found"] = "No results found",
  ["no_talkers_for_the_host"] = "There are no talkers for the current host",
  ["note_flow_search_allowed_networks"] = "Current user is only allowed to browse the following networks: %{nets}.",
  ["note_flow_search_allowed_networks_applications"] = "Hosts not belonging to any of the allowed networks will be hidden from the application talkers.",
  ["note_flow_search_allowed_networks_counter"] = "Counters in the flow search results are total but only flows with client and server in allowed networks will be shown.",
  ["note_flow_search_allowed_networks_ipv6"] = "Non-zero allowed IPv6 networks will cause all IPv6 flows from being shown.",
  ["note_flow_search_allowed_networks_talkers"] = "Hosts not belonging to any of the allowed networks will be hidden from the top talkers.",
  ["notes"] = "NOTES:",
  ["operating_systems"] = "Operating Systems",
  ["os"] = "OS",
  ["other"] = "Other",
  ["outgoingflows"] = "Outgoing Flows Count",
  ["overview"] = "Overview",
  ["packets"] = "Packets",
  ["peers"] = "Peers",
  ["percentage"] = "Percentage",
  ["pkts"] = "Pkts",
  ["port"] = "Port",
  ["ports"] = "Ports",
  ["previous"] = "Previous",
  ["protocol"] = "Protocol",
  ["protocol_categories"] = "Protocol Categories",
  ["protocols"] = "Protocols",
  ["purged_error_message"] = "Very likely it is expired and %{product} has purged it from memory. You can set purge idle timeout settings from the <a href=\"%{url}\"><i class=\"fa fa-flask\"></i> Preferences</a>.",
  ["quotas"] = "Quotas",
  ["reason"] = "Reason",
  ["received"] = "Received",
  ["refresh"] = "Refresh",
  ["remote_networks"] = "Remote Networks",
  ["remove"] = "Remove",
  ["reset"] = "Reset",
  ["restore"] = "Restore",
  ["retry"] = "Retry",
  ["running"] = "Running",
  ["save"] = "Save",
  ["save_configuration"] = "Save Configuration",
  ["save_settings"] = "Save Settings",
  ["search_host"] = "Search",
  ["seen_since"] = "Seen Since",
  ["sent"] = "Sent",
  ["server"] = "Server",
  ["showing_x_to_y_rows"] = "Showing %{x} to %{y} of %{tot} rows",
  ["similarity"] = "Similarity",
  ["speed"] = "Speed",
  ["ssl_certificate"] = "SSL Certificate",
  ["start"] = "Start",
  ["status"] = "Status",
  ["stop"] = "Stop",
  ["summary"] = "Summary",
  ["system"] = "System",
  ["talkers"] = "Talkers",
  ["tcp_flags"] = "TCP Flags",
  ["tcp_stats"] = "TCP Statistics",
  ["throughput"] = "Throughput",
  ["time"] = "Time",
  ["timeframe"] = "Timeframe",
  ["today"] = "Today",
  ["total"] = "Total",
  ["traffic"] = "Traffic",
  ["traffic_policy"] = "Traffic Policy",
  ["undo"] = "Undo",
  ["unknowers"] = "Unknown Traffic Volume",
  ["unknown"] = "Unknown",
  ["unlimited"] = "&infin;",
  ["uploaders"] = "Upload Volume",
  ["version"] = "Your version is %{vers}.",
  ["via"] = "Via",
  ["vlan"] = "VLAN",
  ["warning"] = "Warning",
  ["week"] = "Week",
  ["welcome"] = "Welcome",
  ["welcome_to"] = "Welcome to %{product}",
  ["yes"] = "Yes",
  ["about"] = {
    ["about"] = "About",
    ["about_ntopng"] = "About ntopng",
    ["about_x"] = "About %{product}",
    ["built_on"] = "Built on",
    ["copyright"] = "Copyright",
    ["cpu_load"] = "CPU load",
    ["datadir_warning"] = "Data directory migration notice",
    ["last_log"] = "Last Log Trace",
    ["licence"] = "License",
    ["licence_expires_in"] = "License expires in %{time}",
    ["licence_generation"] = "Click on the above URL to generate your professional version license, or <br>purchase a license at <a href=\"%{purchase_url}\">e-shop</a>. If you are no-profit, research or an education<br>institution please read <a href=\"%{universities_url}\">this</a>.",
    ["maintenance_expired"] = "%{product} maintenance is expired",
    ["maxmind"] = "This product includes GeoLite data created by <a href=\"%{maxmind_url}\">MaxMind</a>.",
    ["ntop_blog"] = "ntop Blog",
    ["platform"] = "Platform",
    ["ram_memory"] = "RAM",
    ["readme_and_manual"] = "User's Guide",
    ["report_issue"] = "Report an Issue",
    ["runtime_status"] = "Runtime Status",
    ["save_licence"] = "Save Licence",
    ["specify_licence"] = "Specify here your ntopng License",
    ["startup_line"] = "Startup Line",
    ["system_id"] = "System Id",
    ["telegram"] = "Help and News",
    ["upgrade_to_professional"] = "Upgrade to Professional version",
    ["uptime"] = "Uptime",
    ["version"] = "Version",
    ["you_have_too_many_flows"] = "You have too many hosts/flows for your %{product} configuration and this will lead to packet drops and high CPU load. Please restart %{product} increasing -x and -X",
  },
  ["activities_page"] = {
    ["host_activity"] = "Host Activity",
  },
  ["alert_messages"] = {
    ["a_new_device_has_connected"] = "New device <a href=\"%{url}\">%{device}</a> has connected to the network.",
    ["device_has_connected"] = "The device <a href=\"%{url}\">%{device}</a> has connected to the network.",
    ["device_has_disconnected"] = "The device <a href=\"%{url}\">%{device}</a> has disconnected from the network.",
    ["host_entity"] = "host %{entity_value}",
    ["host_pool_has_connected"] = "The host pool <a href=\"%{url}\">%{pool}</a> has connected to the network.",
    ["host_pool_has_disconnected"] = "The host pool <a href=\"%{url}\">%{pool}</a> has disconnected from the network.",
    ["host_remote_to_remote"] = "Remote host <a href=\"%{url}\">%{ip}</a> [ <a href=\"%{mac_url}\">%{mac}</a> ] has contacted a remote host. Remote-to-remote flows available from the <a href=\"%{flow_alerts_url}\">flow alerts page</a>.",
    ["influxdb_partial_write"] = "This can be fixed by setting \"max-values-per-tag = 0\" in the InfluxDB server config.",
    ["influxdb_write_error"] = "There was an error while sending timeseries data to \"%{influxdb}\": %{err}",
    ["interface_entity"] = "interface %{entity_value}",
    ["mac_ip_association_change"] = "IP %{ip} changed association from <a href=\"%{old_mac_url}\">%{old_mac}</a> to <a href=\"%{new_mac_url}\">%{new_mac}</a>",
    ["network_entity"] = "network %{entity_value}",
    ["nfq_flushed"] = "Interface <a href=\"%{url}\">%{name}</a> packets queue flushed. Queue %{pct}%% full with %{tot} packets and %{dropped} drops.",
    ["ntopng_anomalous_termination"] = "Started after anomalous termination (<a href=\"%{url}\">bug report</a>)",
    ["ntopng_start"] = "Started",
    ["ntopng_stop"] = "Stopped",
    ["open_files_limit_too_small"] = "Ntopng detected that the maximum number of files MySQL can open is potentially too small. This can result in flow data loss due to errors such as [Out of resources when opening file './ntopng/flowsv6#P#p22.MYD' (Errcode: 24 - Too many open files)][23]. Make sure to increase open_files_limit or, if you just want to ignore this warning, disable the check from the preferences.",
    ["proto_bytes_quotas"] = "%{proto} bytes",
    ["proto_time_quotas"] = "%{proto} time",
    ["subject_quota_exceeded"] = "Host pool <a href=\"%{url}\">%{pool}</a> exceeded %{subject} quota [%{value} &gt; %{quota}]",
    ["x_alerts"] = "%{num} alerts",
  },
  ["alerts_dashboard"] = {
    ["alert_counts"] = "Counts",
    ["alert_duration"] = "Duration",
    ["alert_severity"] = "Severity",
    ["alert_type"] = "Type",
    ["alerts_dashboard"] = "Alerts Dashboard",
    ["all_hosts"] = "All Hosts",
    ["blacklisted_flow"] = "Blacklisted Flow",
    ["blocked_flow"] = "Blocked Flow",
    ["custom_period"] = "Custom Period",
    ["device_connection"] = "Device Connection",
    ["device_disconnection"] = "Device Disconnection",
    ["engaged_for_longest"] = "Past Alerts Engaged for Longest",
    ["error"] = "Error",
    ["five_mins"] = "Last 5 Minutes",
    ["flow_alert_origins"] = "Flow Alert Origins",
    ["flow_alert_targets"] = "Flow Alert Targets",
    ["flow_misbehaviour"] = "Flow Misbehaviour",
    ["flows_flood"] = "Flows Flood",
    ["host_pool_connection"] = "Host Pool Connection",
    ["host_pool_disconnection"] = "Host Pool Disconnection",
    ["influxdb_export_failure"] = "InfluxDB Export Failure",
    ["info"] = "Info",
    ["interface_alerted"] = "Interface Alerted",
    ["involving_msg"] = "Flow Alerts Involving",
    ["last_day"] = "Last Day",
    ["last_hour"] = "Last Hour",
    ["last_minute"] = "Last Minute",
    ["local_only"] = "Local Hosts Only",
    ["local_origin_remote_target"] = "Local Origin - Remote Target",
    ["mac_ip_association_change"] = "IP/MAC Change",
    ["misconfigured_app"] = "Misconfigured App",
    ["new_device"] = "New Device",
    ["nfq_flushed"] = "Packets Queue Flushed",
    ["no_alert"] = "No Alert",
    ["no_alerts"] = "No alerts",
    ["none"] = "None",
    ["not_engaged"] = "Not engaged",
    ["one_day"] = "Last Day",
    ["one_hour"] = "Last Hour",
    ["one_min"] = "Last Minute",
    ["process"] = "Process",
    ["quota_exceeded"] = "Quota Exceeded",
    ["remote_only"] = "Remote Hosts Only",
    ["remote_origin_local_target"] = "Remote Origin - Local Target",
    ["remote_to_remote"] = "Remote to Remote",
    ["search_criteria"] = "Dashboard Settings",
    ["slow_stats_update"] = "Slow Statistics Update",
    ["snmp_device_is_unresponsive"] = "SNMP device <a href=\"%{url}\">%{device}</a> is unresponsive",
    ["snmp_port_changed_operational_status"] = "Interface <a href=\"%{port_url}\">%{port}</a> on SNMP device <a href=\"%{url}\">%{device}</a> changed its status to %{new_op}",
    ["snmp_port_status_change"] = "Interface Status Change",
    ["starting_on"] = "starting on",
    ["submit"] = "Update Dashboard",
    ["suspicious_activity"] = "Suspicious Activity",
    ["suspicious_device_protocol"] = "Suspicious Device Protocol",
    ["tcp_syn_flood"] = "TCP SYN Flood",
    ["threashold_cross"] = "Threshold Cross",
    ["too_many_drops"] = "Packet Drops",
    ["total_alerts"] = "Total Alerts",
    ["trailing_msg"] = "Time Window",
    ["unresponsive_device"] = "Unresponsive Device",
    ["user_activity"] = "User Activity",
    ["warning"] = "Warning",
    ["web_mining"] = "Web Mining",
  },
  ["alerts_thresholds_config"] = {
    ["active_local_hosts"] = "Local Hosts",
    ["active_local_hosts_threshold_descr"] = "Number of active local hosts",
    ["activity_time"] = "Activity Time",
    ["alert_active_description"] = "Activity time delta (seconds).",
    ["alert_bytes_description"] = "Layer 2 bytes delta (sent + received)",
    ["alert_dns_description"] = "Layer 2 bytes delta (sent + received) for DNS detected traffic",
    ["alert_flows_description"] = "Flows delta (as client + as server)",
    ["alert_idle_description"] = "Idle time since last packet seen (seconds)",
    ["alert_network_egress_description"] = "Egress Bytes delta",
    ["alert_network_ingress_description"] = "Ingress Bytes delta",
    ["alert_network_inner_description"] = "Inner Bytes delta",
    ["alert_p2p_description"] = "Layer 2 bytes delta (sent + received) for peer-to-peer detected traffic",
    ["alert_packets_description"] = "Packets delta (sent + received)",
    ["alert_throughput_description"] = "Average throughput (sent + received) [Mbps]",
    ["common_thresholds_local_sources"] = "%{source}s Common Thresholds",
    ["daily"] = "Daily",
    ["dns_traffic"] = "DNS Traffic",
    ["egress_traffic"] = "Egress Traffic",
    ["every_5_minutes"] = "Every 5 Minutes",
    ["every_minute"] = "Every Minute",
    ["hourly"] = "Hourly",
    ["idle_time"] = "Idle Time",
    ["ingress_traffic"] = "Ingress Traffic",
    ["inner_traffic"] = "Inner Traffic",
    ["note_attacker_victime_threshold"] = "An attacker/victim threshold is considered exceeded if the corresponding host has exceeded the configured threshold for at least three seconds when performing the periodic check.",
    ["note_checks_on_active_hosts"] = "Checks are only performed for active hosts. Setting a 'less-than' condition implies greater than zero.",
    ["note_consecutive_checks"] = "Consecutive checks are not necessarily performed on consecutive periods. For example, if an host goes idle, its thresholds will not be checked until it becomes active again.",
    ["note_control_threshold_checks_periods"] = "Thresholds listed in these tabs are checked periodically. Use tabs to control threshold checks periods.",
    ["note_deltas_of_idle_host_become_active"] = "Deltas of an idle host that becomes active again will be computed as the difference of the same quantity during the latest check and the most recent check performed when the host was active before going idle.",
    ["note_thresholds_expressed_as_delta"] = "Some thresholds are expressed as a delta. A delta is the difference of the same quantity between two consecutive checks.",
    ["notes"] = "NOTES",
    ["p2p_traffic"] = "P2P Traffic",
    ["threshold_type"] = "Threshold Type",
    ["thresholds_single_source"] = "%{source} %{alt_name} Thresholds",
    ["throughput"] = "Throughput",
  },
  ["arp_page"] = {
    ["arp_type"] = "ARP Type",
  },
  ["as_details"] = {
    ["as"] = "Autonomous System",
    ["as_parameter_missing_message"] = "Autonomous System parameter is missing (internal error?)",
    ["as_timeseries_enable_message"] = "AS timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
    ["no_available_data_for_as"] = "No available data for AS %{asn}.",
  },
  ["as_stats"] = {
    ["autonomous_systems"] = "Autonomous Systems",
  },
  ["categories_page"] = {
    ["search_application"] = "Search Protocol",
    ["target"] = "Target",
  },
  ["conf_backup"] = {
    ["conf_backup"] = "Backup Configuration",
    ["conf_restore"] = "Restore Configuration",
  },
  ["contacts_page"] = {
    ["client_address"] = "Client Address",
    ["client_contacts_initiator"] = "Client Contacts (Initiator)",
    ["contacts"] = "Contacts",
    ["no_client_contacts_so_far"] = "No client contacts so far",
    ["no_contacts_message"] = "No contacts for this host",
    ["no_server_contacts_so_far"] = "No server contacts so far",
    ["server_address"] = "Server Address",
    ["server_contacts_receiver"] = "Server Contacts (Receiver)",
  },
  ["country_details"] = {
    ["country"] = "Country",
    ["country_parameter_missing_message"] = "Country parameter is missing (internal error?)",
    ["no_available_stats_for_country"] = "No available stats for country %{country}",
  },
  ["country_stats"] = {
    ["hosts_by_country"] = "Hosts by Country",
  },
  ["custom_categories"] = {
    ["add"] = "Add",
    ["add_to_categories"] = "Add to Categories",
    ["custom_host_category"] = "Custom Host Category",
    ["custom_hosts"] = "Custom Hosts",
    ["domain_names_substrings"] = "Domain names are interpreted as substring to be matched.<br>E.g. \"%{s1}\" will match \"%{s2}\" and \"%{s3}\"",
    ["each_host_separate_line"] = "Each host must be put on a separate line",
    ["edit_category_hosts"] = "Edit Custom Hosts",
    ["edit_hosts"] = "Edit Hosts",
    ["host_domain_or_cidr"] = "Hosts can be either domain names or IPv4 addresses/CIDR network addresses",
    ["select_url_category"] = "Please select the category to assign the domain to:",
    ["similar_host_found"] = "a host similar to \"%{host}\" is already contained into the %{category} category",
    ["the_following_is_a_list_of_hosts"] = "The following is a list of custom hosts for the %{category} category",
    ["the_following_url_will_be_added"] = "The following domain will be added:",
  },
  ["dashboard"] = {
    ["actual_traffic"] = "Actual Traffic",
    ["lastday_app_traffic"] = "Top Application Traffic Last Day View",
    ["lastday_traffic"] = "Network Interfaces: Last Day View",
    ["realtime_app_traffic"] = "Realtime Top Application Traffic",
    ["realtime_traffic"] = "Network Interfaces: Realtime Traffic",
    ["top_local_talkers"] = "Top Local Talkers",
    ["top_remote_destinations"] = "Top Remote Destinations",
    ["traffic_dashboard"] = "Traffic Dashboard",
  },
  ["db_explorer"] = {
    ["abort"] = "Abort",
    ["all"] = "all",
    ["app_between_talkers_pairs"] = "applications between pairs of talkers",
    ["app_flows_between"] = "%{app} application flows between %{peer1} and %{peer2}",
    ["app_talkers"] = "%{app} talkers",
    ["app_talkers_with"] = "%{app} talkers with %{peer}",
    ["application_flows"] = "Application flows",
    ["application_protocol"] = "Application Protocol",
    ["applications_between"] = "Applications between %{peer1} and %{peer2}",
    ["average_throughput"] = "Avg Thpt",
    ["client_server_breakdown"] = "Client vs Server Traffic Breakdown",
    ["client_server_host"] = "Client/Server Host",
    ["dns_query"] = "DNS Query",
    ["download_flows"] = "Download flows",
    ["download_flows_limit"] = "Maximum 1000 records.",
    ["empty_query_response"] = "Empty query response (database down or query killed/timed out?)",
    ["extract_pcap"] = "Extract pcap",
    ["filter_bpf"] = "Filter (BPF)",
    ["first_last_seen"] = "First / Last Seen",
    ["flow_peers"] = "Flow Peers",
    ["get_proto_talkers"] = "Get Talkers using this protocol",
    ["historical_data_explorer"] = "Historical Data Explorer",
    ["host_name"] = "Host Name",
    ["host_talkers"] = "%{host} talkers",
    ["hosts_talking_proto_with"] = "Hosts talking %{proto} with {host}",
    ["http_host"] = "HTTP Host",
    ["http_method"] = "HTTP Method",
    ["interface_name"] = "Instance Name",
    ["l4_proto"] = "L4 Proto",
    ["last_hour_flows"] = "Flows seen in the last hour",
    ["ms_client"] = "%{client} ms (client)",
    ["ms_server"] = "%{server} ms (server)",
    ["network_latency_breakdown"] = "Network Latency Breakdown",
    ["observation_period"] = "Observation Period",
    ["ok_request_sent"] = "OK, request sent",
    ["packet_rate"] = "Average Packet Rate",
    ["pcap_requests_and_status"] = "Pcap Requests and Statuses",
    ["pcaps"] = "Pcaps",
    ["protocol_flows_between"] = "%{proto} protocol flows between %{peer1} and %{peer2}",
    ["protocol_id"] = "Protocol id",
    ["query_in_progress"] = "Database query in progress, waiting to receive results...",
    ["request_failed"] = "Request failed",
    ["response_code"] = "Response Code",
    ["search_flows"] = "Search Flows",
    ["selected_saved"] = "Select saved",
    ["server_name"] = "Server Name",
    ["summary"] = "Summary",
    ["talkers_with_this_host"] = "Talkers with this host",
    ["task_id"] = "Task Id",
    ["this_flow_has_been_reset"] = "This flow has been reset and probably the server application is down",
    ["this_flow_is_active"] = "This flow is active",
    ["this_flow_is_completed"] = "This flow is completed and will soon expire",
    ["top_flows_ipv4"] = "Top IPv4 Flows [%{date_from} - %{date_to}]",
    ["top_flows_ipv6"] = "Top IPv6 Flows [%{date_from} - %{date_to}]",
    ["top_proto_ipv4_flows"] = "Top %{proto} IPv4 Flows",
    ["top_proto_ipv6_flows"] = "Top %{proto} IPv6 Flows",
    ["total_flows"] = "Total Flows",
    ["total_packets"] = "Total Packets",
    ["total_traffic"] = "Bytes Total",
    ["traffic_rate"] = "Average Traffic Rate",
    ["traffic_received"] = "Bytes Received",
    ["traffic_sent"] = "Bytes Sent",
    ["traffic_sent_to_cli"] = "Bytes Sent to Clients",
    ["traffic_sent_to_srv"] = "Bytes Sent to Servers",
    ["traffic_volume"] = "Traffic Volume",
    ["unable_to_find_flow"] = "Unable to find the specified flow",
    ["unsave"] = "Remove",
    ["vlan_id"] = "VLAN Id",
  },
  ["delete_data"] = {
    ["delete_active_interface_confirmation"] = "Are you sure you want to delete all the persistent data associated to %{ifname}? Data deletion will be performed upon %{product} restart. Restart %{product} to make the deletion effective.",
    ["delete_active_interface_data_failed"] = "Unable to delete active interface data.",
    ["delete_active_interface_data_ok"] = "Data for %{ifname} has successfully been marked for deletion. Restart %{product} to make the deletion effective.",
    ["delete_confirmation"] = "Are you sure you want to delete all persistent data for %{host}?",
    ["delete_failed"] = "Unable to delete data for %{host}.",
    ["delete_inactive_interfaces_confirmation"] = "The following interfaces are inactive:%{interfaces_list}Are you sure you want to delete all their persistent data?",
    ["delete_inactive_interfaces_data_failed"] = "Unable to delete inactive interfaces data.",
    ["delete_inactive_interfaces_data_ok"] = "Data for inactive interfaces successfully deleted.",
    ["delete_ok"] = "Data for %{host} has been successfully deleted.",
    ["msg_err_invalid_host"] = "The format of the specified host is not recognized.",
    ["msg_err_no_fs_data"] = "No persistent data found for the specified host.",
    ["msg_err_unable_to_delete_dir"] = "Unable to delete the data directory.",
    ["msg_err_unable_to_delete_ts_data"] = "Unable to delete timeseries data.",
    ["msg_err_unknown"] = "An unknown error occurred.",
    ["note_persistent_data"] = "All the persistent data is deleted. Data include stored timeseries, flows, alerts, and Redis caches.",
  },
  ["details"] = {
    ["additional_mac_address"] = "Additional MAC Address",
    ["address_resolution_protocol"] = "Address Resolution Protocol",
    ["ago"] = "ago",
    ["alerts"] = "Alerts",
    ["arp_replies"] = "ARP Replies",
    ["arp_requests"] = "ARP Requests",
    ["as_client"] = "As Client",
    ["as_server"] = "As Server",
    ["device_port"] = "Device Port",
    ["device_type"] = "Device Type",
    ["first_last_seen"] = "First / Last Seen",
    ["first_observed_on"] = "First Observed On",
    ["flow_snmp_localization"] = "Flow SNMP Localization",
    ["flows_dropped_by_bridge"] = "Flows Blocked due to Traffic Policies",
    ["flows_non_packet_iface"] = "Recently Active Flows / Total",
    ["flows_packet_iface"] = "Active Flows / Total Active / Low Goodput",
    ["flows_packet_pcap_dump_iface"] = "Flows / Total Active / Low Goodput",
    ["further_host_names_information"] = "Further Host Names/Information",
    ["goodput"] = "Goodput",
    ["host_pool"] = "Host Pool",
    ["host_snmp_localization"] = "SNMP Localization",
    ["input_device_port"] = "Device Input Port",
    ["keep_alive"] = "KeepAlive",
    ["l4_proto"] = "L4 Proto",
    ["label_blacklisted_host"] = "Blacklisted Host",
    ["label_local_host"] = "Local Host",
    ["label_private_ip"] = "Private IP",
    ["label_remote"] = "Remote",
    ["label_system_ip"] = "System IP",
    ["lost"] = "Lost",
    ["note"] = "NOTE",
    ["note_hosts_located_snmp_device"] = "Hosts are located in SNMP devices using the <A HREF=%{url}>Bridge MIB</A>.",
    ["out_of_order"] = "Out of Order",
    ["output_device_port"] = "Device Output Port",
    ["rcvd"] = "Rcvd",
    ["retransmissions"] = "Retransmissions",
    ["router_access_point_mac_address"] = "(Router/AccessPoint) MAC Address",
    ["sent_vs_received_traffic_breakdown"] = "Sent vs Received Traffic Breakdown",
    ["show_hosts"] = "Show Hosts",
    ["source_id"] = "Source Id",
    ["tcp_packets_sent_analysis"] = "TCP Packets Sent Analysis",
    ["total_traffic"] = "Total Traffic",
    ["traffic_sent_received"] = "Traffic Sent / Received",
    ["vlan_id"] = "VLAN ID",
    ["whois_lookup"] = "Whois Lookup",
  },
  ["device_protocols"] = {
    ["alert"] = "Trigger Alert",
    ["device_protocol_policy"] = "Device Protocol Policy",
    ["device_protocols"] = "Device Protocols",
    ["devtype_as_proto_client"] = "%{devtype} as <i>%{proto}</i> client",
    ["devtype_as_proto_server"] = "%{devtype} as <i>%{proto}</i> server",
    ["filter_device_protocols"] = "%{filter} Device Protocols",
    ["ok"] = "Acceptable",
  },
  ["device_types"] = {
    ["iot"] = "IoT",
    ["laptop"] = "Laptop",
    ["multimedia"] = "Multimedia",
    ["nas"] = "NAS",
    ["networking"] = "Router/Switch",
    ["phone"] = "Phone",
    ["printer"] = "Printer",
    ["tablet"] = "Tablet",
    ["tv"] = "TV",
    ["unknown"] = "Unknown",
    ["video"] = "Video",
    ["wifi"] = "Wireless Network",
    ["workstation"] = "Computer",
  },
  ["discover"] = {
    ["device"] = "Device",
    ["discovered_devices"] = "Discovered %{manuf} %{sys} %{dev} Devices",
    ["err_unable_to_arp_discovery"] = "Unable to start ARP network discovery",
    ["error_no_discovery_cached"] = "No discovery data has been cached yet.",
    ["error_unable_to_decode_json"] = "Unable to decode cache JSON discovery data.",
    ["ghost_icon_descr"] = "The %{ghost_icon} icon highlights ghost hosts (i.e. they do not belong to the interface IP address network)",
    ["network_discovery"] = "Network Discovery",
    ["network_discovery_datetime"] = "Last Network Discovery",
    ["network_discovery_not_enabled"] = "Network discovery in progress",
  },
  ["dns_page"] = {
    ["dns_breakdown"] = "DNS Breakdown",
    ["dns_query_sent_distribution"] = "DNS Query Sent Distribution",
    ["error_replies"] = "Error Replies",
    ["note"] = "NOTE",
    ["note_dns_ratio"] = "Ideally the request vs reply DNS ratio should be 1 (one reply per request). When much lower than that then there are issues worth to be investigated as it means that the number of replies received is much lower than expected and this can indicate that we are using unresponsive DNS resolvers or that they are misconfigured (e.g. they have been move to another IP).",
    ["positive_replies"] = "Positive Replies",
    ["queries"] = "Queries",
    ["ratio"] = "Ratio",
    ["rcvd"] = "Rcvd",
    ["replies"] = "Replies",
    ["reply_breakdown"] = "Reply Breakdown",
    ["request_vs_reply"] = "Request vs Reply",
  },
  ["entity_thresholds"] = {
    ["flow_attacker_description"] = "Max number of sent flows/sec over which a host is considered a flooder",
    ["flow_attacker_title"] = "Flow Flood Attacker",
    ["flow_victim_description"] = "Max number of received flows/sec over which a host is considered under flood attack",
    ["flow_victim_title"] = "Flow Flood Victim",
    ["syn_attacker_description"] = "Max number of sent TCP SYN packets/sec over which a host is considered a SYN flooder",
    ["syn_attacker_title"] = "SYN Flood Attacker",
    ["syn_victim_description"] = "Max number of received TCP SYN packets/sec over which a host is considered under SYN flood attack",
    ["syn_victim_title"] = "SYN Flood Victim",
  },
  ["export_data"] = {
    ["export_json_data"] = "Export JSON Data",
    ["note_active_hosts"] = "Only active hosts are returned.",
    ["note_maximum_number"] = "The maximum number of downloadable hosts is 32,768.",
  },
  ["flow_alerts_explorer"] = {
    ["by_target_port"] = "By Target Port",
    ["flow_alert_origin"] = "Alert Origin",
    ["flow_alert_target"] = "Alert Target",
    ["label"] = "Flow Alerts Explorer",
    ["origins"] = "Origins",
    ["search"] = "Search Flow Alerts",
    ["summary_cli2srv"] = "Total Origin to Target Traffic",
    ["summary_n_origins"] = "Total Origins",
    ["summary_n_targets"] = "Total Targets",
    ["summary_srv2cli"] = "Total Target to Origin Traffic",
    ["summary_total"] = "Total Flow Alerts",
    ["targets"] = "Targets",
    ["type_alerts_by_type"] = "Flow Alerts By Type",
    ["type_explorer"] = "Type Explorer",
    ["visual_explorer"] = "Visual Explorer",
  },
  ["flow_details"] = {
    ["acceptable_label"] = "Acceptable",
    ["actual_peak_throughput"] = "Actual / Peak Throughput",
    ["additional_flow_elements"] = "Additional Flow Elements",
    ["application_latency"] = "Application Latency",
    ["average_cpu_load"] = "Average CPU Load",
    ["bittorrent_hash"] = "BitTorrent hash",
    ["blacklisted_flow"] = "Client, server or domain is blacklisted",
    ["c_ip_addresses"] = "C IP Addresses",
    ["call_canceled"] = "Call Canceled",
    ["call_completed"] = "Call Completed",
    ["call_error"] = "Call Error",
    ["call_id"] = "Call-ID",
    ["call_initiator"] = "Call Initiator",
    ["call_quality_indicators"] = "Call Quality Indicators",
    ["call_started"] = "Call Started",
    ["call_state"] = "Call State",
    ["called_party"] = "Called Party",
    ["cancel_bye_failure_reason_cause"] = "Cancel/Bye/Failure Reason Cause",
    ["certificates_not_match"] = "Certificates don't match",
    ["client_process_information"] = "Client Process Information",
    ["client_requested"] = "Client Requested",
    ["computed_as_tcp_window_size_rtt"] = "Computed as TCP Window Size / RTT",
    ["could_not_add_host_to_category"] = "Could not add host \"%{host}\" to the \"%{category}\" category.",
    ["desirable_label"] = "Desirable",
    ["dns_invalid_query"] = "Invalid DNS query",
    ["dns_query"] = "DNS Query",
    ["drop_flow_traffic_btn"] = "Drop Flow Traffic",
    ["dropped_packets"] = "Dropped Packets",
    ["dtmf_tones_sent"] = "DTMF tones sent during the call",
    ["dump_flow_traffic"] = "Dump Flow Traffic",
    ["elephant_flow_l2r"] = "Elephant Flow (Local to Remote)",
    ["elephant_flow_r2l"] = "Elephant Flow (Remote to Local)",
    ["first_last_flow_sequence"] = "First / Last Flow Sequence",
    ["flow_active_msg"] = "This flow is active",
    ["flow_blocked_by_bridge"] = "Flow blocked due to configured policies",
    ["flow_cannot_be_found_message"] = "This flow cannot be found.",
    ["flow_completed_msg"] = "This flow is completed and will expire soon",
    ["flow_details"] = "Flow Details",
    ["flow_emitted"] = "Flow emitted when network interface was alerted",
    ["flow_marker"] = "Flow Marker",
    ["flow_peer_roles_inaccurate_msg"] = "However, flow begin has not been seen: peer roles (client/server) might be inaccurate",
    ["flow_peers_client_server"] = "Flow Peers [ Client / Server ]",
    ["flow_quota"] = "Flow Quota",
    ["flow_reset_by_resetter_msg"] = "This flow has been reset by %{resetter}",
    ["flow_reset_msg"] = "This flow has been reset",
    ["flow_shapers"] = "Flow Shapers",
    ["flow_status"] = "Flow Status",
    ["flow_traffic_is_dropped"] = "Flow Traffic is Dropped",
    ["forward"] = "Forward",
    ["gsm_cell_identifier"] = "GSM Cell Identifier",
    ["gsm_cell_lac"] = "GSM Cell LAC (Location Area Code)",
    ["host_successfully_added_to_category"] = "Host \"%{host}\" successfully added to the <a href=\"%{url}\">%{category}</a> category. Only new flows will be affected by the rule.",
    ["http_method"] = "HTTP Method",
    ["icmp_info"] = "ICMP Info",
    ["imsi"] = "IMSI (International mobile Subscriber Identity)",
    ["io_wait_time_percentage"] = "I/O Wait Time Percentage",
    ["jitter"] = "Jitter",
    ["longlived_flow"] = "Long-Lived Flow",
    ["looks_like_idle_flow_message"] = "This looks like an <font color=red>idle flow</font> with periodic transmissions just to keep it alive.",
    ["lost_packets"] = "Lost Packets",
    ["low_goodput"] = "Low Goodput",
    ["max_estimated_tcp_throughput"] = "Max (Estimated) TCP Throughput",
    ["max_packet_interarrival_time"] = "Max Packet Interarrival Time",
    ["memory_actual_peak"] = "Memory Actual / Peak",
    ["normal"] = "Normal",
    ["not_recommended_label"] = "Not Recommended",
    ["nsapi"] = "NSAPI",
    ["ongoing_call"] = "Ongoing Call",
    ["packet_inter_arrival_time"] = "Packet Inter-Arrival Time <br>[ Min / Avg / Max ]",
    ["payload_type"] = "Payload Type",
    ["process_information_report_warning"] = "Process information report is limited unless you use ntopng with <A HREF='%{url}'>nProbe</A> and the sprobe plugin",
    ["process_pid_name"] = "Process PID/Name",
    ["profile_name"] = "Profile Name",
    ["pseudo_mos"] = "(Pseudo) MOS",
    ["r_factor"] = "R-Factor",
    ["reach_connection_label"] = "Reach Connection",
    ["remote_to_remote"] = "Remote client and remote server",
    ["response_code"] = "Response Code",
    ["reverse"] = "Reverse",
    ["round_trip_time"] = "Round Trip Time",
    ["rtp_codecs"] = "RTP Codecs",
    ["rtp_flow"] = "RTP Flow",
    ["rtp_protocol_information"] = "RTP Protocol Information",
    ["rtp_stream_peers"] = "RTP Stream Peers",
    ["rtp_transit_in_out"] = "RTP Transit IN / OUT",
    ["rtt_breakdown"] = "Round-Trip Time Breakdown",
    ["rtt_distance"] = "Client/Server Estimated Distance",
    ["sac_service_area_code"] = "SAC (Service Area Code)",
    ["server_certificate"] = "Server Certificate",
    ["server_name"] = "Server Name",
    ["server_process_information"] = "Server Process Information",
    ["sip_call_id"] = "SIP Call-ID",
    ["sip_protocol_information"] = "SIP Protocol Information",
    ["slow_application_header"] = "Slow Application Header",
    ["slow_data_exchange"] = "Slow Data Exchange (Slowloris?)",
    ["slow_tcp_connection"] = "Slow TCP Connection",
    ["son_of_father_process"] = "son of <a href ='%{url}'>%{proc_father_pid}/%{proc_father_name}</a>",
    ["ssh_signature"] = "SSH Signature",
    ["ssl_certificate"] = "SSL Certificate",
    ["ssl_certificate_mismatch"] = "SSL Certificate Mismatch",
    ["suspicious_client_device_protocol"] = "Client protocol \"%{proto}\" is not allowed by the configured <a href=\"%{url}\">%{devtype} protocol policy</a>",
    ["suspicious_server_device_protocol"] = "Server protocol \"%{proto}\" is not allowed by the configured <a href=\"%{url}\">%{devtype} protocol policy</a>",
    ["suspicious_tcp_probing"] = "Suspicious TCP Probing",
    ["suspicious_tcp_syn_probing"] = "Suspicious TCP SYN Probing (or server port down)",
    ["sync_source_id"] = "Sync Source ID",
    ["tcp_connection_issues"] = "TCP Connection Issues (Retransmission, OOO, Lost)",
    ["tcp_connection_refused"] = "TCP connection refused",
    ["tcp_packet_analysis"] = "TCP Packet Analysis",
    ["throughput_trend"] = "Throughput Trend",
    ["unknown_status"] = "Unknown status (%{status})",
    ["url"] = "URL",
    ["user_name"] = "User Name",
    ["vm_page_faults"] = "VM Page Faults",
    ["web_mining_detected"] = "The website is known for mining cryptocurrencies on client devices",
  },
  ["flow_devices"] = {
    ["active_sflow"] = "Active sFlow Devices",
    ["all_device_ports"] = "All %{device} Ports",
    ["all_flow_devices"] = "All Flow Devices",
    ["all_sflow_devices"] = "All sFlow Devices",
    ["duplex"] = "Duplex",
    ["exporter_ip"] = "Flow Exporter IP",
    ["flow_device_x"] = "Flow Device %{device}",
    ["flow_exporter_devices"] = "Flow Exporter Devices",
    ["full_duplex"] = "Full-Duplex",
    ["half_duplex"] = "Half-Duplex",
    ["in_errors"] = "In Errors",
    ["note_condition_1"] = "Device %{device} must support SNMP and must be configured in the <a href=\"%{url}\">SNMP</a> devices page",
    ["note_condition_2"] = "SNMP and flow devices timeseries must be enabled from the from the <A HREF=\"%{url}\"><i class=\"fa fa-flask\"></i> Preferences</A> (Expert View)",
    ["note_zmq_fields1"] = "Flow devices are determined using ZMQ fields %%EXPORTER_IPV4_ADDRESS and %%NPROBE_IPV4_ADDRESS. When both fields are available, the former takes precedence over the latter",
    ["note_zmq_fields2"] = "Flow devices interfaces are determined using ZMQ fields %%INPUT_SNMP and %%OUTPUT_SNMP",
    ["note_zmq_fields3"] = "sFlow devices are determined using sFlow field deviceIP received via ZMQ (topic 'counter')",
    ["note_zmq_fields4"] = "sFlow devices interfaces are determined using field ifIndex received via ZMQ (topic 'counter')",
    ["out_errors"] = "Out Errors",
    ["promisc"] = "Promisc",
    ["sflow_device_x"] = "sFlow Device %{device}",
    ["snmp_description"] = "SNMP Description",
    ["snmp_devmodel"] = "SNMP Device Model",
    ["snmp_devname"] = "SNMP Device Name",
    ["snmp_location"] = "SNMP Location",
    ["snmp_ratio"] = "Flow/SNMP Ratio",
    ["snmp_ratio_descr"] = "The Flow/SNMP ratio is a number 0..1 that indicates how much received flows represent the overall traffic. As in flow-based analysis non-IP and layer 2 headers are not accounted, <br>typical ratio values are in the 0.8..0.9 range (i.e. 0.9 means that 90%% of the received traffic as observed via SNMP has been reported in flows).<br>Ratio is computed hourly only if the following conditions are met",
    ["this_page_contains_couters"] = "This page contains interface counters as they have been collected via sFlow. If SNMP is configured, you can also see the <A HREF=\"%{url}\">SNMP view</A> of this device",
    ["timeseries_descr"] = "Flow devices timeseries can be enabled from the <a href=\"%{url}\"><i class=\"fa fa-flask\"></i> Preferences</a>. Few minutes are necessary to see the first data points",
  },
  ["flow_fields_description"] = {
    ["appl_latency_ms"] = "Application latency (msec), a.k.a. server response time",
    ["application_id"] = "Collected Application Id (Cisco or IXIA)",
    ["application_name"] = "Palo Alto App-Id",
    ["biflow_direction"] = "1=initiator, 2=reverseInitiator",
    ["bittorrent_hash"] = "BITTORRENT hash",
    ["client_nw_latency_ms"] = "Network RTT/2 client <-> nprobe (msec)",
    ["cumulative_icmp_type"] = "Cumulative OR of ICMP type packets",
    ["dhcp_client_ip"] = "DHCP assigned client IPv4 address",
    ["dhcp_client_mac"] = "MAC of the DHCP client",
    ["dhcp_client_name"] = "DHCP client name",
    ["dhcp_message_type"] = "DHCP message type",
    ["dhcp_remote_id"] = "DHCP agent remote Id",
    ["dhcp_subscriber_id"] = "DHCP subscriber Id",
    ["diameter_clr_cancel_type"] = "DIAMETER Cancellation Type",
    ["diameter_clr_flags"] = "DIAMETER CLR Flags",
    ["diameter_exp_res_result_code"] = "DIAMETER Response Experimental Result Code",
    ["diameter_exp_res_vendor_id"] = "DIAMETER Response Experimental Result Vendor Id",
    ["diameter_hop_by_hop_id"] = "DIAMETER Hop by Hop Identifier",
    ["diameter_req_msg_type"] = "DIAMETER Request Msg Type",
    ["diameter_req_origin_host"] = "DIAMETER Origin Host Request",
    ["diameter_req_user_name"] = "DIAMETER Request User Name",
    ["diameter_rsp_msg_type"] = "DIAMETER Response Msg Type",
    ["diameter_rsp_origin_host"] = "DIAMETER Origin Host Response",
    ["diameter_rsp_result_code"] = "DIAMETER Response Result Code",
    ["direction"] = "Flow direction [0=src->dst, 1=dst->src]",
    ["dns_num_answers"] = "DNS # of returned answers",
    ["dns_query"] = "DNS query",
    ["dns_query_id"] = "DNS query transaction Id",
    ["dns_query_type"] = "DNS query type (e.g. 1=A, 2=NS..)",
    ["dns_response"] = "DNS response(s)",
    ["dns_ret_code"] = "DNS return code (e.g. 0=no error)",
    ["dns_ttl_answer"] = "TTL of the first A record (if any)",
    ["dot1q_dst_vlan"] = "Destination VLAN (outer VLAN in QinQ)",
    ["dot1q_src_vlan"] = "Source VLAN (outer VLAN in QinQ)",
    ["downstream_session_id"] = "Downstream session identifier (e.g. L2TP) or 0 if unknown",
    ["downstream_tunnel_id"] = "Downstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
    ["dst_as"] = "Destination BGP AS",
    ["dst_as_map"] = "Organization name for DST_AS",
    ["dst_as_path_1"] = "Dest AS path position 1",
    ["dst_as_path_10"] = "Dest AS path position 10",
    ["dst_as_path_2"] = "Dest AS path position 2",
    ["dst_as_path_3"] = "Dest AS path position 3",
    ["dst_as_path_4"] = "Dest AS path position 4",
    ["dst_as_path_5"] = "Dest AS path position 5",
    ["dst_as_path_6"] = "Dest AS path position 6",
    ["dst_as_path_7"] = "Dest AS path position 7",
    ["dst_as_path_8"] = "Dest AS path position 8",
    ["dst_as_path_9"] = "Dest AS path position 9",
    ["dst_father_proc_name"] = "Dst father process name",
    ["dst_father_proc_pid"] = "Dst father process PID",
    ["dst_fragments"] = "Num fragmented packets dst->src",
    ["dst_ip_city"] = "City where the dst IP is located",
    ["dst_ip_country"] = "Country where the dst IP is located",
    ["dst_ip_lat"] = "Latitude where the dst IP is located",
    ["dst_ip_long"] = "Longitude where the dst IP is located",
    ["dst_proc_actual_memory"] = "Dst process actual memory (bytes)",
    ["dst_proc_average_cpu_load"] = "Dst process avg load (%% * 100)",
    ["dst_proc_name"] = "Dst process name",
    ["dst_proc_num_page_faults"] = "Dst process num pagefaults",
    ["dst_proc_pctg_iowait"] = "Src process iowait time %% (%% * 100)",
    ["dst_proc_peak_memory"] = "Dst process peak memory (bytes)",
    ["dst_proc_pid"] = "Dst process PID",
    ["dst_proc_uid"] = "Dst process UID",
    ["dst_proc_user_name"] = "Dst process user name",
    ["dst_to_src_avg_throughput"] = "Dst to src average thpt (bps)",
    ["dst_to_src_max_throughput"] = "Dst to src max thpt (bps)",
    ["dst_to_src_min_throughput"] = "Dst to src min thpt (bps)",
    ["dst_tos"] = "TOS/DSCP (dst->src)",
    ["dst_vlan"] = "Destination VLAN (inner VLAN in QinQ)",
    ["duration_in"] = "Client to Server stream duration (msec)",
    ["duration_out"] = "Client to Server stream duration (msec)",
    ["engine_id"] = "Id of the flow switching engine",
    ["engine_type"] = "Flow switching engine",
    ["exporter_ipv4_address"] = "Flow exporter IPv4 Address",
    ["exporter_ipv6_address"] = "Flow exporter IPv6 Address",
    ["firewall_event"] = "Firewall Event 0=ignore, 1=flow created, 2=flow deleted, 3=flow denied, 4=flow alert, 5=flow update",
    ["first_switched"] = "SysUptime (msec) of the first flow pkt",
    ["flow_active_timeout"] = "Activity timeout of flow cache entries",
    ["flow_duration_microseconds"] = "Flow duration (usec)",
    ["flow_duration_milliseconds"] = "Flow duration (msec)",
    ["flow_end_microseconds"] = "uSec (epoch) of the first flow packet",
    ["flow_end_milliseconds"] = "Msec (epoch) of the last flow packet",
    ["flow_end_sec"] = "Seconds (epoch) of the last flow packet",
    ["flow_id"] = "Serial Flow Identifier",
    ["flow_inactive_timeout"] = "Inactivity timeout of flow cache entries",
    ["flow_proto_port"] = "L7 port that identifies the flow protocol or 0 if unknown",
    ["flow_server_name"] = "Flow server name (if known)",
    ["flow_start_microseconds"] = "uSec (epoch) of the first flow packet",
    ["flow_start_milliseconds"] = "Msec (epoch) of the first flow packet",
    ["flow_start_sec"] = "Seconds (epoch) of the first flow packet",
    ["flow_user_name"] = "Flow username of the tunnel (if known)",
    ["frame_length"] = "Original L2 frame length",
    ["ftp_command"] = "FTP client command",
    ["ftp_command_ret_code"] = "FTP client command return code",
    ["ftp_login"] = "FTP client login",
    ["ftp_password"] = "FTP client password",
    ["gtpv0_apn_name"] = "GTPv0 APN Name",
    ["gtpv0_end_user_ip"] = "GTPv0 End User IP Address",
    ["gtpv0_end_user_msisdn"] = "GTPv0 End User MSISDN",
    ["gtpv0_rai_cell_lac"] = "GTPv0 Cell Location Area Code",
    ["gtpv0_rai_cell_rac"] = "GTPv0 Cell Routing Area Code",
    ["gtpv0_rai_mcc"] = "GTPv0 Mobile Country Code",
    ["gtpv0_rai_mnc"] = "GTPv0 Mobile Network Code",
    ["gtpv0_req_msg_type"] = "GTPv0 Request Msg Type",
    ["gtpv0_response_cause"] = "GTPv0 Cause of Operation",
    ["gtpv0_rsp_msg_type"] = "GTPv0 Response Msg Type",
    ["gtpv0_tid"] = "GTPv0 Tunnel Identifier",
    ["gtpv1_apn_name"] = "GTPv1 APN Name",
    ["gtpv1_c2s_teid_ctrl"] = "GTPv1 Client->Server TunnelId Control",
    ["gtpv1_c2s_teid_data"] = "GTPv1 Client->Server TunnelId Data",
    ["gtpv1_end_user_imei"] = "GTPv1 End User IMEI",
    ["gtpv1_end_user_imsi"] = "GTPv1 End User IMSI",
    ["gtpv1_end_user_ip"] = "GTPv1 End User IP Address",
    ["gtpv1_end_user_msisdn"] = "GTPv1 End User MSISDN",
    ["gtpv1_rai_lac"] = "GTPv1 RAI Location Area Code",
    ["gtpv1_rai_mcc"] = "GTPv1 RAI Mobile Country Code",
    ["gtpv1_rai_mnc"] = "GTPv1 RAI Mobile Network Code",
    ["gtpv1_rai_rac"] = "GTPv1 RAI Routing Area Code",
    ["gtpv1_rat_type"] = "GTPv1 RAT Type",
    ["gtpv1_req_msg_type"] = "GTPv1 Request Msg Type",
    ["gtpv1_response_cause"] = "GTPv1 Cause of Operation",
    ["gtpv1_rsp_msg_type"] = "GTPv1 Response Msg Type",
    ["gtpv1_s2c_teid_ctrl"] = "GTPv1 Server->Client TunnelId Control",
    ["gtpv1_s2c_teid_data"] = "GTPv1 Server->Client TunnelId Data",
    ["gtpv1_uli_cell_ci"] = "GTPv1 ULI Cell CI",
    ["gtpv1_uli_cell_lac"] = "GTPv1 ULI Cell Location Area Code",
    ["gtpv1_uli_mcc"] = "GTPv1 ULI Mobile Country Code",
    ["gtpv1_uli_mnc"] = "GTPv1 ULI Mobile Network Code",
    ["gtpv1_uli_sac"] = "GTPv1 ULI SAC",
    ["gtpv2_apn_name"] = "GTPv2 APN Name",
    ["gtpv2_c2s_s1u_gtpu_ip"] = "GTPv2 Client->Svr S1U GTPU IP",
    ["gtpv2_c2s_s1u_gtpu_teid"] = "GTPv2 Client->Svr S1U GTPU TEID",
    ["gtpv2_c2s_s5_s8_gtpc_ip"] = "GTPv2 Client->Svr S5/S8 GTPC IP",
    ["gtpv2_c2s_s5_s8_gtpu_ip"] = "GTPv2 Client->Srv S5/S8 PGW GTPU IP",
    ["gtpv2_c2s_s5_s8_gtpu_teid"] = "GTPv2 Client->Srv S5/S8 PGW GTPU TEID",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_ip"] = "GTPv2 Client->Srv S5/S8 SGW GTPU IP",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_teid"] = "GTPv2 Client->Srv S5/S8 SGW GTPU TEID",
    ["gtpv2_end_user_imei"] = "GTPv2 End User IMEI",
    ["gtpv2_end_user_imsi"] = "GTPv2 End User IMSI",
    ["gtpv2_end_user_msisdn"] = "GTPv2 End User MSISDN",
    ["gtpv2_pdn_ip"] = "GTPV2 PDN IP Address",
    ["gtpv2_rat_type"] = "GTPv2 RAT Type",
    ["gtpv2_req_msg_type"] = "GTPv2 Request Msg Type",
    ["gtpv2_response_cause"] = "GTPv2 Cause of Operation",
    ["gtpv2_rsp_msg_type"] = "GTPv2 Response Msg Type",
    ["gtpv2_s2c_s1u_gtpu_ip"] = "GTPv2 Srv->Client S1U GTPU IP",
    ["gtpv2_s2c_s1u_gtpu_teid"] = "GTPv2 Srv->Client S1U GTPU TEID",
    ["gtpv2_s2c_s5_s8_gtpc_ip"] = "GTPv2 Svr->Client S5/S8 GTPC IP",
    ["gtpv2_s2c_s5_s8_gtpu_ip"] = "GTPv2 Srv->Client S5/S8 PGW GTPU IP",
    ["gtpv2_s2c_s5_s8_gtpu_teid"] = "GTPv2 Srv->Client S5/S8 PGW GTPU TEID",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_ip"] = "GTPv2 Srv->Client S5/S8 SGW GTPU IP",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_teid"] = "GTPv2 Srv->Client S5/S8 SGW GTPU TEID",
    ["gtpv2_s5_s8_gtpc_teid"] = "GTPv2 S5/S8 SGW GTPC TEIDs",
    ["gtpv2_uli_cell_id"] = "GTPv2 Cell Identifier",
    ["gtpv2_uli_cell_tac"] = "GTPv2 Tracking Area Code",
    ["gtpv2_uli_mcc"] = "GTPv2 Mobile Country Code",
    ["gtpv2_uli_mnc"] = "GTPv2 Mobile Network Code",
    ["http_host"] = "HTTP Host Name (IXIA Host Name)",
    ["http_method"] = "HTTP METHOD",
    ["http_mime"] = "HTTP Mime Type",
    ["http_referer"] = "HTTP Referer",
    ["http_ret_code"] = "HTTP return code (e.g. 200, 304...)",
    ["http_site"] = "HTTP server without host name",
    ["http_ua"] = "HTTP User Agent",
    ["http_url"] = "HTTP URL (IXIA URI)",
    ["http_via"] = "HTTP Via",
    ["http_x_forwarded_for"] = "HTTP X-Forwarded-For",
    ["icmp_ipv4_code"] = "ICMP Code",
    ["icmp_ipv4_type"] = "ICMP Type",
    ["icmp_type"] = "ICMP Type * 256 + ICMP code",
    ["imap_login"] = "Mail sender",
    ["in_bytes"] = "Incoming flow bytes (src->dst)",
    ["in_dst_mac"] = "Destination MAC Address",
    ["in_pkts"] = "Incoming flow packets (src->dst)",
    ["in_src_mac"] = "Source MAC Address",
    ["in_src_osi_sap"] = "OSI Source SAP (OSI Traffic Only)",
    ["ingress_vrfid"] = "Ingress VRF ID",
    ["input_snmp"] = "Input interface SNMP idx",
    ["ip_protocol_version"] = "[4=IPv4][6=IPv6]",
    ["ipfix_sampling_algorithm"] = "Sampling algorithm",
    ["ipv4_dst_addr"] = "IPv4 destination address",
    ["ipv4_dst_mask"] = "IPv4 dest subnet mask (/<bits>)",
    ["ipv4_next_hop"] = "IPv4 next hop address",
    ["ipv4_src_addr"] = "IPv4 source address",
    ["ipv4_src_mask"] = "IPv4 source subnet mask (/<bits>)",
    ["ipv6_dst_addr"] = "IPv6 destination address",
    ["ipv6_dst_mask"] = "IPv6 destination mask",
    ["ipv6_next_hop"] = "IPv6 next hop address",
    ["ipv6_src_addr"] = "IPv6 source address",
    ["ipv6_src_mask"] = "IPv6 source mask",
    ["l4_dst_port"] = "Layer 4 destination port",
    ["l4_dst_port_map"] = "Layer 4 destination port symbolic name",
    ["l4_src_port"] = "IPv4 source port",
    ["l4_src_port_map"] = "Layer 4 source port symbolic name",
    ["l4_srv_port"] = "Layer 4 server port",
    ["l4_srv_port_map"] = "Layer 4 server port symbolic name",
    ["l7_proto"] = "Layer 7 protocol (numeric)",
    ["l7_proto_name"] = "Layer 7 protocol name",
    ["last_switched"] = "SysUptime (msec) of the last flow pkt",
    ["longest_flow_pkt"] = "Longest packet (bytes) of the flow",
    ["max_ttl"] = "Max flow TTL",
    ["min_ttl"] = "Min flow TTL",
    ["mpls_label_1"] = "MPLS label at position 1",
    ["mpls_label_10"] = "MPLS label at position 10",
    ["mpls_label_2"] = "MPLS label at position 2",
    ["mpls_label_3"] = "MPLS label at position 3",
    ["mpls_label_4"] = "MPLS label at position 4",
    ["mpls_label_5"] = "MPLS label at position 5",
    ["mpls_label_6"] = "MPLS label at position 6",
    ["mpls_label_7"] = "MPLS label at position 7",
    ["mpls_label_8"] = "MPLS label at position 8",
    ["mpls_label_9"] = "MPLS label at position 9",
    ["mysql_appl_latency_usec"] = "MySQL request->response latecy (usec)",
    ["mysql_db"] = "MySQL database in use",
    ["mysql_query"] = "MySQL Query",
    ["mysql_response"] = "MySQL server response",
    ["mysql_server_version"] = "MySQL server version",
    ["mysql_username"] = "MySQL username",
    ["netbios_query_name"] = "NETBIOS Query Name",
    ["netbios_query_os"] = "NETBIOS Query OS",
    ["netbios_query_type"] = "NETBIOS Query Type",
    ["netbios_response"] = "NETBIOS Query Response",
    ["nprobe_ipv4_address"] = "IPv4 address of the host were nProbe runs",
    ["num_pkts_1024_to_1514_bytes"] = "# packets whose IP size > 1024 and <= 1514",
    ["num_pkts_128_to_256_bytes"] = "# packets whose IP size > 128 and <= 256",
    ["num_pkts_256_to_512_bytes"] = "# packets whose IP size > 256 and < 512",
    ["num_pkts_512_to_1024_bytes"] = "# packets whose IP size > 512 and < 1024",
    ["num_pkts_over_1514_bytes"] = "# packets whose IP size > 1514",
    ["num_pkts_ttl_128_160"] = "# packets with TTL > 128 and <= 160",
    ["num_pkts_ttl_160_192"] = "# packets with TTL > 160 and <= 192",
    ["num_pkts_ttl_192_224"] = "# packets with TTL > 192 and <= 224",
    ["num_pkts_ttl_224_255"] = "# packets with TTL > 224 and <= 255",
    ["num_pkts_ttl_2_5"] = "# packets with TTL > 1 and TTL <= 5",
    ["num_pkts_ttl_32_64"] = "# packets with TTL > 32 and <= 64",
    ["num_pkts_ttl_5_32"] = "# packets with TTL > 5 and TTL <= 32",
    ["num_pkts_ttl_64_96"] = "# packets with TTL > 64 and <= 96",
    ["num_pkts_ttl_96_128"] = "# packets with TTL > 96 and <= 128",
    ["num_pkts_ttl_eq_1"] = "# packets with TTL = 1",
    ["num_pkts_up_to_128_bytes"] = "# packets whose IP size <= 128",
    ["observation_point_id"] = "Observation point id",
    ["observation_point_type"] = "Observation point type",
    ["ooorder_in_pkts"] = "Number of out of order TCP flow packets (dst->src)",
    ["ooorder_out_pkts"] = "Number of out of order TCP flow packets (src->dst)",
    ["oracle_query"] = "Oracle Query",
    ["oracle_query_duration"] = "Oracle Query Duration (msec)",
    ["oracle_rsp_code"] = "Oracle Response Code",
    ["oracle_rsp_string"] = "Oracle Response String",
    ["oracle_username"] = "Oracle Username",
    ["out_bytes"] = "Outgoing flow bytes (dst->src) [Aliased to %%DST_TO_SRC_BYTES]",
    ["out_dst_mac"] = "Destination MAC Address, potentially modified by a middlebox function after the Observation Point",
    ["out_dst_osi_sap"] = "OSI Destination SAP (OSI Traffic Only)",
    ["out_pkts"] = "Outgoing flow packets (dst->src) [Aliased to %%DST_TO_SRC_PKTS]",
    ["out_src_mac"] = "Source MAC Address, potentially modified by a middlebox function after the Observation Point",
    ["output_snmp"] = "Output interface SNMP idx",
    ["packet_section_offset"] = "Packet section offset",
    ["packets_observed"] = "Tot number of packets seen",
    ["packets_selected"] = "Number of pkts selected for sampling",
    ["payload_hash"] = "Initial flow payload hash",
    ["plugin_name"] = "Plugin name used by this flow (if any)",
    ["pop_user"] = "POP3 user login",
    ["post_napt_dst_transport_port"] = "Post NAPT Destination Transport Port",
    ["post_napt_src_transport_port"] = "Post NAPT Source Transport Port",
    ["post_nat_dst_ipv4_addr"] = "Post NAT Destination IPv4 Address",
    ["post_nat_src_ipv4_addr"] = "Post NAT Source IPv4 Address",
    ["protocol"] = "IP protocol byte",
    ["protocol_map"] = "IP protocol name",
    ["radius_acct_in_octets"] = "RADIUS Accounting Input Octets",
    ["radius_acct_in_pkts"] = "RADIUS Accounting Input Packets",
    ["radius_acct_out_octets"] = "RADIUS Accounting Output Octets",
    ["radius_acct_out_pkts"] = "RADIUS Accounting Output Packets",
    ["radius_acct_session_id"] = "RADIUS Accounting Session Name",
    ["radius_acct_status_type"] = "RADIUS Accounting Status Type",
    ["radius_called_station_id"] = "RADIUS Called Station Id",
    ["radius_calling_station_id"] = "RADIUS Calling Station Id",
    ["radius_framed_ip_addr"] = "RADIUS Framed IP",
    ["radius_nas_identifier"] = "RADIUS NAS Identifier",
    ["radius_nas_ip_addr"] = "RADIUS NAS IP Address",
    ["radius_req_msg_type"] = "RADIUS Request Msg Type",
    ["radius_rsp_msg_type"] = "RADIUS Response Msg Type",
    ["radius_user_imei"] = "RADIUS User MSISDN (Extension)",
    ["radius_user_imsi"] = "RADIUS User IMSI (Extension)",
    ["radius_user_name"] = "RADIUS User Name (Access Only)",
    ["retransmitted_in_bytes"] = "Number of retransmitted TCP flow bytes (src->dst)",
    ["retransmitted_in_pkts"] = "Number of retransmitted TCP flow packets (src->dst)",
    ["retransmitted_out_bytes"] = "Number of retransmitted TCP flow bytes (dst->src)",
    ["retransmitted_out_pkts"] = "Number of retransmitted TCP flow packets (dst->src)",
    ["rtp_dtmf_tones"] = "DTMF tones sent (if any) during the call",
    ["rtp_first_seq"] = "First flow RTP Seq Number",
    ["rtp_first_ts"] = "First flow RTP timestamp",
    ["rtp_in_jitter"] = "RTP jitter (ms * 1000)",
    ["rtp_in_max_delta"] = "Max delta (ms*100) between consecutive pkts (src->dst)",
    ["rtp_in_mos"] = "RTP pseudo-MOS (value * 100) (src->dst)",
    ["rtp_in_payload_type"] = "RTP payload type",
    ["rtp_in_pkt_drop"] = "Packet discarded by Jitter Buffer (src->dst)",
    ["rtp_in_pkt_lost"] = "Packet lost in stream (src->dst)",
    ["rtp_in_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (src->dst)",
    ["rtp_in_transit"] = "RTP Transit (value * 100) (src->dst)",
    ["rtp_last_seq"] = "Last flow RTP Seq Number",
    ["rtp_last_ts"] = "Last flow RTP timestamp",
    ["rtp_mos"] = "RTP pseudo-MOS (value * 100) (average both directions)",
    ["rtp_out_jitter"] = "RTP jitter (ms * 1000)",
    ["rtp_out_max_delta"] = "Max delta (ms*100) between consecutive pkts (dst->src)",
    ["rtp_out_mos"] = "RTP pseudo-MOS (value * 100) (dst->src)",
    ["rtp_out_payload_type"] = "RTP payload type",
    ["rtp_out_pkt_drop"] = "Packet discarded by Jitter Buffer (dst->src)",
    ["rtp_out_pkt_lost"] = "Packet lost in stream (dst->src)",
    ["rtp_out_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (dst->src)",
    ["rtp_out_transit"] = "RTP Transit (value * 100) (dst->src)",
    ["rtp_r_factor"] = "RTP pseudo-R_FACTOR (value * 100) (average both directions)",
    ["rtp_rtt"] = "RTP Round Trip Time (ms)",
    ["rtp_sip_call_id"] = "SIP call-id corresponding to this RTP stream",
    ["rtp_ssrc"] = "RTP Sync Source ID",
    ["s1ap_cause_enb_to_mme"] = "S1AP Cause from ENB to MME",
    ["s1ap_detailed_cause_enb_to_mme"] = "S1AP Detailed Cause from ENB to MME",
    ["s1ap_enb_ue_s1ap_id"] = "S1AP ENB Identifier",
    ["s1ap_mme_ue_s1ap_id"] = "S1AP MME Identifier",
    ["s1ap_msg_emm_type_enb_to_mme"] = "S1AP EMM Message Type from ENB to MME",
    ["s1ap_msg_emm_type_mme_to_enb"] = "S1AP EMM Message Type from MME to ENB",
    ["s1ap_msg_esm_type_enb_to_mme"] = "S1AP ESM Message Type from ENB to MME",
    ["s1ap_msg_esm_type_mme_to_enb"] = "S1AP ESM Message Type from MME to ENB",
    ["sampled_packet_id"] = "Sampled packet id",
    ["sampled_packet_size"] = "Sampled packet size",
    ["sampling_algorithm"] = "Sampling type (deterministic/random)",
    ["sampling_interval"] = "Sampling rate",
    ["sampling_population"] = "Sampling population",
    ["sampling_size"] = "Number of packets to sample",
    ["selector_id"] = "Selector id",
    ["selector_name"] = "Sampler name",
    ["server_nw_latency_ms"] = "Network RTT/2 nprobe <-> server (msec)",
    ["shortest_flow_pkt"] = "Shortest packet (bytes) of the flow",
    ["sip_bye_ok_time"] = "SIP time (epoch) of BYE OK",
    ["sip_bye_time"] = "SIP time (epoch) of BYE",
    ["sip_c_ip"] = "SIP C IP adresses",
    ["sip_call_id"] = "SIP call-id",
    ["sip_call_state"] = "SIP Call State",
    ["sip_called_party"] = "SIP Called party",
    ["sip_calling_party"] = "SIP Call initiator",
    ["sip_cancel_ok_time"] = "SIP time (epoch) of CANCEL OK",
    ["sip_cancel_time"] = "SIP time (epoch) of CANCEL",
    ["sip_invite_failure_time"] = "SIP time (epoch) of INVITE FAILURE",
    ["sip_invite_ok_time"] = "SIP time (epoch) of INVITE OK",
    ["sip_invite_time"] = "SIP time (epoch) of INVITE",
    ["sip_reason_cause"] = "SIP Cancel/Bye/Failure reason cause",
    ["sip_response_code"] = "SIP failure response code",
    ["sip_ringing_time"] = "SIP time (epoch) of RINGING",
    ["sip_rtp_codecs"] = "SIP RTP codecs",
    ["sip_rtp_ipv4_dst_addr"] = "SIP RTP stream dest IP",
    ["sip_rtp_ipv4_src_addr"] = "SIP RTP stream source IP",
    ["sip_rtp_l4_dst_port"] = "SIP RTP stream dest port",
    ["sip_rtp_l4_src_port"] = "SIP RTP stream source port",
    ["sip_trying_time"] = "SIP time (epoch) of Trying",
    ["smtp_mail_from"] = "Mail sender",
    ["smtp_rcpt_to"] = "Mail recipient",
    ["src_as"] = "Source BGP AS",
    ["src_as_map"] = "Organization name for SRC_AS",
    ["src_as_path_1"] = "Src AS path position 1",
    ["src_as_path_10"] = "Src AS path position 10",
    ["src_as_path_2"] = "Src AS path position 2",
    ["src_as_path_3"] = "Src AS path position 3",
    ["src_as_path_4"] = "Src AS path position 4",
    ["src_as_path_5"] = "Src AS path position 5",
    ["src_as_path_6"] = "Src AS path position 6",
    ["src_as_path_7"] = "Src AS path position 7",
    ["src_as_path_8"] = "Src AS path position 8",
    ["src_as_path_9"] = "Src AS path position 9",
    ["src_father_proc_name"] = "Src father process name",
    ["src_father_proc_pid"] = "Src father process PID",
    ["src_fragments"] = "Num fragmented packets src->dst",
    ["src_ip_city"] = "City where the src IP is located",
    ["src_ip_country"] = "Country where the src IP is located",
    ["src_ip_lat"] = "Latitude where the src IP is located",
    ["src_ip_long"] = "Longitude where the src IP is located",
    ["src_proc_actual_memory"] = "Src process actual memory (bytes)",
    ["src_proc_average_cpu_load"] = "Src process avg load (%% * 100)",
    ["src_proc_name"] = "Src process name",
    ["src_proc_num_page_faults"] = "Src process num pagefaults",
    ["src_proc_pctg_iowait"] = "Src process iowait time %% (%% * 100)",
    ["src_proc_peak_memory"] = "Src process peak memory (bytes)",
    ["src_proc_pid"] = "Src process PID",
    ["src_proc_uid"] = "Src process UID",
    ["src_proc_user_name"] = "Src process user name",
    ["src_to_dst_avg_throughput"] = "Src to dst average thpt (bps)",
    ["src_to_dst_max_throughput"] = "Src to dst max thpt (bps)",
    ["src_to_dst_min_throughput"] = "Src to dst min thpt (bps)",
    ["src_tos"] = "TOS/DSCP (src->dst)",
    ["src_vlan"] = "Source VLAN (inner VLAN in QinQ)",
    ["ssdp_host"] = "SSDP Host",
    ["ssdp_method"] = "SSDP Method",
    ["ssdp_server"] = "SSDP Server",
    ["ssdp_type"] = "SSDP Type",
    ["ssdp_usn"] = "SSDP USN",
    ["ssl_server_name"] = "SSL server name",
    ["tcp_flags"] = "Cumulative of all flow TCP flags",
    ["tcp_win_max_in"] = "Max TCP Window (src->dst)",
    ["tcp_win_max_out"] = "Max TCP Window (dst->src)",
    ["tcp_win_min_in"] = "Min TCP Window (src->dst)",
    ["tcp_win_min_out"] = "Min TCP Window (dst->src)",
    ["tcp_win_mss_in"] = "TCP Max Segment Size (src->dst)",
    ["tcp_win_mss_out"] = "TCP Max Segment Size (dst->src)",
    ["tcp_win_scale_in"] = "TCP Window Scale (src->dst)",
    ["tcp_win_scale_out"] = "TCP Window Scale (dst->src)",
    ["total_bytes_exp"] = "Total bytes exported",
    ["total_flows_exp"] = "Total number of exported flows",
    ["total_pkts_exp"] = "Total flow packets exported",
    ["untunneled_ipv4_dst_addr"] = "Untunneled IPv4 destination address",
    ["untunneled_ipv4_src_addr"] = "Untunneled IPv4 source address",
    ["untunneled_ipv6_dst_addr"] = "Untunneled IPv6 destination address",
    ["untunneled_ipv6_src_addr"] = "Untunneled IPv6 source address",
    ["untunneled_l4_dst_port"] = "Untunneled IPv4 destination port",
    ["untunneled_l4_src_port"] = "Untunneled IPv4 source port",
    ["untunneled_protocol"] = "Untunneled IP protocol byte",
    ["upstream_session_id"] = "Upstream session identifier (e.g. L2TP) or 0 if unknown",
    ["upstream_tunnel_id"] = "Upstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
    ["user_name"] = "Palo Alto User-Id",
  },
  ["flows_page"] = {
    ["active_flows"] = "Active %{filter} Flows",
    ["actual_throughput"] = "Actual Thpt",
    ["alerted"] = "Alerted",
    ["all_ases"] = "All ASes",
    ["all_categories"] = "All Categories",
    ["all_devices"] = "All Flow Exporters",
    ["all_flows"] = "All Flows",
    ["all_hosts"] = "All Hosts",
    ["all_inIfIdx"] = "All Input Interfaces",
    ["all_ip_versions"] = "All Versions",
    ["all_outIfIdx"] = "All Output Interfaces",
    ["all_proto"] = "All Proto",
    ["all_vlan_ids"] = "All VLANs",
    ["applications"] = "Applications",
    ["blocked"] = "Blocked",
    ["client_as"] = "Client AS",
    ["device_ip"] = "Flow Exporter",
    ["direction"] = "Direction",
    ["flow_exporters"] = "Flow Exporters",
    ["flows"] = "%{filter} Flows",
    ["hosts"] = "Hosts",
    ["idle_flows_not_listed"] = "Idle flows not listed.",
    ["inIfIdx"] = "Input Interface",
    ["ip_version"] = "IP Version",
    ["ipv4_only"] = "IPv4 Only",
    ["ipv6_only"] = "IPv6 Only",
    ["l4_proto"] = "L4 Proto",
    ["local_cli_remote_srv"] = "Local Client - Remote Server",
    ["local_only"] = "Local Only",
    ["local_srv_remote_cli"] = "Local Server - Remote Client",
    ["multicast"] = "Multicast/Broadcast",
    ["network"] = " [ Network %{network} ]",
    ["non_multicast"] = "Non-Multicast/Non-Broadcast",
    ["normal"] = "Normal",
    ["one_way_multicast"] = "One-Way Multicast/Broadcast",
    ["one_way_non_multicast"] = "One-Way Non-Multicast/Non-Broadcast",
    ["outIfIdx"] = "Output Interface",
    ["recently_active_flows"] = "Recently Active %{filter} Flows",
    ["remote_only"] = "Remote Only",
    ["server_as"] = "Server AS",
    ["sflow_devices"] = "sFlow Devices",
    ["source_id"] = "Source Id",
    ["total_bytes"] = "Total Bytes",
    ["vlan"] = "VLAN",
  },
  ["geo_map"] = {
    ["browser_reported_home_map"] = "Browser reported home map location",
    ["geo_map"] = "Geo Map",
    ["geolocation_error"] = "Geolocation error",
    ["hosts_geomap"] = "Hosts GeoMap",
    ["latitude"] = "Latitude",
    ["longitude"] = "Longitude",
    ["note"] = "NOTE",
    ["note_active_flows"] = "Have active flows between peers with public IP addresses.",
    ["note_compiled_ntopng_with_geolocation"] = "Have compiled the software with geolocation and started with it.",
    ["note_google_maps_browser_api_key"] = "A Google Maps Browser API Key may be required. Detailed information on key generation <a href='%{url_google}'>can be found here</a>.<br>Once generated, the key can be submitted via the <a href='%{url_prefs}'><i class=\"fa fa-flask\"></i> Preferences</a>.",
    ["note_html_browser_geolocation"] = "HTML <A HREF=%{url}>browser geolocation</A> is used to place on map hosts based on unknown locations.",
    ["note_requirements_visualize_maps"] = "In order to visualize maps you must",
    ["note_working_internet_connection"] = "Have a working Internet connection.",
    ["unavailable_geolocation"] = "Geolocation not supported by your browser or disabled.",
    ["using_default_location"] = "Using default location.",
  },
  ["graphs"] = {
    ["95_perc"] = "95th Perc",
    ["active_devices"] = "Active Devices",
    ["active_flows"] = "Active Flows",
    ["active_host_contacts"] = "Active Host Contacts",
    ["active_hosts"] = "Active Hosts",
    ["active_http_servers"] = "Active HTTP Servers",
    ["arp_replies"] = "ARP Replies",
    ["arp_requests"] = "ARP Requests",
    ["average"] = "Average",
    ["average_traffic"] = "Average Traffic/sec",
    ["avg"] = "Avg",
    ["binary_operators_note"] = "For more information about the EMA, SMA and RSI indicators check out the <a href=\"%{url}\">online documentation</a>.",
    ["blocked_flows"] = "Blocked Flows",
    ["custom"] = "Custom",
    ["export_flows_as_txt"] = "Export flows as TXT file",
    ["flows_vs_local_hosts"] = "Active Flows vs Local Hosts",
    ["flows_vs_traffic"] = "Active Flows vs Traffic",
    ["get_permanent_link"] = "Get permanent link",
    ["graph_info"] = "Graph Info",
    ["hover_the_mouse_to"] = "Hover the mouse on the chart to display minute top traffic statistics",
    ["max"] = "Max",
    ["minute_interface_top_stats"] = "Minute Interface Top Traffic Statistics",
    ["note_ases_rcvd"] = "Traffic received the traffic received by the autonomous system.",
    ["note_ases_sent"] = "Traffic sent is the traffic sent by the autonomous system.",
    ["note_ases_traffic"] = "Traffic shown is sent and received by the autonomous system.",
    ["note_chart_zoom"] = "Click and drag on the chart to zoom in, double click to zoom out.",
    ["note_protocols_shown"] = "Protocols not seen in the selected timeframe are not listed in the dropdown.",
    ["num_ms_rtt"] = "Round-Trip Time ms",
    ["num_nfq_drops"] = "Dropped Packets",
    ["num_nfq_pct"] = "Queue Fill %%",
    ["packet_drops"] = "Packet Drops",
    ["percentile"] = "95th <a href=\"%{url}\">Percentile</a>",
    ["permanent_link"] = "Permanent Link",
    ["pkt_drops"] = "Pkt Drops",
    ["query_too_much_time"] = "The query is taking a long time to complete",
    ["query_too_slow"] = "The query has taken too much time to complete",
    ["query_was_aborted"] = "Query was aborted",
    ["raw_flows"] = "Raw Flows",
    ["raw_proto_flows"] = "Raw %{proto} Flows",
    ["reset_zoom"] = "Reset Zoom",
    ["right_axis_note"] = "(right axis)",
    ["rtt"] = "RTT",
    ["tcp_finack_packets"] = "TCP FIN+ACK Packets",
    ["tcp_packets_lost"] = "TCP Packets Lost",
    ["tcp_packets_ooo"] = "TCP Packets Out-Of-Order",
    ["tcp_packets_retr"] = "TCP Retransmitted Packets",
    ["tcp_retr_ooo_lost"] = "TCP Retransmitted Out-Of-Order and Lost",
    ["tcp_rst_packets"] = "TCP RST Packets",
    ["tcp_syn_packets"] = "TCP SYN Packets",
    ["tcp_synack_packets"] = "TCP SYN+ACK Packets",
    ["the_select_timeframe_too_small_top_talkers"] = "The selected timeframe is too small to determine the top talkers. Please select at least a 1 minute frame.",
    ["top_clients"] = "Top %{protocol} Clients",
    ["top_interfaces"] = "Top Interfaces",
    ["top_l7_contacts"] = "Top %{protocol} L7 Contacts",
    ["top_ndpi_categories"] = "Top Categories",
    ["top_ndpi_protocols"] = "Top Protocols",
    ["top_profiles"] = "Top Profiles",
    ["top_receivers"] = "Top Receivers",
    ["top_senders"] = "Top Senders",
    ["top_servers"] = "Top %{protocol} Servers",
    ["trend"] = "Trend",
    ["zmq_received_flows"] = "ZMQ Received Flows",
    ["metrics_prefixes"] = {
      ["broadcast_bytes"] = "Broadcast Bytes",
      ["drops"] = "Drops",
      ["num_devices"] = "Num Devices",
      ["num_flows"] = "Num Flows",
      ["num_hosts"] = "Num Hosts",
      ["num_http_hosts"] = "Num HTTP Hosts",
      ["num_ms_rtt"] = "RTT ms",
      ["packets"] = "Packets",
    },
    ["metrics_suffixes"] = {
      ["by_as"] = "%{metric} by AS",
      ["egress"] = "Egress",
      ["ingress"] = "Ingress",
      ["inner"] = "Inner",
      ["rcvd"] = "rcvd",
      ["sent"] = "sent",
    },
  },
  ["host_config"] = {
    ["drop_all_host_traffic"] = "Drop All Host Traffic",
    ["hide_from_top"] = "Hide from Top Talkers",
    ["hide_host_from_top_descr"] = "Do not account host %{host} in top talkers computation",
    ["host_alias"] = "Host Alias",
    ["host_pool"] = "Host Pool",
    ["host_traffic_policy"] = "Host Traffic Policy",
    ["modify_host_pool_policy_btn"] = "Modify Host Pool Policy",
    ["trigger_alerts_for_host"] = "Trigger alerts for Host %{host}",
    ["trigger_host_alerts"] = "Trigger Host Alerts",
    ["unblock_host_traffic"] = "Unblock Host Traffic",
  },
  ["host_details"] = {
    ["blocked_traffic"] = "Blocked Traffic",
    ["host"] = "Host",
    ["host_cannot_be_found_message"] = "Host %{host} cannot be found.",
    ["host_parameter_missing_message"] = "Host parameter is missing (internal error ?)",
    ["host_traffic_blocked_quota"] = "Some host traffic has been blocked by an exceeded quota",
    ["host_traffic_blocked_quota_and_shaper"] = "Some host traffic has been blocked by an exceeded quota and a blocking shaper",
    ["host_traffic_blocked_shaper"] = "Some host traffic has been blocked by a blocking shaper",
    ["restore_from_cache_message"] = "Click <a href=%{js_code}> here</a> to restore it from cache.",
    ["snmp"] = "SNMP",
    ["trace_debug_host_info"] = "Host:%{hostinfo}, Vlan: %{vlan}",
    ["trace_debug_host_ip"] = "Host:%{hostip}, Vlan: %{vlan}",
    ["trace_debug_restored_host_info"] = "Restored Host Info",
    ["unknown_device_type"] = "Unknown Device Type",
  },
  ["host_pools"] = {
    ["alias_or_manufacturer"] = "Alias / Manufacturer",
    ["and_associated_members"] = "its RRD data and any associated members",
    ["cannot_delete_cp"] = "A pool cannot be deleted if there is any Captive Portal user associated",
    ["change_member_pool"] = "Change Member Pool",
    ["change_pool"] = "Switch Pool",
    ["children_safe"] = "Child Safe",
    ["confirm_delete_pool"] = "Do you really want to delete host pool",
    ["confirm_empty_pool"] = "Do you really want to remove all members from the host pool",
    ["confirm_remove_member"] = "Do you really want to remove member",
    ["confirm_reset_pool_quotas"] = "Do you really want to reset the \"%{pool}\" pool couters?",
    ["confirm_reset_quotas"] = "Do you really want to reset all the quotas counters?",
    ["create_new_quotas_here"] = "You can create new quotas <a href=\"%{url}\">here</a>.",
    ["create_pool_hint"] = "You can create new pools from the Manage Pools tab.",
    ["create_pools"] = "Manage Pools",
    ["delete_pool"] = "Delete Pool",
    ["duplicate_member"] = "Duplicate member address",
    ["duplicate_pool"] = "Duplicate pool name",
    ["edit_host_pools"] = "Edit Host Pools",
    ["empty_pool"] = "Empty Pool",
    ["enforce_quotas_per_pool_member"] = "Per-Member Quotas",
    ["enforce_shapers_per_pool_member"] = "Per-Member Shapers",
    ["from_pool"] = "from host pool",
    ["host_pools"] = "Host Pools",
    ["invalid_member"] = "Invalid member address format",
    ["manage_pools"] = "Manage Pool Membership",
    ["manufacturer_filter"] = "Manufacturer: %{manufacturer}",
    ["max_members_message"] = "With this version of ntopng you can only assign %{maxnum} members per host pool. Upgrade to the Enterprise version to remove this limit.",
    ["max_pools_message"] = "With this version of ntopng you can only create %{maxnum} host pools. Upgrade to the Enterprise version to remove this limit.",
    ["member_address"] = "Member Address",
    ["member_exists"] = "member \"%{member_name}\" not added. It is already assigned to pool \"%{member_pool}\".",
    ["member_filter"] = "Member: %{member}",
    ["members_limit_reached"] = "members limit reached",
    ["network_normalized"] = "network \"%{network}\" has a non-zero host identifier. Using \"%{network_normalized}\".",
    ["new_pool"] = "New Pool",
    ["no_pools_defined"] = "No Host Pools defined.",
    ["per_member_quotas"] = "When the per-member quotas option is set, each host will have a separate quota count. When unset, all the hosts traffic will count as a whole to the quota limit",
    ["per_member_shapers"] = "When the per-member shapers option is set, each host will its own shapers. When unset, all the hosts belonging to the same pool will share the same shapers",
    ["pool"] = "Pool Name",
    ["pool_name"] = "Pool Name",
    ["pool_name_pattern_error"] = "Please enter only lowercase characters, numbers or underscore",
    ["remove_member"] = "Remove Member",
    ["reset_quotas"] = "Reset Quotas",
    ["search_member"] = "Search Member",
    ["select_new_pool"] = "Select a new pool from the dropdown below to assign member \"%{member}\" to:",
    ["specify_member_address"] = "Please specify an IPv4/IPv6 address or network or a MAC address",
    ["specify_pool_name"] = "Specify a pool name",
    ["view"] = "View",
  },
  ["hosts_comparison"] = {
    ["hosts_parameter_missing_message"] = "Hosts parameter is missing (internal error ?)",
  },
  ["hosts_stats"] = {
    ["all"] = "All",
    ["all_hosts"] = "All Hosts",
    ["as_geolocation"] = "AS Geolocation",
    ["as_info"] = "AS Info",
    ["as_path"] = "AS Path",
    ["as_prefixes"] = "AS Prefixes",
    ["asn_title"] = "for AS %{asn}",
    ["bgp_updates"] = "BGP Updates",
    ["blacklisted"] = "Blacklisted",
    ["blacklisted_hosts_only"] = "Blacklisted Hosts Only",
    ["blocking_traffic_policy_popup_msg"] = "Host traffic is affected by a blocking Traffic Policy",
    ["country_title"] = "for Country %{country}",
    ["filter_hosts"] = "Filter Hosts",
    ["filtered"] = "Filtered",
    ["filtered_hosts_only"] = "Hosts With Blocked Traffic",
    ["host_pool"] = "Host Pool %{pool_name}",
    ["hosts"] = "Hosts",
    ["hosts_page_title"] = "%{all} %{traffic_type} %{local_remote} %{protocol} %{network} %{ip_version} %{os} Hosts %{country_asn_or_mac} %{vlan}",
    ["idle_hosts_not_listed"] = "Idle hosts not listed.",
    ["in_network"] = "in %{network}",
    ["ipver_title"] = "IPv%{version_num}",
    ["label_blacklisted_host"] = "Blacklisted Host",
    ["label_local_host"] = "Local Host",
    ["label_remote_host"] = "Remote Host",
    ["local"] = "Local",
    ["local_hosts_only"] = "Local Hosts Only",
    ["location"] = "Location",
    ["mac_title"] = "with Mac %{mac}",
    ["more_info_about_as_popup_msg"] = "More Information about AS",
    ["pool_title"] = "for Pool %{poolname}",
    ["remote"] = "Remote",
    ["remote_hosts_only"] = "Remote Hosts Only",
    ["source_id"] = "Source Id",
    ["traffic_type_all"] = "All Hosts",
    ["traffic_type_one_way"] = "One-Way Traffic",
    ["user"] = "User %{pool_name}",
    ["user_title"] = "for User %{poolname}",
    ["vlan_title"] = "VLAN %{vlan}",
  },
  ["http_page"] = {
    ["distribution"] = "Distribution",
    ["http_queries"] = "HTTP Queries Sent",
    ["http_responses"] = "HTTP Responses Received",
    ["method"] = "Method",
    ["other_method"] = "Other Method",
    ["requests"] = "Requests",
    ["requests_served"] = "Requests Served",
    ["response_code"] = "Response code",
    ["response_code_1xx"] = "1xx (Informational)",
    ["response_code_2xx"] = "2xx (Success)",
    ["response_code_3xx"] = "3xx (Redirection)",
    ["response_code_4xx"] = "4xx (Client Error)",
    ["response_code_5xx"] = "5xx (Server Error)",
    ["responses"] = "Responses",
    ["traffic_received"] = "Traffic Received",
    ["traffic_sent"] = "Traffic Sent",
    ["virtual_hosts"] = "Virtual Hosts",
  },
  ["http_servers_stats"] = {
    ["actual_requests"] = "Actual Requests",
    ["bytes_received"] = "Bytes Received",
    ["bytes_sent"] = "Bytes Sent",
    ["http_server_ip"] = "HTTP Server IP",
    ["http_servers"] = "Server HTTP",
    ["http_virtual_host"] = "HTTP Virtual Host",
    ["local_http_servers"] = "Local HTTP Servers",
    ["total_requests"] = "Total Requests",
  },
  ["icmp_page"] = {
    ["icmp_message"] = "ICMP Message",
    ["last_rcvd_peer"] = "Last Rcvd Peer",
    ["last_sent_peer"] = "Last Sent Peer",
    ["packets_received"] = "Packets Received",
    ["packets_sent"] = "Packets Sent",
  },
  ["icmp_v4_msgs"] = {
    ["type_0_0_echo_reply"] = "Echo Reply",
    ["type_10_0_router_selection"] = "Router Selection",
    ["type_11_0_ttl_expired_in_transit"] = "Time Exceeded: TTL expired in transit",
    ["type_11_1_fragment_reassembly_time_exceeded"] = "Time Exceeded: Fragment reassembly time exceeded",
    ["type_12_0_parameter_problem"] = "Parameter Problem",
    ["type_13_0_timestamp_request"] = "Timestamp Request",
    ["type_14_0_timestamp_reply"] = "Timestamp Reply",
    ["type_15_0_information_request"] = "Information Request",
    ["type_16_0_information_reply"] = "Information Reply",
    ["type_17_0_address_mask_request"] = "Address Mask Request",
    ["type_18_0_address_mask_reply"] = "Address Mask Reply",
    ["type_30_0_traceroute"] = "Traceroute",
    ["type_3_0_destination_network_unreachable"] = "Destination Network Unreachable",
    ["type_3_0_destination_unreachable"] = "Destination Unreachable",
    ["type_3_1_destination_host_unreachable"] = "Destination Host Unreachable",
    ["type_3_2_destination_protocol_unreachable"] = "Destination Protocol Unreachable",
    ["type_3_3_destination_port_unreachable"] = "Destination Port Unreachable",
    ["type_3_4_fragmentation_required"] = "Fragmentation required, and DF flag set",
    ["type_3_6_destination_network_unknown"] = "Destination Network Unknown",
    ["type_3_7_destination_host_unknown"] = "Destination Host Unknown",
    ["type_4_0_source_quench"] = "Source Quench",
    ["type_5_0_redirect"] = "Redirect",
    ["type_8_0_echo_request"] = "Echo Request",
    ["type_9_0_router_advertisement"] = "Router Advertisement",
  },
  ["icmp_v4_types"] = {
    ["type_0_0_echo_reply"] = "Echo Reply",
    ["type_10_0_route_solicitation"] = "Route solicitation",
    ["type_11_0_ttl_equals_0_during_transit"] = "TTL equals 0 during transit",
    ["type_11_1_ttl_equals_0_during_reassembly"] = "TTL equals 0 during reassembly",
    ["type_12_0_ip_header_bad"] = "IP header bad (catchall error)",
    ["type_12_1_required_options_missing"] = "Required options missing",
    ["type_13_0_timestamp_request"] = "Timestamp request (obsolete)",
    ["type_14_0_timestamp_reply"] = "Timestamp reply (obsolete)",
    ["type_15_0_information_request"] = "Information request (obsolete)",
    ["type_16_0_information_reply"] = "Information reply (obsolete)",
    ["type_17_0_address_mask_request"] = "Address mask request",
    ["type_18_0_address_mask_reply"] = "Address mask reply",
    ["type_3_0_network_unreachable"] = "Network Unreachable",
    ["type_3_10_destination_host_administratively_prohibited"] = "Destination host administratively prohibited",
    ["type_3_11_network_unreachable_for_tos"] = "Network unreachable for TOS",
    ["type_3_12_host_unreachable_for_tos"] = "Host unreachable for TOS",
    ["type_3_13_communication_administratively_prohibited_by_filtering"] = "Communication administratively prohibited by filtering",
    ["type_3_14_host_precedence_violation"] = "Host precedence violation",
    ["type_3_15_precedence_cutoff_in_effect"] = "Precedence cutoff in effect",
    ["type_3_1_host_unreachable"] = "Host Unreachable",
    ["type_3_2_protocol_unreachable"] = "Protocol Unreachable",
    ["type_3_3_port_unreachable"] = "Port Unreachable",
    ["type_3_4_fragmentation_needed_but_no_fragment_bit_set"] = "Fragmentation needed but no fragment bit set",
    ["type_3_5_source_routing_failed"] = "Source routing failed",
    ["type_3_6_destination_network_unknown"] = "Destination network unknown",
    ["type_3_7_destination_host_unknown"] = "Destination host unknown",
    ["type_3_8_source_host_isolated"] = "Source host isolated (obsolete)",
    ["type_3_9_destination_network_administratively_prohibited"] = "Destination network administratively prohibited",
    ["type_4_0_source_quench"] = "Source quench",
    ["type_5_0_redirect_for_network"] = "Redirect for network",
    ["type_5_1_redirect_for_host"] = "Redirect for host",
    ["type_5_2_redirect_for_tos_and_network"] = "Redirect for TOS and network",
    ["type_5_3_redirect_for_tos_and_host"] = "Redirect for TOS and host",
    ["type_8_0_echo_request_x"] = "Echo request x",
    ["type_9_0_router_advertisement"] = "Router advertisement",
  },
  ["icmp_v6_msgs"] = {
    ["type_128_0_echo_request"] = "Echo Request",
    ["type_129_0_echo_reply"] = "Echo Reply",
    ["type_133_0_router_solicitation"] = "Router Solicitation",
    ["type_134_0_router_advertisement"] = "Router Advertisement",
    ["type_135_0_neighbor_solicitation"] = "Neighbor Solicitation",
    ["type_136_0_neighbor_advertisement"] = "Neighbor Advertisement",
    ["type_1_0_destination_unreachable"] = "Destination Unreachable",
    ["type_2_0_packet_too_big"] = "Packet Too Big",
    ["type_3_0_hop_limit_exceeded_in_transit"] = "Time Exceeded: hop limit exceeded in transit",
    ["type_3_1_fragment_reassembly_time_exceeded"] = "Time Exceeded: fragment reassembly time exceeded",
    ["type_4_0_parameter_problem"] = "Parameter Problem",
  },
  ["icmp_v6_types"] = {
    ["type_0_reserved"] = "Reserved",
    ["type_100_private_experimentation"] = "Private experimentation",
    ["type_101_private_experimentation"] = "Private experimentation",
    ["type_127_reserved_for_expansion_of_icmpv6_error_messages"] = "Reserved for expansion of ICMPv6 error messages",
    ["type_128_echo_request"] = "Echo Request",
    ["type_129_echo_reply"] = "Echo Reply",
    ["type_130_multicast_listener_query"] = "Multicast Listener Query",
    ["type_131_multicast_listener_report"] = "Multicast Listener Report",
    ["type_132_multicast_listener_done"] = "Multicast Listener Done",
    ["type_133_router_solicitation"] = "Router Solicitation",
    ["type_134_router_advertisement"] = "Router Advertisement",
    ["type_135_neighbor_solicitation"] = "Neighbor Solicitation",
    ["type_136_neighbor_advertisement"] = "Neighbor Advertisement",
    ["type_137_redirect_message"] = "Redirect Message",
    ["type_138_router_renumbering"] = "Router Renumbering",
    ["type_139_icmp_node_information_query"] = "ICMP Node Information Query",
    ["type_140_icmp_node_information_response"] = "ICMP Node Information Response",
    ["type_141_inverse_neighbor_discovery_solicitation_message"] = "Inverse Neighbor Discovery Solicitation Message",
    ["type_142_inverse_neighbor_discovery_advertisement_message"] = "Inverse Neighbor Discovery Advertisement Message",
    ["type_143_version_2_multicast_listener_report"] = "Version 2 Multicast Listener Report",
    ["type_144_home_agent_address_discovery_request_message"] = "Home Agent Address Discovery Request Message",
    ["type_145_home_agent_address_discovery_reply_message"] = "Home Agent Address Discovery Reply Message",
    ["type_146_mobile_prefix_solicitation"] = "Mobile Prefix Solicitation",
    ["type_147_mobile_prefix_advertisement"] = "Mobile Prefix Advertisement",
    ["type_148_certification_path_solicitation_message"] = "Certification Path Solicitation Message",
    ["type_149_certification_path_advertisement_message"] = "Certification Path Advertisement Message",
    ["type_150_icmp_messages_utilized_by_experimental_mobility_protocols"] = "ICMP messages utilized by experimental mobility protocols",
    ["type_151_multicast_router_advertisement"] = "Multicast Router Advertisement",
    ["type_152_multicast_router_solicitation"] = "Multicast Router Solicitation",
    ["type_153_multicast_router_termination"] = "Multicast Router Termination",
    ["type_154_fmipv6_messages"] = "FMIPv6 Messages",
    ["type_155_rpl_control_message"] = "RPL Control Message",
    ["type_156_ilnpv6_locator_update_message"] = "ILNPv6 Locator Update Message",
    ["type_157_duplicate_address_request"] = "Duplicate Address Request",
    ["type_158_duplicate_address_confirmation"] = "Duplicate Address Confirmation",
    ["type_159_mpl_control_message"] = "MPL Control Message",
    ["type_1_destination_unreachable"] = "Destination Unreachable",
    ["type_200_private_experimentation"] = "Private experimentation",
    ["type_201_private_experimentation"] = "Private experimentation",
    ["type_255_reserved_for_expansion_of_icmpv6_informational_messages"] = "Reserved for expansion of ICMPv6 informational messages",
    ["type_2_packet_too_big"] = "Packet Too Big",
    ["type_3_time_exceeded"] = "Time Exceeded",
    ["type_4_parameter_problem"] = "Parameter Problem",
  },
  ["if_stats_config"] = {
    ["custom_name"] = "Custom Name",
    ["custom_name_popup_msg"] = "Specify an alias for the interface",
    ["hide_from_top_networks"] = "Hide from Top Networks",
    ["hide_from_top_networks_descr"] = "e.g. %{example}",
    ["interface_network_discovery"] = "Periodic Interface Network Discovery",
    ["interface_rrd_creation"] = "Create Interface Timeseries",
    ["interface_speed"] = "Interface Speed (Mbit/s)",
    ["interface_speed_popup_msg"] = "Specify the maximum interface speed",
    ["is_mirrored_traffic"] = "Mirrored Traffic",
    ["refresh_rate"] = "Realtime Stats Refresh Rate (sec)",
    ["refresh_rate_popup_msg"] = "Specify the stats refresh rate for the interface",
    ["scaling_factor"] = "Ingress Packets Sampling Rate",
    ["scaling_factor_popup_msg"] = "This should match your capture interface sampling rate",
    ["trigger_interface_alerts"] = "Trigger Interface Alerts",
  },
  ["if_stats_overview"] = {
    ["active"] = "Active",
    ["all_counters"] = "All Counters",
    ["blocked_flows"] = "Blocked Flows",
    ["bridged_traffic"] = "Bridged Traffic",
    ["buffer_full"] = "Buffer Full",
    ["collected_flows"] = "Collected Flows",
    ["dropped_flows"] = "Dropped Flows",
    ["dropped_packets"] = "Dropped Packets",
    ["drops_only"] = "Drops Only",
    ["dumped_files"] = "Dumped Files",
    ["dumped_packets"] = "Dumped Packets",
    ["egress_packets"] = "Egress Packets",
    ["exported_flows"] = "Exported Flows",
    ["family"] = "Family",
    ["flows_export_statistics"] = "Flows Export Statistics",
    ["has_traffic_directions"] = "with RX/TX Directions",
    ["id"] = "Id",
    ["iface_switch_active_msg"] = "The selected interface <b>%{interface}</b> [ifid: %{ifid}] is now active",
    ["iface_switch_empty_session_msg"] = "Empty session",
    ["iface_switch_error_msg"] = "Error while switching interfaces",
    ["in_path_interface"] = "In-Path Interface (Bump in the Wire)",
    ["ingress_packets"] = "Ingress Packets",
    ["ingress_traffic"] = "Ingress Traffic",
    ["interface_ip"] = "Interface IP",
    ["interface_name"] = "Interface Name",
    ["interface_rx_updates"] = "Interface RX Updates",
    ["nf"] = "Netfilter",
    ["nf_enobufs"] = "No Buffer Space",
    ["nf_handle_packet_failed"] = "Queued Packets Handling Failures",
    ["nf_queue_dropped"] = "Dropped Packets (Queue Full)",
    ["nf_queue_pct"] = "Queue Fill Level",
    ["nf_queue_total"] = "Queued Packets",
    ["nf_queue_user_dropped"] = "Dropped Packets (Couldn't Send to Userspace)",
    ["note"] = "NOTE",
    ["note_drop_ifstats_dynamic"] = "Drops are available in the main interface",
    ["note_drops_sflow"] = "Drops are shown only for sFlow as NetFlow does not report them.<br><A HREF=https://www.ietf.org/rfc/rfc3176.txt>sFlow</A> drops count the number of times the sFlow agent detected that a packet marked to be sampled was dropped due to lack of resources. The drops counter reports the total number of drops detected since the agent was last reset. A high drop rate indicates that the management agent is unable to process samples as fast as they are being generated by hardware. Increasing the sFlow sampling rate will reduce the drop rate. Note: An agent that cannot detect drops will always report zero.",
    ["note_packets"] = "In ethernet networks, each packet has an <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">overhead of 24 bytes</A> [preamble (7 bytes), start of frame (1 byte), CRC (4 bytes), and <A HREF=\"http://en.wikipedia.org/wiki/Interframe_gap\">IFG</A> (12 bytes)]. Such overhead needs to be accounted to the interface traffic, but it is not added to the traffic being exchanged between IP addresses. This is because such data contributes to interface load, but it cannot be accounted in the traffic being exchanged by hosts, and thus expect little discrepancies between host and interface traffic values.",
    ["note_probe_zmq_drops_export_queue_full"] = "Remote probe has successfully processed these flows but is was unable to enqueue them for the export as the export queue was full.",
    ["paused"] = "Paused",
    ["probe_ip"] = "Probe IP",
    ["probe_timeout_idle"] = "Idle Timeout",
    ["probe_timeout_lifetime"] = "Lifetime Timeout",
    ["probe_zmq_drops_export_queue_full"] = "Queue Full Dropped Flows",
    ["probe_zmq_num_endpoints"] = "Active Probe ZMQ Endpoints",
    ["probe_zmq_num_flow_exports"] = "Exported Flows",
    ["public_probe_ip"] = "Public Probe IP",
    ["received_traffic"] = "Received Traffic",
    ["remote_probe"] = "Remote Probe",
    ["reset_counters"] = "Reset Counters",
    ["send_error"] = "Send Error",
    ["sflow_counter_updates"] = "sFlow Counter Updates",
    ["shaped_filtered_packets"] = "Shaped/Filtered Packets",
    ["snmp"] = "SNMP",
    ["state"] = "State",
    ["traffic_breakdown"] = "Traffic Breakdown",
    ["zmq_message_drops"] = "ZMQ Message Drops",
    ["zmq_rx_statistics"] = "ZMQ RX Statistics",
  },
  ["index_page"] = {
    ["applications"] = "Protocols",
    ["asns"] = "ASNs",
    ["dashboard"] = "Dashboard",
    ["hosts"] = "Hosts",
    ["live_update"] = "Live update",
    ["minute"] = "Minute",
    ["never"] = "Never",
    ["no_packet_warning"] = "No packet has been received yet on interface %{ifname}.<p>Please wait %{countdown} seconds until this page reloads.",
    ["refresh"] = "Refresh",
    ["refresh_frequency"] = "Refresh frequency",
    ["refresh_graph_popup_msg"] = "Refresh graph",
    ["seconds"] = "Seconds",
    ["senders"] = "Senders",
    ["top_flow_talkers"] = "Top Flow Talkers",
  },
  ["live_capture"] = {
    ["active_live_captures"] = "Live Captures",
    ["note"] = "Capture live traffic for host %{hostinfo}. The stream will automatically stop after 1 minute or 100k packets.",
  },
  ["live_traffic"] = {
    ["error_generic"] = "Generic Error",
    ["error_not_found"] = "Not found",
    ["error_not_granted"] = "Request not granted",
    ["modal_vlan_tagged_with_bpf_confirmation"] = "This host is VLAN-tagged. The BPF filter submitted, to properly match packets, must contain VLAN 51. The VLAN can be specified in the filter as <br> <pre>vlan %{vlan} and <i>...rest of the filter...</i></pre>",
    ["modal_vlan_tagged_with_bpf_continue"] = "Continue",
    ["modal_vlan_tagged_with_bpf_title"] = "Host pcap Download",
  },
  ["local_flow_matrix"] = {
    ["error_no_local_hosts"] = "No local hosts can be found",
    ["local_flow_matrix"] = "Local Flow Matrix",
    ["local_hosts_active_flows_matrix"] = "Local Hosts Active Flows Matrix",
  },
  ["local_hosts_stats"] = {
    ["criteria"] = "Criteria",
    ["looking_glass"] = "Looking Glass",
  },
  ["locales"] = {
    ["de"] = "German",
    ["en"] = "English",
    ["it"] = "Italian",
    ["jp"] = "Japanese",
  },
  ["login"] = {
    ["add_captive_portal_user"] = "Add Captive Portal User",
    ["add_web_user"] = "Add Web User",
    ["auth_success"] = "Authentication Successful",
    ["blacklisted_ip_notice"] = "Too many failed authentication attempts. Please retry after a while.",
    ["change_password"] = "Change Password",
    ["confirm_password"] = "Confirm Password",
    ["device_label"] = "Device Label",
    ["donation"] = "If you find %{product} useful, please support us by making a small <A href=\"%{donation_url}\">donation</A>. Your funding will help to run and foster the development of this project. Thank you.",
    ["enter_credentials"] = "Please enter your credentials for accessing this network.",
    ["informative_captive_join"] = "Access the Internet",
    ["informative_captive_portal_tos"] = "I have read and agreeed the <a target='_blank' href='%{url}'>terms of service</a>.",
    ["internet_redirecting"] = "We're redirecting you to the Internet...",
    ["license"] = "%{product} is released under <a href=\"%{license_url}\">%{license}</a>.",
    ["logging_out"] = "Logging out...",
    ["login"] = "Login",
    ["logout"] = "Logout",
    ["logout_user_x"] = "Logout %{user}",
    ["must_change_password"] = "Default admin password must be changed. Please enter a new password below.",
    ["password"] = "Password",
    ["password_mismatch"] = "Passwords do not match",
    ["password_not_valid"] = "Please specify a different password",
    ["password_pattern_error"] = "Please enter at least 5 valid characters.",
    ["password_ph"] = "Password (default admin)",
    ["passwords_dont_match"] = "Passwords don't match.",
    ["unsupported_browser"] = "Your browser is not supported.<br>Please consider using a recent Firefox or Chrome.",
    ["username"] = "Username",
    ["username_ph"] = "Username (default admin)",
    ["web_users"] = "Web Users",
    ["welcome_to"] = "Welcome to %{product}",
  },
  ["mac_details"] = {
    ["json_error_inactive"] = "JSON Error: inactive host purged or %{product} terminated?",
    ["mac"] = "Mac",
    ["mac_cannot_be_found_message"] = "Mac %{mac} cannot be found.",
    ["mac_parameter_missing_message"] = "Mac parameter is missing (internal error ?)",
  },
  ["mac_stats"] = {
    ["all_devices"] = "All",
    ["all_layer_2_devices"] = "All Mac Addresses",
    ["all_manufacturers"] = "All Manufacturers",
    ["arp_total"] = "ARP",
    ["dev_layer_2_devices"] = "%{device_type} Mac Addresses",
    ["dhcp_only"] = "DHCP Only",
    ["filter_macs"] = "Filter Macs",
    ["idle_devices_not_listed"] = "Idle devices not listed.",
    ["layer_2_dev_devices"] = "%{device_type} Mac Addresses",
    ["layer_2_devices_with_manufacturer"] = "%{manufacturer} %{title}",
    ["layer_2_source_devices"] = "%{device_type} Source Mac Addresses",
    ["manufacturer"] = "Manufacturer",
    ["source_macs"] = "Source Only",
  },
  ["manage_data"] = {
    ["all_hosts"] = "All",
    ["delete"] = "Delete Host Data",
    ["delete_active_interface"] = "Delete Interface Data",
    ["delete_inactive_interfaces"] = "Delete Inactive Interfaces Data",
    ["delete_tab"] = "Delete",
    ["export"] = "Export Host Data",
    ["export_tab"] = "Export",
    ["hosts"] = "Hosts",
    ["ip_or_mac_address"] = "IP or MAC Address",
    ["local_hosts"] = "Local",
    ["mac_or_ip_required"] = "Please insert a valid IP or MAC Address",
    ["manage_data"] = "Manage Stored Data",
    ["remote_hosts"] = "Remote",
    ["single"] = "Single",
  },
  ["manage_users"] = {
    ["add_new_user"] = "Add New User",
    ["administrator"] = "Administrator",
    ["allowed_interface"] = "Allowed Interface",
    ["allowed_networks"] = "Allowed Networks",
    ["allowed_networks_descr"] = "Comma separated list of networks this user can view. Example:",
    ["allowed_passwd_charset"] = "Allowed characters are ISO 8859-1 (latin1) upper and lower case letters, numbers and special symbols",
    ["any_interface"] = "Any Interface",
    ["authentication_lifetime"] = "Authentication Lifetime",
    ["change_user_password"] = "Change User Password",
    ["change_user_preferences"] = "Change User Preferences",
    ["confirm_delete_user"] = "Are you sure you want to delete %{user}?",
    ["enable_captive_portal"] = "<a href=\"%{url}\">Enabling the captive portal</a> allows you to define captive portal users",
    ["expires_after"] = "Expires after",
    ["group"] = "Group",
    ["host_pool_id"] = "Host Pool Id",
    ["manage"] = "Manage",
    ["manage_user_x"] = "Manage User %{user}",
    ["manage_users"] = "Manage Users",
    ["new_password"] = "New Password",
    ["new_password_confirm"] = "Confirm New Password",
    ["no_host_pools"] = "No Host Pools defined. Please create one <a href='%{url}'>here</a>",
    ["non_privileged_user"] = "Non Privileged User",
    ["old_password"] = "Old Password",
    ["the_auth_can_be_perpetual"] = "The authentication can be perpetual or can expire after the specified time",
    ["the_host_pool_associated"] = "The host pool that will be associated to the user upon successful authentication",
    ["unlimited"] = "Unlimited",
    ["user_role"] = "User Role",
    ["web_captive_users"] = "Web/Captive Portal Users",
  },
  ["metrics"] = {
    ["days"] = "Days",
    ["hours"] = "Hours",
    ["mins"] = "Mins",
    ["secs"] = "Secs",
  },
  ["ndpi_page"] = {
    ["application_protocol"] = "Application Protocol",
    ["application_protocol_category"] = "Application Protocol Category",
    ["custom_applications"] = "Custom Applications",
    ["live_flows_count"] = "Live Flows Count",
    ["note"] = "NOTE",
    ["note_historical_per_protocol_traffic"] = "Historical %{what} traffic data can be enabled via the <a href='%{url}'>%{flask_icon} Preferences</a>.",
    ["note_live_flows_chart"] = "This chart depicts only TCP connections.",
    ["note_possible_probing_alert"] = "An icon like %{icon} indicates a possible probing (or application server down) alert as the host has received traffic for a specific application protocol without sending back any data. You can use <A HREF='%{url}'>historical reports</A> to drill-down this issue.",
    ["note_protocol_usage_time"] = "Protocol usage time is computed on discrete slot intervals.",
    ["overview"] = "%{what} Overview",
    ["rcvd"] = "Rcvd",
    ["received_only"] = "Received only",
    ["sent"] = "Sent",
    ["sent_only"] = "Sent only",
    ["total_since_startup"] = "Total (Since Startup)",
    ["unable_to_find_host"] = "Unable to find %{host_ip} (data expired ?)",
  },
  ["nedge"] = {
    ["a_member_address_is"] = "A member address is a rule to assign devices to a user. The following order applies:",
    ["a_zero_quota_is_unlimited"] = "A zero quota means unlimited traffic.",
    ["active_user"] = "Active User",
    ["add_gateway"] = "Add Gateway",
    ["add_member"] = "Add Member",
    ["add_routing_policy"] = "Add Routing Policy",
    ["add_some_gateways_first"] = "No gateways defined. Please define some gateways <a href=\"%{url}\">here</a>.",
    ["add_static_lease"] = "Add Static Lease",
    ["add_static_route"] = "Add Static Route",
    ["add_system_user"] = "Add System User",
    ["add_user_member"] = "Add User Member",
    ["applied_policy"] = "Applied Policy",
    ["apply_and_reboot"] = "Apply and Reboot",
    ["apply_and_restart_self"] = "Apply and Restart",
    ["apply_configuration"] = "Apply Configuration",
    ["apply_configuration_and_reboot"] = "You are going to apply the new configuration. Network interfaces will be reconfigured according to the specified settings and the system will be rebooted. Wrong settings can cause the system to lose IP connectivity. Only proceed if you are extremely confident settings are correct.",
    ["apply_configuration_and_restart_self"] = "You are going to apply the new configuration. This will cause %{product} to restart and can cause this web GUI to becomes unresponsive for a few seconds.",
    ["apply_the_initial_device_configuration"] = "Apply the initial device configuration.",
    ["authentication_gui_and_captive_portal"] = "The authentication methods apply both to the %{product} gui and the <a href=\"%{url}\">Captive Portal</a> access.",
    ["bandwidth_allocation"] = "Bandwidth Allocation",
    ["bind_to_any"] = "Any Interface",
    ["bind_to_lan"] = "LAN Interface",
    ["cannot_rename_gateway"] = "Cannot rename gateway.",
    ["cannot_rename_policy"] = "Cannot rename policy.",
    ["cannot_rename_static_route"] = "Cannot rename static route.",
    ["captive_portal_other_methods"] = "The Captive Portal uses the authentication methods defined in the <a href=\"%{url}\">Authentication preferences</a> (e.g. Radius).",
    ["categories_policies"] = "Category Policies",
    ["configure_routing_policies"] = "Configure Routing Policies",
    ["configured_members"] = "Configured Members",
    ["confirm_delete_gateway"] = "Do you really want to delete gateway \"%{gw}\" ?",
    ["confirm_delete_policy"] = "Do you really want to delete policy \"%{policy}\" ?",
    ["confirm_delete_static_lease"] = "Do you really want to delete \"%{hostname}\" static lease?",
    ["confirm_delete_static_route"] = "Do you really want to delete static route \"%{sr}\" ?",
    ["confirm_remove_member_from_user"] = "Do you really want to remove the member %{member} from user %{user}?",
    ["custom"] = "Custom",
    ["custom_datetime"] = "Current Time",
    ["custom_datetime_descr"] = "Manually sets the date and time of the system.",
    ["custom_policy"] = "Custom Policy",
    ["data_reset"] = "Data Reset",
    ["data_reset_msg"] = "Do you really want to reset all the device data? Data include stored timeseries, flows, alerts, Redis caches and host counters. Device configuration an system setup won't be affected by the reset.<br>This will cause %{product} to restart and can cause this web GUI to becomes unresponsive for a few seconds.",
    ["date_time"] = "Date and Time",
    ["default_categories"] = "Default Category Policies",
    ["default_categories_with_a_defined_policy"] = "Default Custom Category Policies",
    ["default_categories_with_a_defined_quota"] = "Default Quota Category Policies",
    ["default_categories_with_policy_x"] = "Default %{x} Category Policies",
    ["default_gateway"] = "Default Gateway",
    ["default_policy"] = "Default Policy",
    ["default_protocols"] = "Default Protocol Policies",
    ["default_protocols_with_a_defined_policy"] = "Default Custom Protocol Policies",
    ["default_protocols_with_a_defined_quota"] = "Default Quota Protocol Policies",
    ["default_protocols_with_policy_x"] = "Default %{x} Protocol Policies",
    ["default_shaper"] = "Pass",
    ["default_shaper_descr"] = "The Default bandwidth percentage of the interface speed.",
    ["delete_gateway"] = "Delete Gateway",
    ["delete_policy"] = "Delete Policy",
    ["delete_static_lease"] = "Delete Static Lease",
    ["delete_static_route"] = "Delete Static Route",
    ["device_protocol_policy_has_higher_priority"] = "Device Policies have higher priority than the Protocol Policies.",
    ["device_protocols_blocked_warning"] = "Traffic will <b>not</b> be blocked because %{device_protocols_policies} are disabled",
    ["device_protocols_policies"] = "Device Policies",
    ["dhcp_disabled_warning"] = "If no other DHCP server is available in your network then your clients won't be able to connect automatically.",
    ["dhcp_first_ip"] = "First IP address",
    ["dhcp_first_ip_descr"] = "The first IP address of the DHCP address pool",
    ["dhcp_last_ip"] = "Last IP address",
    ["dhcp_last_ip_descr"] = "The last IP address of the DHCP address pool",
    ["dhcp_server"] = "DHCP Server",
    ["dhcp_server_description"] = "Enable the DHCP server.",
    ["dhcp_server_not_enabled"] = "The DHCP server is not enabled. You can enabled it <a href=\"%{url}\">here</a>.",
    ["dns_configuration"] = "DNS Configuration",
    ["dns_server_preset"] = "DNS Server Preset",
    ["dns_server_preset_descr"] = "You can select a featured DNS servers from the list or specify your custom DNS servers.",
    ["download_description"] = "The maximum download speed for the interface.",
    ["download_speed"] = "Download Speed",
    ["edit_gateway"] = "Edit Gateway",
    ["edit_quotas"] = "Edit Quotas",
    ["edit_routing_policy"] = "Edit Routing Policy",
    ["edit_static_route"] = "Edit Static Route",
    ["edit_users"] = "Edit Users",
    ["enable_device_protocols_policies"] = "Device Protocols Policies",
    ["enable_interface"] = "Enable Interface",
    ["enable_interface_descr"] = "Enable or disable the network interface.",
    ["enable_nat"] = "Enable NAT",
    ["enable_nat_descr"] = "If enabled, the clients IP addresses will be maqueraded with the IP address of the WAN interface.",
    ["enforce_global_dns"] = "Enforce Global DNS",
    ["enforce_global_dns_description"] = "Enable DNS forging to force the devices to use the specified global DNS.",
    ["factory_reset"] = "Factory Reset",
    ["factory_reset_msg"] = "Do you really want to reset the device to its factory configuration? Any configuration and data will be lost.",
    ["filter_policies"] = "Filter Policies",
    ["gateway"] = "Gateway",
    ["gateway_exists"] = "Gateway %{gw} already exists.",
    ["gateway_interface_descr"] = "Specify the network interface to use to determine the gateway IP address",
    ["gateway_name"] = "Gateway Name",
    ["gateway_type"] = "Mode",
    ["gateway_type_address_descr"] = "Specify the IP address of the gateway.",
    ["gateway_x"] = "Gateway %{gw}",
    ["gateways"] = "Gateways",
    ["gateways_status"] = "Gateways Status",
    ["global_dns"] = "Global DNS",
    ["global_shapers_rates"] = "Global Bandwidth Control",
    ["high_priority"] = "High Priority",
    ["higher_priority"] = "Higher Priority",
    ["hostname"] = "Hostname",
    ["hostname_lease_exists"] = "A static lease with hostname \"%{hostname}\" already exists.",
    ["interfaces_configuration"] = "Interfaces Configuration",
    ["invalid_dhcp_range"] = "Invalid DHCP range. Ensure that the DHCP IP addresses are inside the LAN network range, otherwise your devices won't be able to surf the web.",
    ["ip_address_takes_preced"] = "An IP address takes precedence over a network address",
    ["ip_lease_exists"] = "A static lease with ip \"%{ip}\" already exists.",
    ["lan"] = "LAN",
    ["lan_ip_addr"] = "LAN IP Address",
    ["lan_ip_addr_descr"] = "Specify the LAN interface IP address.",
    ["lan_recovery_ip"] = "LAN Recovery IP",
    ["lan_recovery_ip_descr"] = "An additional IP address to reach the %{product} device on the LAN interface.",
    ["lan_recovery_warning"] = "Please ensure that this does not collide with any other defined network.",
    ["link_not_ready"] = "Link Not Ready",
    ["linkdown"] = "Link Down",
    ["low_priority"] = "Low Priority",
    ["lower_priority"] = "Lower Priority",
    ["mac_address_takes_preced"] = "A mac address takes precedence over an IP address",
    ["mac_lease_exists"] = "A static lease for mac \"%{mac}\" already exists.",
    ["max_bps_per_host"] = "Max %{bps} per Host",
    ["max_perc"] = "Max %{perc}%%",
    ["max_rrt"] = "Max RTT",
    ["max_rrt_description"] = "The maximum Round Trip Time toward the monitor address. If the measured RTT exceeds this value, the gateway is considered down.",
    ["maximum_enforced"] = "Maximum Enforced",
    ["maximum_enforced_descr"] = "If set to maximum enforced, the maximum bandwidth allocation will be enforced regardless of the available bandwidth.",
    ["member_address"] = "Member Address",
    ["member_exists"] = "Member %{member} not added, as it is already assigned to user %{existing_user}",
    ["members"] = "Members",
    ["members_for_user_x"] = "Members of User %{user}",
    ["min_perc"] = "Min %{perc}%%",
    ["minimum_guaranteed"] = "Minimum Guaranteed",
    ["minimum_guaranteed_descr"] = "If set to minimum guaranteed, only minimum bandwidth allocation will be guaranteed.",
    ["mode"] = "Mode",
    ["nedge"] = "nEdge",
    ["network_conf_dhcp"] = "DHCP",
    ["network_conf_iface_descr"] = "Specify the interface IP address mode.",
    ["network_conf_iface_gw"] = "IP address of the default gateway of the interface (e.g. 192.168.1.1).",
    ["network_conf_iface_ip"] = "IP address of the interface (e.g. 192.168.1.10).",
    ["network_conf_iface_nmask"] = "Network mask of the interface (e.g. 255.255.255.0).",
    ["network_conf_iface_title"] = "%{ifrole} Interface %{ifname}",
    ["network_conf_static"] = "Static",
    ["network_conf_vlan_trunk"] = "VLAN Trunk",
    ["no_gateways_defined"] = "No gateways defined.",
    ["no_interfaces_available"] = "No interfaces available.",
    ["no_routing_policies_defined"] = "No routing policies defined",
    ["no_static_leases"] = "No Static Leases",
    ["no_static_routes_defined"] = "No static route defined.",
    ["ntp_sync"] = "NTP Synchronization",
    ["ntp_sync_descr"] = "Toggle the synchronization with an NTP server.",
    ["per_ip_rates"] = "Per Host Bandwidth Control",
    ["ping_address"] = "Monitor Address",
    ["ping_address_description"] = "The address to monitor to verify the gateway status.",
    ["please_fill_out_this_field"] = "Please fill out this field.",
    ["policy_due_to_source"] = "%{policy} due to %{source}",
    ["policy_name"] = "Policy Name",
    ["power_off"] = "Power Off",
    ["power_off_confirm"] = "Do you want to power off the device?",
    ["priority_x"] = "Priority %{x}",
    ["protocol_policy_has_higher_priority"] = "Protocol Policies have higher priority than the Category Policies.",
    ["protocols_policies"] = "Protocol Policies",
    ["reboot"] = "Reboot",
    ["reboot_corfirm"] = "Do you want to reboot the device?",
    ["remote_assistance"] = "Remote Assistance",
    ["remove_all_members"] = "Remove All Members",
    ["remove_all_members_confirm"] = "Do you really want to remove all the members of user %{user}?",
    ["reset_and_reboot"] = "Reset and Reboot",
    ["reset_and_restart_self"] = "Reset and Restart",
    ["restrict_weg_gui_access_description"] = "Restrict the access to this management web GUI to make it accessible only from the LAN interface (more secure) or from any interface of the system (less secure).",
    ["restrict_weg_gui_access_title"] = "Management Web GUI Access",
    ["router"] = "Router",
    ["router_mode_requires_enterprise"] = "Router mode is only available in the nedge Enterprise edition.",
    ["routing"] = "Routing",
    ["routing_policies"] = "Routing Policies",
    ["routing_policy"] = "Routing Policy",
    ["routing_policy_exists"] = "Routing policy \"%{policy}\" already exists.",
    ["safe_search_description"] = "Use the Child Safe DNS to block inappropriate content.",
    ["search_categories"] = "Search Categories",
    ["search_protocols"] = "Search Protocols",
    ["security"] = "Security",
    ["set_the_device_mode"] = "Set the device operating mode.",
    ["setup_apply"] = "Apply",
    ["setup_config_edited_descr"] = "Apply changes to make the new configuration effective or discard to keep using the current one.",
    ["setup_config_edited_title"] = "System configuration edited!",
    ["setup_discard"] = "Discard",
    ["setup_mode"] = "Operating Mode",
    ["setup_network"] = "Network",
    ["shapers"] = "Bandwidth Control",
    ["single_port_router"] = "Single Port Router",
    ["slow_pass_shaper_descr"] = "The Slow Pass bandwidth percentage of the interface speed.",
    ["slower_pass_shaper_descr"] = "The Slower Pass bandwidth percentage of the interface speed.",
    ["specify_a_protocol"] = "Specify an Application Protocol",
    ["static_dhcp_leases"] = "DHCP Server Static Leases",
    ["static_route_address_descr"] = "Specify the destination for the static route.",
    ["static_route_exists"] = "Static route %{sr} already exists.",
    ["static_route_is_local_descr"] = "Specify whether this is a static route to a local network.",
    ["static_route_is_local_title"] = "Local Network Static Route",
    ["static_route_name"] = "Static Route Name",
    ["static_route_netmask_descr"] = "Specify the netmask to apply to the destination for the static route.",
    ["static_route_via_descr"] = "Specify the IP address to use as next hop for the static route.",
    ["static_route_x"] = "Static route %{sr}",
    ["static_routes"] = "Static Routes",
    ["static_routes_in_policies"] = "Static routes are applied to (and take precedence over) any of the defined <a href=\"%{url}\">Routing Policies</a>.",
    ["status_activate"] = "Activate",
    ["status_connected"] = "Connected",
    ["status_connecting"] = "Connecting",
    ["status_deactivate"] = "Deactivate",
    ["status_disabled"] = "Disabled",
    ["status_disconnected"] = "Disconnected",
    ["status_down"] = "Down",
    ["status_failed"] = "Failed",
    ["status_inactive"] = "Inactive",
    ["status_unreachable"] = "Unreachable",
    ["status_up"] = "Up",
    ["system_setup"] = "System Setup",
    ["system_users"] = "System Users",
    ["test_policies"] = "Test Policies",
    ["test_policies_page_description"] = "This page can be used to verify which will be the policies applied on the %{user} devices based on the current configuration.",
    ["the_fallback_policy"] = "The <a href=\"%{url}\">Fallback Policy</a> is applied when both the user and the global policy for a given protocol and its corresponding category are set to \"Default\".",
    ["the_not_assigned_user_contains"] = "The \"Not Assigned\" user can be used to define policies for devices which are not assigned to any user.",
    ["the_primary_dns_server"] = "The Primary DNS server",
    ["the_secondary_dns_server"] = "The Secondary DNS server",
    ["timezone"] = "Time Zone",
    ["timezone_descr"] = "Sets the time zone of the system.",
    ["upload_description"] = "The maximum upload speed for the interface.",
    ["upload_speed"] = "Upload Speed",
    ["user"] = "User",
    ["user_categories"] = "Category Policies for User %{user}",
    ["user_categories_with_a_defined_policy"] = "Custom Category Policies for User %{user}",
    ["user_categories_with_a_defined_quota"] = "Quota Category Policies for User %{user}",
    ["user_categories_with_policy_x"] = "%{x} Category Policies for User %{user}",
    ["user_category_policies"] = "User Category Policies",
    ["user_device_protocols"] = "Protocol Policies for %{user} Devices",
    ["user_protocols"] = "Protocol Policies for User %{user}",
    ["user_protocols_with_a_defined_policy"] = "Custom Protocol Policies for User %{user}",
    ["user_protocols_with_a_defined_quota"] = "Quota Protocol Policies for User %{user}",
    ["user_protocols_with_policy_x"] = "%{x} Protocol Policies for User %{user}",
    ["users_list"] = "Users List",
    ["view_quotas"] = "View Quotas",
    ["wan"] = "WAN",
    ["with_quota"] = "With Quota",
    ["x_shaper_per_host_descr"] = "The %{shaper} maximum per-host bandwidth allocation. 0 for unlimited.",
    ["you_can_assign_routing_policy"] = "You can assign routing policies to <a href=\"%{url}\">Users</a>.",
    ["you_can_assign_shapers_to_users_protocols"] = "You can assign bandwidth policies to <a href=\"%{url}\">Users</a> specific protocols or set them globally as a <a href=\"%{url2}\">Fallback Policy</a>.",
    ["you_can_set_static_dhcp_lease_here"] = "You can configure static DHCP leases <a href=\"%{url}\">here</a>.",
    ["you_can_use_gateways_in_policies"] = "You can specify gateways priorities in <a href=\"%{url}\">Routing Policies</a>.",
    ["policy_source_labels"] = {
      ["policy_source_category"] = "Category Policy",
      ["policy_source_default"] = "Unknown",
      ["policy_source_device_protocol"] = "Device Protocol Policy",
      ["policy_source_pool"] = "Default Policy",
      ["policy_source_protocol"] = "Protocol Policy",
    },
  },
  ["network_alert_config"] = {
    ["trigger_alerts_for_network"] = "Trigger alerts for Network %{network}",
    ["trigger_network_alerts"] = "Trigger Network Alerts",
  },
  ["network_details"] = {
    ["network"] = "Network",
    ["network_parameter_missing_message"] = "Network parameter is missing (internal error?)",
    ["no_available_stats_for_network"] = "No available stats for network %{network}",
  },
  ["network_stats"] = {
    ["network_list"] = "Network List",
    ["network_name"] = "Network Name",
    ["networks"] = "Networks",
    ["networks_traffic_with_ipver"] = "%{networks} with IPv%{ipver} traffic",
    ["note_broader_network"] = "The broader network will not include hosts defined in smaller networks.",
    ["note_overlapping_networks"] = "NOTE: In case you have defined overlapping networks:",
    ["note_see_both_network_entries"] = "You will see both network entries in the above table.",
  },
  ["os_stats"] = {
    ["hosts_by_operating_system"] = "Hosts by Operating System",
  },
  ["packets_page"] = {
    ["arp_distribution"] = "ARP Distribution",
    ["ip_version_distribution"] = "IP Version Distribution",
    ["lost"] = "Lost",
    ["out_of_order"] = "Out of Order",
    ["received_distribution"] = "Received Distribution",
    ["retransmissions"] = "Retransmissions",
    ["sent_distribution"] = "Sent Distribution",
    ["size_distribution"] = "Size Distribution",
    ["tcp_flags_distribution"] = "TCP Flags Distribution",
    ["tcp_packets_analysis"] = "TCP Packets Analysis",
  },
  ["peers_page"] = {
    ["host"] = "Host",
    ["no_active_flows_message"] = "No active flows have been observed for the specified host",
    ["top_peer_protocol"] = "Top Peer Protocols",
    ["top_peers_for_host"] = "Top %{hostkey} Peers",
    ["traffic_volume"] = "Traffic Volume",
  },
  ["please_wait_page"] = {
    ["command"] = "Command",
    ["database"] = "Database",
    ["host"] = "Host",
    ["id"] = "Id",
    ["info"] = "Info",
    ["operations_on_database_msg"] = "Operations currently performed on the database are the following: ",
    ["state"] = "State",
    ["time"] = "Time",
    ["user"] = "User",
    ["waiting_for_db_msg"] = "Database schema migration in progress, waiting for database <b>%{dbname}</b> to become operational. You will be redirected as soon as the database is ready. Depending on the size of the existing database, this operation can take a long time. Migrations are performed only once and only during major version upgrades. If in doubt, please contact the developers at <a href='mailto:info@ntop.org'>info@ntop.org</a>.",
  },
  ["policy_presets"] = {
    ["business"] = "Business",
    ["business_description"] = "A preset for business company employees",
    ["child"] = "Child",
    ["child_description"] = "A preset for children. Blocks social networks and limits game time",
    ["default"] = "Default",
    ["guests"] = "Guests",
    ["guests_description"] = "A preset for guests. Only basic navigation allowed",
    ["no_obfuscation"] = "No Obfuscation",
    ["no_obfuscation_description"] = "A preset to prevent traffic obfuscation",
    ["walled_garden"] = "Walled Garden",
    ["walled_garden_description"] = "Blocks VPN and Social Networks",
  },
  ["pool_details"] = {
    ["host_pool"] = "Host Pool",
    ["host_pool_timeseries_enable_message"] = "Host Pool timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
    ["no_available_data_for_host_pool_message"] = "No available data for Host Pool '%{pool_name}'.",
    ["pool_parameter_missing_message"] = "Parameter is missing (internal error ?)",
  },
  ["pool_stats"] = {
    ["host_pool_list"] = "Host Pool List",
  },
  ["port_details"] = {
    ["active_flows_for_host_and_port"] = "Active Flows for %{host}:%{port}",
    ["active_flows_on_port"] = "Active Flows on Port %{port}",
    ["active_flows_on_port_symbolic"] = "Active Flows on Port %{port} [%{symbolic_port}]",
    ["l4_port"] = "L4 Port",
  },
  ["ports_page"] = {
    ["client_ports"] = "Client Ports",
    ["server_ports"] = "Server Ports",
  },
  ["prefs"] = {
    ["active_local_host_cache_interval_description"] = "Interval between consecutive active local hosts cache dumps. Default: 1 hour.",
    ["active_local_host_cache_interval_title"] = "Active Local Host Cache Interval",
    ["admin_group_description"] = "Group name to which user has to belong in order to authenticate as an administrator.",
    ["admin_group_title"] = "LDAP Admin Group",
    ["aggregated_flows"] = "Aggregated Flows",
    ["alert_entity"] = "Alert Entity",
    ["alerts_notifications"] = "Alert Endpoints",
    ["alerts_retention"] = "Alerts Retention",
    ["alerts_settings"] = "Alerts Settings",
    ["all"] = "All",
    ["auth_methods_order"] = "The authentication methods check order is the same as the listing order above, e.g. if both LDAP and local auth are enabled, LDAP will be checked first and, if authentication fails, local auth will be checked next.",
    ["authentication"] = "Authentication",
    ["bind_dn_description"] = "Bind Distinguished Name of LDAP server. Example:",
    ["bind_dn_title"] = "LDAP Bind DN",
    ["bind_pwd_description"] = "Bind password used for authenticating with the LDAP server.",
    ["bind_pwd_title"] = "LDAP Bind Authentication Password",
    ["both"] = "Both",
    ["cache_settings"] = "Cache Settings",
    ["captive_portal_disabled_message"] = "This button is <b>disabled</b> as the ntopng web GUI has NOT been started on port 80 that is required by the captive portal (-w command line parameter, e.g. -w 80,3000).",
    ["captive_portal_url_description"] = "The URL your clients will be redirected to after a successful captive portal authentication.",
    ["captive_portal_url_title"] = "Redirection URL",
    ["could_not_contact_influxdb"] = "Could not contact the InfluxDB database: %{msg}",
    ["databases"] = "Databases",
    ["default_snmp_community_description"] = "The default SNMP community is used when trying to walk the SNMP MIB of a selected local host that has not been configured through the SNMP devices page.",
    ["default_snmp_community_title"] = "Default SNMP Community",
    ["default_snmp_proto_version_description"] = "The default SNMP protocol version.",
    ["default_snmp_proto_version_title"] = "Default SNMP Version",
    ["device_identifier"] = "Device Identifier",
    ["device_identifier_descr"] = "Usually devices are identified by MAC address. However, if devices are behind a router, IP identification is desiderable instead.",
    ["disable_alerts_generation_description"] = "Toggle the overall generation of alerts.",
    ["disable_alerts_generation_title"] = "Enable Alerts",
    ["dns"] = "DNS",
    ["dns_service"] = "Service",
    ["dynamic_interfaces_creation_description"] = "ntopng can use a criterion to disaggregate incoming traffic. When a disaggregation criterion is selected, ntopng will use the criterion value to divert incoming traffic to dynamically-created interfaces. For example, when the 'VLAN Id' criterion is selected, a dynamic interface will be created for each VLAN Id observed, and the incoming traffic will be diverted to one dynamic interface depending the VLAN Id value. ",
    ["dynamic_interfaces_creation_note_0"] = "'VLAN Id' disaggregation is supported both for physical interfaces as well as for flows received over ZMQ. The other disaggregation criteria are only supported for ZMQ flows and will be ineffective for physical interfaces.",
    ["dynamic_interfaces_creation_note_1"] = "Criterion changes will not affect existing interfaces. <b>A restart of ntopng is required for the change to have effect</b>.",
    ["dynamic_interfaces_creation_note_2"] = "When using the 'Ingress Interface' criterion on non-sflow devices, %%INPUT_SNMP must appear into the nprobe template.",
    ["dynamic_interfaces_creation_note_3"] = "'Interface' disaggregation criterion adds any flow to two dynamic interfaces. The value of %%INPUT_SNMP is used to select the first dynamic interface, whereas the value of %%OUTPUT_SNMP is used to select the second.",
    ["dynamic_interfaces_creation_title"] = "Disaggregation Criterion",
    ["dynamic_network_interfaces"] = "Dynamic Network Interfaces",
    ["elephant_flow_local_to_remote_bytes_description"] = "The amount of data a flow can upload before being considered an Elephant Flow.",
    ["elephant_flow_local_to_remote_bytes_title"] = "Elephant Flows Threshold (Local To Remote)",
    ["elephant_flow_remote_to_local_bytes_description"] = "The amount of data a flow can download before being considered an Elephant Flow.",
    ["elephant_flow_remote_to_local_bytes_title"] = "Elephant Flows Threshold (Remote To Local)",
    ["email_notification"] = "Email Notification",
    ["email_notification_recipient_description"] = "The recipient email address.",
    ["email_notification_recipient_title"] = "Recipient",
    ["email_notification_sender_description"] = "The sender email address.",
    ["email_notification_sender_title"] = "Sender",
    ["email_notification_server_description"] = "The SMTP server to deliver the email.",
    ["email_notification_server_title"] = "SMTP Server",
    ["email_send_error"] = "Email send error. Check out the %{product} log for more details.",
    ["email_sent_successfully"] = "Email sent successfully",
    ["errors"] = "Errors",
    ["errors_and_warnings"] = "Errors and Warnings",
    ["ewma_alpha_percent_description"] = "Exponentially Weighted Moving Average (EWMA) alpha coefficient, expressed as a percentage. Used to estimate Autonomous Systems round-trip time.",
    ["ewma_alpha_percent_title"] = "EWMA alpha coefficient (percent)",
    ["expert_view"] = "Expert View",
    ["featured_dns_description"] = "The following is a list of secure DNS servers. You can use them as a global DNS servers or as as Child Safe provider.",
    ["featured_dns_title"] = "Featured DNS Servers",
    ["flow_database_dump"] = "Flow Database Dump",
    ["flow_interface"] = "Interface",
    ["flow_max_idle_description"] = "Inactivity time after which a flow is considered idle. Default: 1 min.",
    ["flow_max_idle_title"] = "Flow Idle Timeout",
    ["global_dns_description"] = "A DNS server to redirect the clients DNS requests to for non Child Safe host pools. If empty, the redirection is disabled and the default DNS is used.",
    ["global_dns_title"] = "Global Primary DNS",
    ["google_apis_browser_key_description"] = "Graphical hosts geomaps are based on Google Maps APIs. Google recently changed Maps API access policies and now requires a browser API key to be submitted for every request. Detailed information on how to obtain an API key can be found <a href=\"%{url}\">here</a>. Once obtained, the API key can be placed in this field.",
    ["google_apis_browser_key_title"] = "Google APIs Browser Key",
    ["host_mask"] = "Mask Host IP Addresses",
    ["housekeeping_frequency_description"] = "Some host statistics such as throughputs are updated periodically. This timeout regulates how often %{product} will update these statistics. Larger values are less computationally intensive and tend to average out minor variations. Smaller values are more computationally intensive and tend to highlight minor variations. Values in the order of few seconds are safe. Default: 5 seconds.",
    ["housekeeping_frequency_title"] = "Hosts Statistics Update Frequency",
    ["http_auth"] = "HTTP Authentication",
    ["http_auth_server_description"] = "The URL of the HTTP server to use to authenticate users.",
    ["http_auth_server_title"] = "HTTP Server",
    ["idle_timeout_settings"] = "Idle Timeout Settings",
    ["ignored_interfaces_description"] = "When 'Ingress Interface' is selected as disaggregation criterion, do not add to a dynamic interface any flow having its %%INPUT_SNMP in this list. When 'Interface' disaggregation is selected, do not add to the first (second) dynamic interface any flow having its %%INPUT_SNMP (%%OUTPUT_SNMP) in this list. Specify one or more comma-separated SNMP interface ids. Changes require %{product} restart.",
    ["ignored_interfaces_title"] = "Ignored interfaces",
    ["incompatible_influxdb_version"] = "Incompatible InfluxDB version: required \"%{required}\", found \"%{found}\"",
    ["influxdb_auth_description"] = "Enable InfluxDB authentication.",
    ["influxdb_auth_title"] = "InfluxDB Authentication",
    ["influxdb_create_error"] = "Could not create \"%{db}\" database: %{msg}",
    ["influxdb_dbname_description"] = "The database to use for timeseries storage. Existing data will not be migrated.",
    ["influxdb_dbname_title"] = "InfluxDB Database",
    ["influxdb_password_description"] = "The password to authenticate with the InfluxDB database.",
    ["influxdb_retention_error"] = "Could not set retention policy on database \"%{db}\": %{msg}",
    ["influxdb_storage_description"] = "InfluxDB timeseries data retention days (use 0 for unlimited). Default: 365 days.",
    ["influxdb_storage_title"] = "InfluxDB Storage",
    ["influxdb_url_description"] = "The URL pointing to a running InfluxDB instance.",
    ["influxdb_url_title"] = "InfluxDB URL",
    ["influxdb_username_description"] = "The username to authenticate with the InfluxDB database.",
    ["ingress_flow_interface"] = "Ingress Interface",
    ["ingress_vrf_id"] = "Ingress VRF Id",
    ["interfaces_timeseries"] = "Interfaces Timeseries",
    ["internal_log"] = "Internal Log",
    ["l2_devices_timeseries"] = "Devices Timeseries",
    ["ldap_authentication"] = "LDAP Authentication",
    ["ldap_server_address_description"] = "IP address and port of LDAP server (e.g. ldaps://localhost:636). Default: \"ldap://localhost:389\".",
    ["ldap_server_address_title"] = "LDAP Server Address",
    ["license"] = "License",
    ["local_auth"] = "Local Authentication",
    ["local_host_cache_duration_description"] = "Time after which a cached local host is deleted from the cache. Default: 1 hour.",
    ["local_host_cache_duration_title"] = "Local Hosts Cache Duration",
    ["local_host_mask"] = "Mask Local Hosts",
    ["local_host_max_idle_description"] = "Inactivity time after which a local host is considered idle (sec). Idle local hosts are dumped to a cache so their counters can be restored in case they become active again. Counters include, but are not limited to, packets and bytes total and per Layer-7 application. Default: 5 min.",
    ["local_host_max_idle_title"] = "Local Host Idle Timeout",
    ["local_hosts_cache_settings"] = "Local Hosts Cache Settings",
    ["local_hosts_timeseries"] = "Local Hosts Timeseries",
    ["logging"] = "Logging",
    ["longlived_flow_duration_description"] = "The minimum duration for a flow to be considered a Long-Lived Flow.",
    ["longlived_flow_duration_title"] = "Long-Lived Flows Duration",
    ["max_num_aggregated_flows_per_export_description"] = "The maximum number of aggregated flows generated and dumped to database every 5 minutes. Default: 1000.",
    ["max_num_aggregated_flows_per_export_title"] = "Maximum Number of Aggregated Flows Dumped Every 5 Minutes",
    ["max_num_alerts_per_entity_description"] = "The maximum number of alerts per alarmable entity. Alarmable entities are hosts, networks, interfaces. Alerts are checked periodically and, in case the actual number of alerts exceeds the maximum number for a given entity, oldest alerts will be deleted to preserve a number of alerts equal to the 80%% of the maximum configured number. Default: 1024.",
    ["max_num_alerts_per_entity_title"] = "Maximum Number of Alerts per Entity",
    ["max_num_bytes_per_tiny_flow_description"] = "The maximum number of bytes a flow must have to be considered a tiny flow. Default: 64.",
    ["max_num_bytes_per_tiny_flow_title"] = "Maximum Number of Bytes per Tiny Flow",
    ["max_num_flow_alerts_description"] = "The maximum number of flow alerts. Alerts are checked periodically and, in case the actual number of flow alerts exceeds the configured maximum number, oldest alerts will be deleted to preserve a number of alerts equal to the 80%% of the maximum configured number. Default: 16384.",
    ["max_num_flow_alerts_title"] = "Maximum Number of Flow Alerts",
    ["max_num_packets_per_tiny_flow_description"] = "The maximum number of packets a flow must have to be considered a tiny flow. Default: 3.",
    ["max_num_packets_per_tiny_flow_title"] = "Maximum Number of Packets per Tiny Flow",
    ["max_ui_strlen_description"] = "Shorten strings longer than the specified maximum number of characters.",
    ["max_ui_strlen_title"] = "Maximum Displayed String Length",
    ["mgmt_acl_description"] = "A comma-separated list of IPv4 networks. Each network must be explicitly allowed or disallowed with a leading \"+\" or \"-\" sign, respectively. The longest-match principle is used with overlapping networks. Examples: \"+127.0.0.0/8\" makes the interface accessible only from localhost, \"+0.0.0.0/0,-192.168.0.0/16\", makes the interface accessible for everybody except 192.168.0.0/16. Must restart %{product} for changes to have effect.",
    ["mgmt_acl_title"] = "Access Control List",
    ["minute_top_talkers_retention_description"] = "Number of days to keep one minute resolution top talkers statistics. Default: 365 days.",
    ["minute_top_talkers_retention_title"] = "Top Talkers Storage",
    ["misc"] = "Misc",
    ["multiple_ldap_account_type_description"] = "Choose your account type",
    ["multiple_ldap_account_type_title"] = "LDAP Accounts Type",
    ["multiple_timeseries_database_description"] = "The driver used for storing and retrieving timeseries data.",
    ["multiple_timeseries_database_title"] = "Timeseries Driver",
    ["mysql"] = "MySQL",
    ["mysql_retention_description"] = "Duration in days of data retention for the MySQL database. Default: 7 days.<br>MySQL is used to store exported flows data.<br>Flows dump is only possible if the ntopng instance has been launched with option ",
    ["mysql_retention_title"] = "MySQL storage",
    ["n2disk_license_description"] = "Continuous traffic recording requires a n2disk license, purchase one at <a href=\"%{purchase_url}\">e-shop</a>. If you are no-profit, research or an education institution please read <a href=\"%{universities_url}\">this</a>.",
    ["n2disk_license_systemid"] = "SystemID: %{systemid}",
    ["n2disk_license_title"] = "n2disk License Key",
    ["n2disk_license_version"] = "n2disk version: %{version}",
    ["n2n_supernode_description"] = "The address of the <a href=\"%{url}\">n2n</a> <i class=\"fa fa-external-link\"></i> supernode. Set up your own supernode in order to have a fully private remote access.<br>NOTE: this change will have affect only after Remote Assistance restart.",
    ["n2n_supernode_title"] = "Supernode",
    ["nagios_host_name_description"] = "The host_name exactly as specified in Nagios host definition for the %{product} host. Default: ntopng-host",
    ["nagios_host_name_title"] = "Nagios host_name",
    ["nagios_integration"] = "Nagios Integration",
    ["nagios_nsca_host_description"] = "Address of the host where the Nagios NSCA daemon is running. Default: localhost.",
    ["nagios_nsca_host_title"] = "Nagios NSCA Host",
    ["nagios_nsca_port_description"] = "Port where the Nagios daemon's NSCA is listening. Default: 5667.",
    ["nagios_nsca_port_title"] = "Nagios NSCA Port",
    ["nagios_send_nsca_config_description"] = "Absolute path to the Nagios NSCA send_nsca utility configuration file. Default: /usr/local/nagios/etc/send_nsca.cfg",
    ["nagios_send_nsca_config_title"] = "Nagios send_nsca configuration",
    ["nagios_send_nsca_executable_description"] = "Absolute path to the Nagios NSCA send_nsca utility. Default: /usr/local/nagios/bin/send_nsca",
    ["nagios_send_nsca_executable_title"] = "Nagios send_nsca executable",
    ["nagios_service_name_description"] = "The service description exactly as specified in Nagios passive service definition for the %{product} host. Default: NtopngAlert",
    ["nagios_service_name_title"] = "Nagios service_description",
    ["network_discovery"] = "Network Discovery",
    ["network_discovery_interval_description"] = "Interval between consecutive discoveries of networks. Default: 15 min.",
    ["network_discovery_interval_title"] = "Active Network Discovery Interval",
    ["network_interfaces"] = "Network Interfaces",
    ["nindex_retention_description"] = "Number of days to keep indexed flows for historical exploration. Default: 365 days.",
    ["nindex_retention_title"] = "Flow Index Storage",
    ["no_host_mask"] = "Don't Mask Hosts",
    ["non_local_host_max_idle_description"] = "Inactivity time after which a remote host is considered idle. Default: 1 min.",
    ["non_local_host_max_idle_title"] = "Remote Host Idle Timeout",
    ["none"] = "None",
    ["note_timeseries_resolution_disabled"] = "NOTE: this is disabled because \"%{pref}\" is not set to the default value.",
    ["note_update_frequency_disabled"] = "NOTE: this is disabled because of the \"%{pref}\" requirements.",
    ["other_timeseries"] = "Other Timeseries",
    ["per_category"] = "Per Category",
    ["per_protocol"] = "Per Protocol",
    ["policy_target_type"] = "Policy Target Type",
    ["policy_target_type_description"] = "Specify what kind of policy target you wish to apply.",
    ["posix"] = "Posix",
    ["preferences"] = "Preferences",
    ["primary_dns"] = "Primary DNS",
    ["probe_ip_address"] = "Probe IP",
    ["protocols"] = "Protocols",
    ["radius_admin_group_description"] = "The user is authenticated as admin when the value for the Filter-Id Attribute-Value pair returned by RADIUS matches the one specified in this field. When there is no match, the user is authenticated as unprivileged.",
    ["radius_admin_group_title"] = "RADIUS Admin Filter-Id",
    ["radius_auth"] = "RADIUS Authentication",
    ["radius_secret_descroption"] = "The shared secret to authenticate with the RADIUS server.",
    ["radius_secret_title"] = "RADIUS Secret",
    ["radius_server_description"] = "Host and port of the RADIUS server (e.g. %{example}).",
    ["radius_server_title"] = "RADIUS Server Address",
    ["recording"] = "Traffic Recording",
    ["remote_host_mask"] = "Mask Remote Hosts",
    ["report"] = "Report",
    ["rrd_files_retention_description"] = "The maximum number of days non-updated RRDs are preserved before being deleted.<br><b>NOTE</b>: the retention time of a single RRD is always 365 days, regardless of this setting.",
    ["rrd_files_retention_title"] = "Old RRDs Retention",
    ["runtime_prefs"] = "Runtime Preferences",
    ["safe_search_dns_description"] = "The DNS server to be used to perform <a href='%{url}'>Child Safe</a> queries.<br>Child Safe can be enabled for individual host pools from the host pools configuration page. Default: 208.67.222.123.",
    ["safe_search_dns_title"] = "Child Safe DNS",
    ["samaccount"] = "sAMAccount",
    ["search_path_description"] = "Root path used to search the users.",
    ["search_path_title"] = "LDAP Search Path",
    ["search_preferences"] = "Search Preferences",
    ["secondary_dns"] = "Secondary DNS",
    ["secondary_dns_description"] = "A fallback DNS server to use when the global primary DNS server is not available.",
    ["secondary_dns_title"] = "Global Secondary DNS",
    ["security_alerts"] = "Security Alerts",
    ["send_test_mail"] = "Send Test Email",
    ["send_test_slack"] = "Send Test Message",
    ["sender_username_description"] = "Set the username of the sender of slack notifications",
    ["sender_username_title"] = "Notification Sender Username",
    ["simple_view"] = "Simple View",
    ["slack_channel"] = "Slack Channel",
    ["slack_channel_names"] = "Channel Names",
    ["slack_channel_names_descr"] = "Configure the Slack channels where each alert will be sent. Channels must exist in order to correcly display the alert.",
    ["slack_integration"] = "Slack Integration",
    ["slack_notification_severity_preference_description"] = "Errors (errors only), Errors and Warnings (errors and warnings, no info), All (every kind of alerts will be notified).",
    ["slack_notification_severity_preference_title"] = "Notification Serverity",
    ["slack_send_error"] = "Slack message send error.",
    ["slack_sent_successfully"] = "A Slack message has been sent to the #%{channel} channel.",
    ["slack_webhook_description"] = "Send your notification to this slack URL",
    ["slack_webhook_title"] = "Notification Webhook",
    ["snmp"] = "SNMP",
    ["status_alerts"] = "Status Alerts",
    ["successfully_connected_influxdb"] = "Successfully initialized database \"%{db}\" on InfluxDB(%{version})",
    ["syslog_alert_format_description"] = "Chose the syslog alerts output format.",
    ["syslog_alert_format_json"] = "JSON",
    ["syslog_alert_format_plaintext"] = "Plain Text",
    ["syslog_alert_format_title"] = "Syslog Alerts Format",
    ["syslog_notification"] = "Syslog Notification",
    ["timeseries"] = "Timeseries",
    ["timeseries_database"] = "Timeseries Database",
    ["timeseries_resolution_resolution_description"] = "The interval between data points in high resolution timeseries, in particular the local hosts and interface L7 applications.<br>NOTE: High resolution can have a strong impact on memory and disk usage for large networks.",
    ["timeseries_resolution_resolution_title"] = "L7 Applications Resolution",
    ["tiny_flows"] = "Tiny Flows",
    ["toggle_access_log_description"] = "Toggle the creation of HTTP access log in the data dump directory. Settings will have effect at next %{product} startup.",
    ["toggle_access_log_title"] = "Enable HTTP Access Log",
    ["toggle_active_local_host_cache_enabled_description"] = "Toggle the creation of cache entries for active local hosts. Caching active local hosts periodically can be useful to protect host counters against failures (e.g., power losses). This is particularly important for local hosts that seldomly go idle as it guarantees that their counters will be cached after the specified time interval.",
    ["toggle_active_local_host_cache_enabled_title"] = "Active Local Hosts Cache",
    ["toggle_aggregated_flows_export_limit_description"] = "Limit the maximum number of aggregated flows that are dumped every 5 minutes.",
    ["toggle_aggregated_flows_export_limit_title"] = "Limit the Number of Aggregated Flows",
    ["toggle_alert_nagios_description"] = "Toggle alerts notifications via Nagios NSCA (Nagios Service Check Acceptor).",
    ["toggle_alert_nagios_title"] = "Toggle Nagios Notifications",
    ["toggle_alert_probing_description"] = "Toggle alerts generated when probing attempts are detected.",
    ["toggle_alert_probing_title"] = "Probing Alerts",
    ["toggle_alert_syslog_description"] = "Toggle alerts logging to system syslog.",
    ["toggle_alert_syslog_title"] = "Toggle Syslog Notification",
    ["toggle_alerts_notifications_description"] = "Toggle the reporting of alert to third-party endpoints.",
    ["toggle_alerts_notifications_title"] = "Alerts to Third-Party Endpoints",
    ["toggle_asn_rrds_description"] = "Toggle the creation of bytes and application timeseries for autonomous systems.",
    ["toggle_asn_rrds_title"] = "Autonomous Systems",
    ["toggle_autologout_description"] = "Toggle the automatic logout of web interface users with expired sessions.",
    ["toggle_autologout_title"] = "Auto Logout",
    ["toggle_captive_portal_description"] = "Enable the web captive portal for authenticating network users.",
    ["toggle_captive_portal_title"] = "Captive Portal",
    ["toggle_country_rrds_description"] = "Toggle the creation of bytes timeseries for countries.",
    ["toggle_country_rrds_title"] = "Countries",
    ["toggle_device_activation_alert_description"] = "Toggle alerts genereted when devices connect or disconnect from the network.",
    ["toggle_device_activation_alert_title"] = "Devices Connection/Disconnection Alerts",
    ["toggle_device_first_seen_alert_description"] = "Toggle alerts generated when new unseen devices appear on the network.",
    ["toggle_device_first_seen_alert_title"] = "New Devices Connection",
    ["toggle_device_protocols_description"] = "Toggle alerts generated when an anomalous protocol is detected according to the configured <a href=\"%{url}\">device protocols policies</a>.",
    ["toggle_device_protocols_description_nedge"] = "Toggle alerts generated when an anomalous protocol on <i>Not Assigned</i> devices is detected according to the configured <a href=\"%{url}\">device protocols policies</a>.",
    ["toggle_device_protocols_title"] = "Device Protocols Alerts",
    ["toggle_dns_alerts_description"] = "Toggle alerts generated when the DNS query is invalid",
    ["toggle_dns_alerts_title"] = "DNS Alerts",
    ["toggle_dropped_flows_alerts_description"] = "Enable informative alerts generated upon flows block due to configured policies",
    ["toggle_dropped_flows_alerts_title"] = "Enable Blocked Flows Alerts",
    ["toggle_dst_with_post_nat_dst_description"] = "Replace IPv4 destination addresses (%%IPV4_DST_ADDR) and ports (%%L4_DST_PORT) with their post-nat values (%%POST_NAT_DST_IPV4_ADDR and %%POST_NAPT_DST_TRANSPORT_PORT).",
    ["toggle_dst_with_post_nat_dst_title"] = "Use Post-Nat Destination IPv4 Addresses and Ports",
    ["toggle_elephant_flows_alerts_description"] = "Toggle alerts generated when an elephant flow has been detected. This is useful to detect unwanted behaviours (e.g. data exfiltration).",
    ["toggle_elephant_flows_alerts_title"] = "Elephant Flows Alerts",
    ["toggle_email_notification_description"] = "Toggle alerts notifications via email.",
    ["toggle_email_notification_title"] = "Toggle Email Notification",
    ["toggle_flow_alerts_iface_description"] = "Enable flow alert generation when the network interface is alerted.",
    ["toggle_flow_alerts_iface_title"] = "Enable Flow Alerts",
    ["toggle_flow_db_dump_export_description"] = "Toggle the export of tiny flows, that are flows with few packets or bytes. Reduces flow cardinality in databases, speeds-up inserts and searches. Tuning tiny flows can help to limit flow cardinality while not reducing visibility on dumped information.",
    ["toggle_flow_db_dump_export_title"] = "Tiny Flows Export",
    ["toggle_flow_rrds_description"] = "Toggle the creation of bytes timeseries for each port of the remote device as received through ZMQ (e.g. sFlow/NetFlow/SNMP).<br>For non sFlow devices, %%INPUT_SNMP and %%OUTPUT_SNMP must appear into the nprobe template.",
    ["toggle_flow_rrds_title"] = "Flow Devices",
    ["toggle_host_mask_description"] = "For privacy reasons it might be necessary to mask hosts IP addresses. For instance if you are an ISP you are not supposed to know which local addresses are accessing remote hosts.",
    ["toggle_host_mask_title"] = "Mask Host IP Addresses",
    ["toggle_host_pools_log_description"] = "Toggle the creation of logs related to host pools. Logs include associations and disassociations of hosts to their host pools.",
    ["toggle_host_pools_log_title"] = "Enable Host Pool Events Log",
    ["toggle_http_auth"] = "Toggle HTTP Authentication",
    ["toggle_http_auth_descr"] = "Toggle gui authentication via an HTTP authenticator.",
    ["toggle_informative_captive_portal_description"] = "Do not authenticate users. Show only an informative page before letting users access the Internet.",
    ["toggle_informative_captive_portal_title"] = "Informative",
    ["toggle_ip_reassignment_description"] = "Toggle alerts generated when an IP address, previously seen with a MAC address, is now seen with another MAC address. This alert might indicate an ARP spoof attempt.",
    ["toggle_ip_reassignment_title"] = "IP Reassignment Alerts",
    ["toggle_ldap_anonymous_bind_description"] = "Enable anonymous binding.",
    ["toggle_ldap_anonymous_bind_title"] = "LDAP Anonymous Binding",
    ["toggle_ldap_auth"] = "Toggle LDAP Authentication",
    ["toggle_ldap_auth_descr"] = "Toggle gui authentication via LDAP.",
    ["toggle_ldap_referrals_description"] = "Specifies if the client should automatically follow referrals returned by LDAP servers.",
    ["toggle_ldap_referrals_title"] = "Follow Referrals",
    ["toggle_local_auth"] = "Toggle Local Authentication",
    ["toggle_local_auth_descr"] = "Toggle gui authentication according to %{product} defined users.",
    ["toggle_local_host_cache_enabled_description"] = "Toggle the creation of cache entries for idle local hosts. Cached local hosts counters are restored automatically to their previous values  upon detection of additional host traffic.",
    ["toggle_local_host_cache_enabled_title"] = "Idle Local Hosts Cache",
    ["toggle_log_to_file_description"] = "Toggle the creation of ntopng.log in the data dump directory instead of using syslog. Settings will have effect at next %{product} startup.",
    ["toggle_log_to_file_title"] = "Enable Trace Log",
    ["toggle_logging_level_description"] = "Choose the runtime logging level.",
    ["toggle_logging_level_title"] = "Log level",
    ["toggle_longlived_flows_alerts_description"] = "Toggle alerts generated when a long-lived flow has been detected. This is useful to detect unwanted behaviours (e.g. data exfiltration).",
    ["toggle_longlived_flows_alerts_title"] = "Long-Lived Flows Alerts",
    ["toggle_malware_probing_description"] = "Toggle alerts generated by traffic sent/received by malware-marked hosts. Overnight new <a href=\"%{url}\">blacklist rules</a> are refreshed.",
    ["toggle_malware_probing_title"] = "Malware Alerts",
    ["toggle_mining_alerts_description"] = "Toggle alerts generated when traffic from/to hosts known to perform cryptocurrencies mining is detected",
    ["toggle_mining_alerts_title"] = "Mining Alerts",
    ["toggle_mysql_check_open_files_limit_description"] = "Enable MySQL alerts generations due to periodic checks of MySQL open_files_limit.<br>The open_files_limit check is useful to detect when the number of open MySQL files is high, which could lead to database insertion errors.",
    ["toggle_mysql_check_open_files_limit_title"] = "Enable MySQL alerts",
    ["toggle_ndpi_timeseries_creation_description"] = "Toggle the creation of Layer-7 application timeseries. Creating a timeseries per protocol requires more disk space and extra I/O and, in general, it is not needed.",
    ["toggle_ndpi_timeseries_creation_title"] = "Layer-7 Applications",
    ["toggle_network_discovery_description"] = "Toggle the periodic discovery of network devices using multiple techniques that include ARP scan, MDNS and SSDP.<p><b>NOTE:</b> discovery can be <u>only</u> enabled on physical interfaces  (i.e. no ZMQ) where we can send/receive traffic to the network (i.e. read-only interfaces such as those connected to port mirrors won't work). ",
    ["toggle_network_discovery_title"] = "Active Network Discovery",
    ["toggle_pool_activation_alert_description"] = "Toggle alerts generated when the first host connects or the last host disconnect from some pool.",
    ["toggle_pool_activation_alert_title"] = "Host Pools Connection/Disconnection Alerts",
    ["toggle_pools_rrds_description"] = "Toggle the creation of bytes and application protocols timeseries for defined host pools.",
    ["toggle_pools_rrds_title"] = "Host Pools",
    ["toggle_quota_exceed_alert_description"] = "Enable the generation of alerts whenever an host pool exceeded a configured quota.",
    ["toggle_quota_exceed_alert_title"] = "Enable Quota Exceeded Alerts",
    ["toggle_radius_auth"] = "Toggle RADIUS Authentication",
    ["toggle_radius_auth_descr"] = "Toggle gui authentication via a RADIUS server.",
    ["toggle_remote_to_remote_alerts_description"] = "Toggle alerts generated when the client and the server of a flow are remote.",
    ["toggle_remote_to_remote_alerts_title"] = "Remote to Remote Alerts",
    ["toggle_shaping_directions_description"] = "Enable this option to be able to set different shaping policies for ingress and egress traffic.",
    ["toggle_shaping_directions_title"] = "Split Shaping Directions",
    ["toggle_slack_notification_description"] = "Toggle alerts notifications via slack. See integration instructions <a href='%{url}'>here</a>.",
    ["toggle_slack_notification_title"] = "Toggle <a href=\"%{url}\">Slack</a> Notification",
    ["toggle_snmp_rrds_description"] = "Toggle the creation of bytes timeseries for each port of the SNMP devices. For each device port will be created an RRD with ingress/egress bytes.",
    ["toggle_snmp_rrds_title"] = "SNMP Devices Timeseries",
    ["toggle_src_with_post_nat_src_description"] = "Replace IPv4 source addresses (%%IPV4_SRC_ADDR) and ports (%%L4_SRC_PORT) with their post-nat values (%%POST_NAT_SRC_IPV4_ADDR and %%POST_NAPT_SRC_TRANSPORT_PORT).",
    ["toggle_src_with_post_nat_src_title"] = "Use Post-Nat Source IPv4 Addresses and Ports",
    ["toggle_ssl_alerts_description"] = "Toggle alerts generated when the SSL certificate provided by a server does not match the certificate Common Name.",
    ["toggle_ssl_alerts_title"] = "SSL Alerts",
    ["toggle_tcp_flags_rrds_description"] = "Toggle the creation of TCP flags SYN, SYN+ACK, FIN+ACK and RST timeseries for network interfaces.",
    ["toggle_tcp_flags_rrds_title"] = "TCP Flags",
    ["toggle_tcp_retr_ooo_lost_rrds_description"] = "Toggle the creation of timeseries for out-of-order, lost and retransmitted TCP segments. Timeseries will be created for network interfaces, autonomous systems, local networks and vlans.",
    ["toggle_tcp_retr_ooo_lost_rrds_title"] = "TCP Out of Order, Lost and Retransmitted Segments",
    ["toggle_thpt_content_description"] = "Select the throughput unit to be displayed in traffic reports.",
    ["toggle_thpt_content_title"] = "Throughput Unit",
    ["toggle_top_sites_description"] = "Toggle the creation of top visited web sites for local hosts. Top sites are created using an <a href=\"%{url}\">heuristic</a> that maintain no more than 20 sites per local host. The heuristic fully operates in memory and does not require any interaction with the disk. Top sites are cleared every 5 minutes. An historical archive of top visited web sites can be created, for each local host, by periodically polling the JSON <i class=\"fa fa-download fa-sm\"></i> download link accessible from the host details page.",
    ["toggle_top_sites_title"] = "Top HTTP Sites",
    ["toggle_traffic_rrd_creation_description"] = "Toggle the creation of bytes and packets timeseries.",
    ["toggle_traffic_rrd_creation_title"] = "Traffic",
    ["toggle_users_rrds_description"] = "Toggle the creation of bytes and application protocols timeseries for defined users.",
    ["toggle_users_rrds_title"] = "Users",
    ["toggle_vlan_rrds_description"] = "Toggle the creation of bytes and application timeseries for VLANs.",
    ["toggle_vlan_rrds_title"] = "VLANs",
    ["topk_heuristic_precision_description"] = "Use an heuristic when aggregating historical top hosts, countries, etc, to build traffic reports. Useful when building reports over long-periods.",
    ["topk_heuristic_precision_title"] = "Top-K Heuristic",
    ["traffic_bridging"] = "Traffic Bridging",
    ["traffic_shaping"] = "Traffic Shaping",
    ["user_authentication"] = "User Authentication",
    ["user_group_description"] = "Group name to which user has to belong in order to authenticate as unprivileged user.",
    ["user_group_title"] = "LDAP User Group",
    ["vlan"] = "VLAN Id",
    ["web_user_interface"] = "Web User Interface",
    ["zmq_interfaces"] = "ZMQ Interfaces",
  },
  ["processes_stats"] = {
    ["active_processes_title"] = "Active Processes: Realtime View",
    ["active_since"] = "Active Since",
    ["flows_count"] = "Flows Count",
    ["legend"] = "Legend",
    ["lines"] = "Lines",
    ["missing_pid_name_message"] = "Missing pid name",
    ["no_traffic_detected"] = "No traffic detected for this process, flow process expired, or process terminated.",
    ["processes_timeline_title"] = "Processes Timeline",
    ["stack"] = "Stack",
    ["timeline"] = "Timeline",
    ["top_hosts"] = "Top Hosts",
    ["top_hosts_traffic"] = "Top Hosts Traffic",
    ["top_l4_protocols"] = "Top L4 Protocols",
    ["top_l7_protocols"] = "Top L7 Protocols",
    ["traffic_rcvd"] = "Traffic Rcvd",
    ["traffic_sent"] = "Traffic Sent",
    ["type"] = "Type",
  },
  ["remote_assistance"] = {
    ["accept_and_enable"] = "Accept and Enable",
    ["admin_access"] = "Temporary Admin Access",
    ["admin_access_descr"] = "Create a temporary admin password for remote assistance GUI access.",
    ["admin_access_key_descr"] = "The temporary admin password is <b>%{pwd}</b>",
    ["ask_admin"] = "Ask the network administrator permission before doing this.",
    ["check_out_the_preferences"] = "More remote assistance parameters can be tuned from the <a href=\"%{url}\"><i class=\"fa fa-flask\"></i> Remote Assistance Preferences</a>.",
    ["connection_script"] = "Connection Script",
    ["connection_script_descr"] = "Download the connection script and provide it to the support team to let them connect to this ntopng instance. The script will work on systems where the n2n package is installed.",
    ["enable_remote_assistance"] = "Enable Remote Assistance",
    ["product_remote_assistance"] = "%{product} Remote Assistance",
    ["remember_disable"] = "Remember to disable the remote assistance when not needed.",
    ["remote_assistance"] = "Remote Assistance",
    ["remote_ip_msg"] = "This %{product} instance will be accessible from remote at IP address %{ip}",
    ["tos_notice"] = "By clicking \"%{button}\" you will provide remote access to your host and guarantee that your network security policies allow this. ntop is not responsible for any damage, security violation or vulnerability caused by enabling remote assistance.",
    ["will_create_virtual_network"] = "When enabled, the remote assistance will create an encrypted virtual network to connect remotely to your device.",
  },
  ["report"] = {
    ["application_breakdown"] = "Application Breakdown",
    ["applications"] = "Applications",
    ["begin_date_time"] = "Begin Date/Time",
    ["date"] = "%{month}-%{day}-%{year}",
    ["end_date_time"] = "End Date/Time",
    ["filter_report"] = "Filter Report",
    ["generate"] = "Generate",
    ["invalid_begin"] = "Invalid Begin",
    ["invalid_begin_date"] = "Invalid Begin Date",
    ["invalid_begin_end"] = "Invalid Begin/End",
    ["invalid_to"] = "Invalid To",
    ["local_networks"] = "Local Networks",
    ["local_remote"] = "Local/Remote",
    ["network_interface"] = "Network Interface",
    ["period"] = "Interval",
    ["please_check_format"] = "please check its format",
    ["please_choose_valid"] = "please choose a valid begin/end date and time",
    ["please_choose_valid_date_and_time"] = "please choose a valid date and time",
    ["receivers"] = "Receivers",
    ["remote_local"] = "remote/local",
    ["report_for_subject"] = "Report - %{num_min} - for %{subject} starting %{dt}",
    ["reports_professional_only"] = "Reports are only available in the Professional version",
    ["senders"] = "Senders",
    ["starting"] = "Starting",
    ["submit_filter"] = "Submit Filter",
    ["toggle_all"] = "Toggle All",
    ["top_asn"] = "Top ASN",
    ["top_countries"] = "Top Countries",
    ["top_local_hosts"] = "Top Local Hosts",
    ["top_local_os"] = "Top Local OS",
    ["top_networks"] = "Top Networks",
    ["top_non_local_os"] = "Top Non-Local OS",
    ["top_remote_hosts"] = "Top Remote Hosts",
    ["top_talkers"] = "Top Talkers",
    ["total_traffic"] = "Total Traffic",
    ["traffic_report"] = "Traffic Report",
    ["use_server_timezone"] = "Use Server Timezone",
  },
  ["sflows_stats"] = {
    ["active_flows"] = "Active Flows",
    ["client_peer"] = "Client Peer",
    ["client_process"] = "Client Process",
    ["l4_proto"] = "L4 Proto",
    ["server_peer"] = "Server Peer",
    ["server_process"] = "Server Process",
    ["total_bytes"] = "Total Bytes",
  },
  ["shaping"] = {
    ["applied_to"] = "Applied to",
    ["bandwidth_manager"] = "Bandwidth Manager",
    ["confirm_delete_all_policies"] = "Do you really want ot delete all the \"%{pool_name}\" pool policies",
    ["confirm_delete_policy"] = "Do you really want to delete",
    ["confirm_delete_shaper"] = "Do you really want to delete shaper ",
    ["daily_time"] = "Daily Time (Current / Quota)",
    ["daily_time_quota"] = "Daily Time Quota",
    ["daily_traffic"] = "Daily Traffic (Current / Quota)",
    ["daily_traffic_quota"] = "Daily Traffic Quota",
    ["delete_all_policies"] = "Delete all Policies",
    ["delete_policy"] = "Delete Policy",
    ["delete_shaper"] = "Delete Shaper",
    ["for_dropping_all_traffic"] = "for dropping all traffic",
    ["for_no_shaping"] = "for no shaping",
    ["initial_clone_protocols"] = "Initial protocol rules will be cloned",
    ["initial_empty_protocols"] = "Initial protocols rules will be empty",
    ["manage_policies"] = "Manage Policies",
    ["no_quota_applied"] = "No Quota",
    ["no_quota_data"] = "No quota set",
    ["no_quota_traffic"] = "No quota related traffic so far",
    ["no_shapers_available"] = "No shapers available",
    ["note_default_pool_config"] = "Policies and quotas only apply to user-defined host pools. Select a different pool or create a new one <a href='%{url}'>here</a>.",
    ["note_drop_core"] = "Dropping some core protocols can have side effects on other protocols. For instance if you block DNS,<br>symbolic host names are no longer resolved, and thus only communication with numeric IPs work.",
    ["note_quota_unlimited"] = "Set Traffic and Time Quota to 0 for unlimited traffic.",
    ["note_target_type"] = "You can modify what to show into the Target column via the Policy Target Type field in the <a href=\"%{url}\">Traffic Bridging preferences</a> expert view.",
    ["note_traffic_categories"] = "You can configure the Categories from the <a href=\"%{url}\">protocols page</a>.",
    ["notes"] = "NOTES",
    ["policy_from_pool"] = "policy from pool",
    ["protocol_families"] = "Protocol Families",
    ["protocol_policy"] = "Traffic Policy",
    ["protocols"] = "Protocols",
    ["protocols_policies"] = "Protocols Policies",
    ["see_quotas_here"] = "Visit the host pool <a href='%{url}'>quotas page</a> for the full overview of the active host pool quotas.",
    ["select_to_clone"] = "Select an existing network to clone the protocol rules from",
    ["set_max_rate_to"] = "Set max rate to",
    ["shaper0_message"] = "Shaper 0 is the default shaper used for local hosts that have no shaper defined",
    ["shaper_id"] = "Shaper Id",
    ["shapers_in_use_message"] = "Shapers can be deleted only if they are not applied to any network",
    ["traffic_from"] = "Traffic from",
    ["traffic_to"] = "Traffic to",
  },
  ["show_alerts"] = {
    ["1_day"] = "1 day",
    ["1_hour"] = "1 hour",
    ["1_month"] = "1 month",
    ["1_week"] = "1 week",
    ["1_year"] = "1 year",
    ["30_min"] = "30 minutes",
    ["5_min"] = "5 minutes",
    ["6_months"] = "6 months",
    ["alert_actions"] = "Actions",
    ["alert_counts"] = "Counts",
    ["alert_datetime"] = "Date/Time",
    ["alert_description"] = "Description",
    ["alert_duration"] = "Duration",
    ["alert_severity"] = "Severity",
    ["alert_type"] = "Alert Type",
    ["alerts"] = "Alerts",
    ["alerts_are_disabled_message"] = "Alerts are disabled. Please check the preferences page to enable them.",
    ["alerts_to_purge"] = "Alerts to Purge",
    ["confirm_delete_alert"] = "Do you really want to delete the specified alert",
    ["daily"] = "Daily",
    ["delete_alert"] = "Delete Alert",
    ["delete_alerts_configuration"] = "Delete Alerts Configuration",
    ["delete_all"] = "Delete All",
    ["delete_config_btn"] = "Delete %{conf}s Common Configuration",
    ["delete_config_message"] = "Do you really want to delete the common %{granularity} alerts configuration of %{conf}s",
    ["detected_alerts"] = "Detected Alerts",
    ["engaged"] = "Engaged",
    ["engaged_alerts"] = "Engaged Alerts",
    ["explorer"] = "Explore",
    ["five_minutes"] = "Five minutes",
    ["flow_alerts"] = "Flow Alerts",
    ["flush_data"] = "Flush Data",
    ["host_delete_config_btn"] = "Delete Host %{host} Configured Alerts",
    ["host_delete_config_confirm"] = "Do you really want to delete the %{granularity} alerts configuration for host",
    ["hourly"] = "Hourly",
    ["iface_delete_config_btn"] = "Delete Interface %{iface} Configuration",
    ["iface_delete_config_confirm"] = "Do you really want to delete the %{granularity} alerts configuration for interface",
    ["in_the_selected_time_frame"] = "in the selected time period",
    ["interface_drops_threshold"] = "Interface Packets Drops",
    ["interface_drops_threshold_descr"] = "The maximum percentage of dropped packets over the total number of interface observed packets",
    ["last_day"] = "Last Day",
    ["last_hour"] = "Last Hour",
    ["last_minute"] = "Last Minute",
    ["minute"] = "Minute",
    ["network_delete_config_btn"] = "Delete Network %{network} Configured Alerts",
    ["network_delete_config_confirm"] = "Do you really want to delete the %{granularity} alerts configuration for network",
    ["no_recorded_alerts_message"] = "No recorded alerts for interface %{ifname}",
    ["older_1_day_ago"] = " older than 1 day ago",
    ["older_1_hour_ago"] = "older than 1 hour ago",
    ["older_1_month_ago"] = "older than 1 month ago",
    ["older_1_week_ago"] = "older than 1 week ago",
    ["older_1_year_ago"] = "older than 1 year ago",
    ["older_30_minutes_ago"] = "older than 30 minutes ago",
    ["older_5_minutes_ago"] = "older than 5 minutes ago",
    ["older_6_months_ago"] = "older than 6 months ago",
    ["older_than"] = "older than",
    ["past"] = "Past",
    ["past_alerts"] = "Past Alerts",
    ["past_flow"] = "Past Flow",
    ["purge_num_alerts"] = "Purge [%{num_alerts} alerts]",
    ["purge_subj_alerts"] = "Purge %{subj} Alerts",
    ["purge_subj_alerts_confirm"] = "Do you really want to purge all the %{subj} alerts?",
    ["reset_alert_database"] = "Flush Alerts Data",
    ["reset_alert_database_message"] = "This action will remove any alerts related data, including<ul><li>Runtime alerts status</li><li>Alerts configuration</li><li>Persistent alerts SQLite storage</li></ul><br>Do you really want to proceed",
    ["startup"] = "Startup",
  },
  ["sites_page"] = {
    ["contacts"] = "Contacts",
    ["current_sites"] = "Current Sites",
    ["last_5_minutes_sites"] = "Last 5 Minute Sites",
    ["sites"] = "Sites",
    ["top_sites_not_enabled_message"] = "To keep track of visited sites, enable the creation of top visited web sites for local hosts from the <a href=\"%{url}\"><i class=\"fa fa-flask\"></i> Preferences</a>.",
    ["top_sites_not_seen"] = "Current local host has not visited any website yet.",
    ["top_visited_sites"] = "Top Visited Sites",
  },
  ["snmp"] = {
    ["AlertDescription"] = "Alert Description",
    ["ConsoleDisplayBufferText"] = "Display Text",
    ["GeneralSerialNumber"] = "Serial Number",
    ["InputCurrentLevel"] = "Current Level",
    ["InputDimUnit"] = "Dim Unit",
    ["InputMaxCapacity"] = "Max Capacity",
    ["InputMediaDimFeedDirDeclared"] = "InputMediaDimFeedDirDeclared",
    ["InputMediaDimXFeedDirDeclared"] = "InputMediaDimXFeedDirDeclared",
    ["InputName"] = "InputName",
    ["MarkerColorantValue"] = "Marker Colorant",
    ["MarkerLifeCount"] = "Marker Life Count",
    ["MarkerSuppliesDescription"] = "Marker Supplies Description",
    ["MarkerSuppliesLevel"] = "Marker Supplies Level",
    ["MarkerSuppliesMaxCapacity"] = "Marker Supplies Max Capacity",
    ["PrinterCurrentStatus"] = "Current Status",
    ["PrinterOperationalStatus"] = "Operational Status",
    ["add_device"] = "Add New Device",
    ["add_snmp_devices"] = "Add SNMP Devices",
    ["all_snmp_interface_types"] = "All Types",
    ["all_snmp_statuses"] = "All Statuses",
    ["bound_interface_description"] = "Binding a network interface to an SNMP interface is useful to compare network traffic monitored by ntopng with that reported by SNMP",
    ["caching_in_progress"] = "Device SNMP walk in progress. This may take up to 5 minutes. The page will refresh periodically.",
    ["contact"] = "Contact",
    ["delete_all_devices"] = "Delete All Devices",
    ["device_example"] = "Example: %{example}",
    ["device_ip"] = "Device IP",
    ["device_model"] = "Device Model",
    ["device_polling"] = "Device Polling",
    ["device_polling_desc"] = "Perform periodic SNMP walks to collect device data, including device interfaces traffic and status.",
    ["device_status"] = "Device Status",
    ["disable_port_monitor"] = "Disable Port Monitor",
    ["discover_devices"] = "Discover Devices",
    ["enable_port_monitor"] = "Enable Port Monitor",
    ["ifName"] = "Interface Name",
    ["ifindex"] = "Index",
    ["in_bytes"] = "In Bytes",
    ["in_discards"] = "In Discards",
    ["last_change"] = "Last Change",
    ["low_port_speed"] = "Low port speed",
    ["multiple_macs_non_trunk"] = "Multiple MACs on non-trunk port",
    ["no_answer"] = "No answer from host %{host}: please check that SNMP is up and the community is set to the correct value",
    ["no_host_discovered"] = "No host discovered in %{host}/%{cidr}",
    ["note"] = "NOTE",
    ["object_id"] = "ObjectID",
    ["out_bytes"] = "Out Bytes",
    ["port_macs"] = "Mac Addresses",
    ["port_macs_short"] = "MACs",
    ["remove_all_snmp_devices"] = "Remove All SNMP Devices",
    ["remove_all_snmp_devices_confirm"] = "Do you really want to delete all the SNMP devices?",
    ["remove_snmp_device"] = "Remove SNMP Device",
    ["remove_snmp_device_confirm"] = "Do you really want to delete the SNMP device %{device}?",
    ["snmp_all_interfaces"] = "All Interfaces",
    ["snmp_also_seen_on"] = "Also seen on",
    ["snmp_community"] = "SNMP Community",
    ["snmp_device"] = "SNMP Device",
    ["snmp_device_does_not_respond"] = "The SNMP device does not respond.",
    ["snmp_device_last_poll"] = "Time Since Last Poll",
    ["snmp_device_polling_disabled"] = "Periodic device polling is disabled. Information shown may be missing or outdated. Polling can be enabled from the <a href=\"%{url}\"><i class=\"fa fa-flask\"></i> Preferences</a>.",
    ["snmp_device_x"] = "SNMP Device: %{device}",
    ["snmp_devices"] = "SNMP Devices",
    ["snmp_interface"] = "SNMP Interface",
    ["snmp_interface_type"] = "Interface Type",
    ["snmp_interface_x"] = "Interface: %{interface}",
    ["snmp_interfaces"] = "Interfaces",
    ["snmp_monitor_disable_confirm"] = "Do you really want to disable port status monitoring on SNMP device %{device}?",
    ["snmp_monitor_enable_confirm"] = "Do you really want to enable port status monitoring on SNMP device %{device}? Alerts will be generated whenever a port changes state.",
    ["snmp_note_bridge_mib"] = "Periodic SNMP walks on the Bridge MIB are performed to populate the table.",
    ["snmp_note_bridge_mib_status"] = "Shown status is the dot1qTpFdbStatus Bridge MIB status associated to the mac address.",
    ["snmp_note_periodic_interfaces_polling"] = "Periodic SNMP walks are performed to update interfaces at regular 5-minute intervals.",
    ["snmp_note_thpt_calc"] = "The throughput accounts for the total traffic (in + out) over the two most recent consecutive SNMP walks.",
    ["snmp_note_thpt_span"] = "The two most recent consecutive SNMP walks were perfrormed at %{last} and %{prev}.",
    ["snmp_port_monitor"] = "SNMP Port Monitor",
    ["snmp_printer"] = "Printer",
    ["snmp_timeseries_descr"] = "SNMP devices timeseries can be enabled from the <a href=\"%{url}\"><i class=\"fa fa-flask\"></i> Preferences</a>. Few minutes are necessary to see the first data points",
    ["snmp_version"] = "SNMP Version",
    ["status_down"] = "Down",
    ["status_up"] = "Up",
    ["testing"] = "Testing",
    ["tp_fbd_status_invalid"] = "invalid",
    ["tp_fbd_status_learned"] = "learned",
    ["tp_fbd_status_mgmt"] = "mgmt",
    ["tp_fbd_status_other"] = "other",
    ["tp_fbd_status_self"] = "self",
    ["trunk"] = "trunk",
    ["unable_to_delete_snmp_device"] = "Unable to delete SNMP device %{device}",
    ["unresponsive_device"] = "The SNMP walk is too slow. Displayed data may be outdated or missing. Check network connectivity and device responsiveness. A new scan attempt will be performed in 15 minutes.",
    ["view_device"] = "View Device",
  },
  ["snmp_page"] = {
    ["guide_snmp_page_message"] = "Visit page <a href='%{url}'> SNMP</a> to add this host to the list of configured SNMP devices.",
    ["not_configured_as_snmp_device_message"] = "Host %{host_ip} has not been configured as an SNMP device.",
    ["showing_snmp_mib_info_default_community_message"] = "Showing SNMP MIB information retrieved using the default community '%{community}'",
    ["trying_to_retrive_message"] = "Trying to retrieve host SNMP MIB using the default community '%{community}'",
    ["unable_to_retrive_snmp_default_community_message"] = "Unable to retrieve host SNMP MIB using the default community '%{community}'.",
  },
  ["sprobe_page"] = {
    ["active_memory"] = "Active memory",
    ["latency"] = "Latency",
    ["processes"] = "Processes",
    ["processes_traffic_tree"] = "Processes Traffic Tree",
    ["show_more_info"] = "Mouse over to show the process information or double click to show more information.",
    ["system_interactions"] = "System Interactions",
    ["top_processes"] = "Top Processes",
    ["top_users"] = "Top Users",
    ["tree"] = "Tree",
    ["users"] = "Users",
  },
  ["top_hosts"] = {
    ["top_hosts_local"] = "Top Hosts (Local)",
  },
  ["topk_heuristic"] = {
    ["precision"] = {
      ["aggressive"] = "Aggressive",
      ["disabled"] = "Disabled",
      ["less_accurate"] = "Less Accurate",
      ["more_accurate"] = "More Accurate",
    },
  },
  ["traffic_page"] = {
    ["l4_proto_overview"] = "L4 Protocol Overview",
    ["no_traffic_observed_message"] = "No traffic has been observed for the specified host",
    ["rcvd"] = "Rcvd",
  },
  ["traffic_profiles"] = {
    ["advanced_filter_examples"] = "Advanced Filters Examples",
    ["confirm_delete_profile"] = "Do you really want to delete the profile",
    ["delete_profile"] = "Delete Profile",
    ["destination_network"] = "Destination network",
    ["duplicate_profile"] = "Duplicate profile name",
    ["edit_traffic_profiles"] = "Traffic Profiles",
    ["enter_profile_filter"] = "Enter the profile filter",
    ["enter_profile_name"] = "Enter a profile name",
    ["facebook_traffic"] = "Facebook",
    ["host_http_https"] = "Host HTTP/HTTPS",
    ["host_traffic"] = "Host",
    ["http_traffic"] = "HTTP",
    ["invalid_bpf"] = "Invalid BPF filter",
    ["max_profiles_num"] = "With this version of ntopng you can only create %{maxnum} profiles. Upgrade to the Enterprise version to remove this limit",
    ["no_profiles"] = "No profiles set",
    ["note"] = "Note",
    ["note_0"] = "Traffic profile names allow alpha-numeric characters, spaces, and underscores",
    ["note_1"] = "Traffic profiles are applied to flows. Each flow can have up to one profile, thus in case of multiple profile matches, only the first one is selected",
    ["profile_name"] = "Profile Name",
    ["see_ndpi_protos"] = "(use %{option} to print all nDPI supported protocols)",
    ["simple_filter_examples"] = "Simple Filters Examples",
    ["source_ethernet"] = "Source MAC address",
    ["traffic_between"] = "Traffic between hosts",
    ["traffic_filter_bpf"] = "Traffic Filter (nBPF Format)",
    ["traffic_from_to"] = "Traffic from an host to another",
    ["traffic_profiles"] = "Traffic Profiles",
  },
  ["traffic_recording"] = {
    ["about_to_extract"] = "About to extract traffic from <b>%{date_begin}</b> to <b>%{date_end}</b>",
    ["active_since"] = "Active Since",
    ["archive"] = "Archive",
    ["completed"] = "Completed",
    ["continuous_recording"] = "Continuous Traffic Recording",
    ["continuous_recording_and_flows"] = "Continuous Traffic Recording and Flow Visibility",
    ["delete_all_jobs"] = "Delete All Jobs",
    ["delete_all_jobs_confirm"] = "Do you really want to delete all the extraction jobs? Active jobs will be stopped.",
    ["delete_job"] = "Delete Job",
    ["delete_job_confirm"] = "Do you really want to delete Job %{job_id} and the related Pcap files?",
    ["disabled"] = "Disabled",
    ["disk_space"] = "Max Disk Space",
    ["disk_space_note"] = "Maximum disk space used for recorded traffic on disk.",
    ["disk_space_note_in_use"] = "%{in_use} GB are already in use by this instance.",
    ["download"] = "Download",
    ["download_nth_pcap"] = "Download Pcap #{0}",
    ["dump_window"] = "Dump Window",
    ["edit_filter"] = "Edit Filter",
    ["err_alloc"] = "memory allocation error",
    ["err_filter"] = "unsupported filter",
    ["err_open"] = "unable to open dump",
    ["err_stuck"] = "stuck or interrupted",
    ["err_unknown"] = "unexpected error",
    ["ext_interface"] = "External Interface",
    ["extract_action"] = "Extract",
    ["extract_now"] = "Extract now",
    ["extracted_bytes"] = "Extracted Bytes",
    ["extracted_packets"] = "Extracted Packets",
    ["extraction_scheduled"] = "A new extraction job has been scheduled, please check the %{page} page to download the pcap as soon as the file is ready. The job ID for this extraction is ",
    ["failed"] = "Failed",
    ["failure"] = "Failure",
    ["failure_note"] = "Please check the log trace and try restarting the service.",
    ["filter_bpf"] = "Filter (nBPF Format)",
    ["filter_examples"] = "Filter Examples",
    ["global_settings_note"] = "Global settings (e.g. the license key) can be configured from the <a href=\"%{url}\">Traffic Recording preferences</a>.",
    ["invalid_bpf"] = "Invalid filter",
    ["job_date_time"] = "Job Creation Date/Time",
    ["job_id"] = "Job ID",
    ["jobs"] = "Jobs",
    ["logs"] = "Traffic Recording Logs",
    ["max_extracted_pcap_bytes_description"] = "Maximum size for pcap files extracted from recorded data. In case of extractions exceeding this size, the output will be split into multiple files.",
    ["max_extracted_pcap_bytes_title"] = "Max Extracted File Size",
    ["missing_data_msg"] = "Traffic recording has been stopped or restarted. Some data may be missing.",
    ["missing_parameters"] = "Mandatory parameters are missing",
    ["multiple_extracted_files"] = "Traffic extraction generated multiple pcap files of %{mb} MB, it is possible to change this limit from Preferences. Click on the links below to download the pcap files.",
    ["no_data_in_interval"] = "There is no (or partial) pcap data on disk for the selected time interval. Please note that pcap data is dumped every minute (latest minute is not available) and old data is deleted (please check the current dump window in the <A HREF=\"%{page}\">status page</A>). Please try selecting a different time interval.",
    ["no_file"] = "No files dumped yet",
    ["no_recorded_data"] = "No recorded data in the specified time frame. Traffic recorder needs some time to write recent data.",
    ["not_found"] = "File not found",
    ["not_granted"] = "Request not granted",
    ["note_dump"] = "In ethernet networks, each packet has an <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">overhead of 24 bytes</A> [preamble, start of frame, CRC, IFG]. Such overhead is accounted to the interface traffic, but it is not added to the traffic being dumped on disk. For this reason the number of bytes in this page may differ from those reported in the interface chart.",
    ["packet_dumps"] = "Packet Dumps",
    ["pcap_download"] = "Extract pcap",
    ["pcap_download_message"] = "Start the extraction and check the %{page} page to download the pcap as soon as the file is ready.",
    ["processing"] = "Processing",
    ["queue_as_job"] = "Queue as a Job",
    ["recording"] = "Recording",
    ["restart"] = "Restart",
    ["restart_service"] = "Restart the service",
    ["settings"] = "Settings",
    ["start_extraction"] = "Start Extraction",
    ["stop_job"] = "Stop Job",
    ["stop_job_confirm"] = "Do you really want to stop Job %{job_id}?",
    ["stopped"] = "Stopped",
    ["storage"] = "Storage",
    ["storage_dir"] = "Storage Directory",
    ["storage_directory_config"] = "The Storage Directory path can be changed by specifing the <i>%{option}</i> option into the %{product} configuration file.",
    ["storage_utilization"] = "Storage Utilization",
    ["traffic_extraction_jobs"] = "Traffic Extraction Jobs",
    ["traffic_on_disk"] = "Traffic On Disk",
    ["traffic_recording"] = "Traffic Recording",
    ["traffic_recording_settings"] = "Traffic Recording Settings",
    ["traffic_recording_status"] = "Traffic Recording Status",
    ["unsupported_fields"] = "Note that the selected chart provides a view of the traffic not fully supported by the extraction tool, extracted traffic will contain more traffic than expected.",
    ["waiting"] = "Waiting",
    ["waiting_nospace"] = "Waiting (No Space On Disk)",
  },
  ["traffic_report"] = {
    ["current_day"] = "Current Day",
    ["current_month"] = "Current Month",
    ["current_week"] = "Current Week",
    ["daily"] = "Daily",
    ["header_daily"] = "Daily report",
    ["header_monthly"] = "Monthly report",
    ["header_weekly"] = "Weekly report",
    ["monthly"] = "Monthly",
    ["previous_day"] = "Previous Day",
    ["previous_month"] = "Previous Month",
    ["previous_week"] = "Previous Week",
    ["weekly"] = "Weekly",
  },
  ["tree_map"] = {
    ["hosts_treemap"] = "Hosts Tree Map",
  },
  ["unknown_devices"] = {
    ["active_only"] = "Active Only",
    ["all_devices"] = "All Devices",
    ["assign_device_pool"] = "Assign Device to a Pool",
    ["assign_pool"] = "Assign To Pool",
    ["device_name"] = "Device Name",
    ["filter_devices"] = "Filter Devices",
    ["first_seen"] = "First Seen",
    ["inactive_only"] = "Inactive Only",
    ["last_seen"] = "Last Seen",
    ["no_pools"] = "An host pool must be created in order to assign unknown devices to.",
    ["select_pool"] = "Please select an host pool from the dropdown below to assign '%{mac}' to:",
    ["unassigned_devices"] = "Unassigned Devices",
  },
  ["user_activity"] = {
    ["alerts_deleted"] = "User '%{user}' purged '%{status}' alerts.",
    ["changed_preference"] = "User '%{user}' changed settings for %{pref}.",
    ["deleted_all_interfaces_data"] = "User '%{user}' deleted data for all interfaces.",
    ["deleted_host_data"] = "User '%{user}' deleted data for host %{host} on interface %{ifname}.",
    ["deleted_inactive_interfaces_data"] = "User '%{user}' deleted data for all inactive interfaces.",
    ["deleted_interface_data"] = "User '%{user}' deleted data for interface %{ifname}.",
    ["disabled_preference"] = "User '%{user}' disabled preference %{pref}.",
    ["enabled_preference"] = "User '%{user}' enabled preference %{pref}.",
    ["exported_data"] = "User '%{user}' exported JSON data for '%{mode}' hosts.",
    ["exported_data_host"] = "User '%{user}' exported JSON data for '%{mode}' host %{host}.",
    ["file_downloaded"] = "User '%{user}' downloaded file '%{file}'.",
    ["flows_downloaded"] = "User '%{user}' downloaded flows data from %{from} to %{to}.",
    ["host_json_downloaded"] = "User '%{user}' downloaded JSON data for host %{host}.",
    ["live_capture"] = "User '%{user}' captured live traffic on interface %{ifname}.",
    ["live_capture_host"] = "User '%{user}' captured live traffic for host %{host} on interface %{ifname}.",
    ["live_capture_host_with_filter"] = "User '%{user}' captured live traffic for host %{host} matching filter '%{filter}' on interface %{ifname}.",
    ["live_capture_with_filter"] = "User '%{user}' captured live traffic matching filter '%{filter}' on interface %{ifname}.",
    ["live_extraction"] = "User '%{user}' downloaded traffic from interface %{ifname} from %{from} to %{to}.",
    ["live_extraction_with_filter"] = "User '%{user}' downloaded traffic from interface %{ifname} from %{from} to %{to} matching filter '%{filter}'.",
    ["login_not_authorized"] = "Login denied for user '%{user}'.",
    ["login_successful"] = "User '%{user}' logged in.",
    ["password_changed"] = "Password for user '%{pwd_user}' changed by '%{user}'.",
    ["recording_disabled"] = "User '%{user}' disabled Traffic Recording on interface %{ifname}.",
    ["recording_enabled"] = "User '%{user}' enabled Traffic Recording on interface %{ifname}.",
    ["remote_assistance_disabled"] = "User '%{user}' disabled Remote Assistance.",
    ["remote_assistance_enabled"] = "User '%{user}' enabled Remote Assistance.",
    ["snmp_device_added"] = "User '%{user}' added SNMP device %{ip}.",
    ["snmp_device_deleted"] = "User '%{user}' deleted SNMP device %{ip}.",
    ["unknown_activity"] = "User '%{user}' did some unknown activity (%{scope}), please report this.",
    ["unknown_activity_function"] = "User '%{user}' did some unknown activity (%{name}), please report this.",
    ["user_added"] = "User '%{add_user}' added by '%{user}'.",
    ["user_deleted"] = "User '%{del_user}' deleted by '%{user}'.",
  },
  ["user_info"] = {
    ["missing_user_name_message"] = "Missing user name",
    ["processes"] = "Processes",
    ["processes_overview"] = "Processes Overview",
    ["top_l4_protocols"] = "Top L4 Protocols",
    ["top_l7_protocols"] = "Top L7 Protocols",
  },
  ["users"] = {
    ["add_new_user"] = "Add New User",
    ["add_user"] = "Add User",
    ["assigned_devices"] = "Assigned Devices",
    ["cat_protocols"] = "%{cat} Protocols",
    ["categories"] = "Categories",
    ["client_policy"] = "Device As Client",
    ["confirm_delete_user"] = "Do you really want to delete user \"%{user}\"?",
    ["delete_user"] = "Delete User",
    ["devices"] = "Devices",
    ["edit"] = "Edit",
    ["edit_global_policies"] = "Edit Default Policies",
    ["fallback_policy"] = "Fallback Policy",
    ["full_name"] = "Full Name",
    ["global"] = "Global",
    ["global_policies"] = "Default Policies",
    ["no_users"] = "No users",
    ["num_protocols"] = "Num Protocols",
    ["policy"] = "Policy",
    ["protocols"] = "Protocols",
    ["reset_to_defaults"] = "Reset To Defaults",
    ["reset_to_defaults_confirm"] = "Do you really want to reset the device type \"%{devtype}\" policies to to the defaults?",
    ["server_policy"] = "Device As Server",
    ["settings"] = "Settings",
    ["total_daily_time_quota"] = "Total Daily Time Quota",
    ["total_daily_traffic_quota"] = "Total Daily Traffic Quota",
    ["unchanged"] = "Unchanged",
    ["user_exists"] = "User \"%{user}\" already exists",
    ["user_x"] = "User: %{user}",
    ["shapers"] = {
      ["default"] = "Default",
      ["drop"] = "Drop",
      ["pass"] = "Pass",
      ["slow"] = "Slow Pass",
      ["slower"] = "Slower Pass",
    },
  },
  ["vlan_details"] = {
    ["no_available_stats_for_vlan_message"] = "No available stats for VLAN %{vlan_id}. Please wait a few minutes to allow %{product} to harvest new statistics.",
    ["vlan_id_parameter_missing_or_invalid_message"] = "Vlan_Id parameter is missing or is not valid",
  },
  ["vlan_stats"] = {
    ["vlan_id"] = "VLAN ID",
    ["vlans"] = "VLANs",
  },
}

return lang
