/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_SPELL_API_H
#define __FCITX_MODULE_FCITX_SPELL_API_H

#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "spell.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-spell", Spell)

DEFINE_GET_AND_INVOKE_FUNC(Spell, HintWords, 0)
static inline SpellHint*
FcitxSpellHintWords(FcitxInstance *instance, const char* _arg0, const char* _arg1, const char* _arg2, unsigned int _arg3, const char* _arg4, const char* _arg5)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, const char*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, unsigned int, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, const char*, _arg4);
    FCITX_DEF_CAST_TO_PTR(arg5, const char*, _arg5);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4, arg5);
    result = FcitxSpellInvokeHintWords(instance, args);
    FCITX_RETURN_FROM_PTR(SpellHint*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Spell, AddPersonal, 1)
static inline boolean
FcitxSpellAddPersonal(FcitxInstance *instance, const char* _arg0, const char* _arg1)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    result = FcitxSpellInvokeAddPersonal(instance, args);
    FCITX_RETURN_FROM_PTR(boolean, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Spell, DictAvailable, 2)
static inline boolean
FcitxSpellDictAvailable(FcitxInstance *instance, const char* _arg0, const char* _arg1)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1);
    result = FcitxSpellInvokeDictAvailable(instance, args);
    FCITX_RETURN_FROM_PTR(boolean, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Spell, GetCandWords, 3)
static inline FcitxCandidateWordList*
FcitxSpellGetCandWords(FcitxInstance *instance, const char* _arg0, const char* _arg1, const char* _arg2, unsigned int _arg3, const char* _arg4, const char* _arg5, FcitxSpellGetCandWordCb _arg6, void* _arg7)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_CAST_TO_PTR(arg1, const char*, _arg1);
    FCITX_DEF_CAST_TO_PTR(arg2, const char*, _arg2);
    FCITX_DEF_CAST_TO_PTR(arg3, unsigned int, _arg3);
    FCITX_DEF_CAST_TO_PTR(arg4, const char*, _arg4);
    FCITX_DEF_CAST_TO_PTR(arg5, const char*, _arg5);
    FCITX_DEF_CAST_TO_PTR(arg6, FcitxSpellGetCandWordCb, _arg6);
    FCITX_DEF_CAST_TO_PTR(arg7, void*, _arg7);
    FCITX_DEF_MODULE_ARGS(args, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    result = FcitxSpellInvokeGetCandWords(instance, args);
    FCITX_RETURN_FROM_PTR(FcitxCandidateWordList*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Spell, CandWordGetCommit, 4)
static inline const char*
FcitxSpellCandWordGetCommit(FcitxInstance *instance, FcitxCandidateWord* _arg0)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, FcitxCandidateWord*, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    result = FcitxSpellInvokeCandWordGetCommit(instance, args);
    FCITX_RETURN_FROM_PTR(const char*, result);
}


#ifdef __cplusplus
}
#endif

#endif
