/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;

public class SocketFetcher
implements Runnable {
    private Socket socket;
    private String host;
    private int port;
    private Properties props;
    private String prefix;
    private int cto;
    private boolean useSSL;
    private IOException exception;
    private boolean aborted = false;
    private boolean done = false;
    private static final String SSL_SOCKET_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final String SSL_SOCKET = "javax.net.ssl.SSLSocket";
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$net$InetAddress;

    private SocketFetcher(String string, int n, Properties properties, String string2, int n2, boolean bl) throws IOException {
        this.host = string;
        this.port = n;
        this.props = properties;
        this.prefix = string2;
        this.cto = n2;
        this.useSSL = bl;
    }

    public static Socket getSocket(String string, int n, Properties properties, String string2, boolean bl) throws IOException {
        if (string2 == null) {
            string2 = "socket";
        }
        if (properties == null) {
            properties = new Properties();
        }
        String string3 = properties.getProperty(String.valueOf(string2) + ".connectiontimeout", null);
        int n2 = -1;
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n2 > 0) {
            SocketFetcher socketFetcher = new SocketFetcher(string, n, properties, string2, n2, bl);
            try {
                Thread thread = new Thread((Runnable)socketFetcher, "Connection thread for host " + string);
                thread.start();
            }
            catch (Exception exception) {
                return SocketFetcher.getSocket0(string, n, properties, string2, bl);
            }
            return socketFetcher.getSocket();
        }
        return SocketFetcher.getSocket0(string, n, properties, string2, bl);
    }

    public static Socket getSocket(String string, int n, Properties properties, String string2) throws IOException {
        return SocketFetcher.getSocket(string, n, properties, string2, false);
    }

    public static Socket startTLS(Socket socket) throws IOException {
        InetAddress inetAddress = socket.getInetAddress();
        String string = inetAddress.getHostName();
        int n = socket.getPort();
        try {
            String string2;
            try {
                string2 = System.getProperty("mail.SSLSocketFactory.class", SSL_SOCKET_FACTORY);
            }
            catch (SecurityException securityException) {
                string2 = SSL_SOCKET_FACTORY;
            }
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getMethod("getDefault", new Class[0]);
            Object object = method.invoke(new Object(), new Object[0]);
            Class[] classArray = new Class[]{class$java$net$Socket != null ? class$java$net$Socket : (class$java$net$Socket = SocketFetcher.class$("java.net.Socket")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SocketFetcher.class$("java.lang.String")), Integer.TYPE, Boolean.TYPE};
            Method method2 = clazz.getMethod("createSocket", classArray);
            Object[] objectArray = new Object[]{socket, string, new Integer(n), Boolean.TRUE};
            socket = (Socket)method2.invoke(object, objectArray);
            Class<?> clazz2 = Class.forName(SSL_SOCKET);
            try {
                Method method3 = clazz2.getMethod("setEnabledProtocols", array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = SocketFetcher.class$("[Ljava.lang.String;")));
                if (method3 != null) {
                    method3.invoke((Object)socket, new Object[]{new String[]{"TLSv1"}});
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception exception) {
            Exception exception2;
            Throwable throwable;
            if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof Exception) {
                exception2 = (Exception)throwable;
            }
            if (exception2 instanceof IOException) {
                throw (IOException)exception2;
            }
            throw new IOException("Exception in startTLS: host " + string + ", port " + n + "; Exception: " + exception2);
        }
        return socket;
    }

    private static Socket getSocket0(String string, int n, Properties properties, String string2, boolean bl) throws IOException {
        int n2;
        Socket socket = null;
        String string3 = properties.getProperty(String.valueOf(string2) + ".socketFactory.class", null);
        String string4 = properties.getProperty(String.valueOf(string2) + ".timeout", null);
        String string5 = properties.getProperty(String.valueOf(string2) + ".localaddress", null);
        InetAddress inetAddress = null;
        if (string5 != null) {
            inetAddress = InetAddress.getByName(string5);
        }
        String string6 = properties.getProperty(String.valueOf(string2) + ".localport", null);
        int n3 = 0;
        if (string6 != null) {
            try {
                n3 = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        boolean bl2 = false;
        if ((string3 == null || string3.length() <= 0) && bl) {
            try {
                string3 = System.getProperty("mail.SSLSocketFactory.class", SSL_SOCKET_FACTORY);
            }
            catch (SecurityException securityException) {
                string3 = SSL_SOCKET_FACTORY;
            }
            bl2 = true;
        }
        if (string3 == null || string3.length() <= 0) {
            socket = new Socket(string, n, inetAddress, n3);
        } else {
            Object object;
            Object object2;
            n2 = -1;
            boolean bl3 = false;
            if (!bl2) {
                object2 = properties.getProperty(String.valueOf(string2) + ".socketFactory.fallback", null);
                bl3 = object2 == null || !((String)object2).equalsIgnoreCase("false");
                object = properties.getProperty(String.valueOf(string2) + ".socketFactory.port", null);
                if (object != null) {
                    try {
                        n2 = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            try {
                object2 = Class.forName(string3);
                object = ((Class)object2).getMethod("getDefault", new Class[0]);
                Object object3 = ((Method)object).invoke(new Object(), new Object[0]);
                Integer n4 = new Integer(n2 != -1 ? n2 : n);
                if (inetAddress != null) {
                    Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SocketFetcher.class$("java.lang.String")), Integer.TYPE, class$java$net$InetAddress != null ? class$java$net$InetAddress : (class$java$net$InetAddress = SocketFetcher.class$("java.net.InetAddress")), Integer.TYPE};
                    Method method = ((Class)object2).getMethod("createSocket", classArray);
                    Object[] objectArray = new Object[]{string, n4, inetAddress, new Integer(n3)};
                    socket = (Socket)method.invoke(object3, objectArray);
                } else {
                    Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SocketFetcher.class$("java.lang.String")), Integer.TYPE};
                    Method method = ((Class)object2).getMethod("createSocket", classArray);
                    Object[] objectArray = new Object[]{string, n4};
                    socket = (Socket)method.invoke(object3, objectArray);
                }
            }
            catch (Exception exception) {
                Exception exception2;
                if (bl3) {
                    socket = new Socket(string, n, inetAddress, n3);
                }
                if (exception instanceof InvocationTargetException && (object = ((InvocationTargetException)exception).getTargetException()) instanceof Exception) {
                    exception2 = (Exception)object;
                }
                if (exception2 instanceof IOException) {
                    throw (IOException)exception2;
                }
                throw new IOException("Couldn't connect using \"" + string3 + "\" socket factory to host, port: " + string + ", " + n2 + "; Exception: " + exception2);
            }
        }
        n2 = -1;
        if (string4 != null) {
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n2 >= 0) {
            socket.setSoTimeout(n2);
        }
        return socket;
    }

    private synchronized Socket getSocket() throws IOException {
        if (!this.done) {
            try {
                long l = System.currentTimeMillis();
                long l2 = l + (long)this.cto;
                while (l < l2) {
                    this.wait(l2 - l);
                    if (!this.done) {
                        l = System.currentTimeMillis();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                this.exception = new InterruptedIOException(interruptedException.toString());
            }
        }
        if (this.exception != null) {
            this.aborted = true;
            throw this.exception;
        }
        if (this.socket == null) {
            this.aborted = true;
            throw new ConnectException("connection to " + this.host + " timed out");
        }
        Socket socket = this.socket;
        this.socket = null;
        return socket;
    }

    public void run() {
        try {
            Socket socket = SocketFetcher.getSocket0(this.host, this.port, this.props, this.prefix, this.useSSL);
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                if (this.aborted) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.socket = socket;
                }
                this.done = true;
                this.notify();
                return;
            }
        }
        catch (IOException iOException) {
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                this.exception = iOException;
                this.done = true;
                this.notify();
                return;
            }
        }
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        if (this.socket != null) {
            this.socket.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

