/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class TablePosition<S, T> {
    private final int row;
    private final TableColumn<S, T> tableColumn;
    private final TableView<S> tableView;

    public TablePosition(TableView<S> tableView, int n, TableColumn<S, T> tableColumn) {
        this.row = n;
        this.tableColumn = tableColumn;
        this.tableView = tableView;
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.tableView == null || this.tableColumn == null ? -1 : this.tableView.getVisibleLeafIndex(this.tableColumn);
    }

    public final TableView<S> getTableView() {
        return this.tableView;
    }

    public final TableColumn<S, T> getTableColumn() {
        return this.tableColumn;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TablePosition tablePosition = (TablePosition)object;
        if (this.row != tablePosition.row) {
            return false;
        }
        if (!(this.tableColumn == tablePosition.tableColumn || this.tableColumn != null && this.tableColumn.equals(tablePosition.tableColumn))) {
            return false;
        }
        return this.tableView == tablePosition.tableView || this.tableView != null && this.tableView.equals(tablePosition.tableView);
    }

    public int hashCode() {
        int n = 5;
        n = 79 * n + this.row;
        n = 79 * n + (this.tableColumn != null ? this.tableColumn.hashCode() : 0);
        n = 79 * n + (this.tableView != null ? this.tableView.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "TablePosition [ row: " + this.row + ", column: " + this.tableColumn + ", " + "tableView: " + this.tableView + " ]";
    }
}

