/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class RuptelaProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_RECORDS = 1;
    public static final int MSG_DEVICE_CONFIGURATION = 2;
    public static final int MSG_DEVICE_VERSION = 3;
    public static final int MSG_FIRMWARE_UPDATE = 4;
    public static final int MSG_SET_CONNECTION = 5;
    public static final int MSG_SET_ODOMETER = 6;
    public static final int MSG_SMS_VIA_GPRS_RESPONSE = 7;
    public static final int MSG_SMS_VIA_GPRS = 8;
    public static final int MSG_DTCS = 9;
    public static final int MSG_SET_IO = 17;
    public static final int MSG_FILES = 37;
    public static final int MSG_EXTENDED_RECORDS = 68;

    public RuptelaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodeCommandResponse(DeviceSession deviceSession, int type, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("type", type);
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                position.set("result", buf.toString(buf.readerIndex(), buf.readableBytes() - 2, StandardCharsets.US_ASCII).trim());
                return position;
            }
            case 17: {
                position.set("result", String.valueOf(buf.readUnsignedByte()));
                return position;
            }
        }
        return null;
    }

    private long readValue(ByteBuf buf, int length, boolean signed) {
        switch (length) {
            case 1: {
                return signed ? (long)buf.readByte() : (long)buf.readUnsignedByte();
            }
            case 2: {
                return signed ? (long)buf.readShort() : (long)buf.readUnsignedShort();
            }
            case 4: {
                return signed ? (long)buf.readInt() : buf.readUnsignedInt();
            }
        }
        return buf.readLong();
    }

    private void decodeParameter(Position position, int id, ByteBuf buf, int length) {
        switch (id) {
            case 2: 
            case 3: 
            case 4: {
                position.set("di" + (id - 1), this.readValue(buf, length, false));
                break;
            }
            case 5: {
                position.set("ignition", this.readValue(buf, length, false) == 1L);
                break;
            }
            case 74: {
                position.set("temp3", (double)this.readValue(buf, length, true) * 0.1);
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                position.set("temp" + (id - 78), (double)this.readValue(buf, length, true) * 0.1);
                break;
            }
            default: {
                position.set("io" + id, this.readValue(buf, length, false));
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedShort();
        String imei = String.format("%015d", buf.readLong());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        short type = buf.readUnsignedByte();
        if (type == 1 || type == 68) {
            LinkedList<Position> positions = new LinkedList<Position>();
            buf.readUnsignedByte();
            int count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                int id;
                int j;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.setTime(new Date(buf.readUnsignedInt() * 1000L));
                buf.readUnsignedByte();
                if (type == 68) {
                    buf.readUnsignedByte();
                }
                buf.readUnsignedByte();
                position.setValid(true);
                position.setLongitude((double)buf.readInt() / 1.0E7);
                position.setLatitude((double)buf.readInt() / 1.0E7);
                position.setAltitude((double)buf.readUnsignedShort() / 10.0);
                position.setCourse((double)buf.readUnsignedShort() / 100.0);
                position.set("sat", buf.readUnsignedByte());
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
                position.set("hdop", (double)buf.readUnsignedByte() / 10.0);
                if (type == 68) {
                    position.set("event", buf.readUnsignedShort());
                } else {
                    position.set("event", buf.readUnsignedByte());
                }
                int cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 1);
                }
                cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 2);
                }
                cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 4);
                }
                cnt = buf.readUnsignedByte();
                for (j = 0; j < cnt; ++j) {
                    id = type == 68 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
                    this.decodeParameter(position, id, buf, 8);
                }
                Long driverIdPart1 = (Long)position.getAttributes().remove("io126");
                Long driverIdPart2 = (Long)position.getAttributes().remove("io127");
                if (driverIdPart1 != null && driverIdPart2 != null) {
                    ByteBuf driverId = Unpooled.copyLong((long[])new long[]{driverIdPart1, driverIdPart2});
                    position.set("driverUniqueId", driverId.toString(StandardCharsets.US_ASCII));
                    driverId.release();
                }
                positions.add(position);
            }
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])DataConverter.parseHex("0002640113bc")), remoteAddress));
            }
            return positions;
        }
        if (type == 9) {
            LinkedList<Position> positions = new LinkedList<Position>();
            int count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                buf.readUnsignedByte();
                position.setTime(new Date(buf.readUnsignedInt() * 1000L));
                position.setValid(true);
                position.setLongitude((double)buf.readInt() / 1.0E7);
                position.setLatitude((double)buf.readInt() / 1.0E7);
                if (buf.readUnsignedByte() == 2) {
                    position.set("archive", true);
                }
                position.set("dtcs", buf.readSlice(5).toString(StandardCharsets.US_ASCII));
                positions.add(position);
            }
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])DataConverter.parseHex("00026d01c4a4")), remoteAddress));
            }
            return positions;
        }
        return this.decodeCommandResponse(deviceSession, type, buf);
    }
}

