/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseFrameDecoder;
import org.traccar.helper.BufferUtil;

public class AtrackFrameDecoder
extends BaseFrameDecoder {
    private static final int KEEPALIVE_LENGTH = 12;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() >= 2) {
            if (buf.getUnsignedShort(buf.readerIndex()) == 65026) {
                if (buf.readableBytes() >= 12) {
                    return buf.readRetainedSlice(12);
                }
            } else if (buf.getUnsignedShort(buf.readerIndex()) == 16464 && buf.getByte(buf.readerIndex() + 2) != 44) {
                if (buf.readableBytes() > 6) {
                    int length = buf.getUnsignedShort(buf.readerIndex() + 4) + 4 + 2;
                    if (buf.readableBytes() >= length) {
                        return buf.readRetainedSlice(length);
                    }
                }
            } else {
                int lengthStart = buf.indexOf(buf.readerIndex() + 3, buf.writerIndex(), (byte)44) + 1;
                if (lengthStart > 0) {
                    int lengthEnd = buf.indexOf(lengthStart, buf.writerIndex(), (byte)44);
                    if (lengthEnd > 0) {
                        int length = lengthEnd + Integer.parseInt(buf.toString(lengthStart, lengthEnd - lengthStart, StandardCharsets.US_ASCII));
                        if (buf.readableBytes() > length && buf.getByte(buf.readerIndex() + length) == 10) {
                            ++length;
                        }
                        if (buf.readableBytes() >= length) {
                            return buf.readRetainedSlice(length);
                        }
                    }
                } else {
                    int endIndex = BufferUtil.indexOf("\r\n", buf);
                    if (endIndex > 0) {
                        return buf.readRetainedSlice(endIndex - buf.readerIndex() + 2);
                    }
                }
            }
        }
        return null;
    }
}

