/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import tr.model.action.Interval;
import tr.model.action.Period;
import tr.model.action.PeriodType;
import tr.prefs.dates.DatesPrefs;
import tr.prefs.recurrence.RecurrencePrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodWeek
extends Period {
    public static final byte ID = 3;
    public static final String BUNDLE_KEY = "period.week";
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int SUNDAY = 1;
    private final List<Integer> selectedDays;

    public PeriodWeek() {
        this.selectedDays = new Vector<Integer>();
    }

    public PeriodWeek(List<Integer> selectedDays) {
        this.selectedDays = selectedDays;
    }

    @Override
    public Period clone() {
        return new PeriodWeek(new Vector<Integer>(this.selectedDays));
    }

    @Override
    public final String getBundleKey() {
        return BUNDLE_KEY;
    }

    @Override
    public final byte getID() {
        return 3;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.selectedDays != null ? ((Object)this.selectedDays).hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PeriodWeek) {
            PeriodWeek other = (PeriodWeek)object;
            return ((Object)this.selectedDays).equals(other.selectedDays);
        }
        return false;
    }

    public List<Integer> getSelectedDays() {
        Collections.sort(this.selectedDays);
        return this.selectedDays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(Integer dayOfWeek) {
        PeriodWeek periodWeek = this;
        synchronized (periodWeek) {
            return this.selectedDays.contains(dayOfWeek);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(Integer dayOfWeek) {
        PeriodWeek periodWeek = this;
        synchronized (periodWeek) {
            if (!this.isSelected(dayOfWeek)) {
                this.selectedDays.add(dayOfWeek);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselected(Integer dayOfWeek) {
        PeriodWeek periodWeek = this;
        synchronized (periodWeek) {
            this.selectedDays.remove(dayOfWeek);
        }
    }

    private Date calculateStartDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(DatesPrefs.getFirstDayOfWeek());
        calendar.set(7, DatesPrefs.getFirstDayOfWeek());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date calculateEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(DatesPrefs.getFirstDayOfWeek());
        calendar.set(7, calendar.getMaximum(7));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private Date addWeeks(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(DatesPrefs.getFirstDayOfWeek());
        calendar.setTime(date);
        calendar.add(3, n);
        return calendar.getTime();
    }

    public List<Date> getSelectedDates(Date periodDate) {
        Vector<Date> dates = new Vector<Date>();
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(DatesPrefs.getFirstDayOfWeek());
        Date startDate = this.calculateStartDate(periodDate);
        for (Integer day : this.selectedDays) {
            calendar.setTime(startDate);
            calendar.set(7, day);
            dates.add(calendar.getTime());
        }
        return dates;
    }

    @Override
    public List<Date> getSelectedDates(Date startDate, Date templateDate) {
        assert (startDate != null);
        assert (templateDate != null);
        Vector<Date> dates = new Vector<Date>();
        Calendar templateCal = Calendar.getInstance();
        templateCal.setFirstDayOfWeek(DatesPrefs.getFirstDayOfWeek());
        templateCal.setTime(templateDate);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(DatesPrefs.getFirstDayOfWeek());
        cal.setTime(startDate);
        for (Integer day : this.selectedDays) {
            cal.set(7, day);
            cal.set(11, templateCal.get(11));
            cal.set(12, templateCal.get(12));
            cal.set(13, templateCal.get(13));
            cal.set(14, templateCal.get(14));
            dates.add(cal.getTime());
        }
        return dates;
    }

    @Override
    public void initialise(Date startDate) {
        this.selectedDays.clear();
        if (startDate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            this.selectedDays.add(cal.get(7));
        }
    }

    @Override
    public int getDefaultAdvanceNbr() {
        return RecurrencePrefs.getNbrFutureWeek();
    }

    @Override
    public PeriodType getType() {
        return PeriodType.WEEK;
    }

    @Override
    public Interval getPeriod(Date date) {
        return new Interval(this.calculateStartDate(date), this.calculateEndDate(date));
    }

    @Override
    public Interval addPeriods(Interval interval, int n) {
        return this.getPeriod(this.addWeeks(interval.start, n));
    }
}

