/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSizeEstimator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String TERMS = "terms";
    public static final String STORED_FIELDS = "storedFields";
    public static final String NORMS = "norms";
    public static final String DOC_VALUES = "docValues";
    public static final String POINTS = "points";
    public static final String TERM_VECTORS = "termVectors";
    public static final String SUMMARY = "summary";
    public static final String DETAILS = "details";
    public static final String FIELDS_BY_SIZE = "fieldsBySize";
    public static final String TYPES_BY_SIZE = "typesBySize";
    public static final int DEFAULT_SAMPLING_THRESHOLD = 100000;
    public static final float DEFAULT_SAMPLING_PERCENT = 5.0f;
    private final IndexReader reader;
    private final int topN;
    private final int maxLength;
    private final boolean withSummary;
    private final boolean withDetails;
    private int samplingThreshold = 100000;
    private float samplingPercent = 5.0f;
    private int samplingStep = 1;

    public IndexSizeEstimator(IndexReader reader, int topN, int maxLength, boolean withSummary, boolean withDetails) {
        this.reader = reader;
        this.topN = topN;
        this.maxLength = maxLength;
        this.withSummary = withSummary;
        this.withDetails = withDetails;
    }

    public void setSamplingThreshold(int threshold) {
        if (threshold <= 0) {
            threshold = Integer.MAX_VALUE;
        }
        this.samplingThreshold = threshold;
    }

    public void setSamplingPercent(float percent) throws IllegalArgumentException {
        if (percent <= 0.0f || percent > 100.0f) {
            throw new IllegalArgumentException("samplingPercent must be 0 < percent <= 100");
        }
        if (this.reader.maxDoc() > this.samplingThreshold) {
            this.samplingStep = Math.round(100.0f / this.samplingPercent);
            log.info("- number of documents {} larger than {}, sampling percent is {} and sampling step {}", new Object[]{this.reader.maxDoc(), this.samplingThreshold, Float.valueOf(this.samplingPercent), this.samplingStep});
            if (this.reader.maxDoc() / this.samplingStep < 10) {
                throw new IllegalArgumentException("Out of " + this.reader.maxDoc() + " less than 10 documents would be sampled, which is too unreliable. Increase the samplingPercent.");
            }
        }
        this.samplingPercent = percent;
    }

    public Estimate estimate() throws Exception {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> summary = new LinkedHashMap<String, Object>();
        this.estimateStoredFields(details);
        this.estimateTerms(details);
        this.estimateNorms(details);
        this.estimatePoints(details);
        this.estimateTermVectors(details);
        this.estimateDocValues(details);
        this.estimateSummary(details, summary);
        if (this.samplingStep > 1) {
            details.put("samplingPercent", Float.valueOf(this.samplingPercent));
            details.put("samplingStep", this.samplingStep);
        }
        ItemPriorityQueue fieldSizeQueue = new ItemPriorityQueue(summary.size());
        summary.forEach((field, perField) -> {
            long size = ((AtomicLong)((Map)perField).get("totalSize")).get();
            if (size > 0L) {
                fieldSizeQueue.insertWithOverflow(new Item(field, size));
            }
        });
        LinkedHashMap<String, Long> fieldsBySize = new LinkedHashMap<String, Long>();
        fieldSizeQueue._forEachEntry((k, v) -> fieldsBySize.put((String)k, (Long)v));
        HashMap<String, AtomicLong> typeSizes = new HashMap<String, AtomicLong>();
        summary.forEach((field, perField) -> {
            Map perType = (Map)((Map)perField).get("perType");
            perType.forEach((type, size) -> {
                if (type.contains("_lengths")) {
                    AtomicLong totalSize = typeSizes.computeIfAbsent(type.replace("_lengths", ""), t -> new AtomicLong());
                    totalSize.addAndGet(((AtomicLong)size).get());
                }
            });
        });
        ItemPriorityQueue typesSizeQueue = new ItemPriorityQueue(typeSizes.size());
        typeSizes.forEach((type, size) -> {
            if (size.get() > 0L) {
                typesSizeQueue.insertWithOverflow(new Item(type, size.get()));
            }
        });
        LinkedHashMap<String, Long> typesBySize = new LinkedHashMap<String, Long>();
        typesSizeQueue._forEachEntry((k, v) -> typesBySize.put((String)k, (Long)v));
        LinkedHashMap<String, Object> newSummary = new LinkedHashMap<String, Object>();
        fieldsBySize.keySet().forEach(k -> newSummary.put(String.valueOf(k), summary.get(k)));
        this.convert(newSummary);
        this.convert(details);
        return new Estimate(fieldsBySize, typesBySize, this.withSummary ? newSummary : null, this.withDetails ? details : null);
    }

    private void convert(Map<String, Object> result) {
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            LinkedHashMap map;
            Object value = entry.getValue();
            if (value instanceof ItemPriorityQueue) {
                ItemPriorityQueue queue = (ItemPriorityQueue)((Object)value);
                map = new LinkedHashMap();
                queue.toMap(map);
                entry.setValue(map);
                continue;
            }
            if (value instanceof MapWriterSummaryStatistics) {
                MapWriterSummaryStatistics stats = (MapWriterSummaryStatistics)((Object)value);
                map = new LinkedHashMap();
                stats.toMap(map);
                entry.setValue(map);
                continue;
            }
            if (value instanceof AtomicLong) {
                entry.setValue(((AtomicLong)value).longValue());
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.convert((Map)value);
        }
    }

    private void estimateSummary(Map<String, Object> details, Map<String, Object> summary) {
        log.info("- preparing summary...");
        details.forEach((type, perType) -> ((Map)perType).forEach((field, perField) -> {
            Map perFieldSummary = (Map)summary.computeIfAbsent((String)field, f -> new HashMap());
            ((Map)perField).forEach((k, val) -> {
                if (val instanceof SummaryStatistics) {
                    SummaryStatistics stats = (SummaryStatistics)val;
                    if (k.startsWith("lengths")) {
                        AtomicLong total = (AtomicLong)perFieldSummary.computeIfAbsent("totalSize", kt -> new AtomicLong());
                        total.addAndGet((long)stats.getSum());
                    }
                    Map perTypeSummary = (Map)perFieldSummary.computeIfAbsent("perType", pt -> new HashMap());
                    AtomicLong total = (AtomicLong)perTypeSummary.computeIfAbsent(type + "_" + k, t -> new AtomicLong());
                    total.addAndGet((long)stats.getSum());
                }
            });
        }));
    }

    private void estimateNorms(Map<String, Object> result) throws IOException {
        log.info("- estimating norms...");
        HashMap<String, Map> stats = new HashMap<String, Map>();
        for (LeafReaderContext leafReaderContext : this.reader.leaves()) {
            LeafReader leafReader = leafReaderContext.reader();
            FieldInfos fieldInfos = leafReader.getFieldInfos();
            for (FieldInfo info : fieldInfos) {
                NumericDocValues norms = leafReader.getNormValues(info.name);
                if (norms == null) continue;
                Map perField = stats.computeIfAbsent(info.name, n -> new HashMap());
                SummaryStatistics lengthSummary = (SummaryStatistics)perField.computeIfAbsent("lengths", s -> new MapWriterSummaryStatistics());
                while (norms.advance(norms.docID() + this.samplingStep) != Integer.MAX_VALUE) {
                    for (int i = 0; i < this.samplingStep; ++i) {
                        lengthSummary.addValue(8.0);
                    }
                }
            }
        }
        result.put(NORMS, stats);
    }

    private void estimatePoints(Map<String, Object> result) throws IOException {
        log.info("- estimating points...");
        HashMap<String, Map> stats = new HashMap<String, Map>();
        for (LeafReaderContext leafReaderContext : this.reader.leaves()) {
            LeafReader leafReader = leafReaderContext.reader();
            FieldInfos fieldInfos = leafReader.getFieldInfos();
            for (FieldInfo info : fieldInfos) {
                PointValues values = leafReader.getPointValues(info.name);
                if (values == null) continue;
                Map perField = stats.computeIfAbsent(info.name, n -> new HashMap());
                SummaryStatistics lengthSummary = (SummaryStatistics)perField.computeIfAbsent("lengths", s -> new MapWriterSummaryStatistics());
                lengthSummary.addValue((double)(values.size() * (long)values.getBytesPerDimension() * (long)values.getNumIndexDimensions()));
            }
        }
        result.put(POINTS, stats);
    }

    private void estimateTermVectors(Map<String, Object> result) throws IOException {
        log.info("- estimating term vectors...");
        HashMap<String, Map<String, Object>> stats = new HashMap<String, Map<String, Object>>();
        for (LeafReaderContext leafReaderContext : this.reader.leaves()) {
            LeafReader leafReader = leafReaderContext.reader();
            Bits liveDocs = leafReader.getLiveDocs();
            for (int docId = 0; docId < leafReader.maxDoc(); docId += this.samplingStep) {
                Fields termVectors;
                if (liveDocs != null && !liveDocs.get(docId) || (termVectors = leafReader.getTermVectors(docId)) == null) continue;
                for (String field : termVectors) {
                    Terms terms = termVectors.terms(field);
                    if (terms == null) continue;
                    this.estimateTermStats(field, terms, stats, true);
                }
            }
        }
        result.put(TERM_VECTORS, stats);
    }

    private void estimateDocValues(Map<String, Object> result) throws IOException {
        log.info("- estimating docValues...");
        HashMap<String, Map<String, Object>> stats = new HashMap<String, Map<String, Object>>();
        for (LeafReaderContext context : this.reader.leaves()) {
            LeafReader leafReader = context.reader();
            FieldInfos fieldInfos = leafReader.getFieldInfos();
            for (FieldInfo info : fieldInfos) {
                this.countDocValues(stats, info.name, "binary", (DocIdSetIterator)leafReader.getBinaryDocValues(info.name), values -> {
                    try {
                        BytesRef value = ((BinaryDocValues)values).binaryValue();
                        return value.length;
                    }
                    catch (IOException iOException) {
                        return 0;
                    }
                });
                this.countDocValues(stats, info.name, "numeric", (DocIdSetIterator)leafReader.getNumericDocValues(info.name), values -> 8);
                this.countDocValues(stats, info.name, "sorted", (DocIdSetIterator)leafReader.getSortedDocValues(info.name), values -> {
                    try {
                        TermsEnum termsEnum = ((SortedDocValues)values).termsEnum();
                        BytesRef term = termsEnum.next();
                        if (term != null) {
                            return term.length;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return 0;
                });
                this.countDocValues(stats, info.name, "sortedNumeric", (DocIdSetIterator)leafReader.getSortedNumericDocValues(info.name), values -> ((SortedNumericDocValues)values).docValueCount() * 8);
                this.countDocValues(stats, info.name, "sortedSet", (DocIdSetIterator)leafReader.getSortedSetDocValues(info.name), values -> {
                    try {
                        TermsEnum termsEnum = ((SortedSetDocValues)values).termsEnum();
                        BytesRef term = termsEnum.next();
                        if (term != null) {
                            return term.length;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return 0;
                });
            }
        }
        result.put(DOC_VALUES, stats);
    }

    private void countDocValues(Map<String, Map<String, Object>> stats, String field, String type, DocIdSetIterator values, Function<DocIdSetIterator, Integer> valueLength) throws IOException {
        if (values == null) {
            return;
        }
        Map perField = stats.computeIfAbsent(field, n -> new HashMap());
        SummaryStatistics lengthSummary = (SummaryStatistics)perField.computeIfAbsent("lengths_" + type, s -> new MapWriterSummaryStatistics());
        while (values.advance(values.docID() + this.samplingStep) != Integer.MAX_VALUE) {
            int len = valueLength.apply(values);
            for (int i = 0; i < this.samplingStep; ++i) {
                lengthSummary.addValue((double)len);
            }
        }
    }

    private void estimateTerms(Map<String, Object> result) throws IOException {
        log.info("- estimating terms...");
        HashMap<String, Map<String, Object>> stats = new HashMap<String, Map<String, Object>>();
        for (LeafReaderContext context : this.reader.leaves()) {
            LeafReader leafReader = context.reader();
            FieldInfos fieldInfos = leafReader.getFieldInfos();
            for (FieldInfo info : fieldInfos) {
                Terms terms = leafReader.terms(info.name);
                if (terms == null) continue;
                this.estimateTermStats(info.name, terms, stats, false);
            }
        }
        result.put(TERMS, stats);
    }

    private void estimateTermStats(String field, Terms terms, Map<String, Map<String, Object>> stats, boolean isSampling) throws IOException {
        BytesRef term;
        Map perField = stats.computeIfAbsent(field, n -> new HashMap());
        SummaryStatistics lengthSummary = (SummaryStatistics)perField.computeIfAbsent("lengths_terms", s -> new MapWriterSummaryStatistics());
        SummaryStatistics docFreqSummary = (SummaryStatistics)perField.computeIfAbsent("docFreqs", s -> new MapWriterSummaryStatistics());
        SummaryStatistics totalFreqSummary = (SummaryStatistics)perField.computeIfAbsent("lengths_postings", s -> new MapWriterSummaryStatistics());
        SummaryStatistics payloadSummary = null;
        if (terms.hasPayloads()) {
            payloadSummary = (SummaryStatistics)perField.computeIfAbsent("lengths_payloads", s -> new MapWriterSummaryStatistics());
        }
        ItemPriorityQueue topLen = (ItemPriorityQueue)((Object)perField.computeIfAbsent("topLen", s -> new ItemPriorityQueue(this.topN)));
        ItemPriorityQueue topTotalFreq = (ItemPriorityQueue)((Object)perField.computeIfAbsent("topTotalFreq", s -> new ItemPriorityQueue(this.topN)));
        TermsEnum termsEnum = terms.iterator();
        PostingsEnum postings = null;
        while ((term = termsEnum.next()) != null) {
            String value;
            if (isSampling) {
                for (int i = 0; i < this.samplingStep; ++i) {
                    lengthSummary.addValue((double)term.length);
                    docFreqSummary.addValue((double)termsEnum.docFreq());
                    totalFreqSummary.addValue((double)termsEnum.totalTermFreq());
                }
            } else {
                lengthSummary.addValue((double)term.length);
                docFreqSummary.addValue((double)termsEnum.docFreq());
                totalFreqSummary.addValue((double)termsEnum.totalTermFreq());
            }
            if (terms.hasPayloads()) {
                postings = termsEnum.postings(postings, 120);
                while (postings.nextDoc() != Integer.MAX_VALUE) {
                    int freq = postings.freq();
                    for (int i = 0; i < freq && postings.nextPosition() >= 0; ++i) {
                        BytesRef payload = postings.getPayload();
                        if (payload == null) continue;
                        if (isSampling) {
                            for (int k = 0; k < this.samplingStep; ++k) {
                                payloadSummary.addValue((double)payload.length);
                            }
                            continue;
                        }
                        payloadSummary.addValue((double)payload.length);
                    }
                }
            }
            if ((value = term.utf8ToString()).length() > this.maxLength) {
                value = value.substring(0, this.maxLength);
            }
            topLen.insertWithOverflow(new Item(value, term.length));
            topTotalFreq.insertWithOverflow(new Item(value, termsEnum.totalTermFreq()));
        }
    }

    private void estimateStoredFields(Map<String, Object> result) throws IOException {
        log.info("- estimating stored fields...");
        HashMap<String, Map<String, Object>> stats = new HashMap<String, Map<String, Object>>();
        for (LeafReaderContext context : this.reader.leaves()) {
            LeafReader leafReader = context.reader();
            EstimatingVisitor visitor = new EstimatingVisitor(stats, this.topN, this.maxLength, this.samplingStep);
            Bits liveDocs = leafReader.getLiveDocs();
            if (leafReader instanceof CodecReader) {
                CodecReader codecReader = (CodecReader)leafReader;
                StoredFieldsReader storedFieldsReader = codecReader.getFieldsReader();
                storedFieldsReader = storedFieldsReader.getMergeInstance();
                for (int docId = 0; docId < leafReader.maxDoc(); docId += this.samplingStep) {
                    if (liveDocs != null && !liveDocs.get(docId)) continue;
                    storedFieldsReader.visitDocument(docId, (StoredFieldVisitor)visitor);
                }
                storedFieldsReader.close();
                continue;
            }
            for (int docId = 0; docId < leafReader.maxDoc(); docId += this.samplingStep) {
                if (liveDocs != null && !liveDocs.get(docId)) continue;
                leafReader.document(docId, (StoredFieldVisitor)visitor);
            }
        }
        result.put(STORED_FIELDS, stats);
    }

    @SuppressForbidden(reason="System.err and System.out required for a command-line utility")
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: " + IndexSizeEstimator.class.getName() + " [-topN NUM] [-maxLen NUM] [-summary] [-details] <indexDir>");
            System.err.println();
            System.err.println("\t<indexDir>\tpath to the index (parent path of 'segments_N' file)");
            System.err.println("\t-topN NUM\tnumber of top largest items to collect");
            System.err.println("\t-maxLen NUM\ttruncate the largest items to NUM bytes / characters");
            System.err.println(-1);
        }
        String path = null;
        int topN = 20;
        int maxLen = 100;
        boolean details = false;
        boolean summary = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-topN")) {
                topN = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-maxLen")) {
                maxLen = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-details")) {
                details = true;
                continue;
            }
            if (args[i].equals("-summary")) {
                summary = true;
                continue;
            }
            path = args[i];
        }
        if (path == null) {
            System.err.println("ERROR: <indexDir> argument is required.");
            System.exit(-2);
        }
        FSDirectory dir = FSDirectory.open((Path)Paths.get(path, new String[0]));
        DirectoryReader reader = StandardDirectoryReader.open((Directory)dir);
        IndexSizeEstimator stats = new IndexSizeEstimator((IndexReader)reader, topN, maxLen, summary, details);
        System.out.println(Utils.toJSONString((Object)stats.estimate()));
        System.exit(0);
    }

    private static class EstimatingVisitor
    extends StoredFieldVisitor {
        final Map<String, Map<String, Object>> stats;
        final int topN;
        final int maxLength;
        final int samplingStep;

        EstimatingVisitor(Map<String, Map<String, Object>> stats, int topN, int maxLength, int samplingStep) {
            this.stats = stats;
            this.topN = topN;
            this.maxLength = maxLength;
            this.samplingStep = samplingStep;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            int len;
            int n = len = value != null ? value.length : 0;
            if (len > this.maxLength) {
                byte[] newValue = new byte[this.maxLength];
                System.arraycopy(value, 0, newValue, 0, this.maxLength);
                value = newValue;
            }
            String strValue = new BytesRef(value).toString();
            this.countItem(fieldInfo.name, strValue, len);
        }

        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            int len;
            int n = len = value != null ? value.length : 0;
            if (len > this.maxLength) {
                byte[] newValue = new byte[this.maxLength];
                System.arraycopy(value, 0, newValue, 0, this.maxLength);
                value = newValue;
            }
            String strValue = new String(value, "UTF-8");
            this.countItem(fieldInfo.name, strValue, len);
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.countItem(fieldInfo.name, String.valueOf(value), 4);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.countItem(fieldInfo.name, String.valueOf(value), 8);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.countItem(fieldInfo.name, String.valueOf(value), 4);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.countItem(fieldInfo.name, String.valueOf(value), 8);
        }

        private void countItem(String field, Object value, int size) {
            Map perField = this.stats.computeIfAbsent(field, n -> new HashMap());
            SummaryStatistics summary = (SummaryStatistics)perField.computeIfAbsent("lengths", s -> new MapWriterSummaryStatistics());
            for (int i = 0; i < this.samplingStep; ++i) {
                summary.addValue((double)size);
            }
            ItemPriorityQueue topNqueue = (ItemPriorityQueue)((Object)perField.computeIfAbsent("topLen", s -> new ItemPriorityQueue(this.topN)));
            topNqueue.insertWithOverflow(new Item(value, size));
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }
    }

    public static class ItemPriorityQueue
    extends PriorityQueue<Item>
    implements MapWriter {
        public ItemPriorityQueue(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(Item a, Item b) {
            return a.size < b.size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(it.next());
            }
            return sb.toString();
        }

        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            Item[] items = new Item[this.size()];
            int pos = this.size() - 1;
            while (this.size() > 0) {
                items[pos] = (Item)this.pop();
                --pos;
            }
            for (Item item : items) {
                ew.put((CharSequence)String.valueOf(item.value), item.size);
            }
        }
    }

    public static class MapWriterSummaryStatistics
    extends SummaryStatistics
    implements MapWriter {
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)"n", this.getN());
            ew.put((CharSequence)"min", this.getMin());
            ew.put((CharSequence)"max", this.getMax());
            ew.put((CharSequence)"sum", this.getSum());
            ew.put((CharSequence)"mean", this.getMean());
            ew.put((CharSequence)"geoMean", this.getGeometricMean());
            ew.put((CharSequence)"variance", this.getVariance());
            ew.put((CharSequence)"populationVariance", this.getPopulationVariance());
            ew.put((CharSequence)"stddev", this.getStandardDeviation());
            ew.put((CharSequence)"secondMoment", this.getSecondMoment());
            ew.put((CharSequence)"sumOfSquares", this.getSumsq());
            ew.put((CharSequence)"sumOfLogs", this.getSumOfLogs());
        }
    }

    public static class Item {
        Object value;
        long size;

        public Item(Object value, long size) {
            this.value = value;
            this.size = size;
        }

        public String toString() {
            return "size=" + this.size + ", value=" + this.value;
        }
    }

    public static final class Estimate
    implements MapWriter {
        private final Map<String, Long> fieldsBySize;
        private final Map<String, Long> typesBySize;
        private final Map<String, Object> summary;
        private final Map<String, Object> details;

        public Estimate(Map<String, Long> fieldsBySize, Map<String, Long> typesBySize, Map<String, Object> summary, Map<String, Object> details) {
            Objects.requireNonNull(fieldsBySize);
            Objects.requireNonNull(typesBySize);
            this.fieldsBySize = fieldsBySize;
            this.typesBySize = typesBySize;
            this.summary = summary;
            this.details = details;
        }

        public Map<String, Long> getFieldsBySize() {
            return this.fieldsBySize;
        }

        public Map<String, Long> getTypesBySize() {
            return this.typesBySize;
        }

        public Map<String, String> getHumanReadableFieldsBySize() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            this.fieldsBySize.forEach((field, size) -> result.put((String)field, RamUsageEstimator.humanReadableUnits((long)size)));
            return result;
        }

        public Map<String, String> getHumanReadableTypesBySize() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            this.typesBySize.forEach((field, size) -> result.put((String)field, RamUsageEstimator.humanReadableUnits((long)size)));
            return result;
        }

        public Map<String, Object> getSummary() {
            return this.summary;
        }

        public Map<String, Object> getDetails() {
            return this.details;
        }

        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.put((CharSequence)IndexSizeEstimator.FIELDS_BY_SIZE, this.fieldsBySize);
            ew.put((CharSequence)IndexSizeEstimator.TYPES_BY_SIZE, this.typesBySize);
            if (this.summary != null) {
                ew.put((CharSequence)IndexSizeEstimator.SUMMARY, this.summary);
            }
            if (this.details != null) {
                ew.put((CharSequence)IndexSizeEstimator.DETAILS, this.details);
            }
        }
    }
}

