/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.MaintainTimeRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.TimeZoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRoutedAlias
implements RoutedAlias {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final RoutedAlias.SupportedRouterTypes TYPE = RoutedAlias.SupportedRouterTypes.TIME;
    private volatile boolean preemptiveCreateOnceAlready = false;
    private List<Map.Entry<Instant, String>> parsedCollectionsDesc;
    private Aliases parsedCollectionsAliases;
    public static final String ROUTER_START = "router.start";
    public static final String ROUTER_INTERVAL = "router.interval";
    public static final String ROUTER_MAX_FUTURE = "router.maxFutureMs";
    public static final String ROUTER_AUTO_DELETE_AGE = "router.autoDeleteAge";
    public static final String ROUTER_PREEMPTIVE_CREATE_MATH = "router.preemptiveCreateMath";
    public static final Set<String> REQUIRED_ROUTER_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("name", "router.name", "router.field", "router.start", "router.interval")));
    public static final Set<String> OPTIONAL_ROUTER_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("router.maxFutureMs", "router.autoDeleteAge", "router.preemptiveCreateMath", "TZ")));
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendPattern("[_HH[_mm[_ss]]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC);
    private final String aliasName;
    private final Map<String, String> aliasMetadata;
    private final String routeField;
    private final String intervalMath;
    private final long maxFutureMs;
    private final String preemptiveCreateMath;
    private final String autoDeleteAgeMath;
    private final TimeZone timeZone;
    private String start;

    TimeRoutedAlias(String aliasName, Map<String, String> aliasMetadata) throws SolrException {
        if (!aliasMetadata.keySet().containsAll(REQUIRED_ROUTER_PARAMS)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A time routed alias requires these params: " + REQUIRED_ROUTER_PARAMS + " plus some create-collection prefixed ones.");
        }
        this.aliasMetadata = aliasMetadata;
        this.start = this.aliasMetadata.get(ROUTER_START);
        this.aliasName = aliasName;
        MapSolrParams params = new MapSolrParams(this.aliasMetadata);
        RequiredSolrParams required = params.required();
        if (!"time".equals(required.get("router.name"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only 'time' routed aliases is supported by TimeRoutedAlias.");
        }
        this.routeField = required.get("router.field");
        this.intervalMath = required.get(ROUTER_INTERVAL);
        this.maxFutureMs = params.getLong(ROUTER_MAX_FUTURE, TimeUnit.MINUTES.toMillis(10L));
        String pcmTmp = params.get(ROUTER_PREEMPTIVE_CREATE_MATH);
        this.preemptiveCreateMath = pcmTmp != null ? (pcmTmp.startsWith("-") ? pcmTmp : "-" + pcmTmp) : null;
        this.autoDeleteAgeMath = params.get(ROUTER_AUTO_DELETE_AGE);
        this.timeZone = TimeZoneUtils.parseTimezone(this.aliasMetadata.get("TZ"));
        Date now = new Date();
        try {
            Date after = new DateMathParser(now, this.timeZone).parseMath(this.intervalMath);
            if (!after.after(now)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "duration must add to produce a time in the future");
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "bad router.interval, " + e, (Throwable)e);
        }
        if (this.autoDeleteAgeMath != null) {
            try {
                Date before = new DateMathParser(now, this.timeZone).parseMath(this.autoDeleteAgeMath);
                if (now.before(before)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "duration must round or subtract to produce a time in the past");
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "bad router.autoDeleteAge, " + e, (Throwable)e);
            }
        }
        if (this.preemptiveCreateMath != null) {
            try {
                new DateMathParser().parseMath(this.preemptiveCreateMath);
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid date math for preemptiveCreateMath:" + this.preemptiveCreateMath);
            }
        }
        if (this.maxFutureMs < 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "router.maxFutureMs must be >= 0");
        }
    }

    @Override
    public String computeInitialCollectionName() {
        return TimeRoutedAlias.formatCollectionNameFromInstant(this.aliasName, this.parseStringAsInstant(this.start, this.timeZone));
    }

    public static Instant parseInstantFromCollectionName(String aliasName, String collection) {
        String separatorPrefix = TYPE.getSeparatorPrefix();
        String dateTimePart = collection.contains(separatorPrefix) ? collection.substring(collection.lastIndexOf(separatorPrefix) + separatorPrefix.length()) : collection.substring(aliasName.length() + 1);
        return DATE_TIME_FORMATTER.parse((CharSequence)dateTimePart, Instant::from);
    }

    public static String formatCollectionNameFromInstant(String aliasName, Instant timestamp) {
        String nextCollName = DATE_TIME_FORMATTER.format(timestamp);
        for (int i = 0; i < 3; ++i) {
            if (!nextCollName.endsWith("_00")) continue;
            nextCollName = nextCollName.substring(0, nextCollName.length() - 3);
        }
        assert (DATE_TIME_FORMATTER.parse((CharSequence)nextCollName, Instant::from).equals(timestamp));
        return aliasName + TYPE.getSeparatorPrefix() + nextCollName;
    }

    Instant parseStringAsInstant(String str, TimeZone zone) {
        Instant start = DateMathParser.parseMath(new Date(), str, zone).toInstant();
        this.checkMilis(start);
        return start;
    }

    private void checkMilis(Instant date) {
        if (!date.truncatedTo(ChronoUnit.SECONDS).equals(date)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Date or date math for start time includes milliseconds, which is not supported. (Hint: 'NOW' used without rounding always has this problem)");
        }
    }

    @Override
    public boolean updateParsedCollectionAliases(ZkController zkController) {
        Aliases aliases = zkController.getZkStateReader().getAliases();
        if (this.parsedCollectionsAliases != aliases) {
            if (this.parsedCollectionsAliases != null) {
                log.debug("Observing possibly updated alias: {}", (Object)this.getAliasName());
            }
            this.parsedCollectionsDesc = this.parseCollections(aliases);
            this.parsedCollectionsAliases = aliases;
            return true;
        }
        return false;
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public String getRouteField() {
        return this.routeField;
    }

    public String getIntervalMath() {
        return this.intervalMath;
    }

    public long getMaxFutureMs() {
        return this.maxFutureMs;
    }

    public String getPreemptiveCreateWindow() {
        return this.preemptiveCreateMath;
    }

    public String getAutoDeleteAgeMath() {
        return this.autoDeleteAgeMath;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("aliasName", (Object)this.aliasName).add("routeField", (Object)this.routeField).add("intervalMath", (Object)this.intervalMath).add("maxFutureMs", this.maxFutureMs).add("preemptiveCreateMath", (Object)this.preemptiveCreateMath).add("autoDeleteAgeMath", (Object)this.autoDeleteAgeMath).add("timeZone", (Object)this.timeZone).toString();
    }

    List<Map.Entry<Instant, String>> parseCollections(Aliases aliases) {
        List collections = (List)aliases.getCollectionAliasListMap().get(this.aliasName);
        if (collections == null) {
            throw RoutedAlias.newAliasMustExistException(this.getAliasName());
        }
        ArrayList<Map.Entry<Instant, String>> result = new ArrayList<Map.Entry<Instant, String>>(collections.size());
        for (String collection : collections) {
            Instant colStartTime = TimeRoutedAlias.parseInstantFromCollectionName(this.aliasName, collection);
            result.add(new AbstractMap.SimpleImmutableEntry<Instant, String>(colStartTime, collection));
        }
        result.sort((e1, e2) -> ((Instant)e2.getKey()).compareTo((Instant)e1.getKey()));
        return result;
    }

    public Instant computeNextCollTimestamp(Instant fromTimestamp) {
        Instant nextCollTimestamp = DateMathParser.parseMath(Date.from(fromTimestamp), "NOW" + this.intervalMath, this.timeZone).toInstant();
        assert (nextCollTimestamp.isAfter(fromTimestamp));
        return nextCollTimestamp;
    }

    @Override
    public void validateRouteValue(AddUpdateCommand cmd) throws SolrException {
        Instant docTimestamp = this.parseRouteKey(cmd.getSolrInputDocument().getFieldValue(this.getRouteField()));
        if (docTimestamp.isAfter(Instant.now().plusMillis(this.getMaxFutureMs()))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The document's time routed key of " + docTimestamp + " is too far in the future given " + ROUTER_MAX_FUTURE + "=" + this.getMaxFutureMs());
        }
    }

    @Override
    public String createCollectionsIfRequired(AddUpdateCommand cmd) {
        SolrQueryRequest req = cmd.getReq();
        SolrCore core = req.getCore();
        CoreContainer coreContainer = core.getCoreContainer();
        CollectionsHandler collectionsHandler = coreContainer.getCollectionsHandler();
        Instant docTimestamp = this.parseRouteKey(cmd.getSolrInputDocument().getFieldValue(this.getRouteField()));
        Map.Entry<Instant, String> candidateCollectionDesc = this.findCandidateGivenTimestamp(docTimestamp, cmd.getPrintableId());
        String candidateCollectionName = candidateCollectionDesc.getValue();
        try {
            switch (this.typeOfCreationRequired(docTimestamp, candidateCollectionDesc.getKey())) {
                case SYNCHRONOUS: {
                    return this.createAllRequiredCollections(docTimestamp, cmd, candidateCollectionDesc);
                }
                case ASYNC_PREEMPTIVE: {
                    if (!this.preemptiveCreateOnceAlready) {
                        log.debug("Executing preemptive creation for {}", (Object)this.getAliasName());
                        String mostRecentCollName = this.parsedCollectionsDesc.get(0).getValue();
                        log.debug("Most recent at preemptive: {}", (Object)mostRecentCollName);
                        this.preemptiveAsync(() -> this.createNextCollection(mostRecentCollName, collectionsHandler), core);
                    }
                    return candidateCollectionName;
                }
                case NONE: {
                    return candidateCollectionName;
                }
            }
            throw this.unknownCreateType();
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getAliasMetadata() {
        return this.aliasMetadata;
    }

    @Override
    public Set<String> getRequiredParams() {
        return REQUIRED_ROUTER_PARAMS;
    }

    @Override
    public Set<String> getOptionalParams() {
        return OPTIONAL_ROUTER_PARAMS;
    }

    private String createAllRequiredCollections(Instant docTimestamp, AddUpdateCommand cmd, Map.Entry<Instant, String> targetCollectionDesc) {
        SolrQueryRequest req = cmd.getReq();
        SolrCore core = req.getCore();
        CoreContainer coreContainer = core.getCoreContainer();
        CollectionsHandler collectionsHandler = coreContainer.getCollectionsHandler();
        block5: while (true) {
            switch (this.typeOfCreationRequired(docTimestamp, targetCollectionDesc.getKey())) {
                case NONE: {
                    return targetCollectionDesc.getValue();
                }
                case ASYNC_PREEMPTIVE: {
                    String mostRecentCollName = this.parsedCollectionsDesc.get(0).getValue();
                    this.preemptiveAsync(() -> this.createNextCollection(mostRecentCollName, collectionsHandler), core);
                    return targetCollectionDesc.getValue();
                }
                case SYNCHRONOUS: {
                    this.createNextCollection(targetCollectionDesc.getValue(), collectionsHandler);
                    ZkController zkController = coreContainer.getZkController();
                    if (!this.updateParsedCollectionAliases(zkController)) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "We need to create a new time routed collection but for unknown reasons were unable to do so.");
                    }
                    targetCollectionDesc = this.findCandidateGivenTimestamp(docTimestamp, cmd.getPrintableId());
                    continue block5;
                }
            }
            break;
        }
        throw this.unknownCreateType();
    }

    private SolrException unknownCreateType() {
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown creation type while adding document to a Time Routed Alias! This is a bug caused when a creation type has been added but not all code has been updated to handle it.");
    }

    private void createNextCollection(String mostRecentCollName, CollectionsHandler collHandler) {
        try {
            MaintainTimeRoutedAliasCmd.remoteInvoke(collHandler, this.getAliasName(), mostRecentCollName);
            collHandler.getCoreContainer().getZkController().getZkStateReader().aliasesManager.update();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void preemptiveAsync(Runnable r, SolrCore core) {
        this.preemptiveCreateOnceAlready = true;
        core.runAsync(r);
    }

    private CreationType typeOfCreationRequired(Instant docTimeStamp, Instant targetCollectionTimestamp) {
        Instant preemptNextColCreateTime;
        Instant nextCollTimestamp = this.computeNextCollTimestamp(targetCollectionTimestamp);
        if (!docTimeStamp.isBefore(nextCollTimestamp)) {
            return CreationType.SYNCHRONOUS;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPreemptiveCreateWindow()) && !docTimeStamp.isBefore(preemptNextColCreateTime = this.calcPreemptNextColCreateTime(this.getPreemptiveCreateWindow(), nextCollTimestamp))) {
            return CreationType.ASYNC_PREEMPTIVE;
        }
        return CreationType.NONE;
    }

    private Instant calcPreemptNextColCreateTime(String preemptiveCreateMath, Instant nextCollTimestamp) {
        DateMathParser dateMathParser = new DateMathParser();
        dateMathParser.setNow(Date.from(nextCollTimestamp));
        try {
            return dateMathParser.parseMath(preemptiveCreateMath).toInstant();
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Preemptive Create Window Math:'" + preemptiveCreateMath + '\'', (Throwable)e);
        }
    }

    private Instant parseRouteKey(Object routeKey) {
        Instant docTimestamp;
        if (routeKey instanceof Instant) {
            docTimestamp = (Instant)routeKey;
        } else if (routeKey instanceof Date) {
            docTimestamp = ((Date)routeKey).toInstant();
        } else if (routeKey instanceof CharSequence) {
            docTimestamp = Instant.parse((CharSequence)routeKey);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected type of routeKey: " + routeKey);
        }
        return docTimestamp;
    }

    private Map.Entry<Instant, String> findCandidateGivenTimestamp(Instant docTimestamp, String printableId) {
        for (Map.Entry<Instant, String> entry : this.parsedCollectionsDesc) {
            Instant colStartTime = entry.getKey();
            if (docTimestamp.isBefore(colStartTime)) continue;
            return entry;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Doc " + printableId + " couldn't be routed with " + this.getRouteField() + "=" + docTimestamp);
    }

    static enum CreationType {
        NONE,
        ASYNC_PREEMPTIVE,
        SYNCHRONOUS;

    }
}

