/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.trafo.Point3D;

public class DxfVERTEX
extends DxfEntity {
    protected Point3D position = new Point3D();
    protected int type;
    protected float startWidth = -1.0f;
    protected float endWidth = -1.0f;
    protected float rounding;
    protected float tangent;
    protected int[] index;
    public static final int FIT_POINT = 1;
    public static final int TANGENT = 2;
    public static final int LINE_FIT = 8;
    public static final int CONTROL = 16;
    public static final int LINE_3D = 32;
    public static final int WEB_3D = 64;
    public static final int NET_CONTROL = 128;
    public static final int APPROX = 9;
    public static final int NO_INDEX = 0;
    public static final int PFACEVMAX = 4;

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: 
            case 20: 
            case 30: {
                this.setCoord(this.position, grpNr / 10, fval);
                return true;
            }
            case 40: {
                this.startWidth = fval;
                return true;
            }
            case 41: {
                this.endWidth = fval;
                return true;
            }
            case 42: {
                this.rounding = fval;
                return true;
            }
            case 50: {
                this.tangent = fval;
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean setGroup(short grpNr, int ival) {
        switch (grpNr) {
            case 70: {
                this.type = ival;
                return true;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                if (this.index == null) {
                    this.index = new int[4];
                    int i = 0;
                    while (i < 4) {
                        this.index[i] = 0;
                        ++i;
                    }
                }
                this.index[grpNr - 71] = ival;
                return true;
            }
        }
        return super.setGroup(grpNr, ival);
    }

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
    }

    public final Point3D getPosition() {
        return this.position;
    }

    public final int getType() {
        return this.type;
    }

    public final float getStartWidth() {
        return this.startWidth;
    }

    public final float getEndWidth() {
        return this.endWidth;
    }

    public void setWidths(float startWidth, float endWidth) {
        this.startWidth = startWidth;
        this.endWidth = endWidth;
    }

    public void setStartWidth(float startWidth) {
        this.startWidth = startWidth;
    }

    public void setEndWidth(float endWidth) {
        this.endWidth = endWidth;
    }

    public final float getRounding() {
        return this.rounding;
    }

    public final float getTangent() {
        return this.tangent;
    }

    public final int[] getReferences() {
        return this.index == null ? new int[4] : this.index;
    }
}

