/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate4.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.jasypt.encryption.pbe.PBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.StandardPBEBigIntegerEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate4.encryptor.HibernatePBEEncryptorRegistry;

public final class EncryptedBigIntegerType
implements UserType,
ParameterizedType {
    private static int sqlType = 2;
    private static int[] sqlTypes = new int[]{sqlType};
    private boolean initialized = false;
    private boolean useEncryptorName = false;
    private String encryptorName = null;
    private String algorithm = null;
    private String password = null;
    private Integer keyObtentionIterations = null;
    private PBEBigIntegerEncryptor encryptor = null;

    public int[] sqlTypes() {
        return (int[])sqlTypes.clone();
    }

    public Class returnedClass() {
        return BigInteger.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && y != null && x.equals(y);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return (Serializable)this.deepCopy(value);
    }

    public boolean isMutable() {
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        this.checkInitialization();
        BigDecimal decimalMessage = rs.getBigDecimal(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        BigInteger message = decimalMessage.setScale(0, 7).unscaledValue();
        return this.encryptor.decrypt(message);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.checkInitialization();
        if (value == null) {
            st.setNull(index, sqlType);
        } else {
            BigInteger encryptedMessage = this.encryptor.encrypt((BigInteger)value);
            st.setBigDecimal(index, new BigDecimal(encryptedMessage));
        }
    }

    public synchronized void setParameterValues(Properties parameters) {
        String paramEncryptorName = parameters.getProperty("encryptorRegisteredName");
        String paramAlgorithm = parameters.getProperty("algorithm");
        String paramPassword = parameters.getProperty("password");
        String paramKeyObtentionIterations = parameters.getProperty("keyObtentionIterations");
        this.useEncryptorName = false;
        if (paramEncryptorName != null) {
            if (paramAlgorithm != null || paramPassword != null || paramKeyObtentionIterations != null) {
                throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is specified, none of \"algorithm\", \"password\" or \"keyObtentionIterations\" can be specified");
            }
            this.encryptorName = paramEncryptorName;
            this.useEncryptorName = true;
        } else if (paramPassword != null) {
            this.password = paramPassword;
            if (paramAlgorithm != null) {
                this.algorithm = paramAlgorithm;
            }
            if (paramKeyObtentionIterations != null) {
                try {
                    this.keyObtentionIterations = new Integer(Integer.parseInt(paramKeyObtentionIterations));
                }
                catch (NumberFormatException e) {
                    throw new EncryptionInitializationException("Value specified for \"keyObtentionIterations\" is not a valid integer");
                }
            }
        } else {
            throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is not specified, then \"password\" (and optionally \"algorithm\" and \"keyObtentionIterations\") must be specified");
        }
    }

    private synchronized void checkInitialization() {
        if (!this.initialized) {
            if (this.useEncryptorName) {
                HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
                PBEBigIntegerEncryptor pbeEncryptor = registry.getPBEBigIntegerEncryptor(this.encryptorName);
                if (pbeEncryptor == null) {
                    throw new EncryptionInitializationException("No big integer encryptor registered for hibernate with name \"" + this.encryptorName + "\"");
                }
                this.encryptor = pbeEncryptor;
            } else {
                StandardPBEBigIntegerEncryptor newEncryptor = new StandardPBEBigIntegerEncryptor();
                newEncryptor.setPassword(this.password);
                if (this.algorithm != null) {
                    newEncryptor.setAlgorithm(this.algorithm);
                }
                if (this.keyObtentionIterations != null) {
                    newEncryptor.setKeyObtentionIterations(this.keyObtentionIterations);
                }
                newEncryptor.initialize();
                this.encryptor = newEncryptor;
            }
            this.initialized = true;
        }
    }
}

