/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class RegionFactoryInitiator
implements StandardServiceInitiator<RegionFactory> {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, RegionFactoryInitiator.class.getName());
    public static final RegionFactoryInitiator INSTANCE = new RegionFactoryInitiator();

    @Override
    public Class<RegionFactory> getServiceInitiated() {
        return RegionFactory.class;
    }

    @Override
    public RegionFactory initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Properties p = new Properties();
        if (configurationValues != null) {
            p.putAll((Map<?, ?>)configurationValues);
        }
        boolean useSecondLevelCache = ConfigurationHelper.getBoolean("hibernate.cache.use_second_level_cache", configurationValues, true);
        boolean useQueryCache = ConfigurationHelper.getBoolean("hibernate.cache.use_query_cache", configurationValues);
        RegionFactory regionFactory = NoCachingRegionFactory.INSTANCE;
        String setting = ConfigurationHelper.getString("hibernate.cache.region.factory_class", configurationValues, null);
        if ((useSecondLevelCache || useQueryCache) && setting != null) {
            try {
                Class<RegionFactory> regionFactoryClass = registry.getService(StrategySelector.class).selectStrategyImplementor(RegionFactory.class, setting);
                try {
                    regionFactory = regionFactoryClass.getConstructor(Properties.class).newInstance(p);
                }
                catch (NoSuchMethodException e) {
                    LOG.debugf("%s did not provide constructor accepting java.util.Properties; attempting no-arg constructor.", (Object)regionFactoryClass.getSimpleName());
                    regionFactory = regionFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new HibernateException("could not instantiate RegionFactory [" + setting + "]", e);
            }
        }
        LOG.debugf("Cache region factory : %s", (Object)regionFactory.getClass().getName());
        return regionFactory;
    }

    public static String mapLegacyNames(String name) {
        if ("org.hibernate.cache.EhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.EhCacheRegionFactory";
        }
        if ("org.hibernate.cache.SingletonEhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory";
        }
        return name;
    }
}

