/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.TaskJob;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class TaskManager {
    private static SchedulerFactory factory;
    private static Scheduler scheduler;
    private static Logger logger;

    public static void init() {
        Properties params = new Properties();
        params.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        params.put("org.quartz.threadPool.threadCount", Netshot.getConfig("netshot.tasks.threadcount", "10"));
        try {
            factory = new StdSchedulerFactory(params);
            scheduler = factory.getScheduler();
            scheduler.start();
        }
        catch (Exception e) {
            logger.error(MarkerFactory.getMarker("FATAL"), "Unable to instantiate the Task Manager", e);
            throw new RuntimeException("Unable to instantiate the Task Manager.", e);
        }
    }

    public static void cancelTask(Task task, String reason) throws SchedulerException, HibernateException {
        logger.debug("Cancelling task.");
        scheduler.deleteJob(task.getIdentity());
        logger.trace("The task has been deleted from the scheduler.");
        try (Session session = Database.getSession();){
            session.beginTransaction();
            task.onCancel();
            task.setCancelled();
            task.warn(reason);
            session.saveOrUpdate(task);
            session.getTransaction().commit();
            logger.trace("Task successfully cancelled.");
        }
    }

    public static void addTask(Task task) throws SchedulerException, HibernateException {
        logger.debug("Adding a task to the scheduler.");
        try (Session session = Database.getSession();){
            session.beginTransaction();
            task.onSchedule();
            task.setScheduled();
            session.saveOrUpdate(task);
            session.getTransaction().commit();
            session.evict(task);
            logger.trace("Task successfully added to the database.");
        }
        JobDetail job = JobBuilder.newJob(TaskJob.class).withIdentity(task.getIdentity()).build();
        job.getJobDataMap().put("Netshot Task", (Object)new Long(task.getId()));
        Date when = task.getNextExecutionDate();
        Trigger trigger = when == null ? TriggerBuilder.newTrigger().startNow().build() : TriggerBuilder.newTrigger().startAt(when).build();
        scheduler.scheduleJob(job, trigger);
        logger.trace("Task successfully added to the scheduler.");
    }

    public static void repeatTask(Task task) throws SchedulerException, HibernateException {
        logger.debug("Repeating task {} if necessary.", (Object)task.getId());
        if (!task.isRepeating()) {
            logger.trace("Not necessary.");
            return;
        }
        try {
            Task newTask = (Task)task.clone();
            logger.trace("Got a clone, will schedule it.");
            TaskManager.addTask(newTask);
        }
        catch (CloneNotSupportedException e) {
            logger.error("Unable to clone the task {}.", (Object)task.getId(), (Object)e);
        }
    }

    public static void rescheduleAll() {
        List tasks;
        logger.debug("Will schedule the tasks that can be found in the database.");
        try (Session session = Database.getSession();){
            tasks = session.createQuery("select t from Task t where t.status = :status1 or t.status = :status2").setParameter("status1", (Object)Task.Status.SCHEDULED).setParameter("status2", (Object)Task.Status.RUNNING).list();
        }
        logger.trace("Found {} task(s) to reschedule.", (Object)tasks.size());
        Calendar inOneMinute = Calendar.getInstance();
        inOneMinute.add(12, 1);
        for (Task task : tasks) {
            try {
                Date when = task.getNextExecutionDate();
                if (when != null && when.after(inOneMinute.getTime())) {
                    TaskManager.addTask(task);
                    continue;
                }
                TaskManager.cancelTask(task, "Task skipped, too late to run at server startup.");
            }
            catch (SchedulerException e) {
                logger.error("Unable to schedule the task {}.", (Object)task.getId(), (Object)e);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(TaskManager.class);
    }
}

